;  COBOL.EM,  EMACSSRC>EMACS*>EXTENSIONS>SOURCES, EMACS TEAM-DNK, 06/18/84
;  Contains the first part of the functions for COBOL mode
;  Copyright (c) 1984, Prime Computer, Inc., Natick, MA 01760

; Modifications:
;   Date   Programmer   Description of modification
; 06/10/84 DNK          Added disabled_in_cobol_mode$ as an improvement on the
;                       too-vaguely-named "not_defined" macro.  Left the
;                       "not_defined" macro around just in case, but used the
;                       new disabled_in_cobol_mode$ macro wherever possible.

;                       Commented out the fundamental_cobol_keybindings$ macro
;                       here because it is duplicated, and better, in COBOL2.EM.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; FUNCTIONS:                                                               ;;;
;;;      cobol_indent$  Figures out what indentation should be               ;;;
;;;      correct_length$                                                     ;;;
;;;                     Corrects line length for parse_region$               ;;;
;;;      not_defined    Used to disable commands                             ;;;
;;;      disabled_in_cobol_mode$                                             ;;;
;;;                     ALSO used to disable commands                        ;;;
;;;      parse_for_blank_lines$                                              ;;;
;;;                     Pads blank lines with spaces to ^n and ^z work best  ;;;
;;;      parse_region$  Makes sure lines, both left and right, are correct   ;;;
;;;      trim_line$     Makes sure lines aren't too long                     ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; COMMANDS:                                                                ;;;
;;;      See the Reference Guide, all are mentioned.                         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


; 02/03/83 removed by Zane   (if (null loaded$) (load))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Global Variables (initialized elsewhere:)

; 02/03/83 Zane         (setq begin_column$ 7)
; 02/03/83 Zane         (setq end_column$ 73)
; 02/03/83 Zane         (setq word_scan_table$ " ,.;:?!(){}[]~n")
; 02/03/83 Zane         (setq comment_column$ 7)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; not_defined                                                              ;;;
;;;   Used to disable fundamental modes commands not used here.              ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom not_defined
    &doc "Disables commands not used in COBOL mode"
    (ring_the_bell)
    (info_message "This command is disabled in COBOL mode"))

(defcom disabled_in_cobol_mode$
    &doc "Disables commands not used in COBOL mode"
    (ring_the_bell)
    (info_message "This command is disabled in COBOL mode")
                                       ; THIS LINE BEGINS THE DIFFERENCE
                                       ; from the not_defined macro
    (sleep_for_n_milliseconds 3000)    ; since it may be called from outside
                                       ; of SUI, make NO use of the
                                       ; sui_info_message_time$ global
    (info_message "")
    (flush_typeahead)                  ; to avoid excessive enforced "time-out"
                                       ; from multiple invocations while the
                                       ; first info_message is on the screen
    )

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; trim_line$                                                               ;;;
;;;   Makes sure the a line is the correct length                            ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun trim_line$ ()
     (let ((line# (line_number current_cursor)))
          (save_excursion
             (end_line)
             (if (> (cur_hpos) end_column$)
                 (go_to_hpos end_column$)
                 (search_bk_in_line " ")
                 (delete_white_sides)
                 (open_line)
                 (next_line)
                 (cobol_indent$)))
           (if (^= line# (line_number current_cursor))
               (prev_line)
               (end_line))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_indent$                                                            ;;;
;;;    Figures out where current line should be indented.                    ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun cobol_indent$ (&local (indentation integer))
     (save_excursion
          (if (prev_line)
              (end_line)
              (if (looked_at ".")
                  (setq indentation 12)
               else
                  (begin_line)
                  (if (line_is_blank)
                      (setq indentation 8)
                   else
                      (skip_over_white)
                      (setq indentation (cur_hpos))))
           else
               (setq indentation 12))
           (next_line)
           (whitespace_to_hpos indentation)))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; parse_for_blank_lines$                                                   ;;;
;;;    Pads blank lines so that they have six blanks.                        ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun parse_for_blank_lines$ ()
                                       ; looks for blank lines and pads
                                       ; them with spaces
     (save_excursion
         (cobol_move_bottom)
         (move_top)
         (do_forever
             (if (forward_search "~n~n")
                 (prev_line)
                 (self_insert " " 6)
                 (prev_line)
              else
                 (stop_doing)))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; parse_region$                                                            ;;;
;;;    Makes sure lines are between columns 7 and 72.                        ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun parse_region$ ()
                                       ; checks to insure that nothing
                                       ; is in columns 1-6 and beyond 73
     (save_excursion
        (if (< (buffer_info mark) current_cursor)
            (exchange_mark))
        (begin_line)
        (do_n_times (1+ (- (line_number (buffer_info mark))
                        (line_number current_cursor)))
            (if (not (looking_at "      "))
                (delete_white_sides)
                (whitespace_to_hpos begin_column$))
            (end_line)
            (if (> (cur_hpos) end_column$)
                (correct_length$))
            (next_line))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; correct_length$                                                          ;;;
;;;    corrects , the cr, then correct length    ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_rubout_char
    &doc "COBOL: Delete previous character"
    &na (&pass count &default 1)
    (if (> count 0)
        (do_n_times count
            (if (first_line_p)
                (if (= (cur_hpos) 7)
                    (info_message "Cannot delete at this position")
                    (return)))
            (rubout_char)
            (if (< (cur_hpos) begin_column$)
                (kill_line 0)
                (delete_white_right)
                (rubout_char)
                (trim_line$)))
         (if (< (cur_hpos) begin_column$)
             (cobol_begin_line))
     else
         (cobol_delete_char (- count))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_wrap                                                               ;;;
;;;   cr or space after col 72 causes line to be wrapped and length adjusted ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_wrap
    &doc "COBOL: Inserts cr so you don't have to"
    (if (< (cur_hpos) end_column$)     ; someday make this a sep statement
                                       ; then call fill's wrap--avoid dual
                                       ; maintenance.
        (if (= (character_argument) \ )
            (insert " ")
         else
            (cr)
            (cobol_indent$))
        (return))
    (insert "")
    (go_to_hpos end_column$)
    (if (search_bk_in_line " ")
        (delete_white_sides)
        (cr)
        (save_excursion
             (next_line)
             (if (line_is_blank)
                 (if_at " "
                      (kill_line 2)
                  else
                      (delete_char)))))
    (begin_line)
    (forward_search "")
    (rubout_char 3)
    (cobol_indent$)
    (if (= (character_argument) \ )
        (insert " ")))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_kill_line                                                          ;;;
;;;   same as fundamental but insures length of line is correct              ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_kill_line
    &doc "COBOL: Kill line"
    &na (&pass count &default 1)
    (kill_line count)
    (if (not (eolp)) (trim_line$)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_open_line                                                          ;;;
;;;    after an open, pads line with blanks                                  ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_open_line
    &doc "COBOL: Open line"
    &na (&pass count &default 1)
    (do_n_times count
        (open_line)
        (save_excursion
            (next_line)
            (insert "      "))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_kill_region                                                        ;;;
;;;   insures that line left after kill is correct length                    ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_kill_region
    &doc "COBOL: Move region to kill ring"
    (kill_region)
    (trim_line$))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_yank_region                                                        ;;;
;;;   insures that yanked text is correct length                             ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_yank_region
    &doc "COBOL: Yank region"
    (yank_region)
    (parse_region$))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_back_word                                                          ;;;
;;;   knows that - is part of word, not separator                            ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_back_word
    &doc "COBOL: Back word"
    &na (&pass count &default 1)
    (if (> count 0)
        (do_n_times count (cobol_back_word$))
     else
        (do_n_times (- count) (cobol_forward_word$))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_back_word$                                                         ;;;
;;;   Where back_word stuff really gets done.                                ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun cobol_back_word$ (&local (start cursor))
    (back_char)
    (if (beginning_of_buffer_p)
        (return))
    (setq start (copy_cursor current_cursor))
    (verify_bk word_scan_table$)
    (if (search_charset_backward word_scan_table$)
        (if (= current_cursor start)
            (cobol_back_word$)
         else
            (forward_char))
     else
        (cobol_move_top)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_delete_word                                                        ;;;
;;;    Knows that - is part of word                                          ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_delete_word
    &doc "COBOL: Delete word"
    &na (&pass count &default 1)
    (mark)
    (cobol_forward_word count)
    (kill_region)
    (trim_line$))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_forward_word                                                       ;;;
;;;    knows that - is part of word                                          ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_forward_word
    &doc "COBOL: Forward word"
    &na (&pass count &default 1)
    (if (> count 0)
        (do_n_times count (cobol_forward_word$))
     else
        (do_n_times count (cobol_back_word$))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_forward_word$                                                      ;;;
;;;   where forward word's work is really done.                              ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun cobol_forward_word$ ()
    (forward_char)
    (verify_fd " ~n")
    (if (^ (search_charset_forward word_scan_table$))
        (move_bottom)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_goto_line                                                          ;;;
;;;     Insures that column is kept on goto. Probably unnecessary.           ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_goto_line
    &doc "COBOL: Go to line"
    &na (&pass count &default 1)
    (goto_line count)
    (if (< (cur_hpos) 7)
        (cobol_begin_line)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_rubout_word                                                        ;;;
;;;    rubs out word and knows - is part of word                             ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_rubout_word
    &doc "COBOL: Rubout previous word"
    &na (&pass count &default 1)
    (mark)
    (cobol_back_word count)
    (kill_region))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; com cobol_backward_kill_sentence
        &doc "COBOL: Kills a sentence backwards"
        &na (&pass count &default 1)
        (mark)
        (cobol_backward_sentence count)
        (kill_region))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_forward_kill_sentence                                              ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_forward_kill_sentence
        &doc "COBOL: Kills a sentence forward"
        &na (&pass count &default 1)
        (mark)
        (cobol_forward_sentence count)
        (kill_region)
        (trim_line$))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_backward_kill_line                                                 ;;;
;;;    Kills from point to begin of line, then insures whitespace at bol     ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_backward_kill_line
     &doc "COBOL: Kills from point back to beginning of line"
     (kill_line 0)
     (whitespace_to_hpos begin_column$))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_repaint                                                            ;;;
;;;    point is now in col 7                                                 ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_repaint
    &doc "COBOL: Moves cursor to first line of screen"
    &na (&pass count &default 1)
    (repaint count)
    (cobol_begin_line))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_mark_top                                                           ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_mark_top
    &doc "COBOL: Mark top of buffer"
    (mark)
    (cobol_move_top)
    (exchange_mark))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_mark_bottom                                                        ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_mark_bottom
    &doc "COBOL: Mark bottom of buffer"
    (mark)
    (cobol_move_bottom)
    (exchange_mark))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_read_file                                                          ;;;
;;;   Insures that a read file is gone through parse_for_blank_lines$        ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_read_file
    &doc "COBOL: Read file"
    (read_file)
    (parse_for_blank_lines$)
    (if (< (cur_hpos) 7) (cobol_begin_line)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; fundamental_cobol_keybindings                                            ;;;
;;;   What all this stuff gets bound to                                      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; DNK commented this defun out 06/10/84 The function name is duplicated in
                                       ; COBOL2.EM, which presumably supersedes
                                       ; This one.  (And the later definition
                                       ; is BETTER...)

;(defun fundamental_cobol_keybindings$ ()
;    (set_mode_key "cobol" " " "cobol_wrap")
;    (set_mode_key "cobol" "^a" "cobol_begin_line")
;    (set_mode_key "cobol" "^b" "cobol_back_char")
;    (set_mode_key "cobol" "^d" "cobol_delete_char")
;    (set_mode_key "cobol" "^e" "cobol_end_line")
;    (set_mode_key "cobol" "^f" "cobol_forward_char")
;    (set_mode_key "cobol" "^h" "cobol_rubout_char")
;    (set_mode_key "cobol" "^j" "cobol_wrap")
;    (set_mode_key "cobol" "^k" "cobol_kill_line")
;    (set_mode_key "cobol" "^o" "cobol_open_line")
;    (set_mode_key "cobol" "^w" "cobol_kill_region")
;    (set_mode_key "cobol" "^y" "cobol_yank_region")
;    (set_mode_key "cobol" "^[^h" "cobol_rubout_word")
;    (set_mode_key "cobol" "^[a" "cobol_backward_sentence")
;    (set_mode_key "cobol" "^[A" "cobol_backward_sentence")
;    (set_mode_key "cobol" "^[b" "cobol_back_word")
;    (set_mode_key "cobol" "^[B" "cobol_back_word")
;    (set_mode_key "cobol" "^[c" "not_defined")
;    (set_mode_key "cobol" "^[C" "not_defined")
;    (set_mode_key "cobol" "^[d" "cobol_delete_word")
;    (set_mode_key "cobol" "^[D" "cobol_delete_word")
;    (set_mode_key "cobol" "^[e" "cobol_forward_sentence")
;    (set_mode_key "cobol" "^[E" "cobol_forward_sentence")
;    (set_mode_key "cobol" "^[f" "cobol_forward_word")
;    (set_mode_key "cobol" "^[F" "cobol_forward_word")
;    (set_mode_key "cobol" "^[g" "cobol_goto_line")
;    (set_mode_key "cobol" "^[G" "cobol_goto_line")
;    (set_mode_key "cobol" "^[k" "cobol_forward_kill_sentence")
;    (set_mode_key "cobol" "^[K" "cobol_forward_kill_sentence")
;    (set_mode_key "cobol" "^[l" "not_defined")
;    (set_mode_key "cobol" "^[L" "not_defined")
;    (set_mode_key "cobol" "^[q" "not_defined")
;    (set_mode_key "cobol" "^[Q" "not_defined")
;    (set_mode_key "cobol" "^[<" "cobol_move_top")
;    (set_mode_key "cobol" "^[>" "cobol_move_bottom")
;    (set_mode_key "cobol" "^[\" "cobol_white_delete")
;    (set_mode_key "cobol" "^x^h" "cobol_backward_kill_sentence")
;    (set_mode_key "cobol" "^x^k" "cobol_backward_kill_line")
;    (set_mode_key "cobol" "^x^l" "not_defined")
;    (set_mode_key "cobol" "^x^r" "cobol_read_file")
;    (set_mode_key "cobol" "^x^z^a" "not_defined")
;    (set_mode_key "cobol" "^x^z^e" "not_defined")
;    (set_mode_key "cobol" "^x^z^h" "not_defined")
;    (set_mode_key "cobol" "^x^z^k" "not_defined")
;    (set_mode_key "cobol" "^x^zs" "not_defined")
;    (set_mode_key "cobol" "^x^zS" "not_defined")
;    (set_mode_key "cobol" "^x^z<" "cobol_mark_top")
;    (set_mode_key "cobol" "^x^z>" "cobol_mark_bottom")
;    (set_mode_key "cobol" "^xr" "cobol_repaint")
;    (set_mode_key "cobol" "^xR" "cobol_repaint")
;    (set_mode_key "cobol" "^x[" "cobol_back_para")
;    (set_mode_key "cobol" "^x]" "cobol_forward_para"))

; 02/03/83 removed by Zane: (fasload "EMACS*>extensions>cobol2")

;<FOXTST>DNK>KEYMACS>SOURCES>COBOL.EM  Ed: DNK Sun 10 Jun 1984 12:51:36
; Last modified -- SUN, 10 JUN 1984 12:51:36
;END
