;  COBOL2.EM,  EMACSSRC>EMACS*>EXTENSIONS>SOURCES, EMACS TEAM-DNK, 06/18/84
;  Contains the second part of the functions for COBOL mode
;  Copyright (c) 1984, Prime Computer, Inc., Natick, MA 01760

; Modifications:
;   Date   Programmer   Description of modification
; 06/10/84 DNK          Added PT200-specific keybindings;
;                       Substituted use of "disabled_in_cobol_mode$" macro for
;                       previous use of too-vaguely-named "not_defined" macro.
;                       Added binding to del$ in PT45-specific bindings.
;                       Improved the handling of lm_forward_error_key$ and
;                       lm_prev_error_key$ assignments.

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; the following code activates fundamental bindings unless a library       ;;;
;;; file says otherwise                                                      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;
(defun do_cobol_keybindings$ ()        ; This macro is normally called by the
                                       ; cobol_on macro.
  (if cobol_bindings_loaded$ (return)) ; it has no effect if
                                       ; cobol_bindings_loaded$ is true already
  (setq cobol_bindings_loaded$ true)   ; assuming we survive,
                                       ; prevent re-execution the next time.
  (if (^ (null cobol_keybindings$))    ; check this atom's existence:
                                       ; run the macro load_cobol_keybindings$
                                       ; if it exists at all
    (load_cobol_keybindings$)          ; This macro USED TO BE defined elsewhere
                                       ; in the SUI code.  It is NO LONGER
                                       ; defined there.  If you wish, you can
                                       ; define your own and branch to it
                                       ; by setting cobol_keybindings$ true.
                                       ; If you DO set it true, there had
                                       ; BETTER be a load_cobol_keybindings$
                                       ; macro already defined!!
    (return))
  (select keybinding$                  ; Now we assume we are an SUIX user
    "pt45"
       (load_cobol_pt45$)
    "pst100"
       (load_cobol_pst100$)
    "pt200"
       (load_cobol_pt200$)
    otherwise                          ; but if we're not,
       (fundamental_cobol_keybindings$)))

(defun fundamental_cobol_keybindings$ ()
  (load_most_cobol_bindings$)          ; Load the ones that don't conflict
                                       ; with the PT45 function keys,
                                       ; AND NOW SOME THAT DO CONFLICT WITH
                                       ; THE PT45's FUNCTION KEYS...
  (set_mode_key "cobol" "^[>" "cobol_move_bottom")
  (set_mode_key "cobol" "^[L" "disabled_in_cobol_mode$")
  (set_mode_key "cobol" "^[B" "cobol_back_word")
  (set_mode_key "cobol" "^w" "cobol_kill_region"))
                                       ; Too bad, if you're a PT45 function key
                                       ; user...

(defun load_cobol_pt45$ ()
  (load_most_cobol_bindings$)
  (set_mode_key "cobol" btab$ "cobol_sui_back_tab")
  (set_mode_key "cobol" f9$ "cobol_move_top")
  (set_mode_key "cobol" f11$ "cobol_begin_line")
  (set_mode_key "cobol" f14$ "cobol_kill_region")
  (set_mode_key "cobol" f15$ "cobol_yank_region")
  (set_mode_key "cobol" f16$ "sui_toggle_cobol_word")
  (set_mode_key "cobol" dline$ "cobol_kill_line")
  (set_mode_key "cobol" iline$ "cobol_open_line")
  (set_mode_key "cobol" dchar$ "cobol_delete_char")
  (set_mode_key "cobol" aset$ "cobol_move_bottom")
  (set_mode_key "cobol" print$ "cobol_end_line")
  (set_mode_key "cobol" left$ "cobol_back_char")
  (set_mode_key "cobol" home$ "cobol_repaint")
  (set_mode_key "cobol" right$ "cobol_forward_char")
  (set_mode_key "cobol" "^h" "cobol_rubout_char")
  (set_mode_key "cobol" del$ "cobol_delete_char"))
                                       ; above line is new 06/10/84 DNK

(defun load_cobol_pst100$ ()
  (load_most_cobol_bindings$)
  (set_mode_key "cobol" "^[>" "cobol_move_bottom")
  (set_mode_key "cobol" "^[L" "disabled_in_cobol_mode$")
  (set_mode_key "cobol" "^[B" "cobol_back_word")
  (set_mode_key "cobol" "^w" "cobol_kill_region")
  (set_mode_key "cobol" backtab_pst100$ "cobol_sui_back_tab")
  (set_mode_key "cobol" pf07_pst100$ "cobol_move_top")
  (set_mode_key "cobol" pf11_pst100$ "cobol_begin_line")
  (set_mode_key "cobol" sf07_pst100$ "cobol_kill_region")
                                       ; Above line new 06/10/84 DNK
  (set_mode_key "cobol" sf08_pst100$ "cobol_yank_region")
  (set_mode_key "cobol" pf12_pst100$ "sui_toggle_cobol_word")
  (set_mode_key "cobol" sdelete_pst100$ "cobol_kill_line")
  (set_mode_key "cobol" insert_pst100$ "cobol_open_line")
  (set_mode_key "cobol" delete_pst100$ "cobol_delete_char")
  (set_mode_key "cobol" pf10_pst100$ "cobol_move_bottom")
  (set_mode_key "cobol" pf14_pst100$ "cobol_end_line")
  (set_mode_key "cobol" left_pst100$ "cobol_back_char")
  (set_mode_key "cobol" home_pst100$ "cobol_repaint")
  (set_mode_key "cobol" shome_pst100$ "cobol_repaint")
  (set_mode_key "cobol" right_pst100$ "cobol_forward_char")
  (set_mode_key "cobol" backspace_pst100$ "cobol_rubout_char")
  (set_mode_key "cobol" del_pst100$ "cobol_delete_char"))

(defun load_cobol_pt200$ ()
  (load_most_cobol_bindings$)
  (set_mode_key "cobol" "^[>" "cobol_move_bottom")
  (set_mode_key "cobol" "^[L" "disabled_in_cobol_mode$")
  (set_mode_key "cobol" "^[B" "cobol_back_word")
  (set_mode_key "cobol" "^w" "cobol_kill_region")
  (set_mode_key "cobol" back_tab_pt200$ "cobol_sui_back_tab")
  (set_mode_key "cobol" sscroll_down_pt200$ "cobol_move_top")
  (set_mode_key "cobol" begin_end_pt200$ "cobol_begin_line")
  (set_mode_key "cobol" f07_pt200$ "cobol_kill_region")
  (set_mode_key "cobol" f06_pt200$ "cobol_yank_region")
  (set_mode_key "cobol" delete_pt200$ "sui_toggle_cobol_word")
  (set_mode_key "cobol" spf10_pt200$ "cobol_kill_line")
  (set_mode_key "cobol" insert_pt200$ "cobol_open_line")
  (set_mode_key "cobol" num_lock_pt200$ "cobol_delete_char")
  (set_mode_key "cobol" sscroll_up_pt200$ 