;  GET_SAVE_TAB.EM,  EMACSSRC>EMACS*>EXTENSIONS>SOURCES, TOOLS GROUP-DNK, 11/05/82
;  Contains routines that save and restore tabs
;  Copyright (c) 1982, Prime Computer, Inc., Natick, MA 01760
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; get_tab      Retrieves tabs previously written to a file.  This is       ;;;
;;;              an extended command.                                        ;;;
;;; save_tab     Writes tabs to a file that you specify.  This is an         ;;;
;;;              extended command.                                           ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; save_tab                                                                 ;;;
;;;     Extended command that writes the tabs currently being used to a file.;;;
;;;     It prompts for the filename.  If the file does not exist, it creates ;;;
;;;     it. After the tabs are written, the file is saved.                   ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom save_tab
    &doc "Saves tab stops for future use"
    (save_tab$))
(defun save_tab$ (&local (place string)
                         (tab_name string)
                         (temp_tab list))
    (if (null tab_loaded$)                  ; if this isn't here, no tabs exist
        (info_message "No Tabs are set")
        (ring_the_bell)
        (return))
    (save_excursion                    ; return to starting point
        (setq place (prompt "What file do you wish to write to"))
        (if (file_info place exists)
            (find_file place)          ; check if file exists
         else
            (go_to_cursor (find_buffer place))
            (write_file place))
        (move_bottom)                  ; write it at end
                                       ; ask for a name
        (setq tab_name (prompt "What name are you using to save the tabs"))
                                       ; build a text string for insertion
        (insert (catenate "(setq " tab_name " '("))
        (setq temp_tab tab_list$)      ; parse a temp copy of the list of
                                       ; of tabs
        (do_forever
                                       ; insert string versions into file
            (insert (integer_to_string (car temp_tab)))
            (setq temp_tab (cdr temp_tab))
            (if (null temp_tab) (stop_doing))
            (insert " "))
        (insert "))")
        (cr)
        (save_file)
        (info_message "Tabs are now saved")))




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; get_tab                                                                  ;;;
;;;     Extended command that restores tabs that were previously saved.      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom get_tab
    &doc "Restores named tabs"
    &args ((place &prompt "Where are the tabs stored" &string))
    (save_position                     ; file must exist
        (if (^ (file_info place exists))
            (ring_the_bell)
            (error_message "File not found")
            (return))
        (find_file place)
        (pl)                           ; pl the file so the names are known
        (setq tab_name (intern (prompt "What name are the tabs stored with")))
        (if (null (eval tab_name))
            (ring_the_bell)
            (error_message "Tab name not known")
            (return))
        (tablist_to_array (eval tab_name)))
    (info_message "Tabs are now restored"))

; 02/03/83 Zane   (setq get_save_tab_loaded$ true)
