;  INDENT_AND_WHITE.EM,  EMACSSRC>EMACS*>EXTENSIONS>SOURCES, TOOLS GROUP-DNK, 11/05/82
;  The library of whitespace functions for EMACS
;  Copyright (c) 1982, Prime Computer, Inc., Natick, MA 01760
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; back_to_nonwhite      goes to first nonwhite char on line      {esc}m    ;;;
;;; cret_indent_relative  same as indent_relative but adds {cr}    ^x^j      ;;;
;;; delete_blank_lines    deletes blank lines around point         ^x^o      ;;;
;;; indent_relative       lines up text or tabs text over more     {esc}i    ;;;
;;; leave_one_white       deletes whitespace around point, but  {esc}{space} ;;;
;;; merge_lines           joins two lines together                 {esc}^    ;;;
;;; split_line            breaks a line, preserving the horizontal {esc}^o   ;;;
;;;                       position of the second half by indenting           ;;;
;;;                       it to its old starting position                    ;;;
;;; white_delete          deletes whitespace around point          {esc}\    ;;;
;;;                       leaves one space                                   ;;;
;;;                                                                          ;;;



;;; Global Variables: whitespace, init_whitespace                            ;;;
;;;                   makes sure atom whitespace is only blank characters,   ;;;
;;;                   not newline                                            ;;;

;
; Part of core initialization
;
; 02/03/83 Zane                 (setq init_whitespace whitespace)
; 02/03/83 Zane                 (setq whitespace " ")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; white_delete                                                             ;;;
;;;    Command that deletes the whitespace around point. The function        ;;;
;;;    white_delete$ returns a boolean that indicates whether or not         ;;;
;;;    the operation was successful. The command is bound as {esc}\.         ;;;
;;;                                                                          ;;;
;;;        (white_delete)                                                    ;;;
;;;                                                                          ;;;
;;;        (if (white_delete$) ... )                                         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom white_delete
     &doc "Deletes space around the cursor"
     (white_delete$))
(defun white_delete$ (&returns boolean)
     (if (looked_at " ") (back_char))
     (if (^ (looking_at " "))
         (back_char)
         (if (^ (looking_at " "))
             (forward_char)
             (return false)))
     (delete_white_sides)
     (return true))




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; leave_one_white                                                          ;;;
;;;   Deletes the whitespace around point.  The command is bound as          ;;;
;;;   {esc}{space}.                                                          ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom leave_one_white
     &doc "Deletes all but one space around cursor"
     (if (white_delete$)
         (insert " ")))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; split_line                                                               ;;;
;;;     Breaks a line, preserving the horizontal position of the second      ;;;
;;;     half by indenting it to its old starting position. This command      ;;;
;;;     is bound as {esc}^o.  This command does not take an argument.        ;;;
;;;                                                                          ;;;
;;;        (split_line)                                                      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom split_line
     &doc "Breaks line at cursor and indents next"
     &na (&pass count &default 1)
     (let ((indentation (cur_hpos)))
          (do_n_times count
             (cr)
             (indent_line_to_hpos indentation)
             (prev_line_command))))




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; merge_lines                                                              ;;;
;;;     This command merges two lines together.  With a positive aregument   ;;;
;;;     it merges the current line with the next line.  With a negative      ;;;
;;;     argument, it merges the current line with the previous line.         ;;;
;;;     It is bound as {esc}^.                                               ;;;
;;;                                                                          ;;;
;;;         (merge_lines arg)                                                ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom merge_lines
     &doc "Merges lines together"
     &na (&pass count &default 1)
     (save_excursion
          (if (> count 0)
              (do_n_times count
                  (end_line)
                  (delete_char)
                  (white_delete)
                  (insert " "))
          else
              (do_n_times (- count)
                  (begin_line)
                  (rubout_char)
                  (white_delete)
                  (insert " ")))))




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; delete_blank_lines                                                       ;;;
;;;     This comand deletes blank lines.  Because it is often used in        ;;;
;;;     conjunction with an arg open_line, it works downward, rather         ;;;
;;;     than upward if executed while on a non-blank line.  It is bound      ;;;
;;;     as ^x^o.                                                             ;;;
;;;                                                                          ;;;
;;;         (delete_blank_lines)                                             ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom delete_blank_lines
     &doc "Deletes blank lines"
     (save_position
          (if (^ (line_is_blank))    ; you want to execute while point
              (next_line)            ; is on a blank line
              (if (^ (line_is_blank))
                  (prev_line 2)
                  (if (^ (line_is_blank)) return)))
          (do_forever
               (if 