;  MAINTAIN.EM,  EMACSSRC>EMACS*>EXTENSIONS>SOURCES, TOOLS GROUP-DNK, 11/05/82
;  Contains routines helpful for administering EMACS libraries
;  Copyright (c) 1982, Prime Computer, Inc., Natick, MA 01760
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; dump_file             creates a fasdump file                             ;;;
;;; load_compiled         loads a fasdump file                               ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; USERS SHOULD NOT BE MODIFYING THIS FILE--COUNT BE DANGEROUS              ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; dump_file                                                                ;;;
;;;     This command converts an ASCII file to a fasdump file.  It is        ;;;
;;;     run as {esc}x dump_file.  It assumes that the extension to           ;;;
;;;     the file is EM.                                                      ;;;
;;;                                                                          ;;;
;;;         (dump_file)                                                      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom dump_file
     &doc "Convert to fasdump file"
     (dump_filef))
(defun dump_filef (&local (start integer)
                          (name string)
                          (pos integer))
     (setq start (cpu_time))
     (setq name (buffer_info default_file))
     (setq pos (index name ".EM"))
     (if (> pos 0) (setq name (substr name 1 (- pos 1)))
      else
         (setq pos (index name ".em"))
         (if (> pos 0) (setq name (substr name 1 (1- pos)))))
     (info_message (catenate "Starting to dump " name))
     (setq name (remove_charset name "~~"))
     (fasdump name)
     (info_message (catenate "Elapsed time "
                         (integer_to_string (- (cpu_time) start)))))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; load_compiled                                                            ;;;
;;;   Extended command that load a fasload file.  It prompts the user        ;;;
;;;   for a file name.                                                       ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom load_compiled
     &doc "Loads a fasdump file"
     (fasload (prompt "Fasdump file name")))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;  Utilities for EMACS Maintainers  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; These functions are intentionally not documented anywhere. While these   ;;;
;;; functions can't get anyone in trouble, they are not for general use      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom dump_package
        &doc "Convert to fasdump file"
        (save_position
             (xdump_package_function "")))   ; use the slower one

(defun top_message ((text string))
       (save_position (window_info top_line_cursor dump_top)
            (info_message text)))

(defun dump_package_function (       (note string)
                              &local (start integer)
                                     (name string)
                                     (pos integer)
                                     (dump_top cursor))
       (setq dump_top (window_info top_line_cursor))
       (setq name (buffer_info default_file))
       (setq start (cpu_time))
       (setq pos (index name ".EM"))
       (if (> pos 0) (setq name (substr name 1 (- pos 1)))
        else
           (setq pos (index name ".em"))
           (if (> pos 0) (setq name (substr name 1 (1- pos)))))
       (if (> pos 0) (setq name (substr name 1 (- pos 1))))
       (top_message (catenate "Starting to dump " name " " note))
       (setq name (remove_charset name "~~"))
       (fasdump name)
       (top_message (catenate "Elapsed time "
                         (integer_to_string (- (cpu_time) start)))))

(defcom xdump_package
        &doc "Convert to fasdump file"
        (xdump_package_function ""))

(defun xdump_package_function ((note string)
                     &local (start integer)
                            (name string)
                            (pos integer)
                            (dump_top cursor))
       (setq dump_top (window_info top_line_cursor))
       (setq start (cpu_time))
       (setq name (buffer_info default_file))
       (save_excursion
            (move_top)
            (if (forward_search "~n(def_auto") ; ) for lisp mode
                (move_top)
                (top_message "expanding")
                (util.dump_with_expansion name)
                (save_excursion
                    (go_to_buffer ".temp")
                    (buffer_info changed_ok true)
                    (dump_package_function
                         (catenate "after "
                              (integer_to_string (- (cpu_time) start)))))
                (return)))
       (setq pos (index name ".EM"))
       (if (> pos 0) (setq name (substr name 1 (- pos 1))))
       (top_message (catenate "Starting to dump " name " " note))
       (fasdump name)
       (top_message (catenate "Elapsed time "
                         (integer_to_string (- (cpu_time) start)))))


(defun util.dump_with_expansion
       ((name string)                  ; default file
        &local (the_list list))

       (save_excursion
            (go_to_buffer ".temp")
            (delete_buffer)
            (buffer_info default_file name))
       (move_top)
       (do_forever
          (setq the_list (read))
          (if (not (null the_list))
              (util.process the_list))
          (if (end_of_buffer_p) (stop_doing)))
       (return))                       ; for now

(defun util.process
       ((the_        (prin1 "Width: ")
        (print (terminal_info width))
        (prin1 "Speed: ")
        (print (terminal_info speed))
        (prin1 "Crtp: ")
        (print (terminal_info crtp)))

(defun display_dispatch (d &local (c integer) (s string))
       (prin1 "Name: ")
       (print (dispatch_info d 'name))
       (setq c 0)
       (do_n_times 256
           (if (^ (null (dispatch_info d c)))
               (prin1 (catenate (string_of_length_n
                                    (catenate "Char("
                                              (integer_to_string c)
                                              ")")
                                    9)
                                (catenate ": "
                                          (char_to_string (ItoC c))
                                          " ")
                      )
               )
               (print (dispatch_info d c))
           )
           (setq c (1+ c))
       )
)

(defun get_type((i integer) &returns string)
     (select i
          1    (return "any")
          2    (return "boolean")
          3    (return "character")
          4    (return "integer")
          5    (return "string")
          6    (return "atom")
          7    (return "function")
          8    (return "list")
          9    (return "cursor")
          10   (return "buffer")
          11   (return "dispatch_table")
          12   (return "handler")
          14   (return "window")
          15   (return "array")

       otherwise
               (return (catenate (integer_to_string) " unknown"))))

; 02/03/83 Zane (setq maintain_loaded$ true)
