;  MISC.EM,  EMACSSRC>EMACS*>EXTENSIONS>SOURCES, TOOLS GROUP-DNK, 11/05/82
;  Contains functions used by other functions in EMACS
;  Copyright (c) 1982, Prime Computer, Inc., Natick, MA 01760
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; all_modes_off    Extended command for turning all modes off              ;;;
;;; describe         Tells information about fundamental and library         ;;;
;;;                  commands and functions.                                 ;;;
;;; lines_in_file    a function that returns how many lines exist            ;;;
;;;                  in a file.                                              ;;;
;;; new_features     Lists enhancements, new commands, etc.                  ;;;
;;; tell_modes       Exended command that shows what modes are in force      ;;;
;;; view_file        a command that lets a user look through a               ;;;
;;;                  a file without using EMACS commands.  This is           ;;;
;;;                  an extended command.                                    ;;;
;;; viewer           the function called by view_file                        ;;;
;;;                                                                          ;;;
;;; Global Variables: search_text$                                           ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; view_file                                                                ;;;
;;;     Command that lets a user look through a file without using           ;;;
;;;     EMACS commands.                                                      ;;;
;;;                                                                          ;;;
;;;        (view_file)                                                       ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom view_file
    &doc "Lets a user look at a file"
    (save_excursion
        (let ((filename (prompt "View file")))
             (if (^= filename "")
                 (find_file filename))
             (do_forever
                 (if (^ (viewer (lines_in_file))) (stop_doing)))))
    (info_message ""))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; viewer                                                                   ;;;
;;;    Function that moves though a file without using EMACS commands.       ;;;
;;;                                                                          ;;;
;;;        (viewer optional-integer optional-string)                         ;;;
;;;                                                                          ;;;
;;;    where integer is optional and indicates the number of lines in        ;;;
;;;    the file and string is an optional text message to be printed.        ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun viewer (&optional (no_of_lines integer)
                         (message string)
               &local    (per_cent integer)
                         (movement string)
               &returns  boolean)
    (if (null message) (setq message "Viewer (type ? for help)"))
    (if (^ (null no_of_lines))
        (setq message (catenate "-- "
        (integer_to_string (/ (* (line_number current_cursor) 100) no_of_lines))
                                " % -- " message)))
    (info_message message)
    (setq movement (char_to_string (read_character)))
    (select movement
         "?"   (view_help$)
               (return true)
          " "  "~cj"
               (next_page)
               (return true)
          "b"
          "B"  (back_page)
               (return true)
          "<"  (move_top)
               (return true)
          ">"  (move_bottom)
               (return true)
          "s" "~cs" "S"
               (with_command_abort_handler
                   (if (^ (forward_search
                       (setq search_text$ (prompt "Forward search"))))
                       (info_message (catenate search_text$ " not found"))
                       (sleep_for_n_milliseconds 1000))
                   (return true)
                command_abort_handler
                   (return true))
          "l"  "~cl"
          "L"  (refresh)
               (return true)
          "r"  "~cr" "R"
               (with_command_abort_handler
                  (if (^ (reverse_search
                             (setq search_text$ (prompt "Reverse search"))))
                      (info_message (catenate search_text$ " not found"))
                      (sleep_for_n_milliseconds 1000))
                   (return true)
                command_abort_handler
                   (return true))
          "p" "P"
               (save_excursion
                 (with_no_redisplay
                   (let ((filename (buffer_info default_file)))
                        (if (= filename "")
                            (setq filename ".viewer.print")
                            (write_file filename)
                         else
                            (if (buffer_info modified)
                                (write_file filename)))
                        (primos_command (catenate "spool " filename " -at 1")))))
               (return true)
          "q" "Q" "~cG"
               (return false)
          otherwise
               (info_message "Unknown response")
               (sleep_for_n_milliseconds 1000)
               (return true)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun view_help$ ()
   (save_excursion
      (select_buf ".view.help")
      (if (empty_buffer_p)
      (buffer_info dont_show true)
      (insert "~n~n")
      (insert "                space, cr  Move forward a screen~n")
      (insert "                b          Move back a screen~n")
      (insert "                l          Refresh~n")
      (insert "                p          Print~n")
      (insert "                q          Quit~n")
      (insert "                r          Reverse search~n")
      (insert "                s          Search for a string~n")
      (insert "                <          Move to the top of buffer~n")
      (insert "                >          Move to the bottom of buffer~n")
      (insert "                ?          Type this text~n~n~n")
      (insert "Type any key to return to viewer")
      (buffer_info changed_ok true))
   (read_character)))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; lines_in_file                                                            ;;;
;;;     Function that returns the number of lines in file.                   ;;;
;;;                                                                          ;;;
;;;             (lines_in_file)                                              ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun lines_in_file (&returns integer)
    (return (line_number (buffer_info botring))
     else
         (if (= "@" (substr search_string 1 1))   ; one wild card
             (setq search_string (substr search_string 2))
             (setq found (describe_search1 search_string))
         else                                     ; no wildcards
             (setq search_string (catenate "--*-- " search_string))
             (setq found (describe_search0 search_string))))
    (if (= found  "--*--")
        (sleep_for_n_milliseconds 1000)
        (describe$)
        (return))
    (go_to_cursor (find_buffer ".describe"))
    (buffer_info dont_show true)
    (delete_buffer)
    (insert found)
    (move_top)
    (unmodify)
    (do_forever
         (if (^ (viewer (lines_in_file))) (stop_doing)))
    (info_message "")))              ; clear minibuffer message


(defun describe_search0 ((search_string string)
                &local (found string)
                &returns string)
    (setq found "")
    (with_no_redisplay
      (do_forever
         (if (> (string_length found) 20000)
             (describe_mes$ "The text you entered is not unique enough, try again")
             (return "--*--"))
         (if (forward_search search_string)
             (reverse_search " ")
             (forward_char)
             (with_cursor here
                (forward_search "--*--")
                (begin_line)
                (setq found (catenate found (point_cursor_to_string here))))
         else
             (stop_doing))))
    (if (= found "")
        (setq found "--*--")
        (describe_mes$ "No information was found, try again")
        (sleep_for_n_milliseconds 1000))
    (return found))

(defun describe_search1 ((search_string string)
                &local (found string)
                &returns string)
  (setq found "")
  (with_no_redisplay
    (do_forever
       (if (> (string_length found) 20000)
           (info_message "The text you entered is not unique enough, try again")
           (return "--*--"))
       (if (forward_search "--*-- ")
           (if (> (index (current_line) search_string) 0)
               (with_cursor here
                  (forward_search "--*--")
                  (begin_line)
                  (setq found (catenate found (point_cursor_to_string here)))))
       else
          (stop_doing)))
    (if (= found "")
        (setq found "--*--")
        (describe_mes$ "No information was found, try again")
        (sleep_for_n_milliseconds 1000))
    (return found)))

(defun describe_search2 ((search_string string)
                     &local (found string)
                     &returns string)
    (setq found "")
    (with_no_redisplay
      (do_forever
         (if (> (string_length found) 20000)
           (describe_mes$ "The text you entered is not unique enough, try again")
           (return "--*--"))
         (if (forward_search search_string)
             (reverse_search "--*--")
             (forward_char 5)
             (with_cursor here
                (forward_search "--*--")
                (begin_line)
                (setq found (catenate found (point_cursor_to_string here))))
         else
             (if (= found "")
                 (setq found "--*--")
                 (describe_mes$ "No information was found, try again")
                 (sleep_for_n_milliseconds 1000))
             (return found)))))

(defun describe_help ()
   (save_excursion
     (select_buf ".describe.help")
     (if (empty_buffer_p)
         (buffer_info dont_show true)
(insert "By  typing  a function name, EMACS will print all functions that begin~n")
(insert "with what you have typed.  If you precede the function  name  with  an~n")
(insert "@,  EMACS  will  print all functions that have that string anywhere in~n")
(insert "its function name.  Finally,  if you  precede  the  function name with~n")
(insert "@@,  EMACS looks for that string in the text and function names.~n~n")
(insert "For example, search  locates  all  functions  beginning  with  search.~n")
(insert "@search  would  locate  forward_search  (and other functions as well).~n")
(insert "@@search would locate all places where search was  used.   This  means~n")
(insert "you could get extraneous information, but it will be complete.~n~n")
(insert "After the describe information is presented, EMACS  uses  a  different~n")
(insert "command  set to help you get through the  text.   To  see  what  these~n")
(insert "commands are type ? after the text has been displayed:~n~n~n")
(insert "Type any character to return to viewer")
         (buffer_info changed_ok true))
      (read_character)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; new_features                                                             ;;;
;;;    extended command that allows previewing of undocumented features.     ;;;
;;;    It assumes that information is written to a file called               ;;;
;;;    EMACS*>INFO>NEW_FEATURES_INFO                                         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom new_features
    &doc "Lists new features, commands, etc"
    (save_excursion
       (select_buf ".new_features")
       (move_top)
       (if (empty_buffer_p)
           (read_file "EMACS*>INFO>NEW_FEATURES_INFO")
           (buffer_info changed_ok true)
           (buffer_info read_only true)
           (buffer_info dont_show true))
       (do_forever
           (if (^ (viewer (lines_in_file)))
               (stop_doing))))
               (info_message "")
               )

(defun describe_mes$  ((text string))
    (go_to_buffer ".describe")
    (delete_buffer)
    (buffer_info changed_ok true)
    (buffer_info dont_show true)
    (redisplay)
    (info_message "")
    (insert "~n~n~n~n~n                   ")
    (insert text)
    (insert "~n~n~n~n~n~n~n                   ")
    (insert "Type any character to resume")
    (read_character))

