;  TAB.EM,  EMACSSRC>EMACS*>EXTENSIONS>SOURCES, TOOLS GROUP-DNK, 11/05/82
;  Contains library of tabbing and tab related functions in EMACS
;  Copyright (c) 1982, Prime Computer, Inc., Natick, MA 01760
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; default_tabs     Extended command that restores tabs to every five       ;;;
;;;                  spaces                                                  ;;;
;;; insert_tab       Command that inserts white space to tab stop      ^x^i  ;;;
;;; tablist_to_array Function that converts a list to tab positions          ;;;
;;; type_tab         Command that tabs to tab stop                      ^i   ;;;
;;; check_tab$       Checks if tabs exist in buffer                          ;;;
;;;                                                                          ;;;
;;;                                                                          ;;;
;;; Global Variables: tab_list$                                              ;;;
;;;                   buffer_info -- user tab_array                          ;;;
;;;                   buffer_info -- user last_tab$                          ;;;
;;;                   last_tab$                                              ;;;
;;;                   tab_array$                                             ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


; 02/03/83 Zane    (if (null global_tabs)             ; global variable so that previous
; 02/03/83 Zane        (setq global_tabs true))       ; tabs are usually in force
; 02/03/83 Zane
; 02/03/83 Zane    (setq last_tab$ 0)                 ; needed to set values if switching
; 02/03/83 Zane                                       ; buffers
; 02/03/83 Zane
; 02/03/83 Zane    (buffer_info (user tab_array) ())  ; where tab array is stored
; 02/03/83 Zane
; 02/03/83 Zane    (buffer_info (user last_tab$) ())  ; value that is specific to the buffer,
; 02/03/83 Zane                                       ; may be different than last_tab$ if
; 02/03/83 Zane                                       ; user sets tabs differently in another
; 02/03/83 Zane                                       ; buffer than returns
; 02/03/83 Zane
; 02/03/83 Zane    (setq tab_array$ () )              ; kept around to make some routines
; 02/03/83 Zane                                       ; easier


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; default_tabs                                                             ;;;
;;;   Extended command that restores tabs to every five spaces.              ;;;
;;;                                                                          ;;;
;;;        (default_tabs)                                                    ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom default_tabs
     &doc "Sets up default tabs every five spaces"
     (setq tab_list$ ())
     (let ((counter 0))
          (do_forever                  ; make a new tab list where items are
                                       ; five apart
              (setq tab_list$ (append tab_list$
                                      (list (setq counter (+ counter 5)))))
                                       ; artificial distinction, tabs not allowed
                                       ; more than 130.  Note that absolute
                                       ; limit is due to array sizing.  To
                                       ; increase, just increase array.
              (if (>= counter 130) (stop_doing))))
                                       ; convert list to values
     (tablist_to_array tab_list$))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; tablist_to_array                                                         ;;;
;;;   Function that takes a tablist and transforms the tablist into          ;;;
;;;   tab stops.                                                             ;;;
;;;                                                                          ;;;
;;;        (tablist_to_array integer-list)                                   ;;;
;;;                                                                          ;;;
;;;   where integer-list is a list variable whose contents are all integers. ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun tablist_to_array (         (tab_list$ list)
                         &local   (counter integer)
                                  (tab_array array)
                                  (next_tab integer)
                                  (position integer)
                                  (last_set boolean)
                         &returns list)
     (setq counter 0)
     (setq position 0)
     (setq last_set false)
     (setq tab_array (make_array 'integer 135))
     (do_forever                       ; so that last_tab$ not reset second time
          (if (not last_set)           ; set last_tab$
              (if (= (cdr tab_list$) () )
                  (setq last_set true)
                  (setq last_tab$ (car tab_list$))
                  (buffer_info (user last_tab$) (car tab_list$))))
                                       ; get item off list and reset list
          (setq next_tab (car tab_list$))
          (setq tab_list$ (cdr tab_list$))
                                       ; build array elements from current value
                                       ; to value of next tab stop
          (do_n_times (- next_tab position)
               (if (= counter (array_dimension tab_array)) (stop_doing))
               (if (> next_tab 132) (stop_doing))
               (aset next_tab tab_array counter)
               (setq counter (1+ counter)))
          (if (null tab_list$) (stop_doing))
          (setq position next_tab))
                                       ; fill the array with real values to
                                       ; insure as little can go wrong as
                                       ; possible
     (fill_array tab_array (buffer_info (user last_tab$)) next_tab)
     (buffer_info (user tab_array) tab_array)
                                       ; set up for global tabs
     (if global_tabs
         (setq tab_array$ tab_array))
     (info_message "Tabs are set"))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; type_tab                                                                 ;;;
;;;    Command that moves point to the next tab stop.                        ;;;
;;;                                                                          ;;;
;;;        (type_tab optional-integer)                                       ;;;
;;;                                                                          ;;;
;;;    where the optional integer can be either positive or negative.  If    ;;;
;;;    it is negative, the back_tab routine is called.                       ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom type_tab
    &doc "Tab"
    &na (&pass count &default 1)
    (check_tab)
    (if (> count 0)
        (do_n_times count (type_tabf))))

(defun type_tabf (&local (cur_pos integer))
   (if (>= (cur_hpos) (buffer_info (user last_tab$)))
                                       ; user is past last tab stop
       (info_message "You've tabbed over too far"