;  TAB1.EM,  EMACSSRC>EMACS*>EXTENSIONS>SOURCES, TOOLS GROUP-DNK, 11/05/82
;  Contains library of tabbing and tab related functions in EMACS
;  Copyright (c) 1982, Prime Computer, Inc., Natick, MA 01760
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; back_tab         Command that moves point to the previous tab            ;;;
;;;                  stop.                                                   ;;;
;;; convert_tab      Functions that actualy converts the tablist numbers     ;;;
;;; move             Function that moves user through tab setting            ;;;
;;;                  routines                                                ;;;
;;; parse_line       Function that parses tabs set up by settab              ;;;
;;; settab           Extended command that lets user specify tab stops       ;;;
;;; set_tab          Extended command that lets user specify tab stops       ;;;
;;; set_tabs         Extended command that lets user specify tab stops       ;;;
;;; settabs_from_table                                                       ;;;
;;;                  Extended command that parses a line and sets            ;;;
;;;                  tab stops from positions on the line.  This             ;;;
;;;                  may be abbreviated as setft                             ;;;
;;; tablist          Command that lets user type in the tab position         ;;;
;;;                  numbers and have Emacs convert these numbers to         ;;;
;;;                  tab positions.                                          ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; back_tab                                                                 ;;;
;;;   Command that moves point back to the previous tab stop.  Use           ;;;
;;;   primarily for negative tab arguments.  However, it can be bound        ;;;
;;;   to function keys and used directly.                                    ;;;
;;;                                                                          ;;;
;;;        (back_tab optional-integer)                                       ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom back_tab
    &doc "Moves cursor to previous tab stop"
    &na (&pass count &default 1)
    (check_tab)
    (if (> count 0)
         (do_n_times count (back_tabf))
      else
         (do_n_times (- count) (type_tabf))))

(defun back_tabf (&local (current_tab integer)
                         (prev_tab integer)
                         (down_counter integer))
    (if (= (cur_hpos) 1) (return))
    (if (> (cur_hpos) last_tab$)
        (go_to_hpos last_tab$)
        (return))
    (setq current_tab (aref (buffer_info (user tab_array)) (cur_hpos)))
    (setq prev_tab (aref (buffer_info (user tab_array)) (1- (cur_hpos))))
    (if (^= current_tab prev_tab)
        (setq current_tab prev_tab))
    (setq down_counter (1- current_tab))
    (do_forever
         (if (= (aref (buffer_info (user tab_array)) down_counter) current_tab)
             (setq down_counter (1- down_counter))
             (if (= down_counter 1)
                 (begin_line) (return))
         else
             (go_to_hpos (aref (buffer_info (user tab_array)) down_counter))
             (return))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; settab                                                                   ;;;
;;;   Extended command that lets a user set tabs in whatever way that        ;;;
;;;   is wanted.                                                             ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom settab
    &doc "Sets tabs to what you want"
    (settabf))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; set_tab
;;;   synonyn for settab
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom set_tab
    &doc "Sets tabs to what you want"
    (settabf))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; set_tabs
;;;   synonyn for settab
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom set_tabs
    &doc "Sets tabs to what you want"
    (settabf))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun settabf (&local (counter integer))
    (save_position
         (go_to_cursor (find_buffer ".tab"))
         (buffer_info dont_show true)
         (mark_whole)
         (delete_region)
         (setq counter 1)
         (do_n_times 14
              (insert "         ")
              (insert (integer_to_string (modulo counter 10)))
              (setq counter (1+ counter)))
         (cr)
         (do_n_times 14
              (insert "....5....0"))
         (cr)
         (if (yesno "Is there a default interval")
             (setq interval (1- (string_to_integer (prompt "How far apart"))))
             (do_forever
                 (if (> (cur_hpos) 130) (stop_doing))
                 (self_insert " " interval)
                 (insert "T"))
          else
             (self_insert " " 140))
         (begin_line)
         (save_position
           (move_bottom)
           (insert "~n~n~nType a line of spaces and T's~n~n")
           (insert "space   replace with space and move forward~n")
           (insert "t       insert a T--signals a tab stop~n")
           (insert "b       move backward a space~n")
           (insert "f       move forward a space~n")
           (insert "h       scroll the screen horizontally~n")
           (insert "r       reset scrolled file to column 1~n")
           (insert "q       quit and set tabs~n")
         (info_message
"Type T's at desired tab positions -- finish with the RETURN key."))
         (do_forever
              (if (^ (move)) (stds
                  (if (^ (cursor_on_current_line_p cur_cursor)) (stop_doing))
                                       ; enter them into tab list
                  (setq tab_list$ (append tab_list$ (list (cur_hpos))))
               else
                  (stop_doing))
              (skip_to_white)          ; make sure on correct line
              (if (^ (cursor_on_current_line_p cur_cursor)) (stop_doing))
              (if (eolp)               ; get end of line as a safety
                                       ; precaution--shouldn't hurt
                                       ; if get bug reports, remove
                  (setq tab_list$ (append tab_list$ (list (cur_hpos))))
                  (stop_doing)))
         (tablist_to_array tab_list$)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; tablist                                                                  ;;;
;;;    Extended commands that accepts a series of numbers from the terminal  ;;;
;;;    and converts these numbers into tab stops.                            ;;;
;;;                                                                          ;;;
;;;        (tablist)                                                         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom tablist
   &doc "Sets tabs from a list"
   &args ((tabs &prompt "Set tab columns separated by blanks"))
   (convert_tabs (catenate tabs " ")))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; convert_tabs                                                             ;;;
;;;     Functions that takes a list of numbers and converts them to          ;;;
;;;     tab stops.                                                           ;;;
;;;                                                                          ;;;
;;;        (convert_tabs string)                                             ;;;
;;;                                                                          ;;;
;;;     where string is a series of numbers separated by spaces.  Moreover,  ;;;
;;;     the last character in string must be a space.                        ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun convert_tabs (       (s string)
                     &local (nb integer)
                            (ne integer)
                            (next_tab_string string))
     (setq tab_list$ ())
     (setq next_tab_string "")
     (setq nb 1)
     (do_forever
           (setq ne (index (substr s nb ) " "))
           (setq next_tab_string (substr s nb ne))
           (setq nb (+ nb ne))
           (if (= next_tab_string "") (stop_doing)
            else
                (setq next_tab (string_to_integer next_tab_string))
                (setq tab_list$ (append tab_list$ (list next_tab)))))
     (tablist_to_array tab_list$))
