;  TEXT.EM, EMACS*>EXTENSIONS>SOURCES, EMACS TEAM-DNK, 06/18/84
;  Contains miscellaneous functions for manipulating text in EMACS
;  Copyright (c) 1984, Prime Computer, Inc., Natick, MA 01760
;
; modified MON, 18 JUN 1984 by DNK:  Renamed old defun lowercasef
; to be partial_lowercasef
; and renamed old defun uppercasef to be partial_uppercasef.
; made the uppercase_word defcom move to the START of words before acting;
; same for the lowercase_word defcom.
; The old defuns are still around and still shared, but are NOT
; called anymore by their respective shared defcoms.
; The capinitial defcom was already "word-boundary-sensitive."

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; backward_clause        goes backward a clause at a time        ^x^z^a    ;;;
;;; backward_kill_clause   kills backward a clause                 ^x^z^h    ;;;
;;; backward_kill_line     kills from point to the beginning of    ^x^k      ;;;
;;; backward_kill_sentence kills a sentence backward               ^x^h      ;;;
;;; backward_para          goes backward a paragraph               ^x[       ;;;
;;; backward_sentence      goes back a sentence at a time          {esc}a    ;;;
;;; capinitial             changes a word to initial caps          {esc}c    ;;;
;;; center_line            centers a line within margins           ^x^zs     ;;;
;;; forward_clause         goes forward a clause at a time         ^x^z^e    ;;;
;;; forward_kill_clause    kills forward a clause                  ^x^z^k    ;;;
;;; forward_kill_sentence  kills a sentence forward                {esc}k    ;;;
;;;                        the line                                          ;;;
;;; forward_para           goes forward a paragraph                ^x]       ;;;
;;; forward_sentence       goes forward a sentence at a time       {esc}e    ;;;
;;; lowercase_region       changes a region to lowercase           ^x^l      ;;;
;;; lowercase_word         changes a word to lowercase             {esc}l    ;;;
;;; mark_end_of_word       puts a mark at end of word              {esc}@    ;;;
;;; mark_para              puts mark at the end of a paragraph     {esc}h    ;;;
;;;                        and  point at the begining                        ;;;
;;; transpose words        interchanges the positions of two words {esc}t    ;;;
;;; uppercase_region       changes a region to uppercase           ^x^u      ;;;
;;; uppercase_word         changes a word to uppercase             {esc}u    ;;;
;;;                                                                          ;;;

;;; Global Variables removed: clause_scan_table$, sentence_scan_table$               ;;;

; 02/03/83 Zane              (setq clause_scan_table$ ",.;:?!(){}[]")
; 02/03/83 Zane              (setq sentence_scan_table$  ".?!")

; [these are initialized elsewhere]

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; backward_para                                                            ;;;
;;;     This command places point at the beginning of the current paragraph. ;;;
;;;     Paragraphs are defined as lines beginning with a period, a blank line;;;
;;;     or lines beginning with a space.  If there is no paragraph break,    ;;;
;;;     point is placed at the beginning of the buffer.  Bound as {esc}[.    ;;;
;;;                                                                          ;;;
;;;         (backward_para arg)                                              ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom backward_para
     &doc "Move backward a paragraph"
     &na (&pass count &default 1)
     (if (> count 0)
          (backward_paraf count)
      else
          (forward_paraf (- count))))

(defun backward_paraf (&optional (count integer))
     (if (null count) (setq count 1))
     (do_n_times count
          (prev_line)
          (do_forever
               (if_at "." (stop_doing))
               (if_at " " (prev_line) (stop_doing))
               (if (line_is_blank) (stop_doing))
               (if (beginning_of_buffer_p) (stop_doing))
               (prev_line) ) ) )




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; forward_para                                                             ;;;
;;;     This command places point at the end of the current paragraph.       ;;;
;;;     Paragraphs are defined as lines beginning with a period, a blank line;;;
;;;     or lines beginning with a space.  If there is no paragraph break,    ;;;
;;;     point is placed at the end of the buffer.  It is bound as {esc}].    ;;;
;;;                                                                          ;;;
;;;         (forward_para arg)                                               ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom forward_para
     &doc "Move forward a paragraph"
     &na (&pass count &default 1)
     (if (> count 0)
          (forward_paraf count)
      else
          (backward_paraf (- count))))

(defun forward_paraf (&optional (count integer))
     (if (null count) (setq count 1))
     (do_n_times count
          (next_line)
          (do_forever
               (if_at "." (stop_doing))
               (if_at " " (stop_doing))
               (if (line_is_blank) (stop_doing))
               (if (lastlinep)
                   (move_bottom)
                   (end_line)
                   (cr)
                   (stop_doing))
               (next_line))))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; mark_para                                                                ;;;
;;;     This command puts a mark at the end of a paragraph and               ;;;
;;;     point at the beginning.  It is bound as {esc}h.                      ;;;
;;;                                                                          ;;;
;;;         (mark_para optional-integer)                                     ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom mark_para
     &doc "Marks a paragraph"
     &na (&pass count &default 1)
     (if (> count 0)
         (backward_paraf)
      else
         (forward_paraf))
     (mark)
     (forward_para count))




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;
;;;    This is normally bound as ^x^z^a.                                     ;;;
;;;                                                                          ;;;
;;;         (backward_clause optional-arg)                                   ;;;
;;;                                                                          ;;;
;;;         (if (backward_clausef optional-arg) ... )                        ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom backward_clause
     &doc "Goes backward a clause at a time"
     &na (&pass count &default 1)
     (if (> count 0)
          (backward_clausef count)
      else
          (forward_clausef (- count))))

(defun backward_clausef (&optional (count integer)
                         &local    (start cursor)
                         &returns boolean)
     (if (null count) (setq count 1))
     (do_n_times count
         (back_char)
         (setq start (copy_cursor current_cursor))
         (if (search_charset_backward clause_scan_table$)
             (if (= current_cursor start)
                 (if (beginning_of_buffer_p) (return false))
                 (backward_clausef)
              else
                 (back_char))
          else
             (move_top)
             (return false)))
      (return true))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; forward_clause                                                           ;;;
;;;    Command that places point at the end of the current clause.           ;;;
;;;    This is normally bound as ^x^z^e.                                     ;;;
;;;                                                                          ;;;
;;;         (forward_clause optional-arg)                                    ;;;
;;;                                                                          ;;;
;;;         (if (forward_clausef optional-arg) ... )                         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom forward_clause
     &doc "Goes forward a clause at a time"
     &na (&pass count &default 1)
     (if (> count 0)
          (forward_clausef count)
      else
          (backward_clausef (- count))))

(defun forward_clausef (&optional (count integer)
                        &local    (start cursor)
                        &returns boolean)
     (if (null count) (setq count 1))
     (do_n_times count
         (forward_char)
         (setq start (copy_cursor current_cursor))
         (if (search_charset_forward clause_scan_table$)
             (if (= current_cursor start)
                 (if (end_of_buffer_p) (return false))
                 (forward_clausef)
              else
                 (forward_char))
          else
             (move_bottom)
             (return false)))
      (return true))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; backward_kill_clause                                                     ;;;
;;;    Command that kills from point to the beginning of the current clause. ;;;
;;;    This is normally bound as ^x^z^h.  (^h is backspace.)                 ;;;
;;;                                                                          ;;;
;;;         (backward_kill_clause arg)                                       ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom backward_kill_clause
     &doc "Kills backward a clause at a time"
     &na (&pass count &default 1)
     (if (> count 0)
          (backward_kill_clausef count)
      else
          (forward_kill_clausef (- count))))

(defun backward_kill_clausef (&optional (count integer))
     (mark)
     (if (null count) (setq count 1))
     (backward_clausef count)
     (forward_char 2)
     (kill_region))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; forward_kill_clause                                                      ;;;
;;;    Command that kills from point to the end of the current clause.       ;;;
;;;    This command is normally bound as ^x^z^k.                             ;;;
;;;                                                                          ;;;
;;;         (forward_kill_clause arg)                                        ;;;
;;;                                                                          ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom forward_kill_clause
     &doc "Kills forward a clause at a time"
     &na (&pass count &default 1)
     (if (> count 0)
          (forward_kill_clausef count)
      else
          (backward_kill_clausef (- count))))

(defun forward_kill_clausef (&optional (count integer))
     (mark)
     (if (null count) (setq count 1))
     (forward_clausef count)
     (kill_region))




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; center_line                                                              ;;;
;;;     This command centers a line of text.  It doesn't matter where        ;;;
;;;     you are when you do this.  This is bound as {esc}s.                  ;;;
;;;                                                                          ;;;
;;;         (center_line arg)                                                ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom center_line
    &doc "Center the current line"
    &na (&pass count &default 1)
    (center_linef count))

(defun center_linef (&optional (count integer)
                     &local (text string)
                            (wrap_column integer)
                            (direction integer))
     (if (null count) (setq count 1))
     (if (< count 0)
         (setq direction -1)
         (setq count (- count))
      else
         (setq direction 1))
     (if (| (null (buffer_info fill_column)) (= (buffer_info fill_column) 0))
         (buffer_info fill_column 70)
         (info_message "Filling was not on, column has been set to 70"))
     (do_n_times count
          (setq text (trim (current_line)))
          (begin_line)
          (kill_line)
          (whitespace_to_hpos (/ (- (buffer_info fill_column) (string_length text)) 2))
          (insert text)
          (if (< direction 0)
              (prev_line)
           else
              (next_line))))




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; transpose_word                                                           ;;;
;;;    This command inverts the word after point with the word before        ;;;
;;;    point.  It is bound as {esc}t                                         ;;;
;;;                                                                          ;;;
;;;         (transpose_word)                                                 ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom transpose_word
     &doc "Interchanges the position of two words"
     (transpose_wordf))

(defun transpose_wordf (&local (word1 string)
                               (sep string)
                               (word2 string))
    (if (| (beginning_of_buffer_p) (end_of_buffer_p)) (return))
    (forward_word)
    (back_word)
    (do_forever
          (back_char)
          (if_at " " (forward_charnd as {esc}u.                                                     ;;;
;;;                                                                          ;;;
;;;         (uppercase_word optional-arg)                                    ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom uppercase_word
     &doc "Changes a full word into uppercase"
     &na (&pass count &default 1)
     (let ((start (copy_cursor current_cursor))
           (word ""))
          (if (< count 1)
              (back_word (setq count (- count)))
           else
              (forward_word) (back_word))
          (with_cursor here
              (forward_word count)
              (setq word (upcase (point_cursor_to_string here)))
              (delete_point_cursor here))
         (insert word)
         (if (< current_cursor start)
              (go_to_cursor start))))

(defun partial_uppercasef (&optional (count integer)
                                       ; This is the ORIGINAL defun, now
                                       ; unused, but shared and available
                   &local    (word string)
                   &returns  string)
     (if (null count) (setq count 1))
     (with_cursor here
          (forward_word count)
          (setq word (upcase (point_cursor_to_string here)))
          (delete_point_cursor here))
      (insert word)
      (return word))




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; uppercase_region                                                         ;;;
;;;    This command converts a region to uppercase.  It is bound as ^x^u.    ;;;
;;;                                                                          ;;;
;;;         (uppercase_region)                                               ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom uppercase_region
     &doc "Convert region to upper case"
     (let ((text (point_cursor_to_string (buffer_info mark))))
          (delete_point_cursor (buffer_info mark))
          (create_text_save_buffer$ text)
          (back_char (string_length (insert (upcase text)))))
     (exchange_mark))




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; capinitial                                                               ;;;
;;;    This command initial caps a word.  It is bound as {esc}c.             ;;;
;;;                                                                          ;;;
;;;         (capinitial optional-integer)                                    ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom capinitial
     &doc "Inital capitalizes a word"
     &na (&pass count &default 1)
     (capinitialf count))

(defun capinitialf (       (count integer)
                    &local (start cursor)
                           (word string))
     (if (null count) (setq count 1))
     (setq start (copy_cursor current_cursor))
     (if (< count 1)
          (back_word (setq count (- count))))
     (do_n_times count
          (forward_word) (back_word)
          (with_cursor here
               (forward_char)
               (setq word (upcase (point_cursor_to_string here))))
          (rubout_char)
          (insert word)
          (if (^ (looking_at " "))
              (partial_lowercasef 1)))
     (if (< current_cursor start)
         (go_to_cursor start)))

;<FOXTST>DNK>KEYMACS>SOURCES>TEXT.EM  Ed: DNK Mon 18 Jun 1984 08:55:33
; Version of -- MON, 18 JUN 1984 08:55:33

;END
