;  SUI_TABS.EM,  EMACSSRC>EMACS*>EXTENSIONS>SUI>SOURCES, EMACS TEAM-DNK, 10/09/84
;  Standard User Interface for PT45, PST100, PT200 terminals: TAB macros
;  Copyright (c) 1984, Prime Computer, Inc., Natick, MA 01760

; Future: when TABS get put into source, eliminate the tab functions herein.

(defcom reset_tabs                     ; THIS IS EXECUTED AS PART OF INIT

     &doc "SUI:  Sets up default tabs every five spaces"
     (setq tab_list$ ())
     (let ((counter 0))
          (do_forever
              (setq tab_list$ (append tab_list$
                                 (list (setq counter (+ counter 5)))))
          (if (>= counter 130) (stop_doing))))
     (tablist_to_array tab_list$))

;Removed TUE, 09 OCT 1984 DNK; duplicates functionality in
;                              EMACS*>EXTENSIONS>SOURCES>TAB.EM
;(defun tablist_to_array (       (tab_list$ list)
;                         &local (counter integer)
;                                (next_tab integer)
;                                (position integer)
;                                (last_set boolean)
;                         &returns list)
;     (setq counter 0)
;     (setq position 0)
;     (setq last_set false)
;     (do_forever
;          (setq next_tab (car tab_list$))
;          (setq tab_list$ (cdr tab_list$))
;          (if (not last_set)
;              (if (= (cdr tab_list$) () )
;                  (setq last_set true)
;                  (setq last_tab$ (car tab_list$))
;                  (if (null last_tab$)
;                      (setq last_tab$ next_tab))))
;          (do_n_times (- next_tab position)
;               (if (= counter (array_dimension tab_array$)) (stop_doing))
;               (aset next_tab tab_array$ counter)
;               (setq counter (1+ counter)))
;          (if (null tab_list$) (stop_doing))
;          (setq position next_tab))
;     (fill_array tab_array$ last_tab$ next_tab))

(defcom sui_tab
    &doc "SUI:  Tab function"
    &na (&pass count &default 1)
    (if (null sui_tabs_initialized$) (sui_initialize_tabs$))
                                       ; do the initialization if need be
    (if (> count 0)
        (do_n_times count (sui_tabf))
     else
        (do_n_times (- count) (sui_back_tabf))))

(defun sui_tabf (&local (cur_pos integer))
   (if (>= (cur_hpos) last_tab$)
       (info_message "You've tabbed over too far")
       (ring_the_bell)
       (return))
   (setq cur_pos (aref tab_array$ (cur_hpos)))
   (if (go_to_hpos cur_pos) (return))
   (end_line)
   (whitespace_to_hpos cur_pos))

(defcom sui_back_tab
    &doc "SUI:  Moves cursor to previous tab stop"
    &na (&pass count &default 1)
    (if (null sui_tabs_initialized$) (sui_initialize_tabs$))
                                       ; do the initialization if need be
    (do_n_times count (sui_back_tabf)))

(defun sui_back_tabf (&local (current_tab integer)
                              (prev_tab integer)
                              (down_counter integer))
    (if (= (cur_hpos) 1) (return))
    (if (> (cur_hpos) last_tab$)
        (go_to_hpos last_tab$)
        (return))
    (setq current_tab (aref tab_array$ (cur_hpos)))
    (setq prev_tab (aref tab_array$ (1- (cur_hpos))))
    (if (^= current_tab prev_tab) (setq current_tab prev_tab))
    (setq down_counter (1- current_tab))
    (do_forever
         (if (= (aref tab_array$ down_counter) current_tab)
             (setq down_counter (1- down_counter))
             (if (= down_counter 1)
                 (begin_line) (return))
         else
             (go_to_hpos (aref tab_array$ down_counter))
             (return))))

(defcom sui_set_tabs
    &doc "SUI:  Sets tabs to what you want"
    (info_message "Preparing to set tabs ...")
    (set_tabsf)
    (set_permanent_key "^i" "sui_tab")); HOLDS FOR PT45, PST100, and PT200

(defun set_tabsf (&local (counter integer))
      (save_position
         (go_to_cursor (find_buffer ".tab"))
         (buffer_info dont_show true)  ; conceal it in ^X^B listings
         (mark_whole)
         (delete_region)
         (setq counter 1)
         (do_n_times 9
              (insert "         ")
              (insert (integer_to_string (modulo counter 10)))
              (setq counter (1+ counter)))
         (cr)
         (do_n_times 9
              (insert "....5....0"))
         (cr)
         (cr)
         (cr)
         (insert "
 Type a line of spaces and T's.  All other characters will later be ignored.
         If you make a mistake, use the BACK SPACE key to repair it,
    and then continue your line of T's.  You can't use the cursor keys.
          Abort with the ^G key.  Finish with the RETURN key.")
         (do_n_times 6 (prev_line_command))
                                       ; get back to the empty line below ruler
         (minibuffer_print
"Type T's at desired tab positions -- finish with the RETURN key.")
         (get_input)
         (parse_line)
         (info_message "")             ; clear any info_messages out
    (sui_refresh)))

(defun get_input ()
    (do_forever
        (wait_for_input)
        (self_insert (read_character))
        (back_char)
        (if_at "~n"                    ; if user types a RETURN, exit.
            (delete_char)
            (unmodify)                 ; ignore any changes to this buffer
            (stop_doing)
        else
           (if_at "~cH"                ; if at a backspace
               (delete_char)
               (rubout_char)
            else
               (if_at "~cG"            ; if user types a ^G
                   (unmodify)          ; ignore any changes to this buffer
                   (abort_command)
                else
                   (if_at "t"          ; uppercase any lowercase "t"s
                      (delete_char)
                      (insert "T")
                    else
                      (forward_char)))))))

(defun parse_line ()
    (info_message "Setting tabs...")
    (begin_line)                       ; start at the beginning of the line
    (if (^ (search_fd_in_line "T"))    ; if line contains NO T's,
    (reset_tabs)                       ; just do the default again
    (return)                           ; and get out
 else                                  ; if there ARE some T's, convert them
    (begin_line)                       ; start at the beginning of the line
    (setq tab_list$ ())
    (do_forever
        (if (search_fd_in_line "T")
            (setq tab_list$ (append tab_list$ (list (cur_hpos))))
            (if (^ (eolp)) (forward_char))
         else
            (stop_doing)))
    (tablist_to_array tab_list$)))

(defcom sui_insert_tab
   &doc "SUI:  Inserts spaces to next tab stop"
   &na (&pass count &default 1)
   (if (null sui_tabs_initialized$) (sui_initialize_tabs$))
                                       ; do the initialization if need be
   (do_n_times count
      (if (> (cur_hpos) 130) (return))
      (whitespace_to_hpos (aref tab_array$ (cur_hpos)))))

(defcom init_tab
   &doc "SUI:  Initial setting of tab key"
   &na 