;  KEY_ASSIGNMENTS.EM,  EMACS*>EXTENSIONS>OBSOLETE_SOURCES, TOOLS GROUP,05/19/82
;  Assigns library functions to keypaths
;  Copyright (c) 1982, Prime Computer, Inc., Natick, MA 01760
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;  Purpose: actually assign functions to keys.  Handles fundamental        ;;;
;;;  bindings explicitly; when keybindings is set, acts as described in      ;;;
;;;  select statement below.                                                 ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

   (if (null definitions_loaded$)
       (fasload "emacs*>extensions>definitions"))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; fundamental_bindings                                                     ;;;
;;;    This is the list of all functions in EMACS* that are bound to         ;;;
;;;    function keys                                                         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun fundamental_bindings ()
    (set_permanent_key "^i" "type_tab")
    (set_permanent_key "^[@" "mark_end_of_word")
    (set_permanent_key "^[\" "white_delete")
    (set_permanent_key "^[ " "leave_one_white")
    (set_permanent_key "^[^" "merge_lines")
    (set_permanent_key "^[^d" "kill_rest_of_buffer")
    (set_permanent_key "^[^i" "indent_to_fill_prefix")
    (set_permanent_key "^[^o" "split_line")
    (set_permanent_key "^[^v" "scroll_other_forward")
    (set_permanent_key "^[A" "backward_sentence")
    (set_permanent_key "^[a" "backward_sentence")
    (set_permanent_key "^[c" "capinitial")
    (set_permanent_key "^[C" "capinitial")
    (set_permanent_key "^[e" "forward_sentence")
    (set_permanent_key "^[E" "forward_sentence")
    (set_permanent_key "^[h" "mark_para")
    (set_permanent_key "^[H" "mark_para")
    (set_permanent_key "^[i" "indent_relative")
    (set_permanent_key "^[I" "indent_relative")
    (set_permanent_key "^[k" "forward_kill_sentence")
    (set_permanent_key "^[K" "forward_kill_sentence")
    (set_permanent_key "^[l" "lowercase_word")
    (set_permanent_key "^[L" "lowercase_word")
    (set_permanent_key "^[m" "back_to_nonwhite")
    (set_permanent_key "^[M" "back_to_nonwhite")
    (set_permanent_key "^[n" "next_buf")
    (set_permanent_key "^[N" "next_buf")
    (set_permanent_key "^[p" "prev_buf")
    (set_permanent_key "^[P" "prev_buf")
    (set_permanent_key "^[q" "fill_para")
    (set_permanent_key "^[Q" "fill_para")
    (set_permanent_key "^[t" "transpose_word")
    (set_permanent_key "^[T" "transpose_word")
    (set_permanent_key "^[u" "uppercase_word")
    (set_permanent_key "^[U" "uppercase_word")
    (set_permanent_key "^[^x1" "one_window")
    (set_permanent_key "^[^x2" "split_window")
    (set_permanent_key "^[^x3" "split_window_stay")
    (set_permanent_key "^x." "take_left_margin")
    (set_permanent_key "^x[" "backward_para")
    (set_permanent_key "^x]" "forward_para")
    (set_permanent_key "^x{" "horiz_left")
    (set_permanent_key "^x}" "horiz_right")
    (set_permanent_key "^x1" "mod_one_window")
    (set_permanent_key "^x2" "mod_split_window")
    (set_permanent_key "^x3" "mod_split_window_stay")
    (set_permanent_key "^x^h" "backward_kill_sentence")
    (set_permanent_key "^x^i" "insert_tab")
    (set_permanent_key "^x^l" "lowercase_region")
    (set_permanent_key "^x^j" "cret_indent_relative")
    (set_permanent_key "^x^k" "backward_kill_line")
    (set_permanent_key "^x^o" "delete_blank_lines")
    (set_permanent_key "^x^u" "uppercase_region")
    (set_permanent_key "^x^v" "view")
    (set_permanent_key "^x^w" "mod_write_file")
    (set_permanent_key "^xa" "append_to_buf")
    (set_permanent_key "^xA" "append_to_buf")
    (set_permanent_key "^xb" "mod_select_buf")
    (set_permanent_key "^xB" "mod_select_buf")
    (set_permanent_key "^xd" "explore")
    (set_permanent_key "^xD" "explore")
    (set_permanent_key "^xf" "set_right_margin")
    (set_permanent_key "^xF" "set_right_margin")
    (set_permanent_key "^xp" "prepend_to_buf")
    (set_permanent_key "^xP" "prepend_to_buf")
    (set_permanent_key "^xr" "repaint")
    (set_permanent_key "^xR" "repaint")
    (set_permanent_key "^xv" "scroll_other_backward")
    (set_permanent_key "^xV" "scroll_other_backward")
    (set_permanent_key "^x^z<" "mark_top")
    (set_permanent_key "^x^z>" "mark_bottom")
    (set_permanent_key "^x^z^a" "backward_clause")
    (set_permanent_key "^x^z^e" "forward_clause")
    (set_permanent_key "^x^z^h" "backward_kill_clause")
    (set_permanent_key "^x^z^k" "forward_kill_clause")
    (set_permanent_key "^x^z^y" "yank_kill_text")
    (set_permanent_key "^x^z^V" "view_lines")
    (set_permanent_key "^x^za" "append_to_file")
    (set_permanent_key "^x^zA" "append_to_file")
    (set_permanent_key "^x^zi" "insert_buf")
    (set_permanent_key "^x^zI" "insert_buf")
    (set_permanent_key "^x^zp" "prepend_to_file")
    (set_permanent_key "^x^zP" "prepend_to_file")
    (set_permanent_key "^x^zs" "center_line")
    (set_permanent_key "^x^zS" "center_line")
    (set_permanent_key "^x^zf" "take_right_margin")
    (set_permanent_key "^x^zF" "take_right_margin")
    (set_permanent_key "^x^zk" "view_kill_ring")
    (set_permanent_key "^x^zK" "view_kill_ring"))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; The function of the following form is to determine if the variable called;;;
;;; keybinding$ exists.  If it does, the user is in charge of making his own ;;;
;;; keybinding sets.  That is, the user will not get the fundamental bind-   ;;;
;;; ings.  This is done so that fundamental mode stuff does not interfere    ;;;
;;; with anyone's libraries.                                                 ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(if (null keybinding$)
    (fundamental_bindings)
 else
    (load_bindings$))

(setq key_assignments_loaded$ true)

