;  PT45.EM,  EMACS*>EXTENSIONS>OBSOLETE_SOURCES, TOOLS GROUP, 05/19/82
;  Standard PT45 interface.
;  Copyright (c) 1982, Prime Computer, Inc., Natick, MA 01760


(if (^= (terminal_info type) "pt45")
    (info_message "Your terminal is not a PT45, command aborted")
    (ring_the_bell)
    (return))

(if (null definitions_loaded$)
    (fasload "emacs*>extensions>definitions"))

(setq tab_array$ (make_array 'integer 140))
(setq other_buffer$ ())
(setq keybinding$ "pt45")


(defun load_bindings$ ()
    (fasload "emacs*>extensions>pt45_function_keys")
    (fasload "emacs*>extensions>pt45_bindings"))

(defun do_nothing$ ()
   () )


(defun set_windows$ ()
    (if (= (major_window_count) 2)
        (setq was_two_windows$ true)
        (if (^= (window_info top_line) 1)
            (setq switched_windows$ true)
            (other_window)
         else
            (setq switched_windows$ false))
        (one_file_mode)
     else
        (setq was_two_windows$ false)))

(defun restore_windows$ ()
    (if (not was_two_windows$) (return))
    (two_file_mode)
    (if (not switched_windows$)
        (other_window)))

(defcom repaint
     &doc "Moves cursor to first line of screen"
     &na (&pass count &default 1)
     (goto_line (line_number (window_info top_line_cursor))) ; goto top line
     (let ((window_length (1+ (- (window_info bottom_line)   ; compute length
                                 (window_info top_line)))))  ; of window
          (if (> count window_length)                        ; make sure arg is
              (setq count window_length)                     ; in range
              (ring_the_bell)
              (info_message "Argument too big, it has been reset")))
     (begin_line)
     (if (> count 1)                  ; process argument
         (next_line (1- count))
      else
         (if (< count 1)
             (info_message "Negative arguments are not accepted")
             (ring_the_bell))))


(defcom one_file_mode
    &doc "Creates a single window"
    (other_window)                     ; retain name of other window's buffer
    (setq other_buffer$ (copy_cursor current_cursor))
    (other_window)
    (one_window))

(defcom two_file_mode
    &doc "Split windows"
    &na (&pass count &default -99999)
    (if (= count -99999)
        (setq count (/ (1+ (- (window_info bottom_line)
                              (window_info top_line)))
                       2)))
    (split_window count)               ; same as split_window
    (if (not (null other_buffer$))      ; go to what was there previously
        (go_to_cursor other_buffer$)))


(defcom toggle_two_file_mode
     &doc "Split/unsplit window"
     (if (& (= (window_info top_line)     1)
            (= (window_info bottom_line) 21))
         (two_file_mode)
     else
         (one_file_mode)))

(defcom highlight
     &doc "Used for reverse video"
     (send_raw_string "F5 dQF6 F7 H"))
;    (send_raw_string "$F5 $dQ$F6 $F7 $H");above line with ESC translated to $
     ;above escape sequence, and its meaning:
     ;ESC F 5 space          cursor address, line 22, column 1
     ;ESC dQ                 attribute set, reverse-half
     ;ESC F 6 space          cursor address, line 23, column 1
     ;ESC F 7 space          cursor address, line 24, column 1
     ;ESC H                  home cursor


(defcom re_fresh
     &doc "Refresh that highlights bottom of screen"
     (refresh)
     (highlight))

(defcom query_replace_forward
     &doc "Query replace"
     (save_position
          (mark)
          (move_bottom)
          (exchange_mark)
          (query_replace)))

(defcom replace_forward
     &doc "Replace one string with another"
     (save_position
          (mark)
          (move_bottom)
          (exchange_mark)
          (replace)))

(defcom get_file
     &doc "Loads a new file"
     (if (buffer_info modified)
         (if (yesno "Save this file?")
             (mod_write_file)))
     (delete_buffer_command)
     (go_to_buffer ".scratch")
     (buffer_info default_file "")
     (find_file (prompt "Get File")))


(defcom help
   &doc "Help command"
   (with_command_abort_handler
      (set_windows$)
      (save_excursion
          (with_no_redisplay
              (setq pathname$ "emacs*>info>")
              (go_to_buffer "menu")
              (delete_buffer_command)
              (find_file (catenate pathname$ "menu"))
              (redisplay))
          (do_forever
              (minibuffer_print "RETURN = exit this level")
              (setq choice$ (blinking_prompt))
              (minibuffer_print "")
              (select choice$
                      "1"     (help_template "1")
                      "2"     (help_template "2")
                      "3"     (help_explain)
                      "4"     (null_function)
                      "5"     (null_function)
                      otherwise
                              (stop_doing))))
        (restore_windows$)
    command_abort_handler
       (restore_windows$)))


(defcom help_explain
   (save_excursion
         (with_no_redisplay
               (go_to_buffer "menu2")
               (delete_buffer_command)
               (find_file (catenate pathname$ "menu2"))
               (redisplay))
         (do_forever
             (minibuffer_print "RETURN = exit this level")
             (setq choice$ (blinking_prompt))
             (select choice$
                     "1"     (explain_it "extend_command")
                     "2"     (explain_it "help")
                     "3"     (explain_it "mark_cut_paste")
                     "4"     (explain_it "searching")
                     "5"     (explain_it "searching_and_replacing")
                     "6"     (explain_it "cursor_positioning")
                     "7"     (explain_it "get_file")
                     "8"     (explain_it "write_file")
                     "9"     (explain_it "insert_file")
                     "10"    (explain_it "two_file_mode")
                     "11"    (explain_it "word_char")
                     "12"    (explain_it "save_file")
                     "13"    (explain_it "tab")
                   otherwise
                             (return)))))

(defun explain_it ((fname string))
    (save_excursion
        (with_no_redisplay
             (go_to_buffer (catenate fname "_info"))
             (delete_buffer_command)
             (find_file (catenate pathname$ (catenate fname "_info")))
             (redisplay))
        (prompt "RETURN = exit this level")))

(defun help_template ((function_display string))
    (save_excursion
        (go_to_buffer ".help")
        (delete_buffer_command)
        (set_mode "help")
        (insert_file (catenate pathname$ "template_a" function_display))
        (move_bottom)
        (grph)
        (insert_file (catenate pathname$ "template_b" function_display))
        (move_bottom)
        (grph_off)
        (insert_file (catenate pathname$ "template_c" function_display))
        (minibuffer_print "")
        (move_bottom)
        (setq choice$ (prompt "RETURN = exit this level"))
        (delete_buffer_command)))

(defun blinking_prompt (&local   (response string)
                        &returns string)
        (do_forever
            (send_raw_string "F6 dPF6<dQ")
            (setq response (prompt "Please make your selection "))
            (if (not (< response " "))
                (return response))))

(defun grph ()
    (send_raw_string "R"))
(defun grph_off ()
    (send_raw_string "S"))

(defcom unload
    &doc "Unloads region to specified file"
    &args ((trnam &prompt "Pathname"))
     (save_position
         (with_no_redisplay
             (copy_region)
             (go_to_buffer ".temp")
             (delete_buffer_command)
             (yank_region)
             (write_file trnam)
             (delete_buffer_command))))

(defcom dunload
   &doc "Deletes and unloads region to file"
   &args ((trnam &prompt "Pathname"))
   (save_position
       (with_no_redisplay
          (kill_region)
          (go_to_buffer ".temp")
          (delete_buffer_command)
          (yank_region)
          (write_file trnam)
          (delete_buffer_command))))

(defcom delete_buffer_command
     &doc "Command for deleting a buffer"
     (delete_buffer)
     (unmodify))

(defcom spool
     &doc "PRIMOS command: Spools a file"
     &args ((pathname &prompt "Filename"))
     (save_position
        (primos_command (catenate "spool " pathname)))
     (re_fresh))

(defcom status
     &doc "PRIMOS command: Shows status information"
     &args ((status &prompt "Status"))
     (primos_internal_screen (catenate "status " status))
     (re_fresh))

(defcom listf
     &doc "PRIMOS command: Provides a directory listing"
     (primos_internal_screen "listf")
     (re_fresh))

(defcom attach
     &doc "PRIMOS command: Attaches to a different directory"
     &args ((pathname &prompt "Pathname"))
     (primos_internal_screen (catenate "a " pathname))
     (re_fresh))

(fset 'a (fsymeval 'attach))
(fset 'stat (fsymeval 'status))
(fset 'l (fsymeval 'listf))

(defcom delete_line
     &doc "Deletes an entire line"
     (begin_line)
     (kill_line)
     (if_at "~n"
        (kill_line)))


(defcom mod_overlay_on
     &doc "Toggle overlay mode"
     (overlay_onf$)
     (set_permanent_key "^[Q" "mod_overlay_off"))

(defcom mod_overlay_off
    &doc "Toggle overlay mode"
    (overlay_offf$)
    (set_permanent_key "^[Q" "mod_overlay_on"))

(defun overlay_onf$ ()
    (info_message "Wait ... ")
    (fasload "emacs*>extensions>overlay")
    (overlay_onf$)
    (info_message ""))


(defcom reset_tabs
     &doc "Sets up default tabs every five spaces"
     (setq tab_list$ ())
     (let ((counter 0))
          (do_forever
              (setq tab_list$ (append tab_list$
                                 (list (setq counter (+ counter 5)))))
          (if (>= counter 130) (stop_doing))))
     (tablist_to_array tab_list$))



(defun tablist_to_array (       (tab_list$ list)
                         &local (counter integer)
                                (next_tab integer)
                                (position integer)
                                (last_set boolean)
                         &returns list)
     (setq counter 0)
     (setq position 0)
     (setq last_set false)
     (do_forever
          (setq next_tab (car tab_list$))
          (setq tab_list$ (cdr tab_list$))
          (if (not last_set)
              (if (= (cdr tab_list$) () )
                  (setq last_set true)
                  (setq last_tab$ (car tab_list$))
                  (if (null last_tab$)
                      (setq last_tab$ next_tab))))
          (do_n_times (- next_tab position)
               (if (= counter (array_dimension tab_array$)) (stop_doing))
               (aset next_tab tab_array$ counter)
               (setq counter (1+ counter)))
          (if (null tab_list$) (stop_doing))
          (setq position next_tab))
     (fill_array tab_array$ last_tab$ next_tab))



(reset_tabs)


(defcom pt45_tab
    &doc "Tab"
    &na (&pass count &default 1)
    (if (> count 0)
        (do_n_times count (pt45_tabf))
     else
        (do_n_times (- count) (pt45_back_tabf))))


(defun pt45_tabf (&local (cur_pos integer))
   (if (>= (cur_hpos) last_tab$)
       (info_message "You've tabbed over too far")
       (ring_the_bell)
       (return))
   (setq cur_pos (aref tab_array$ (cur_hpos)))
   (if (go_to_hpos cur_pos) (return))
   (end_line)
   (whitespace_to_hpos cur_pos))


(defcom pt45_back_tab
    &doc "Moves cursor to previous tab stop"
    &na (&pass count &default 1)
    (do_n_times count (pt45_back_tabf)))
(defun pt45_back_tabf (&local (current_tab integer)
                              (prev_tab integer)
                              (down_counter integer))
    (if (= (cur_hpos) 1) (return))
    (if (> (cur_hpos) last_tab$)
        (go_to_hpos last_tab$)
        (return))
    (setq current_tab (aref tab_array$ (cur_hpos)))
    (setq prev_tab (aref tab_array$ (1- (cur_hpos))))
    (if (^= current_tab prev_tab) (setq current_tab prev_tab))
    (setq down_counter (1- current_tab))
    (do_forever
         (if (= (aref tab_array$ down_counter) current_tab)
             (setq down_counter (1- down_counter))
             (if (= down_counter 1)
                 (begin_line) (return))
         else
             (go_to_hpos (aref tab_array$ down_counter))
             (return))))


(defcom set_tabs
    &doc "Sets tabs to what you want"
    (set_tabsf)
    (set_permanent_key "^i" "pt45_tab"))

(defun set_tabsf (&local (counter integer))
      (save_position
         (go_to_cursor (find_buffer ".tab"))
         (mark_whole)
         (delete_region)
         (setq counter 1)
         (do_n_times 9
              (insert "         ")
              (insert (integer_to_string (modulo counter 10)))
              (setq counter (1+ counter)))
         (cr)
         (do_n_times 9
              (insert "....5....0"))
         (cr)
         (minibuffer_print "Type T's at desired tab positions - finish with [RETURN]")
         (get_input)
         (unmodify)
         (parse_line)
    (re_fresh)))

(defcom get_input
    (do_forever
        (wait_for_input)
        (self_insert (read_character))
        (back_char)
        (if_at "~n"
            (delete_char)
            (stop_doing)
        else
           (if_at ""
               (delete_char)
               (rubout_char)
            else
               (if_at ""
                   (abort_command)
                else
                   (if_at "t"
                      (delete_char)
                      (insert "T")
                    else
                      (forward_char)))))))

(defun parse_line ()
    (begin_line)
    (setq tab_list$ ())
    (do_forever
        (if (search_fd_in_line "T")
            (setq tab_list$ (append tab_list$ (list (cur_hpos))))
            (if (^ (eolp)) (forward_char))
         else
            (stop_doing)))
    (tablist_to_array tab_list$))

(defcom pt45_insert_tab
   &doc "Inserts spaces to tab stop"
   &na (&pass count &default 1)
   (do_n_times count
      (if (> (cur_hpos) 130) (return))
      (whitespace_to_hpos (aref tab_array$ (cur_hpos)))))

(set_permanent_key "^x^i" "pt45_insert_tab")


(defun null_function ()
   (info_message "This key is not used")
   (ring_the_bell))   ; disable key

(defcom init_tab
   &na (&pass count &default 1)
   (set_permanent_key "^i" "pt45_tab")
   (info_message "To set tabs, enter command mode and type: set_tabs")
   (pt45_tab count))

(defcom toggle_word ()
     &doc "COBOL: Changes from char to word mode"
     (turn_mode_on (find_mode 'word) first)
     (set_mode_key "word" left$ "back_word")
     (set_mode_key "word" right$ "forward_word")
     (set_mode_key "word" del$ "delete_word")
     (set_mode_key "word" "^h" "rubout_word")
     (set_mode_key "word" dchar$ "delete_word")
     (set_mode_key "word" f16$ "toggle_char"))
(defun toggle_char (&local (word dispatch))
     &doc "Changes from word to char mode"
     (turn_mode_off (find_mode 'word)))

(defcom toggle_cobol_word ()
     &doc "Changes from char to word mode"
     (turn_mode_on (find_mode 'cobol_word) first)
     (set_mode_key "cobol_word" left$ "cobol_back_word")
     (set_mode_key "cobol_word" right$ "cobol_forward_word")
     (set_mode_key "cobol_word" del$ "cobol_delete_word")
     (set_mode_key "cobol_word" "^h" "cobol_rubout_word")
     (set_mode_key "cobol_word" dchar$ "cobol_delete_word")
     (set_mode_key "cobol_word" f16$ "toggle_cobol_char"))
(defun toggle_cobol_char (&local (word dispatch))
     &doc "COBOL: Changes from word to char mode"
     (turn_mode_off (find_mode 'cobol_word)))

(defcom mod_write_file
    &doc "Write specified file"
    &args ((place &prompt "Write file" &string))
    (if (= place "")
        (setq place (file_name current_cursor)))
    (if (file_info place exists)  ;check if file exists
        (if (^ (yesno "This file already exists. Do you want to overwrite it"))
            (mod_write_file)
            (return)))
    (write_file place))


(defcom cobol_pt45_back_tab
    &doc "COBOL: Back tab for PT45"
    &na (&pass count &default 1)
    (pt45_back_tab count)
    (if (< (cur_hpos) 7)
        (cobol_begin_line)))

(setq pt45_loaded$ true)
