; CC.EM, EMACS*>EXTENSIONS>SOURCES, EMACS DEVELOPMENT, 01/04/88
; C Language-mode macros
; Copyright (C) 1982, Prime Computer, Inc., Natick, MA 01760
;
; Modifications:
;
;   Date    Engineer      Modification
; 01/04/88  Bugos/        In both cc_add_local_def$ and cc_add_global_def$,
;           Litterio      replaced "<.type>" (incorrect form) with "<.type.>"
;                         (correct form).
; 03/26/87  Litterio      Removed a (prompt "") used for debugging.
; 02/15/85  Rand          Initial coding.
;

(defcom cc_on
  (turn_mode_on (find_mode 'cc) first)
  (buffer_info (user language_name$) "cc")
  (if (null cc_loaded$) (init_cc))
  (info_message "CC Language Mode ON;  Type ^x? for help."))

(defcom cc_off
  (turn_mode_off (find_mode 'cc))
  (buffer_info (user language_name$) '())
  (info_message "CC Language Mode OFF"))

(defcom init_cc
   (spd_load_file "emacs*>extensions>spd>cc")
   (spd_on)
   (if (null cc_pp$_0) (setq cc_pp$_0 2)) ; current right margin
   (set_mode_key "cc" "^j" "cret_indent_relative")
   (set_mode_key "cc" "^x\" "pp_region")
   (set_mode_key "cc" "^xl1" "cc_pp_function$")
   (set_mode_key "cc" "^xl0" "pp_cursors")
   (set_mode_key "cc" "^xg" "cc_add_global_def$")
   (set_mode_key "cc" "^xc" "cc_add_local_def$")
   (set_mode_key "cc" "^x/" "cc_ret_from_def$")
   (set_mode_key "cc" "^x?" "cc_help$")
   (init_cc_actions)
   (epf_defun cc "RTCC" "*" "kk" "")
   (setq cc_loaded$ true)
)

(defun cc_pp_function$ ()
    (insert "~n/* PP FUNCTION */~n")
    (prev_line)
    (save_excursion
        (pp_region))
    (kill_line 2)
    (rubout_char))

(defun cc_add_global_def$()
    (setq cc_def_retn_cursor$ (copy_cursor current_cursor))
    (if (reverse_search "/* GLOBAL DECLARATIONS */")
       (next_line 2)
       (insert "<.type.> <.identifier.>;~n")
       (mark)
       (prev_line)
       (pp_region)
   )
)

(defun cc_add_local_def$()
    (setq cc_def_retn_cursor$ (copy_cursor current_cursor))
    (if (reverse_search "/* LOCAL DECLARATIONS */")
       (next_line 2)
       (insert "<.type.> <.identifier.>;~n")
       (mark)
       (prev_line)
       (pp_region)
   )
)

(defun cc_ret_from_def$()
    (go_to_cursor cc_def_retn_cursor$)
)

(defcom make_prog
  &doc "Insert a program template."
  (with_no_redisplay
    (insert "/* GLOBAL DECLARATIONS */") (cr)
    (insert "  <.type.> <.identifier.>;") (cr)
    (insert "  ") (cr)
    (insert "<.type.> <.name.> (<.arg_identifier.>)") (cr)
    (insert "  <.type.> <.arg_identifier.>;") (cr)
    (insert "  {") (cr)
    (insert "  /* LOCAL DECLARATIONS */") (cr)
    (insert "  ") (cr)
    (insert "   <.type.> <.identifier.>;") (cr)
    (insert "   ") (cr)
    (insert "   <.statement.>") (cr)
    (insert "   }") (cr)
    (mark)
    (reverse_search "/* GLOBAL DECLARATIONS */")
    (pp_region)
  )
  (exchange_mark)
  (forward_place_holder)
)

(defcom make_func
  &doc "Insert a function template."
  (with_no_redisplay
    (insert "/* PP FUNCTION */") (cr)
    (insert "<.type.> <.name.> (<.arg_identifier.>)") (cr)
    (insert "    <.type.> <.arg_identifier.>;") (cr)
    (insert "{") (cr)
    (insert "/* LOCAL DECLARATIONS */") (cr)
    (insert "") (cr)
    (insert "   <.type.> <.identifier.>;") (cr)
    (insert "") (cr)
    (insert "   <.statement.>") (cr)
    (insert "}") (cr)
    (mark)
    (reverse_search "/* PP FUNCTION */")
    (pp_region)
    )
  (exchange_mark)
  (kill_line)
  (forward_place_holder)
)

(defcom init_cc_actions
  (setq cc$.dt_spec_fun_hd '(0 "N"))
  (setq cc$.fun_head '(0 "li"))
  (setq cc$.param_dcl1 '(0 "ls#1"))
  (setq cc$.param_dcl2 '(0 "ls#"))
  (setq cc$.fun_bod_b '(0 "li.+#2"))
  (setq cc$.fun_bod_e '(0 "^li"))
  (setq cc$.fun_dcl1 '(0 "ls#1"))
  (setq cc$.fun_dcl2 '(0 "ls#1"))
  (setq cc$.ext_data_dcl1 '(0 "ls#1"))
  (setq cc$.ext_data_dcl2 '(0 "ls#1"))
  (setq cc$.int_data_dcl1 '(0 "ls#1"))
  (setq cc$.int_data_dcl2 '(0 "ls#1"))
  (setq cc$.statement '(0 "l"))
  (setq cc$.comp_stat_dec '(0 "l"))
  (setq cc$.comp_stat_b '(0 "lb#2i"))
  (setq cc$.comp_stat_e '(0 "lb#2i"))
  (setq cc$.case_list_b '(0 "li.+#2.+#2"))
  (setq cc$.case_list_e '(0 "^^li"))
  (setq cc$.case_lbl '(0 "n"))
  (setq cc$.case_hdr '(0 "lb#3"))
  (setq cc$.case_dflt_lbl '(0 "n"))
  (setq cc$.case_dflt_hdr '(0 "lb#3"))
  (setq cc$.if_stat '(0 "l"))
  (setq cc$.if_end '(0 "^"))
  (setq cc$.if_else '(0 "lb#3"))
  (setq cc$.if_else_stat '(0 "l"))
  (setq cc$.if_hdr '(0 "li.+#2"))
  (setq cc$.while_hdr '(0 "l.+#2"))
  (setq cc$.while_stat '(0 "l"))
  (setq cc$.while_end '(0 "^"))
  (setq cc$.do_hdr '(0 "li.+#2"))
  (setq cc$.do_stat '(0 "li"))
  (setq cc$.do_while '(0 "^l"))
  (setq cc$.for_hdr '(0 "li.+#2"))
  (setq cc$.for_stat '(0 "li"))
  (setq cc$.for_end '(0 "^"))
  (setq cc$.struct_b '(0 "li"))
  (setq cc$.union_b '(0 "li"))
  (setq cc$.enum_list_b '(0 "li.+#2"))
  (setq cc$.enum_list_e '(0 "^li"))
  (setq cc$.agg_dcl_b '(0 "li.+#2"))
  (setq cc$.agg_dcl_e '(0 "^li"))
  (setq cc$.mem_dcl '(0 "n"))
  (setq cc_pp$_0 2)
  (setq cc_pp$_1 4)
  (setq cc_pp$_2 4)
  (setq cc_pp$_3 4)
  (setq cc_pp$_4 4)
  (setq cc_pp$_5 4)
  (setq cc_pp$_6 8)
  (setq cc_pp$_7 4)
  (setq cc_pp$_8 4)
  (setq cc_pp$_9 4)
)

(defcom cc_help$
  (init_local_displays "The C Language Mode offers the following features:")
  (local_display_generator " ")
  (local_display_generator "    The COMMANDS:")
  (local_display_generator
"            ^x\   pretty print a marked region (only for whole files ")
  (local_display_generator
"                  or inside a function - otherwise use ^xl1);")
  (local_display_generator
"            ^xl1  pretty print a function and/or definition not part ")
  (local_display_generator
"                  of a function body (inside the first brace);")
  (local_display_generator
"            ^xl0  pretty print a just inserted ""template region;"""       )
  (local_display_generator
"            ^xg   add a global declaration;")
  (local_display_generator
"            ^xc   add a local (in the current function) declaration;")
  (local_display_generator
"            ^x/   return from an inserted declaration (^xg or ^xc);")
  (local_display_generator
"            ^x?   print this help;")
  (local_display_generator
" ")
  (local_display_generator
"    The Templates: ")
  (local_display_generator
" ")
  (local_display_generator
"            /prog  to begin a program    /func  to begin a new function")
  (local_display_generator
"            /block, /body, /{ for { <.statement.> } ")
  (local_display_generator
"            /if        => if <.condition.> <.statement.>" )
  (local_display_generator
"            /ifelse    => if <.condition.> <.statement.> else <.statement.>")
  (local_display_generator
"            /for       => for (<.expr.>;<.expr.>;<.expr.>) <.statement.>")
  (local_display_generator
"            /do        => do <.statement.> while(<.expr.>;")
  (local_display_generator
"            /while     => while (<.expr.>) <.statement.> ")
  (local_display_generator
"            /switch    => switch { case <.expr.>: <.stat.> default : <.stat.>}")
  (local_display_generator
"              /case    => case <.expr.> : <.statement.> ")
  (local_display_generator
  "              /default => default : <.statement.> ")
  (local_display_generator
"            /struct    => struct { <.type> <.dentifier.>; } ")
  (local_display_generator
"            /union     => union { <.type> <.dentifier.>; } " )
  (local_display_generator
"            /dcl       => <.type.> <.identifier.>; ")
  (local_display_generator " ")
)
