; CLISP.EM, EMACSSRC>EMACS*>EXTENSIONS>SOURCES, EMACS DEVELOPMENT, 04/17/87
; Common-lisp specific mode
; Copyright (c) 1986, Prime Computer, Inc., Natick, MA 01760
;                     All Rights Reserved

; Description:
;
; Supplies shadowed key sequences to send a marked region for eval
; Sets up two window lisp viewer
; Sets up coroutine interface with Lisp
;
; Commands:
;    CL_on          turns on the shadow mode for Common_lisp.  This will also
;                   turn on lisp mode
;    CL_off         turns off the mode
;    CL_send_region sends the current region to common_lisp
;    CL_macroexpand_region
;    CL_compile_region
;    CL_describe_current_symbol
;    CL_send_file   tell CL to load file (after save)
;    CL_help
;
;    CL_listener    puts the user in a lisp listener window (:listener)
;
;    CL_balbak      Common LISP parens balancer ( in SPL from SAI - modified )
;
; Modifications:
;   Date   Programmer     Description of modification
; 04/17/87 Rand           Removed fancier CL_INDENT, now just indent
;                         lisp_indent_amount$ from current indentation
; 11/07/86 Rand           Fixed so that extra cr is not appended to input line
; 10/07/86 Rand           Changed CL_..._region to not echo input in LISTENER
; 10/01/86 Rand           Removed temp fix
; 07/28/86 Rand           Fixed output from temp fix to CL
; 07/15/86 Rand           Added typin mode to CLISP mode
; 07/15/86 Rand           Fixed lisp initialization in listener
; 07/07/86 Rand           Changed clsp to return and integer and directly
;                         insert results in buffer
; 06/20/86 Rand           Added ~n to all other sent things, changed listener
;                         window name to [listener], and changed
;                         cl_display_results to handle being in the listener
;                         window already.
; 06/18/86 Rand           Changed listener cr to append a ~n to the line
; 01/30/86 Rand           Initial coding.

(defun clsp (string &local rv)
       (info_message "[Working]")
       (if (= (buffer_name current_cursor) *listener-buffer*)
           (setq rv (common_lisp string))
           else
           (save_excursion
              (select_buf *listener-buffer*)
              (move_bottom)
              (setq rv (common_lisp string))
              ))
       (info_message "")
       rv)

(defun clsp-2 (message string &local rv)
       (info_message "[Working]")
       (save_excursion
          (with_no_redisplay
             (select_buf *listener-buffer*)
             (move_bottom)
             (insert message)
             ;; (insert string)
             (cr)
             (setq rv (common_lisp (catenate string NL)))))
       (info_message "")
       rv)

(defcom cl_close_paren
        &doc "Lisp: Flashes matching open parenthesis (iff on screen)"
        (cl_close_parenf))

(defun cl_close_parenf (&local s l t b)
       (insert ")")                    ; insert the close parenthesis
       (if (have_input_p) (return))    ; ignore if type ahead anyway
       (setq l (copy_cursor current_cursor))
       (setq t (window_info top_line_cursor))
       (with_no_redisplay
          (save_excursion
             (if (not (cl_balbak 1))
                 (ring_the_bell)
                 (info_message "Unbalanced parenthesis")
                 (return))
             (setq b (copy_cursor current_cursor))
             (forward_char)
             (setq s (copy_cursor current_cursor))
             (forward_word)
             (setq s (range_to_string s current_cursor))
             ))
       ;; in range?
       (if (>= b t)
           (go_to_cursor b)
           (redisplay)
           (sleep_for_n_milliseconds lisp.paren_time)
           (go_to_cursor l)
           else
           (info_message (catenate "Closed: " s))
           )
       )

(defcom cl_on
        &doc "CL: Turns on common_lisp mode"
        (if (^ (member (find_mode 'lisp) (buffer_info modes)))
            (lisp_on))
        (turn_mode_on (find_mode 'common_lisp) first)
        (if (null cl_mode_initialized) (cl_init)))

(defcom cl_off
        &doc "CL: Turns off common_lisp mode"
        (turn_mode_off (find_mode 'common_lisp))
        (turn_mode_off (find_mode 'lisp)))

(defcom cl_send_region
        &doc "CL: Sends region to common_lisp and displays results"
        (let ((acur) (bcur) (input) (result))  ; cursors for start and end of region
             (setq acur (copy_cursor current_cursor))
             (exchange_mark)
             (setq bcur (copy_cursor current_cursor))
             (exchange_mark)
             (setq result (clsp-2 ";;; Reading input from region"
                                  (setq input (range_to_string acur bcur))))
             (cl_display_results result)
             )
        )

(defcom cl_describe_current_symbol
        &doc "CL: (describe current_symbol)"
        (let ((acur) (bcur) (input) (result)); cursors for start and end of region
             (if (search_bk_in_line "() ,") (forward_char))
             (setq acur (copy_cursor current_cursor))
             (search_fd_in_line "() ,")
             (setq bcur (copy_cursor current_cursor))
             (setq result (clsp-2 ";;; Describing symbol"
                             (setq input
                                      (catenate "(describe '" (range_to_string acur bcur) ")"))))
             (cl_display_results result)
             )
        )

(defcom cl_macroexpand_region
        &doc "CL: Sends region to common_lisp for macroexpansion"
        (let ((acur) (bcur) (input) (result)); cursors for start and end of region
             (setq acur (copy_cursor current_cursor))
             (exchange_mark)
             (setq bcur (copy_cursor current_cursor))
             (exchange_mark)
             (setq result (clsp-2 ";;; Macroexpanding region"
                             (setq input
                                      (catenate "(macroexpand '" (range_to_string acur bcur) ")"))))
             (cl_display_results result)
             )
        )

(defcom cl_compile_region
        &doc "CL: Sends region to common_lisp for compilation"
        (let ((acur) (bcur) (input) (result)); cursors for start and end of region
             (setq acur (copy_cursor current_cursor))
             (exchange_mark)
             (setq bcur (copy_cursor current_cursor))
             (exchange_mark)
             (setq result (clsp-2 ";;; Compiling region"
                             (setq input
                                      (catenate "(compile " (range_to_string acur bcur) ")"))))
             (cl_display_results result)
             )
        )

(defcom cl_send_file
        &doc "CL: Tells CL to read in the current file"
        (if (buffer_info modified) (save_file))
        (let ((input (catenate "(load ~q" (buffer_info default_file) "~q)"))
              (rcode (clsp-2
                        (catenate ";;; Reading file "
                                  (buffer_info default_file))
                        input)))
             (cl_display_results rcode)))

(defcom cl_listener
        &doc "CL: Put the user in a lisp listener window"
        (if (null cl_mode_initialized) (cl_init))
        (select_buf *listener-buffer*)
        (if (null lisp_listener_inited$)
            (lisp_on)
            (turn_mode_on (find_mode 'listener) first)
            (cl_setup_listener_keys)
            (clsp "~cj")
            (buffer_info changed_ok true)
            (back_char)
            (setq *current_input_cursor* (copy_cursor current_cursor))
            (end_line)
            (setq lisp_listener_inited$ true)))

(defun cl_display_results (rcode)
       (if (^= (buffer_name current_cursor) *listener-buffer*)
           (one_window)
           (split_window)
           (cl_listener))
       (if (^= rcode 0)
           (cr)
           (select rcode
                   4 (insert "Common LISP: Throw to top level")
                   5 (insert "Error in LISP: Interrupt - Throw to top level")
                   6 (insert "Error in LISP: Suspended - Unrecoverable error")
                   7 (insert "Error in LISP: Quit - Unrecoverable error")
                   otherwise))
       (back_char)
       (setq *current_input_cursor* (copy_cursor current_cursor))
       (move_bottom)
       )

(defcom cl_send_lisp_line
        &doc "CL: Send current line to lisp"
        (end_line)
        (if (= current_cursor *current_input_cursor*)
            (print "Problem in sending current line, resetting")
            (move_bottom)
            (cr)
            (insert "> ")
            (back_char)
            (setq *current_input_cursor* (copy_cursor current_cursor))
            (end_line)
         else
            (go_to_cursor *current_input_cursor*)
            (forward_char)
            (setq *current_input_cursor* (copy_cursor current_cursor))
            (move_bottom)
            (cr)
            (let ((rcode (clsp (range_to_string *current_input_cursor*
                                                current_cursor))))
                 (back_char)
                 (setq *current_input_cursor* (copy_cursor current_cursor))
                 (move_bottom)
                 )))

(defun cl_setup_listener_keys ()
       (set_mode_key "listener" ")"   "cl_close_paren")
       (set_mode_key "listener" "^[e" "cl_send_region")
       (set_mode_key "listener" "^X?" "cl_listener_help")
       (set_mode_key "listener" "^[m" "cl_macroexpand_region")
       (set_mode_key "listener" "^[=" "cl_describe_current_symbol")
       (set_mode_key "listener" "^[z" "cl_compile_region")
       (set_mode_key "listener" "^j" "cl_send_lisp_line")
       )

;;(defcom cl_minibuffer
;;        &doc "CL: Setup for CL minibuffer"
;;        (let ((eval_string (prompt "CL"))
;;              (result)
;;              )
;;             (with_no_redisplay
;;                (save_excursion
;;                   (select_buf ".temp_clisp")
;;                   (delete_buffer)
;;                   (clsp eval_string)
;;                   (let ((cur1))
;;                        (setq cur1 (copy_cursor current_cursor))
;;                        (move_top)
;;                        (setq result (range_to_string current_cursor cur1)))))
;;             (print result)))

(defcom cl_cr
        &doc "CL: Cret to correct indentation for program"
        (cr)
        (cl_indent))

(defcom cl_indent
        &doc "CL: indent to correct indentation for program"
        (let ((indent_column 1))
             (insert ")")
             (with_no_redisplay
                (save_position
                   (if (cl_balbak 1)
                       (if_at "(("
                         (setq indent_column (1+ (cur_hpos)))
                         else
                         (setq indent_column (+ lisp_indent_amount$ (cur_hpos))))
                       )))
             (rubout_char)
             (indent_line_to_hpos indent_column)))


(defcom cl_help
       (init_local_displays "Keybindings for Common Lisp mode:")
       (local_display_generator "   esc-e    Send current region to Common LISP for interpretation")
       (local_display_generator "   esc-t    Save modified file then load into Common LISP")
       (local_display_generator "   esc-m    Send current region to Common LISP for macroexpansion")
       (local_display_generator "   esc-z    Send current region to Common LISP for compilation")
       (local_display_generator "   esc-=    Describe current symbol")
;;       (local_display_generator "   esc-.    Like the PL minibuffer for Common LISP")
       (local_display_generator "   )        Common LISP paren balancer")
       (local_display_generator "   esc-i    Indent to correct hcol")
       (local_display_generator "   cr       CR and indent to correct hcol")
       (local_display_generator "   ^x-?     This help")
       )

(defcom cl_listener_help
       (init_local_displays "Keybindings for Listener mode:")
       (local_display_generator "   esc-e    Send current region to Common LISP for interpretation")
       (local_display_generator "   esc-m    Send current region to Common LISP for macroexpansion")
       (local_display_generator "   esc-z    Send current region to Common LISP for compilation")
       (local_display_generator "   esc-=    Describe current symbol")
       (local_display_generator "   cr       Sends current line to Common LISP")
       (local_display_generator "   )        Common LISP paren balancer")
       (local_display_generator "   ^x-?     This help")
       )

(defun cl_init ()
       (spd_load_file "emacs*>extensions>spd>cl")
       (set_mode_key "common_lisp" ")"   "cl_close_paren")
       (set_mode_key "common_lisp" "^[e" "cl_send_region")
       (set_mode_key "common_lisp" "^[t" "cl_send_file")
       (set_mode_key "common_lisp" "^[m" "cl_macroexpand_region")
       (set_mode_key "common_lisp" "^[z" "cl_compile_region")
       (set_mode_key "common_lisp" "^[i" "cl_indent")
       (set_mode_key "common_lisp" "^[I" "cl_indent")
       (set_mode_key "common_lisp" "^[E" "cl_send_region")
       (set_mode_key "common_lisp" "^[T" "cl_send_file")
       (set_mode_key "common_lisp" "^[M" "cl_macroexpand_region")
       (set_mode_key "common_lisp" "^[Z" "cl_compile_region")
       (set_mode_key "common_lisp" "^[=" "cl_describe_current_symbol")
;;       (set_mode_key "common_lisp" "^[." "cl_minibuffer")
       (set_mode_key "common_lisp" "^j"  "cl_cr")
       (set_mode_key "common_lisp" "^X?" "cl_help")
       (setq *listener-buffer* "[listener]")
       (with_command_abort_handler
          (epf_defun common_lisp "CL$EMXE" "i" "s" "")
          (epf_defun cl_balbak "CL$RTCLBLBK" "b" "i" "")
        command_abort_handler
          (init_local_displays "See your system administrator about Common Lisp installation")
          (info_message "Common lisp not installed on this machine or bad ENTRY$ search rules")
          )
       (setq cl_mode_initialized true))
