; COBOL.EM,  EMACS*>EXTENSIONS>SOURCES, EMACS DEVELOPMENT, 02/03/88
; COBOL language-mode functions.
; Copyright (c) 1982, Prime Computer, Inc., Natick, MA 01760
;                     All Rights Reserved
;
;
; Description:
;
; Abnormal conditions:
;
; Implementation:
;
; Modifications:
;   Date   Engineer     Description of modification
; 02/03/88 Kokila       Moved cobol_wrap code from here to COBOL3.EM.
; 01/06/88 Bugos        Modified to eliminate insertion of blank line when
;                       COBOL language-mode is entered. (SPAR 4024104)
; 06/07/87 Kokila       Modified cobol_on to load the cobol template autamati
;                       cally when the language mode is on.  This is done only
;                       when the buffer is empty.  The template will be loaded
;                       by cobol85_on as well as cbl_on.  If the buffer is not
;                       empty and trying to load the template will give the
;                       error message in the form of "buffer is not empty".
; 08/07/87 Kokila       added cobol85_on and cobol85_off
; 11/02/87 Bugos        Effectively removed cobol_on and cobol_off.
; 03/10/86 MAM          Added cbl_on back, deleted old keybindings
;                       added cbl_off
; 09/09/85 Rand         Added disabled_in_cobol_mode$,  see cobol2 for longer
;                       comment on not_defined, etc. (must have rearranged it)
; 03/12/85 Sarkisian    Modified cobol_on; doesn't call tablist_to_array,
;                       calls tablist instead.
; 06/10/84 DNK          Added disabled_in_cobol_mode$ as an improvement on the
;                       too-vaguely-named "not_defined" macro.  Left the
;                       "not_defined" macro around just in case, but used the
;                       new disabled_in_cobol_mode$ macro wherever possible.
;                       Commented out the fundamental_cobol_keybindings$ macro
;                       here because it is duplicated, and better, in COBOL2.EM.
; 02/03/83 Zane         Initial coding.


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; FUNCTIONS:                                                               ;;;
;;;      cobol_indent$                                                       ;;;
;;;          Figures out what indentation should be                          ;;;
;;;      cobol_correct_length$                                               ;;;
;;;          Corrects line length for cobol_parse_region$                    ;;;
;;;      cobol_parse_for_blank_lines$                                        ;;;
;;;          Pads blank lines with spaces to ^n and ^z work best             ;;;
;;;      cobol_parse_region$                                                 ;;;
;;;          Makes sure lines, both left and right, are correct              ;;;
;;;      cobol_trim_line$                                                    ;;;
;;;          Makes sure lines aren't too long                                ;;;
;;;      disabled_in_cobol_mode$                                             ;;;
;;;          Used to disable commands                                        ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; COMMANDS:                                                                ;;;
;;;      See the Reference Guide, all are mentioned.                         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


; 02/03/83 removed by Zane   (if (null loaded$) (load))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Global Variables (initialized elsewhere:)

; 02/03/83 Zane         (setq begin_column$ 7)
; 02/03/83 Zane         (setq end_column$ 73)
; 02/03/83 Zane         (setq word_scan_table$ " ,.;:?!(){}[]~n")
; 02/03/83 Zane         (setq comment_column$ 7)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; disabled_in_cobol_mode$                                                  ;;;
;;;   Used to disable fundamental modes commands not used here.              ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom disabled_in_cobol_mode$
    &doc "COBOL: Disables commands not used in COBOL mode"
    (ring_the_bell)
    (info_message "This command is disabled in COBOL mode"))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_trim_line$                                                         ;;;
;;;   Makes sure the a line is the correct length                            ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun cobol_trim_line$ ()
     (let ((line# (line_number current_cursor)))
          (save_excursion
             (end_line)
             (if (> (cur_hpos) end_column$)
                 (go_to_hpos end_column$)
                 (search_bk_in_line " ")
                 (delete_white_sides)
                 (open_line)
                 (next_line)
                 (cobol_indent$)))
           (if (^= line# (line_number current_cursor))
               (prev_line)
               (end_line))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_indent$                                                            ;;;
;;;    Figures out where current line should be indented.                    ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun cobol_indent$ (&local (indentation integer))
     (save_excursion
          (if (prev_line)
              (end_line)
              (if (looked_at ".")
                  (setq indentation 12)
               else
                  (begin_line)
                  (if (line_is_blank)
                      (setq indentation 8)
                   else
                      (skip_over_white)
                      (setq indentation (cur_hpos))))
           else
               (setq indentation 12))
           (next_line)
           (whitespace_to_hpos indentation)))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_parse_for_blank_lines$                                             ;;;
;;;    Pads blank lines so that they have six blanks.                        ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun cobol_parse_for_blank_lines$ ()
                                       ; looks for blank lines and pads
                                       ; them with spaces
     (save_excursion
         (cobol_move_bottom)
         (move_top)
         (do_forever
             (if (forward_search "~n~n")
                 (prev_line)
                 (self_insert " " 6)
                 (prev_line)
              else
                 (stop_doing)))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_parse_region$                                                      ;;;
;;;    Makes sure lines are between columns 7 and 72.                        ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun cobol_parse_region$ ()
                                       ; checks to insure that nothing
                                       ; is in columns 1-6 and beyond 73
     (save_excursion
        (if (< (buffer_info mark) current_cursor)
            (exchange_mark))
        (begin_line)
        (do_n_times (1+ (- (line_number (buffer_info mark))
                        (line_number current_cursor)))
            (if (not (looking_at "      "))
                (delete_white_sides)
                (whitespace_to_hpos begin_column$))
            (end_line)
            (if (> (cur_hpos) end_column$)
                (cobol_correct_length$))
            (next_line))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_correct_length$                                                    ;;;
;;;    corrects length or line for cobol_parse_region$                       ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun cobol_correct_length$ ()
     (go_to_hpos end_column$)
     (search_bk_in_line " ")
     (delete_white_sides)
     (cr)
     (whitespace_to_hpos (1+ begin_column$))
     (end_line)
     (if (> (cur_hpos) end_column$)
         (cobol_correct_length$)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cbl_on                                                                   ;;;
;;;    Turns on CBL mode                                                     ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defcom cbl_on
;    &doc "COBOL: Enter CBL mode"
;    (cobol_on)
;    (buffer_info (user language_name$) "cbl")
;    )
(defcom cbl_on
    &doc "COBOL: Enter CBL mode"
    (if (null tab_loaded$)
        (fasload "emacs*>extensions>tab"))
    (turn_mode_on (find_mode 'cobol) first)  ; done first so that function
                                             ; tab_language_mode will give tab
                                             ; routines proper information about
                                             ; language modes set for current
                                             ; buffer.
    (if (| (null end_column$) (< end_column$ 8))
        (setq end_column$ 73))

    (if (null my_cobol_tabs$)
        (tablist "8 12 16 20 24 28 32 36 40 44 48 52 56 60 64 72")
     else
        (tablist my_cobol_tabs$))

    (buffer_info (user language_name$) "cbl")
    (if (empty_buffer_p)
        (insert "       IDENTIFICATION DIVISION.~n")
        (insert "      *~n")
        (insert "       PROGRAM-ID.~n")
        (insert "       AUTHOR.~n")
        (insert "       INSTALLATION.~n")
        (insert "       DATE-WRITTEN.~n")
        (insert "       DATE-COMPILED.~n")
        (insert "       SECURITY.~n")
        (insert "       REMARKS.~n")
        (insert "      *~n")
        (insert "      ******************************************************************~n")
        (insert "      *~n")
        (insert "       ENVIRONMENT DIVISION.~n")
        (insert "      *~n")
        (insert "       CONFIGURATION SECTION.~n")
        (insert "       SOURCE-COMPUTER.~n")
        (insert "           PRIME.~n")
        (insert "       OBJECT-COMPUTER.~n")
        (insert "           PRIME.~n")
        (insert "      *~n")
        (insert "       INPUT-OUTPUT SECTION.~n")
        (insert "       FILE-CONTROL.~n")
        (insert "      *~n")
        (insert "      ******************************************************************~n")
        (insert "      *~n")
        (insert "       DATA DIVISION.~n")
        (insert "      *~n")
        (insert "       FILE SECTION.~n")
        (insert "      *~n")
        (insert "       WORKING-STORAGE SECTION.~n")
        (insert "      *~n")
        (insert "      ******************************************************************~n")
        (insert "      *~n")
        (insert "       PROCEDURE DIVISION.~n")
        (move_top)
        (forward_search_command "DATE-WRITTEN.")
        (self_insert \ )
        (self_insert \ )
        (self_insert \ )
        (date)
        (self_insert \.)
        (move_top)
        (cobol_parse_for_blank_lines$)
        (if (< (cur_hpos) 7) (cobol_begin_line))
    else
        (cobol_parse_for_blank_lines$)
        (save_excursion
            (do_forever
                (move_bottom)
                (if (= 7 (cur_hpos))
                   ;then
                        (if (= "      " (current_line))
                           ;then
                                (prev_line_command)
                                (end_line)
                                (kill_line 2)
                            else
                                (stop_doing)
                        )
                    else
                        (stop_doing)
                )
            )
            (if (^= "      " (current_line))
               ;then
                    (cr)
                    (whitespace_to_hpos 7)
            )
        )
        (if (< (cur_hpos) 7) (cobol_begin_line))
    )
    (do_cobol_keybindings$)
    (spd_load_file "emacs*>extensions>spd>cobol")
    (spd_on)
    (info_message "CBL language mode on. Type ^x? for help.")
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol85_on                                                               ;;;
;;;    Turns on COBOL85 mode                                                 ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defcom cobol85_on
    &doc "COBOL: Enter COBOL85 mode"
    (cbl_on)
    (buffer_info (user language_name$) "cobol85")
    (spd_load_file "emacs*>extensions>spd>cobol85")
    (spd_on)
    (info_message "COBOL85 language mode on. Type ^x? for help.")
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cbl_off , cobol85_off                                                    ;;;
;;;    Turns off cbl and cobol85 mode.                                       ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cbl_off
    &doc "COBOL: Exit from CBL mode"
    (turn_mode_off (find_mode 'cobol)))

(defcom cobol85_off
    &doc "COBOL: Exit from COBOL85 mode"
    (turn_mode_off (find_mode 'cobol)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_begin_line                                                         ;;;
;;;    goes to column 7 instead of 1                                         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_begin_line
    &doc "COBOL: Go to beginning of line"
    (if (^ (go_to_hpos begin_column$))
        (end_line)
        (whitespace_to_hpos begin_column$)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_back_char                                                          ;;;
;;;     Treats column 7 as beginning of line                                 ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_back_char
    &doc "COBOL: Backspace character"
    &na (&pass count &default 1)
    (if (> count 0)
        (do_n_times count
            (back_char)
            (if (< (cur_hpos) begin_column$)
                (if (first_line_p)
                    (cobol_begin_line)
                 else
                    (prev_line)
                    (cobol_end_line))))
     else
        (cobol_forward_char (- count))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_delete_char                                                        ;;;
;;;    same as fund. except at eol deletes 7 chars then maybe adjust length  ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_delete_char
    &doc "COBOL: Delete character"
    &na (&pass count &default 1)
    (if (> count 0)
        (do_n_times count
            (if (| (eolp) (line_is_blank))
                (kill_line)
                (delete_white_sides)
                (self_insert \ )
                (cobol_trim_line$)
             else
                (delete_char)))
     else
        (cobol_rubout_char (- count))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_end_line                                                           ;;;
;;;    same as fundamental except won't allow text after 72                  ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_end_line
    &doc "COBOL: Go to end of line"
    (end_line)
    (if (> (cur_hpos) end_column$)
        (cobol_trim_line$)
     else
        (if (< (cur_hpos) begin_column$)
            (whitespace_to_hpos begin_column$))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_forward_char                                                       ;;;
;;;    At eol, skips to col 7 of next line                                   ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_forward_char
    &doc "COBOL: Forward character"
    &na (&pass count &default 1)
    (if (> count 0)
        (do_n_times count
            (forward_char)
            (if (< (cur_hpos) begin_column$)
                (cobol_begin_line)))
     else
        (cobol_back_char (- count))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_rubout_char                                                        ;;;
;;;    at column 7, deletes to begin of line, the cr, then correct length    ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_rubout_char
    &doc "COBOL: Delete previous character"
    &na (&pass count &default 1)
    (if (> count 0)
        (do_n_times count
            (if (first_line_p)
                (if (= (cur_hpos) 7)
                    (info_message "Cannot delete at this position")
                    (return)))
            (rubout_char)
            (if (< (cur_hpos) begin_column$)
                (kill_line 0)
                (delete_white_right)
                (rubout_char)
                (cobol_trim_line$)))
         (if (< (cur_hpos) begin_column$)
             (cobol_begin_line))
     else
         (cobol_delete_char (- count))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_kill_line                                                          ;;;
;;;   same as fundamental but insures length of line is correct              ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_kill_line
    &doc "COBOL: Kill line"
    &na (&pass count &default 1)
    (kill_line count)
    (if (not (eolp)) (cobol_trim_line$)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_open_line                                                          ;;;
;;;    after an open, pads line with blanks                                  ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_open_line
    &doc "COBOL: Open line"
    &na (&pass count &default 1)
    (do_n_times count
        (open_line)
        (save_excursion
            (next_line)
            (insert "      "))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_kill_region                                                        ;;;
;;;   insures that line left after kill is correct length                    ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_kill_region
    &doc "COBOL: Move region to kill ring"
    (kill_region)
    (cobol_trim_line$))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_yank_region                                                        ;;;
;;;   insures that yanked text is correct length                             ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_yank_region
    &doc "COBOL: Yank region"
    (yank_region)
    (cobol_parse_region$))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_back_word                                                          ;;;
;;;   knows that - is part of word, not separator                            ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_back_word
    &doc "COBOL: Back word"
    &na (&pass count &default 1)
    (if (> count 0)
        (do_n_times count (cobol_back_word$))
     else
        (do_n_times (- count) (cobol_forward_word$))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_back_word$                                                         ;;;
;;;   Where back_word stuff really gets done.                                ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun cobol_back_word$ (&local (start cursor))
    (back_char)
    (if (beginning_of_buffer_p)
        (return))
    (setq start (copy_cursor current_cursor))
    (verify_bk word_scan_table$)
    (if (search_charset_backward word_scan_table$)
        (if (= current_cursor start)
            (cobol_back_word$)
         else
            (forward_char))
     else
        (cobol_move_top)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_delete_word                                                        ;;;
;;;    Knows that - is part of word                                          ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_delete_word
    &doc "COBOL: Delete word"
    &na (&pass count &default 1)
    (mark)
    (cobol_forward_word count)
    (kill_region)
    (cobol_trim_line$))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_forward_word                                                       ;;;
;;;    knows that - is part of word                                          ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_forward_word
    &doc "COBOL: Forward word"
    &na (&pass count &default 1)
    (if (> count 0)
        (do_n_times count (cobol_forward_word$))
     else
        (do_n_times count (cobol_back_word$))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_forward_word$                                                      ;;;
;;;   where forward word's work is really done.                              ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun cobol_forward_word$ ()
    (forward_char)
    (verify_fd " ~n")
    (if (^ (search_charset_forward word_scan_table$))
        (move_bottom)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_goto_line                                                          ;;;
;;;     Insures that column is kept on goto. Probably unnecessary.           ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_goto_line
    &doc "COBOL: Go to line"
    &na (&pass count &default 1)
    (goto_line count)
    (if (< (cur_hpos) 7)
        (cobol_begin_line)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_rubout_word                                                        ;;;
;;;    rubs out word and knows - is part of word                             ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_rubout_word
    &doc "COBOL: Rubout previous word"
    &na (&pass count &default 1)
    (mark)
    (cobol_back_word count)
    (kill_region))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_white_delete                                                       ;;;
;;;    deletes white space but not at beginning of line                      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_white_delete
    &doc "COBOL: Deletes space around the cursor"
    (white_delete)
    (if (< (cur_hpos) 7)
        (whitespace_to_hpos 7)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_back_para                                                          ;;;
;;;    Knows that para is line with text in cols 8 - 11                      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_back_para
    &doc "COBOL: Move backward a paragraph"
    &na (&pass count &default 1)
    (do_n_times count
        (prev_line)
        (cobol_begin_line)
        (do_forever
            (if (beginning_of_buffer_p) (stop_doing))
            (if (& (^ (looking_at "   "))
                   (^ (looking_at "*"))
                   (^ (looking_at "#"))
                   (^ (line_is_blank)))  (stop_doing))
            (prev_line)
            (cobol_begin_line))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_forward_para                                                       ;;;
;;;    knows that para has text in col 8 - 11                                ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_forward_para
    &doc "COBOL: Move forward a paragraph"
    &na (&pass count &default 1)
    (do_n_times count
        (next_line)
        (cobol_begin_line)
        (do_forever
           (if (end_of_buffer_p) (stop_doing))
           (if (& (^ (looking_at "   "))
                  (^ (looking_at "*"))
                  (^ (looking_at "#"))
                  (^ (line_is_blank))) (stop_doing))
           (next_line)
           (cobol_begin_line))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_move_top                                                           ;;;
;;;    Moves to column 7 on first line.                                      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_move_top
    &doc "COBOL: Move to top"
    (move_top)
    (cobol_begin_line))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_move_bottom                                                        ;;;
;;;    After move to bottom insures that point is in legal column            ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_move_bottom
    &doc "COBOL: Move to bottom"
    (move_bottom)
    (cobol_end_line))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_backward_sentence                                                  ;;;
;;;    Only recognizes period as sentence delimiter                          ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_backward_sentence
    &doc "COBOL: Goes back a sentence"
    &na (&pass count &default 1)
    (if (> count 0)
        (do_n_times count (cobol_backward_sentence$))
     else
        (do_n_times (- count) (cobol_forward_sentence$))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_backward_sentence$                                                 ;;;
;;;    Where real work gets done.                                            ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun cobol_backward_sentence$ ()
    (back_char 2)
    (if (search_charset_backward ".")
        (forward_char)
     else
        (move_top)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_forward_sentence                                                   ;;;
;;;   Knows only delimiter is period                                         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_forward_sentence
    &doc "COBOL: Goes forward a sentence at a time"
    &na (&pass count &default 1)
    (if (> count 0)
            (do_n_times count (cobol_forward_sentence$))
        else
            (do_n_times (- count) (cobol_backward_sentence$))
    )
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_forward_sentence$                                                  ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun cobol_forward_sentence$ ()
    (if (search_charset_forward ".")
        (forward_char)
        (skip_over_white)
     else
        (move_bottom)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_backward_kill_sentence                                             ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_backward_kill_sentence
    &doc "COBOL: Kills a sentence backwards"
    &na (&pass count &default 1)
    (mark)
    (cobol_backward_sentence count)
    (kill_region)
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_forward_kill_sentence                                              ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_forward_kill_sentence
    &doc "COBOL: Kills a sentence forward"
    &na (&pass count &default 1)
    (mark)
    (cobol_forward_sentence count)
    (kill_region)
    (cobol_trim_line$)
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_backward_kill_line                                                 ;;;
;;;    Kills from point to begin of line, then insures whitespace at bol     ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_backward_kill_line
    &doc "COBOL: Kills from point back to beginning of line"
    (kill_line 0)
    (whitespace_to_hpos begin_column$)
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_repaint                                                            ;;;
;;;    point is now in col 7                                                 ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_repaint
    &doc "COBOL: Moves cursor to first line of screen"
    &na (&pass count &default 1)
    (repaint count)
    (cobol_begin_line))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_mark_top                                                           ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_mark_top
    &doc "COBOL: Mark top of buffer"
    (mark)
    (cobol_move_top)
    (exchange_mark))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_mark_bottom                                                        ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_mark_bottom
    &doc "COBOL: Mark bottom of buffer"
    (mark)
    (cobol_move_bottom)
    (exchange_mark))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_read_file                                                          ;;;
;;;   Insures that a read file is gone through cobol_parse_for_blank_lines$  ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_read_file
    &doc "COBOL: Read file"
    (read_file)
    (cobol_parse_for_blank_lines$)
    (if (< (cur_hpos) 7) (cobol_begin_line)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; fundamental_cobol_keybindings                                            ;;;
;;;   What all this stuff gets bound to.  SEE COBOL2.EM                      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
