; COBOL2.EM,  EMACSSRC>EMACS*>EXTENSIONS>SOURCES, EMACS DEVELOPMENT, 07/21/87
; Contains the second part of the functions for COBOL language mode.
; Copyright (c) 1984, Prime Computer, Inc., Natick, MA 01760
;
;
; Description:
;
; Abnormal conditions:
;
; Implementation:
;
; Modifications:
;   Date   Engineer     Description of modification
; 07/21/87 Kokila       Added binding of cobol_ruler_on$     to  ^[^c
;                             binding of cobol_ruler_off$    to  ^[^k
;                             binding of cobol_help$         to  ^x?
;                             binding of cobol_number        to  ^[^n
;                             binding of cobol_renumber      to ^[^r
;                             binding of cobol_remove_number to ^[^u
;                             binding of cobol_column        to ^[^a
; 06/03/85 DNK          Added binding of cobol_delete_char to pf12_pt200$
;                       as well as num_lock_pt200$ key.  Removed line
;                       which simply duplicated the old binding.
;                       Reason: to track change in PT200 ucode.
; 05/02/85 cdm          Added a number of key bindings which were in
;                       cobol.em, and are now commented out there.
;                       Corrected lm_next/prev_error -> lm_next/prev_error$.
; 06/10/84 DNK          Added PT200-specific keybindings;
;                       Substituted use of "disabled_in_cobol_mode$" macro for
;                       previous use of too-vaguely-named "not_defined" macro.
;                       Added binding to del$ in PT45-specific bindings.
;                       Improved the handling of lm_forward_error_key$ and
;                       lm_prev_error_key$ assignments.

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; The following code activates fundamental bindings unless a library       ;;;
;;; file says otherwise.                                                     ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;
(defun do_cobol_keybindings$ ()        ; This macro is normally called by the
                                       ; cobol_on macro.
  (if cobol_bindings_loaded$ (return)) ; it has no effect if
                                       ; cobol_bindings_loaded$ is true already
  (setq cobol_bindings_loaded$ true)   ; assuming we survive,
                                       ; prevent re-execution the next time.
; (if (^ (null cobol_keybindings$))    ; check this atom's existence:
                                       ; run the macro load_cobol_keybindings$
                                       ; if it exists at all
;   (load_cobol_keybindings$)          ; This macro USED TO BE defined elsewhere
                                       ; in the SUI code.  It is NO LONGER
                                       ; defined there.  If you wish, you can
                                       ; define your own and branch to it
                                       ; by setting cobol_keybindings$ true.
                                       ; If you DO set it true, there had
                                       ; BETTER be a load_cobol_keybindings$
                                       ; macro already defined!!
;   (return))
  (select keybinding$                  ; Now we assume we are an SUIX user
    "pt45"
       (load_cobol_pt45$)
    "pst100"
       (load_cobol_pst100$)
    "pt200"
       (load_cobol_pt200$)
    otherwise                          ; but if we're not,
       (fundamental_cobol_keybindings$)))

(defun fundamental_cobol_keybindings$ ()
  (load_most_cobol_bindings$)          ; Load the ones that don't conflict
                                       ; with the PT45 function keys,
                                       ; AND NOW SOME THAT DO CONFLICT WITH
                                       ; THE PT45's FUNCTION KEYS...
  (set_mode_key "cobol" "^[>" "cobol_move_bottom")
  (set_mode_key "cobol" "^[B" "cobol_back_word")
  (set_mode_key "cobol" "^w" "cobol_kill_region")
                                       ; Too bad, if you're a PT45 function key
                                       ; user...
                                       ;
                                       ; These came from cobol.em 05/02/85 CDM
  (set_mode_key "cobol" "^b" "cobol_back_char")
  (set_mode_key "cobol" "^[^h" "cobol_rubout_word")
  (set_mode_key "cobol" "^[b" "cobol_back_word")
  (set_mode_key "cobol" "^[d" "cobol_delete_word")
  (set_mode_key "cobol" "^[D" "cobol_delete_word")
  (set_mode_key "cobol" "^[^c"  "cobol_ruler_on$")
  (set_mode_key "cobol" "^[^C" "cobol_ruler_on$")
  (set_mode_key "cobol" "^[^k" "cobol_ruler_off$")
  (set_mode_key "cobol" "^[^K"  "cobol_ruler_off$")
  (set_mode_key "cobol" "^x?"  "cobol_help$")
  (set_mode_key "cobol" "^X?"  "cobol_help$")
  (set_mode_key "cobol" "^[^n"  "cobol_number")
  (set_mode_key "cobol" "^[^N"  "cobol_number")
  (set_mode_key "cobol" "^[^r"  "cobol_renumber")
  (set_mode_key "cobol" "^[^R"  "cobol_renumber")
  (set_mode_key "cobol" "^[^a"  "cobol_column")
  (set_mode_key "cobol" "^[^u"  "cobol_remove_number")
  (set_mode_key "cobol" "^x^j"  "cret_indent_relative")
  (set_mode_key "cobol" "^X^J"  "cret_indent_relative"))
(defun load_cobol_pt45$ ()
  (load_most_cobol_bindings$)
  (set_mode_key "cobol" btab$ "cobol_sui_back_tab")
  (set_mode_key "cobol" f9$ "cobol_move_top")
  (set_mode_key "cobol" f11$ "cobol_begin_line")
  (set_mode_key "cobol" f14$ "cobol_kill_region")
  (set_mode_key "cobol" f15$ "cobol_yank_region")
  (set_mode_key "cobol" f16$ "sui_toggle_cobol_word")
  (set_mode_key "cobol" dline$ "cobol_kill_line")
  (set_mode_key "cobol" iline$ "cobol_open_line")
  (set_mode_key "cobol" dchar$ "cobol_delete_char")
  (set_mode_key "cobol" aset$ "cobol_move_bottom")
  (set_mode_key "cobol" print$ "cobol_end_line")
  (set_mode_key "cobol" left$ "cobol_back_char")
  (set_mode_key "cobol" home$ "cobol_repaint")
  (set_mode_key "cobol" right$ "cobol_forward_char")
  (set_mode_key "cobol" "^h" "cobol_rubout_char")
  (set_mode_key "cobol" del$ "cobol_delete_char")
  (set_mode_key "cobol" "^[^c"  "cobol_ruler_on$")
  (set_mode_key "cobol" "^[^C" "cobol_ruler_on$")
  (set_mode_key "cobol" "^[^k" "cobol_ruler_off$")
  (set_mode_key "cobol" "^[^K"  "cobol_ruler_off$")
  (set_mode_key "cobol" "^x?"  "cobol_help$")
  (set_mode_key "cobol" "^X?"  "cobol_help$")
  (set_mode_key "cobol" "^[^n"  "cobol_number")
  (set_mode_key "cobol" "^[^N"  "cobol_number")
  (set_mode_key "cobol" "^[^r"  "cobol_renumber")
  (set_mode_key "cobol" "^[^R"  "cobol_renumber")
  (set_mode_key "cobol" "^[^a"  "cobol_column")
  (set_mode_key "cobol" "^[^u"  "cobol_remove_number")
  (set_mode_key "cobol" "^x^j"  "cret_indent_relative")
  (set_mode_key "cobol" "^X^J"  "cret_indent_relative"))

(defun load_cobol_pst100$ ()
  (load_most_cobol_bindings$)
  (set_mode_key "cobol" "^[>" "cobol_move_bottom")
  (set_mode_key "cobol" "^[B" "cobol_back_word")
  (set_mode_key "cobol" "^[b" "cobol_back_word")
  (set_mode_key "cobol" "^w" "cobol_kill_region")
  (set_mode_key "cobol" backtab_pst100$ "cobol_sui_back_tab")
  (set_mode_key "cobol" pf07_pst100$ "cobol_move_top")
  (set_mode_key "cobol" pf11_pst100$ "cobol_begin_line")
  (set_mode_key "cobol" sf07_pst100$ "cobol_kill_region")
  (set_mode_key "cobol" sf08_pst100$ "cobol_yank_region")
  (set_mode_key "cobol" pf12_pst100$ "sui_toggle_cobol_word")
  (set_mode_key "cobol" sdelete_pst100$ "cobol_kill_line")
  (set_mode_key "cobol" insert_pst100$ "cobol_open_line")
  (set_mode_key "cobol" delete_pst100$ "cobol_delete_char")
  (set_mode_key "cobol" pf10_pst100$ "cobol_move_bottom")
  (set_mode_key "cobol" pf14_pst100$ "cobol_end_line")
  (set_mode_key "cobol" left_pst100$ "cobol_back_char")
  (set_mode_key "cobol" home_pst100$ "cobol_repaint")
  (set_mode_key "cobol" shome_pst100$ "cobol_repaint")
  (set_mode_key "cobol" right_pst100$ "cobol_forward_char")
  (set_mode_key "cobol" backspace_pst100$ "cobol_rubout_char")
  (set_mode_key "cobol" del_pst100$ "cobol_delete_char")
  (set_mode_key "cobol" "^[^c"  "cobol_ruler_on$")
  (set_mode_key "cobol" "^[^C" "cobol_ruler_on$")
  (set_mode_key "cobol" "^[^k" "cobol_ruler_off$")
  (set_mode_key "cobol" "^[^K"  "cobol_ruler_off$")
  (set_mode_key "cobol" "^x?"  "cobol_help$")
  (set_mode_key "cobol" "^X?"  "cobol_help$")
  (set_mode_key "cobol" "^[^n"  "cobol_number")
  (set_mode_key "cobol" "^[^N"  "cobol_number")
  (set_mode_key "cobol" "^[^r"  "cobol_renumber")
  (set_mode_key "cobol" "^[^R"  "cobol_renumber")
  (set_mode_key "cobol" "^[^a"  "cobol_column")
  (set_mode_key "cobol" "^[^u"  "cobol_remove_number")
  (set_mode_key "cobol" "^x^j"  "cret_indent_relative")
  (set_mode_key "cobol" "^X^J"  "cret_indent_relative"))

(defun load_cobol_pt200$ ()
  (load_most_cobol_bindings$)
  (set_mode_key "cobol" "^[>" "cobol_move_bottom")
  (set_mode_key "cobol" "^[B" "cobol_back_word")
  (set_mode_key "cobol" "^[b" "cobol_back_word")
  (set_mode_key "cobol" "^w" "cobol_kill_region")
  (set_mode_key "cobol" back_tab_pt200$ "cobol_sui_back_tab")
  (set_mode_key "cobol" sscroll_down_pt200$ "cobol_move_top")
  (set_mode_key "cobol" begin_end_pt200$ "cobol_begin_line")
  (set_mode_key "cobol" f07_pt200$ "cobol_kill_region")
  (set_mode_key "cobol" f06_pt200$ "cobol_yank_region")
  (set_mode_key "cobol" delete_pt200$ "sui_toggle_cobol_word")
  (set_mode_key "cobol" spf10_pt200$ "cobol_kill_line")
  (set_mode_key "cobol" insert_pt200$ "cobol_open_line")
  (set_mode_key "cobol" num_lock_pt200$ "cobol_delete_char")
  (set_mode_key "cobol" pf12_pt200$ "cobol_delete_char")
  (set_mode_key "cobol" sscroll_up_pt200$ "cobol_move_bottom")
  (set_mode_key "cobol" sbegin_end_pt200$ "cobol_end_line")
  (set_mode_key "cobol" left_pt200$ "cobol_back_char")
  (set_mode_key "cobol" home_pt200$ "cobol_repaint")
  (set_mode_key "cobol" shome_pt200$ "cobol_repaint")
  (set_mode_key "cobol" right_pt200$ "cobol_forward_char")
  (set_mode_key "cobol" backspace_pt200$ "cobol_rubout_char")
  (set_mode_key "cobol" num_lock_pt200$ "cobol_delete_char")
  (set_mode_key "cobol" "^[^c"  "cobol_ruler_on$")
  (set_mode_key "cobol" "^[^C" "cobol_ruler_on$")
  (set_mode_key "cobol" "^[^k" "cobol_ruler_off$")
  (set_mode_key "cobol" "^[^K"  "cobol_ruler_off$")
  (set_mode_key "cobol" "^x?"  "cobol_help$")
  (set_mode_key "cobol" "^X?"  "cobol_help$")
  (set_mode_key "cobol" "^[^n"  "cobol_number")
  (set_mode_key "cobol" "^[^N"  "cobol_number")
  (set_mode_key "cobol" "^[^r"  "cobol_renumber")
  (set_mode_key "cobol" "^[^R"  "cobol_renumber")
  (set_mode_key "cobol" "^[^a"  "cobol_column")
  (set_mode_key "cobol" "^[^u"  "cobol_remove_number")
  (set_mode_key "cobol" "^x^j"  "cret_indent_relative")
  (set_mode_key "cobol" "^X^J"  "cret_indent_relative"))

(defun load_most_cobol_bindings$ ()
;
; loads all but the bindings that conflict with PT45 function keys.
;
      (set_mode_key "cobol" " " "cobol_wrap")
      (set_mode_key "cobol" "^j" "cobol_wrap")
      (set_mode_key "cobol" "^a" "cobol_begin_line")
      (set_mode_key "cobol" "^d" "cobol_delete_char")
      (set_mode_key "cobol" "^e" "cobol_end_line")
      (set_mode_key "cobol" "^f" "cobol_forward_char")
      (set_mode_key "cobol" "^h" "cobol_rubout_char")
      (set_mode_key "cobol" "^k" "cobol_kill_line")
      (set_mode_key "cobol" "^o" "cobol_open_line")
      (set_mode_key "cobol" "^y" "cobol_yank_region")
      (set_mode_key "cobol" "^[f" "cobol_forward_word")
      (set_mode_key "cobol" "^[F" "cobol_forward_word")
;     (set_mode_key "cobol" "^[l" "disabled_in_cobol_mode$")
;     (set_mode_key "cobol" "^[L" "disabled_in_cobol_mode$")
      (set_mode_key "cobol" "^[<" "cobol_move_top")
      (set_mode_key "cobol" "^x^z<" "cobol_mark_top")
      (set_mode_key "cobol" "^x^z>" "cobol_mark_bottom")
;     (set_mode_key "cobol" "^x^l" "disabled_in_cobol_mode$")
      (set_mode_key "cobol" "^x^r" "cobol_read_file")
      (set_mode_key "cobol" "^x^z^a" "disabled_in_cobol_mode$")
      (set_mode_key "cobol" "^x^z^e" "disabled_in_cobol_mode$")
      (set_mode_key "cobol" "^x^z^h" "disabled_in_cobol_mode$")
      (set_mode_key "cobol" "^x^z^k" "disabled_in_cobol_mode$")
      (set_mode_key "cobol" "^x^zs" "disabled_in_cobol_mode$")
      (set_mode_key "cobol" "^x^zS" "disabled_in_cobol_mode$")
      (set_mode_key "cobol" "^xr" "cobol_repaint")
      (set_mode_key "cobol" "^xR" "cobol_repaint")
      (set_mode_key "cobol" "^x[" "cobol_back_para")
      (set_mode_key "cobol" "^x]" "cobol_forward_para")
                                ; Added next set from cobol.em.  05/02/85 CDM
      (set_mode_key "cobol" "^[a" "cobol_backward_sentence")
      (set_mode_key "cobol" "^[A" "cobol_backward_sentence")
      (set_mode_key "cobol" "^[e" "cobol_forward_sentence")
      (set_mode_key "cobol" "^[E" "cobol_forward_sentence")
      (set_mode_key "cobol" "^[k" "cobol_forward_kill_sentence")
      (set_mode_key "cobol" "^[K" "cobol_forward_kill_sentence")
      (set_mode_key "cobol" "^[q" "disabled_in_cobol_mode$")
      (set_mode_key "cobol" "^[Q" "disabled_in_cobol_mode$")
      (set_mode_key "cobol" "^[\" "cobol_white_delete")
      (set_mode_key "cobol" "^x^h" "cobol_backward_kill_sentence")
      (set_mode_key "cobol" "^x^k" "cobol_backward_kill_line")
                                       ; and now, time to handle the
                                       ; lm_forward_error_key$ and
                                       ; lm_prev_error_key$ assignments.
      (if (null lm_initialized$) (lm_init))
                                       ; Check existence of global var.
                                       ; lm_initialized.  If it doesn't exist
                                       ; we have to run it to get proper
                                       ; definition of lm_forward_error_key$
                                       ; and lm_prev_error_key$ strings.
                                       ; User can define them privately or
                                       ; if not, accept assignment to "^xn"
                                       ; and "^xp" respectively.
                                       ; lm_init is defined in COMPILE.EM
                                       ; Now with the key string definitions
                                       ; possibly default-accepted, it's
                                       ; OK to bind them to the proper
                                       ; functions for moving to errors
                                       ; in COBOL mode:
    (set_mode_key "cobol" lm_forward_error_key$ "lm_next_error$")
    (set_mode_key "cobol" lm_prev_error_key$ "lm_prev_error$")
                                       ; above 2 functions are also defined in
                                       ; COMPILE.EM - corrected, 05/01/85 CDM
)

