; COBOL3.EM,  EMACSSRC>EMACS*>EXTENSIONS>SOURCES, EMACS DEVELOPMENT, 11/30/88
; Contains the third part of the functions for COBOL language mode.
; Copyright (c) 1985, Prime Computer, Inc., Natick, MA 01760
;
;
; Description:
;
; Abnormal conditions:
;
; Implementation:
;
; Modifications:
;   Date   Engineer     Description of modification
; 11/30/88 Bugos        Made the "cobolruler$" buffer a "changed_ok",
;                       "dont_show", EMACS-internal buffer (".cobolruler$").
;                       In addition, modified to permit cobol_wrap to handle
;                       correctly a line of blank space characters extending
;                       beyond character position 72. (SPAR 4034058)
; 02/22/88 Kokila       Added help information on commands available.
; 02/06/88 Kokila       Added numbering and renumbering of CBL and COBOL85
;                       source code lines.
; 02/03/88 Kokila       Moved cobol_wrap code from COBOL.EM to here.
; 07/15/87 Kokila       Modified cobol_split_window$.  This function is now
;                       cobol_ruler_on$, and cobol_one_window$ is now
;                       cobol_ruler_off$.
; 07/15/87 Kokila       Modified load_cobol_template$. This function is now
;                       load_template$.
; 07/10/87 Kokila       Modified load_cobol_template$. Loads default cobol
;                       template, but only if the buffer is empty.
;                       Also COBOL language mode is invoked. If the buffer
;                       is not empty, tying to load the template will give
;                       error message in the form of "buffer is not empty".
; 07/07/87 Kokila       Modified cobol_split_ruler$ to make cobolruler$ buffer
;                       as a read-only buffer.
; 05/08/85 cdm          Initial coding.


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; FUNCTIONS:                                                               ;;;
;;;     load_template$                                                       ;;;
;;;                     Loads default cobol program template,                ;;;
;;;                     only happens if buffer empty                         ;;;
;;;     cobol_hook$     Checks change in buffer for updating help, etc.      ;;;
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; COMMANDS:                                                                ;;;
;;;     cobol_help$                                                          ;;;
;;;                     Display help on commands available.                  ;;;
;;;                     Normally bound to ^[^h ^[^H.                         ;;;
;;;     cobol_ruler_off                                                      ;;;
;;;                     Take out ruler in top window.                        ;;;
;;;                     Normally bound to ^[^k.                              ;;;
;;;     cobol_ruler_on                                                       ;;;
;;;                     Display ruler in top window.                         ;;;
;;;                     Normally bound to ^[^c.                              ;;;
;;;                                                                          ;;;
;;;     cobol_config    Display line number and column number.               ;;;
;;;                     Normally bound to ^[^g.                              ;;;
;;;     cobol_number    Number source code lines.                            ;;;
;;;                     Normally bound to ^[^n.                              ;;;
;;;     cobol_renumber  Renumber source code lines.                          ;;;
;;;                     Normally bound to ^[^r.                              ;;;
;;;     cobol_column    Display current line and column number.              ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; load_template$                                                           ;;;
;;;     Load standard COBOL program template and insert current date.        ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun load_template$ ()
; (cobol_on)
; )

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_ruler_on$                                                           ;;;
;;;   Split screen and put up ruler                                          ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_ruler_on$
  &doc "COBOL: Split screen and insert ruler"
   (if cobol_ruler_up$ (return))
   (setq cobol_ruler$ true)
   (save_position)
   (split_window_stay 2)
   (select_buf ".cobolruler$")
   (move_top)
   (if (line_is_blank)
   (insert
"         1         2         3         4         5         6         7         8
-------####-------------------------------------------------------------########"
    ))

   (buffer_info read_only true)
   (buffer_info dont_show true)
   (buffer_info changed_ok true)
   (other_window)
   (select_buf "")
   (setq cobol_ruler_up$ true)
   (select keybinding$
       "pt45"    (pt45_highlight)
       "pst100"  (pst100_highlight)
       "pt200"   (pt200_highlight)
    )
;   (begin_line)
    (forward_char 6)
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_ruler_off$                                                         ;;;
;;;   Take out ruler, one window                                             ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_ruler_off$
  &doc "COBOL: Take ruler out, one window"
   (one_window)
   (setq cobol_ruler_up$ false)
   (select keybinding$                ; support SUI users' screens
       "pt45"   (pt45_highlight)
       "pst100" (pst100_highlight)
       "pt200"  (pt200_highlight)
   )
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_help$                                                              ;;;
;;;   Display help information.                                              ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defcom cobol_help$
  &doc "COBOL: Help information on commands available"
  (init_local_displays "")
  (local_display_generator " ")
  (local_display_generator "                       COBOL LANGUAGE MODE ""HELP"" SCREEN:")
  (local_display_generator " ")
  (local_display_generator " ")
  (local_display_generator
"              Command                         Description")
  (local_display_generator " ")
  (local_display_generator
"              cbl_on                          Turn on CBL language mode")
  (local_display_generator
"              cbl_off                         Turn off CBL language mode")
  (local_display_generator
"              cobol85_on                      Turn on COBOL85 language mode")
  (local_display_generator
"              cobol85_off                     Turn off COBOL85 language mode")
  (local_display_generator " ")
  (local_display_generator " ")
  (local_display_generator
"            Key strokes                       Description")
  (local_display_generator " ")
  (local_display_generator
"              ^x?                             Display this ""help"" screen")
 (local_display_generator
"              <esc>^c                         Insert a ruler")
 (local_display_generator
"              <esc>^k                         Remove the ruler")
 (local_display_generator
"              <esc>^n                         Number source code lines")
 (local_display_generator
"              <esc>^r                         Renumber source code lines")
 (local_display_generator
"              <esc>^u                         Remove source code line numbers")
 (local_display_generator
"              <esc>^a                         Display current line and column")
 (local_display_generator
"                                                  number")
  (local_display_generator " ")
  (local_display_generator " ")
  (local_display_generator
"           Key strokes                        Key binding")
  (local_display_generator " ")
  (local_display_generator
"              ^a                              cobol_begin_line")
  (local_display_generator
"              ^b                              cobol_back_character")
  (local_display_generator
"              ^d                              cobol_delete_character")
  (local_display_generator
"              ^e                              cobol_end_line")
  (local_display_generator
"              ^f                              cobol_forward_character")
  (local_display_generator
"              ^h                              cobol_rubout_character")
  (local_display_generator
"              ^k                              cobol_kill_line")
  (local_display_generator
"              ^o                              cobol_open_line")
  (local_display_generator
"              ^w                              cobol_kill_region")
  (local_display_generator
"              ^y                              cobol_yank_region")
  (local_display_generator
"              ^x^h                            cobol_backward_kill_sentence")
  (local_display_generator
"              ^x^k                            cobol_backward_kill_line")
  (local_display_generator
"              ^x^r                            cobol_read_file")
  (local_display_generator
"              ^x^z<                           cobol_mark_top")
  (local_display_generator
"              ^x^z>                           cobol_mark_bottom")
  (local_display_generator
"              ^xr                             cobol_repaint")
  (local_display_generator
"              ^x[                             cobol_back_para")
  (local_display_generator
"              ^x]                             cobol_forward_para")
  (local_display_generator
"              <esc>^h                         cobol_rubout_word")
  (local_display_generator
"              <esc><                          cobol_move_top")
  (local_display_generator
"              <esc>>                          cobol_move_bottom")
  (local_display_generator
"              <esc>a                          cobol_backward_sentence")
  (local_display_generator
"              <esc>b                          cobol_back_word")
  (local_display_generator
"              <esc>d                          cobol_delete_word")
  (local_display_generator
"              <esc>e                          cobol_forward_sentence")
  (local_display_generator
"              <esc>f                          cobol_forward_word")
  (local_display_generator
"              <esc>g                          cobol_goto_line")
  (local_display_generator
"              <esc>\                          cobol_white_delete")
   (local_display_generator
"             <space>                          cobol_wrap")
  (local_display_generator
"             <return>                         cobol_wrap")
(local_display_generator " ")
(local_display_generator
"============================== Type ^g to end ==============================")
(local_display_generator " ")
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_column                                                             ;;;
;;;   Display current line number, column position                           ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_column
  &doc "COBOL: Display line number and column position"

    (info_message (catenate
     "At: Line " (integer_to_string (line_number current_cursor))
     ", Column " (integer_to_string (cur_hpos))
     ))
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;    cobol_number                                                         ;;;
;;;      Number source code lines.                                          ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_number
  &doc "COBOL: Number source code lines"
    (cobol_renum$)
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;    cobol_renumber                                                       ;;;
;;;      Renumber source code lines.                                        ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defcom cobol_renumber
  &doc "COBOL: Renumber source code lines"
    (cobol_renum$)
)

(defun cobol_renum$
             (&local  (value integer)
                      (inc_time integer)
                      (temp string))
   (setq value (prompt_for_integer "beginning line number" 10))
   (setq inc_time (prompt_for_integer "increment value" 10))
   (move_top)
   (do_forever
      (if  (end_of_buffer_p)
           (stop_doing))
      (begin_line)
      (do_n_times 6
          (if (^ (end_of_line_p))
              (delete_char)
          )
       )
      (setq temp(integer_to_string value 6))
      (insert (string_of_length_n temp 6))
      (setq value (+ value inc_time))
      (if (^ (last_line_p))
          (next_line_command)
      else
          (move_bottom)
      )
    )
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;    cobol_remove_number                                                  ;;;
;;;      Remove source code line numbers.                                   ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_remove_number
  &doc "COBOL: Remove source code line numbers."
    (move_top)
    (do_forever
        (if (end_of_buffer_p)
            (stop_doing)
        )
        (begin_line)
        (do_n_times 6
            (if (^ (end_of_line_p))
                (delete_char)
            )
        )
        (insert "      ")
        (next_line_command)
    )
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_wrap                                                               ;;;
;;;   cr or space after col 72 causes line to be wrapped and length adjusted ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom cobol_wrap
  &doc "COBOL: Inserts <return> so user doesn't have to"
    (if (< (cur_hpos) end_column$)     ; someday make this a sep statement
                                       ; then call fill's wrap--avoid dual
                                       ; maintenance.
        (if (= (character_argument) " ")
            (insert " ")
         else
            (cr)
            (cobol_indent$))
        (return))
    (insert "")
    (go_to_hpos end_column$)
    (if (search_bk_in_line " ")
        (if (looked_at "                                ")
           ;then
                (back_char 30)
        )
        (delete_white_sides)
        (if (= (cur_hpos) 1)
           ;then
                (cobol_indent$)
        )
        (cr)
        (save_excursion
            (next_line)
            (if (line_is_blank)
                 (if_at " "
                    ;then
                         (kill_line 2)
                     else
                         (delete_char)
                 )
            )
        )
    )
    (begin_line)
    (forward_search "")
    (rubout_char 3)
    (cobol_indent$)
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; cobol_hook$                                                              ;;;
;;;   sets hooks to give automatic help at each keystroke                    ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun cobol_hook$ ()
 (if (^ (member (find_mode 'cobol) (buffer_info modes)))(return))
 (if (& (= (line_number current_cursor) last_cobol_line_number$)
        (= (cur_hpos) last_cobol_hpos$)) (return))
 (with_no_redisplay
   (if (^ (have_input_p))
;     (if cobol_help$ (give_cobol_help$))
     (if (= (cur_hpos) 72) (ring_the_bell)) ; remind user if in col 72
     (setq last_cobol_hpos$ (cur_hpos))
     (setq last_cobol_line_number$ (line_number current_cursor))
  )))
