; COMPILE.EM, EMACS*>EXTENSIONS>SOURCES, EMACS DEVELOPMENT, 10/21/91
; Compile file in buffer and report errors (part 1).
; Copyright (c) 1983, Prime Computer, Inc., Natick, MA 01760
;                     All Rights Reserved
;
;
; Description:
;
; COMPILE.EM and the primitives necessary to run it
;
; Abnormal conditions:
;
; Implementation:
;
; Modifications:
;   Date    Engineer       Description of modification
; 10/21/91 Cummings       Fixed typo in 'check_for_errors, extra ) before else.
; 08/27/90  S. Horowitz    Added support for C++ ("cxx" compile command)
; 05/31/88  Bugos          Modified to report correctly an invalid compiler
;                          command-line option. (SPAR 4030293)
; 05/17/88  Bugos          Added support for COBOL85.
; 11/02/87  Bugos          Added support for C ("cc" compile command).
; 11/02/87  Bugos          Due to size, split COMPILE.EM into two modules:
;                          COMPILE.EM and COMPILE2.EM.
; 11/02/87  Bugos          Commented out set_cobol_compile$ and
;                          move_cobol_errors. Removed "cobol" from
;                          languages$, error_in_listing_file$, and
;                          get_lm_errors.
; 12/04/86  Bugos          Changed compile option "-list" to "-listing".
; 12/12/85  Rand           Fix ^xn and ^xp bindings to include upper case
; 83->85    Rand           Other fixes
; 08/26/83  Rand           Initial coding.


(defcom lm_init
        (setq languages$  '(spl plp pl1 pl1g modula2 cc pascal f77 ftn cbl
                                cobol85 rpg vrpg pma basicv scribe cxx))
        (setq error_in_listing_file$ '("pma"))

                                       ; option abbreviation list

        (setq abbrevs$ '(("-all" "-allerrors") ("-ban" "-banner")
                         ("-b" "-binary") ("-calc" "-calcindex")
                         ("-cdat" "-compiler_data") ("-corm" "-corrmap")
                         ("-conv" "-convdiags") ("-dc" "-dclvar")
                         ("-deba" "-debase") ("-dbg" "-debug")
                         ("-dbgopt" "-debug_optimized") ("-def" "-define")
                         ("-dm" "-dmap") ("-dmo" "-dmode")
                         ("-dmptk" "dumptokens") ("-do" "-do1")
                         ("-dy" "-dymn") ("-errl" "-errlist")
                         ("-errt" "-errtty") ("-ex" "-explist")
                         ("-fdis" "-formatted_display") ("-find" "-fine_node")
                         ("-fh" "-full_help") ("-force" "forcebinary")
                         ("-h" "-help") ("-hex" "-hexaddress")
                         ("-i" "-input") ("-inc" "-include)
                         ("-int" "-intermediate") ("-lc" "-lcase")
                         ("-le" "-leave") ("-l" "-listing")
                         ("-ma" "-map") ("-maps" "-mapsort")
                         ("-mapw" "-mapwide") ("-nb" "-no_binary")
                         ("-ncalc" "-no_calcindex") ("-ncomp" "-no_comp")
                         ("-nconv" "-no_convdiags") ("-ndbg" "-no_debug")
                         ("-ndmo" "-no_dmode") ("-ne" "-nesting")
                         ("-nerrf" "-no_errorfile") ("-nerrt" "-no_errortty")
                         ("-nexp" "-no_explist") ("-nfdis" "-no_formatted_display")
                         ("-nforce" "no_forcebinary")("-nhex" "-no_hexaddress")
                         ("-nob" "-nobig") ("-nodc" "-nodclvar")
                         ("-node"    "-nodebug") ("-nodo" "-nodo1")
                         ("-noerrl" "-noerrlist") ("-noerrt"  "-noerrtty")
                         ("-noex" "-noexplist") ("-nof" "-nofp")
                         ("-noff"    "-no_offset") ("-nold" "-no_oldio")
                         ("-nexp" "-no_expand") ("-noon" "-no_onunits")
                         ("-noop" "-nooptimize") ("-nprod" "-no_production")
                         ("-nprof" "-no_profile") ("-nra" "-no_range")
                         ("-nosi" "-nosilent") ("-nsig" "-no_signalerrors")
                         ("-nslack" "-no_slackbytes") ("-nstat" "-no_statistics")
                         ("-nsof" "-no_store_owner_field") ("-nsyn" "-no_syntaxmsg")
                         ("-ntp" "-no_tps") ("-ntrunc" "-no_truncdiags")
                         ("-not" "-notrace") ("-nox" "-noxref")
                         ("-nc" "-nocopy") ("-off" "-offset")
                         ("-old" "-oldio") ("-opt" "-optimize")
                         ("-pb" "-pbecb") ("-prod" "-production")
                         ("-pre" "-preprocess") ("-prof" "-profile")
                         ("-pro" "-protect") ("-ra" "-range")
                         ("-rmarg" "-rmargin") ("-rnf" "-range_nonfatal")
                         ("-s" "-source") ("-sa" "-save")
                         ("-sig" "-signalerrors") ("-si" "-silent")
                         ("-slack" "-slackbytes") ("-sof" "-store_owner_field")
                         ("-stat" "-statistics") ("-stdo" "-stdopt")
                         ("-syn" "-syntaxmsg") ("-tmp" "-temp")
                         ("-tp" "-tps") ("-trunc" "-truncdiags")
                         ("-unc" "-uncopt") ("-up" "-upcase")
                         ("-vdec" "-vtbls_declared") ("-vdef" "-vtbls_defined")
                         ("-xd" "-xdd") ("-xdu" "-xdump")
                         ("-xe" "-xed") ("-xl" "-xlex")
                         ("-xr" "-xref") ("-xrs" "-xrefsort")
                         ))
        (if (null lm_list_path$) (setq lm_list_path$ ""))
        (if (null lm_bin_path$) (setq lm_bin_path$  ""))
        (if (null lm_max_num_errors$) (setq lm_max_num_errors$ 100))
        (if (null lm_error_size$) (setq lm_max_error_size$ 10))
        (if (null lm_forward_error_key$) (setq lm_forward_error_key$ "^xn"))
        (if (null lm_prev_error_key$) (setq lm_prev_error_key$    "^xp"))
        (setq lm_initialized$ true)
        )                                      ; end lm_init

;
; Display an error
;

(defun lm_display ((number integer))
       (lm_display_errors (nthcar lm_errors$ number))
       )

(defun lm_display_errors ((slist list)
                         &local
                          (number_of_lines integer)
                          (string_list list)
                          (source_cursor cursor)
                          (total_lines integer)
                          (counter integer))
                                       ; slist has the form
                                       ; (cursor "text1" "text2" ..)
       (setq source_cursor (car slist))
       (setq string_list (cdr slist))
       (if (^= (typef source_cursor) 9)
           (info_message "No more errors to display")
           (return))
       (setq counter 1)
       (one_window)
       (with_no_redisplay
          (save_position
             (select_buf ".errors")
             (delete_buffer)
             (do_forever (if (null string_list) (stop_doing))
                         (insert (catenate  (integer_to_string counter) ". "))
                         (insert (car string_list))
                         (cr)
                         (setq string_list (cdr string_list))
                         (setq counter (1+ counter))
                         )
             (if (> (line_number current_cursor) lm_max_error_size$)
                 (setq number_of_lines lm_max_error_size$)
              else
                 (setq number_of_lines (line_number current_cursor))
                 )
             )
          (setq total_lines (window_info bottom_line))
          (select_buf ".errors")
          (move_top)
          (split_window number_of_lines)
          (go_to_cursor source_cursor)
          )
       (info_message (catenate "Error " (integer_to_string number) " of "
                               (integer_to_string (length lm_errors$))))
       )

(defcom lm_next_error$ (next_error))
(defcom lm_prev_error$ (prev_error))

(defcom next_error
        (setq lm_err#$ (1+ lm_err#$))
        (if (<= lm_err#$ (length lm_errors$))
            (lm_display lm_err#$)
         else
            (info_message "Beyond last error")
            (setq lm_err#$ (1+ (length lm_errors$)))
            )
        )

(defcom lm_goto_error
        &args ((number &prompt "Error #" &default 1 &integer))
        (if (| (< number 1) (> number (length lm_errors$)))
            (info_message "Out of error range")
         else
            (setq lm_err#$ number)
            (lm_display number)
            )
        )

(defcom prev_error
        (setq lm_err#$ (1- lm_err#$))
        (if (> lm_err#$ 0)
            (lm_display lm_err#$)
         else
            (info_message "Before first error")
            (setq lm_err#$ 0)
            )
        )

;
; Decodes abbreviations for command line options
;

(defun abbrev    ((token_string string)
                  &local (scar string)
                  (scdr string)
                  &returns string)
       (if (= token_string "") (return ""))
       (setq scar (before token_string " "))
       (setq scdr (after  token_string " "))
       (return (catenate (abbrev_f scar) " "
                         (abbrev   scdr))))

(defun abbrev_f  ((token string) &returns string)
       (if (^ (null (car (cdr (assoc token  abbrevs$)))))
           (return (car (cdr (assoc token abbrevs$))))
        else (return token))
       )

;
; Returns the oposite of an option
; updated 4/26/85 for change to command line formats
;

(defun anti ((token string) &returns string)
       (if (= (substr token 2 2) "no")
           (return (catenate "-" (substr token 5)))
        else
           (return (catenate "-" "no_" (substr token 2))))
       )

;
; Remove redundant or contradictory options
;

(defun remove_extras ((token_string string)
                      &returns string &local (sc string) (sd string))
       (if (= compiler$ "cc") (return token_string)) ; don't do this for C (c is a silly language)
       (if (= token_string "") (return ""))
       (setq sc (before token_string " "))
       (setq sd (after  token_string " "))
       (if (& (= (index sd sc) 0)
              (= (index sd (anti sc)) 0))
           (return (catenate sc " " (remove_extras sd)))
        else
           (return (remove_extras sd))
           )
       )

;
; Returns global variable options for a language
; (if any)
;

(defun user_options ((cname string) &returns any &local (co atom))
       (setq co (eval (intern (catenate cname "_compile_options$"))))
       (if (null co) (return "") else (return co))
       )

;
; Compile on a key
;
(defcom compile_key
        &doc "Function to invoke compile to bind to a key"
        (setq command_args_string$ "")
        (compile)
        )

;
; Compile file in buffer
;

(defcom compile
        &doc "Compiles current buffer, scans for errors."
        (if (buffer_info modified) (save_file))
        (if (null lm_initialized$) (lm_init))
        (one_window)
                                       ; Setup global variables then call the real compile function
                                       ; if incorrect compiler tell the user
        (setq entry_name$
              (downcase (file_info (buffer_info default_file) entry_name)))
        (setq entry_name$ (before entry_name$ (catenate "." (suffix$ entry_name$))))
        (setq dir_name$
              (downcase (file_info (buffer_info default_file) directory_name)))
        (setq compiler$ (buffer_info (user language_name$)))
        (if (^ (null compiler$))
            (lm_compile dir_name$ entry_name$ compiler$)
         else
            (info_message "Can't find a language mode on, are you in language mode?"))
        )

(defun lm_compile ((dir_name string)
                   (entry_name string)
                   (compiler string)
                   &local (bin_path string)
                   (errors integer)
                   (list_path string)
                   (comp_str string)
                   )

                                       ; Create the compile option string, remove all the duplicate entries
                                       ; and inconsistent entries and make sure to expand abbrevs if they are
                                       ; there

       (setq compile_options$ (process_compile_options
                                  (abbrev (catenate
                                              (user_options compiler)
                                              " "
                                              command_args_string$
                                              " "
                                              ))
                                  )
             )
                                       ; Construct the compile string
       (setq comp_str (catenate compiler " "
                                dir_name ">" entry_name " "
                                compile_options$))
                                       ; Compile
       (compile_the_file comp_str)

       ;; Check for gratuitous errors (missing files bad command lines, etc.)
       ;; we'll use errors later in figuring the display.

       (setq errors (check_for_errors))


                                       ; We've compiled the file now let's process the output

                                       ; If this is one of the nasty compilers then put the .list
                                       ; file into file_output to be processed.  If there is no .list
                                       ; file then tell the user that he needs one
       (get_error_file)

                                       ; Go get the errors and process them

       (get_lm_errors)

       ;; probably bad file or compile if errors is non zero and
       ;; lm_errors$ is not set
       (if (& (^= errors 0) (| (null lm_errors$) (= lm_errors$ 0)))
           (one_window)
           (save_excursion
              (split_window)
              (other_window)
              (select_buf "file_output")
              (other_window)
              )
           (info_message (catenate (integer_to_string errors)
                                   " ERRORS in compile")
                         )
           )

       (redisplay)
       )

(defun compile_the_file (comp_str)
       (info_message (catenate "Compiling: " comp_str))
       (if (^ (null compile_search_rules$))
           (setq comp_str (catenate (compile_search_rules) NL comp_str)))
       (save_excursion (with_no_redisplay
                           (primos_external comp_str)
                       )
       ))

(defun compile_search_rules (&local search_rule_string sr)
       (setq search_rule_string "")
       (setq lm_search_rules$ '())
       (setq sr compile_search_rules$)
       (do_forever (if (null sr) (stop_doing))
                   (select (typef (car sr))
                           5           ;just a pathname
                           (setq lm_search_rules$ (cons (cons (lm_sr (car sr)) (car sr))
                                                        lm_search_rules$)
                                 )
                           (setq search_rule_string (catenate "ssr " (car sr) " -ns" NL
                                                              search_rule_string))
                           8           ;sublist
                           (setq lm_search_rules$ (cons (cons (car (cdr (car sr))) (car (car sr)))
                                                        lm_search_rules$)
                                 )
                           (setq search_rule_string (catenate "ssr " (car (car sr))
                                                              " -lnam " (car (cdr (car sr))) " -ns"
                                                              NL search_rule_string
                                                              ))
                           otherwise
                           (info_message "error in search rules (compile_search_rules)")
                           )
                   (setq sr (cdr sr))
                   )
       (return search_rule_string)
       )

(defun lm_sr (string &local rstring)
       (setq rstring (before string ".sr"))
       (do_forever (if (= (index rstring ".") 0) (stop_doing))
          (setq rstring (after rstring ".")))
       (do_forever (if (= (index rstring ">") 0) (stop_doing))
          (setq rstring (after rstring ">")))
       (return rstring)
       )

(defun check_for_errors (&local counter *ignore_case_in_search)
       (save_excursion
          (select_buf "file_output")
          (move_top)
          (setq counter 0)
          (setq *ignore_case_in_search true)
          (if (= compiler$ "cxx")
              (if (forward_search ": Translation terminated")
                  (move_top)
                  (do_forever (if (^ (forward_search " error:")) (stop_doing))
                              (setq counter (1+ counter)))
                  (move_top)
                  (do_forever (if (^ (forward_search "Error #")) (stop_doing))
                              (setq counter (1+ counter)))
                  (move_top)
                  (do_forever (if (^ (forward_search "Error# ")) (stop_doing))
                              (setq counter (1+ counter)))
                  (move_top)
                  (do_forever (if (^ (forward_search "ed:")) (stop_doing))
                              (setq counter (1+ counter)))
                  (move_top)
                  (do_forever (if (^ (forward_search "recover from")) (stop_doing))
                              (setq counter (1+ counter)))
                              )
           else
              (do_forever (if (^ (forward_search "errors")) (stop_doing))
                          (if (= (cur_hpos) 12)
                              (begin_line)
                              (skip_over_white)
                              (setq counter (+ counter
                                               (string_to_integer (before (current_line) " "))))
                              (end_line)
                              )))
          (move_top)
          (return counter))
       )

(defun get_error_file ()
 (if (member compiler$ error_in_listing_file$)
    (save_excursion
        (with_command_abort_handler
            (select_buf "file_output")
            (delete_buffer)
            (if (= list_path "")
                (insert_file (catenate entry_name ".list"))
             else
                (insert_file (catenate list_path ".list")))
       command_abort_handler
            (info_message "Cannot process errors without .list file")
            (return)
            )
    )
 ))

(defun get_lm_errors ()
 (with_no_redisplay
     (save_excursion
        ;; if user uses include$ search rules then set them up
        (if (^ (null (cdr (assoc "include$" lm_search_rules$)))) ; setup search rules
            (primos_internal_quiet (catenate "ssr "
                                             (cdr (assoc "include$" lm_search_rules$))
                                             " -lnam emacs_compile_include$ -ns")))
        (select_buf "file_output")
                                       ; if old rpg, turn on high bit - twits
        (if (= compiler$ "rpg")
            (move_top)
            (setq t_cursor$ (copy_cursor current_cursor))
            (move_bottom)
            (setq b_cursor$ (copy_cursor current_cursor))
            (save_position
                (select_buf ".temp")
                (insert (high_bit_on (range_to_string t_cursor$ b_cursor$)))
                )
            (delete_buffer)
            (insert_buf ".temp")
            )
                    ; not tsi error format for cobol, pma, rpg, ftn, & cc or cxx
        (select compiler
;               when "cobol"
;                            (move_cobol_errors)
;                            (setq lm_errors$ (scan_errors tsi))
                when "pma"   (setq lm_errors$ (scan_errors pma))
                when "rpg"   (setq lm_errors$ (scan_errors rpg))
                when "ftn"   (setq lm_errors$ (scan_errors ftn))
                when "cxx"   (setq lm_errors$ (scan_errors cxx))
                when "cc"    (setq lm_errors$ (scan_errors cc))
                when "plp"   (setq lm_errors$ (scan_plp_errors))
                otherwise    (setq lm_errors$ (scan_errors tsi))
                )
        )
    (setq lm_errors$ (sort_list lm_errors$))
    (setq lm_errors$ (gather lm_errors$))
    (setq lm_errors$ (makcur lm_errors$))
    (setq lm_err#$ 0)

    (if (> (length lm_errors$) 0)
        (save_excursion
            (select_buf "file_output")
            (buffer_info changed_ok true)
            (select_buf ".errors")
            (buffer_info changed_ok true)
            )
        (set_permanent_key lm_forward_error_key$ "lm_next_error$")
        (set_permanent_key "^xN" "lm_next_error$")
        (set_permanent_key "^xP" "lm_prev_error$")
        (set_permanent_key lm_prev_error_key$ "lm_prev_error$")
        (info_message
            (catenate
                (integer_to_string (length lm_errors$))
                " errors to view, type ^xn for next error, ^xp for previous error")
            )
     else
         (save_excursion
             (select_buf "file_output")
             (if (forward_search "0000 ERRORS")
                ;then
                     (info_message (current_line))
                 else
                     (if (forward_search "Fatal option or file error.")
                        ;then
                             (ring_the_bell)
                             (info_message (current_line))
                         else
                             (if (forward_search "*COMMAND LINE ERROR")
                                ;then
                                     (ring_the_bell)
                                     (info_message (current_line))
                                 else
                                     (info_message "Compilation complete.")
                             )
                     )
             )
         )
        )
    )
)
