; COMPILE2.EM, EMACS*>EXTENSIONS>SOURCES, EMACS DEVELOPMENT,12/22/87
; Compile file in buffer and report errors (part 2).
; Copyright (c) 1983, Prime Computer, Inc., Natick, MA 01760
;                     All Rights Reserved
;
;
; Modifications:
;   Date    Engineer       Description of modification
; 11/02/87  *** NOTE ***   The modification history of COMPILE.EM and of
;                          COMPILE2.EM is recorded in COMPILE.EM only.
; 11/02/87  Bugos          Due to size, split COMPILE.EM into two modules:
;                          COMPILE.EM and COMPILE2.EM.


(defun process_compile_options  (compile_options)
       (setq compile_options (remove_extras compile_options))

                                       ; Set the bin and list pathname from the globals if the option is
                                       ; given and if the global exists

       (setq bin_path (return_path compile_options "-binary" lm_bin_path$))
       (setq list_path (return_path compile_options "-listing" lm_list_path$))
                                       ; Add bin and list pathnames to the compile_options$ string
       (if (^= bin_path "")
           (setq compile_options
                 (insert_in compile_options "-binary" (catenate bin_path ".bin"))))

       (if (^= list_path "")
           (setq compile_options
                 (insert_in compile_options "-listing" (catenate list_path ".list"))))
       (return compile_options)
)

(defun return_path ((options string) (item string) (default string)
                    &local (partstring string)
                    &returns string)
(if (^= (index options item) 0)
    (setq partstring (substr options (index options item)))
    (setq partstring (after  partstring " "))
    (if (| (= (substr partstring 1 1) "-")
           (= partstring ""))
        (return (catenate default entry_name$))
     else
        (return ""))
 else
(return "")
)
)

(defun insert_in ((options string) (item string) (insert_string string)
                  &local (first_part string)
                  (last_part string)
                  (item_index integer)
                  &returns string)
(setq item_index (index options item))
(if (= item_index 0) (return options)
 else
    (setq first_part (substr options 1 (1- item_index)))
    (setq last_part (after  (substr options item_index) " "))
    (return
        (catenate first_part item " " insert_string " " last_part))
    )
)

; Description:
;
; Gather takes any list of lists in the form ( (..) (..) ... (..) )
; and assumes that entries look like (key contents)
; it also assumes that the list is sorted.
; it produces a list with entries that look like (key contents1 contents2 ..)
; which can then be used as an associative list with that key.
;

(defun gather ((alist list)
               &local
               (rlist list)
               &returns list)
(setq rlist '())
(do_forever (if (null alist) (stop_doing))
            (if (= (car (car rlist)) (car (car alist)))
                (setq rlist (cons
                                (append (car rlist) (cdr (car alist)))
                                (cdr rlist)))
             else
                (setq rlist (cons (car alist) rlist))
                )
            (setq alist (cdr alist))
            )
(return rlist)
)

; Description:
;
; MakCur takes a list of errors and makes cursors into the appropriate
; buffers, loading insert files where needed.  It takes a list of the
; form:
;
; ( ("#/filename" "et1" "et2" ...) ... ) most compilers
; or
; ( ("#.#..." "et1" "et2" ...) ... ) c
;
; also # is found by itself, indicating that the error is in the compiled
; routine.
;
; The result is:
;
; ( (c1 "et1" ...) (c2 "et1" ...)  ... )
;
; where c# indicates a cursor, et1,2 etc are error text associated with each
; cursor
;
(defun makcur ((error_list list)
              &local
               (current_list list)
               (return_list list)
               (line_number string)
               (number integer)
               &returns list)
       (setq return_list '())
       (do_forever (if (null error_list) (stop_doing)) ;do until out of errors
                   (setq current_list (car error_list))
                   (setq error_list (cdr error_list))
                   (setq line_number (before (car current_list) "/"))
                   (if (= compiler "cc")
                       (setq return_list
                             (cons (append (list (cc_getline line_number)) (cdr current_list))
                                   return_list))
                    else
                       (save_excursion
                          (if (^= (after (car current_list) "/") "") ; no insert file
                              (with_command_abort_handler
                                 (find_file (after (car current_list) "/") "") ; get the file
                              command_abort_handler
                                 (save_excursion
                                    (select_buf ".temp")
                                    (delete_buffer)
                                    (af (catenate "[find_file " (after (car current_list) "/") " emacs_compile_include$]"))
                                    (with_command_abort_handler
                                       (find_file (current_line) "yes")
                                    command_abort_handler
                                       (info_message (catenate (current_line) " not found"))
                                       )
                                    )
                                 )
                              )
                          (setq return_list
                                (cons (append (list (make_cursor (buffer_info name)
                                                                 (string_to_integer line_number)
                                                                 1
                                                                 ))
                                              (cdr current_list))
                                      return_list
                                      )
                                )
                          )
                       )
                   )
       (return return_list)
       )

;
; cc_getline,  with many thanks to DMM for supplying much of this code.
;
(defun cc_getline ((line_str string)
                   &local
                   (src_curs cursor)
                   (temp_str string)
                   (rt_delim string)
                   &returns cursor)

(save_excursion
;
; For each line (aaa, bbb, ccc... as above), dive as deep as
; necessary to get to the actual source that caused error.
; This may mean diving into included files, included include
; files, etc.  Uses src_curs to remember the outermost include
; (the line in the original source file) so we can get back to
; it if something fails in the diving process.
;
(do_forever
    ;
    ; Go to line in current buffer.
    ;
    (setq src_curs (make_cursor (buffer_info name)
                     (string_to_integer (before line_str ".")) 1 ))
    (go_to_cursor src_curs)
    (begin_line)
    ;
    ; Now check if add'l line numbers specified indicating
    ; we should probably dive into an included file.
    ; If not, simply stop the dive loop.
    ;
    (setq line_str (after line_str "."))
    (if (= line_str "") (stop_doing))
    ;
    ; Dive:  Obviously we can't if the line doesn't contain
    ; a #include, or that #include doesn't seem to contain
    ; a proper filename delimited by "" or <>.  If no dive
    ; possible, stop the loop which marks as deep as we got.
    ;
    (if (or (= (search (current_line) "#") 0)
            (= (index (downcase (current_line)) "include") 0))
        (stop_doing)
    )
    (if (^ (search_fd_in_line "<~""))
        (stop_doing)
    )
    ;
    ; There's a difference between an include file delimited
    ; by <> and "".  The "" is an absolute or relative Primos
    ; pathname.  The <> indicates a standard include file in
    ; the SYSCOM UFD.  At the moment, no search-rules are
    ; used for CC include files.
    ;
    (if_at "<"
        (setq temp_str "syscom>")
        (setq rt_delim ">")
     else
        (setq temp_str "")
        (setq rt_delim "~"")
    )
    (forward_char)
    (with_cursor here
        (search_fd_in_line rt_delim)
        (setq temp_str (catenate temp_str (point_cursor_to_string here)))
    )
    ;
    ; Dive into the included file.  Barf if cannot--return to
    ; original source and let user try his/her luck!
    ; The "yes" in find_file answers the proverbial question:
    ;   `File modified, reread?' if it comes up.
    ;
    (with_command_abort_handler
        (find_file temp_str "yes")
     command_abort_handler
        (go_to_cursor src_curs)
        (stop_doing)
    )
)
)
(return src_curs)
)


(defcom set_lm_list_path$
    &doc "Sets the listing path for COMPILE"
    (let ((path (prompt_for_string  "What is the listing path" "")))
         (if (= path "") (setq path () ))
         (setq lm_list_path$ path)))

(defcom set_lm_bin_path$
    &doc "Sets the binary path for COMPILE"
    (let ((path (prompt_for_string  "What is the binary path" "")))
         (if (= path "") (setq path () ))
         (setq lm_bin_path$ path)))

(defcom set_ftn_compile$
    &doc "Sets the compile options for FTN"
    (let ((options (prompt_for_string  "What are the FTN compile options" "")))
         (if (= options "") (setq options () ))
         (setq ftn_compile_options$ options)))

(defcom set_f77_compile$
    &doc "Sets the compile options for F77"
    (let ((options (prompt_for_string  "What are the F77 compile options" "")))
         (if (= options "") (setq options () ))
         (setq f77_compile_options$ options)))

(defcom set_rpg_compile$
    &doc "Sets the compile options for RPG"
    (let ((options (prompt_for_string  "What are the RPG compile options" "")))
         (if (= options "") (setq options () ))
         (setq rpg_compile_options$ options)))

(defcom set_vrpg_compile$
    &doc "Sets the compile options for VRPG"
    (let ((options (prompt_for_string  "What are the VRPG compile options" "")))
         (if (= options "") (setq options () ))
         (setq vrpg_compile_options$ options)))


(defcom set_cobol85_compile$
    &doc "Sets the compile options for COBOL85"
    (let ((options (prompt_for_string  "What are the COBOL85 compile options" "")))
         (if (= options "") (setq options () ))
         (setq cobol85_compile_options$ options)))


(defcom set_cbl_compile$
    &doc "Sets the compile options for CBL"
    (let ((options (prompt_for_string  "What are the CBL compile options" "")))
         (if (= options "") (setq options () ))
         (setq cbl_compile_options$ options)))

(defcom set_cc_compile$
    &doc "Sets the compile options for C"
    (let ((options (prompt_for_string  "What are the C compile options" "")))
         (if (= options "") (setq options () ))
         (setq cc_compile_options$ options)))

(defcom set_cxx_compile$
    &doc "Sets the compile options for C++"
    (let ((options (prompt_for_string  "What are the C++ compile options" "")))
         (if (= options "") (setq options () ))
         (setq cxx_compile_options$ options)))

(defcom set_max_num_errors$
    &doc "Sets the maximum number of errors for COMPILE"
    (let ((number (prompt_for_integer  "What is the maximum number of errors" 40)))
         (if (= number "") (setq number () ))
         (setq max_num_errors$ number)))

(defcom set_lm_max_error_size$
    &doc "Sets maximum display size for error messages"
    (let ((number (prompt_for_integer  "What is largest size of error display window" 40)))
         (if (= number "") (setq number () ))
         (setq lm_max_error_size$ number)))

; (defun move_cobol_errors (&local
;           (text string)
;           (ln   string)
;           (a cursor)
;           (insert_at cursor)
;           )
;        (select_buf "file_output")
;        (move_top)
;        (save_position
;           (select_buf ".temp")
;           (delete_buffer)
;           (setq insert_at (copy_cursor current_cursor))
;           )
;        (do_forever
;           (if (^ (forward_search (catenate NL " ** "))) (stop_doing))
;           (setq text (trim (current_line)))
;           (prev_line)
;           (begin_line)
;           (search_fd_in_line "(")
;           (forward_char)
;           (setq a (copy_cursor current_cursor))
;           (search_fd_in_line ")")
;           (setq line (range_to_string a current_cursor))
;           (next_line)
;           (next_line)
;           (insert (catenate "ERROR LINE " line NL text NL NL) insert_at)
;           )
;        (if (search_fd (ItoC 12))
;            (begin_line)
;            (next_line)
;            (do_forever
;               (if (= (index "0123456789" (substr (current_line) 1 1)) 0) (stop_doing))
;               (setq text (current_line))
;               (setq line (trim (substr text 1 (index text " "))))
;               (setq text (trim (substr text (index text " "))))
;               (insert (catenate "ERROR LINE " line NL text NL NL) insert_at)
;               (next_line)
;               )
;            )
;        (delete_buffer)
;        (insert_buf ".temp")
;        )

(defun scan_plp_errors (&local error_list)
       (do_forever (if (^ (forward_search "~n ******")) (return error_list))
          (let ((message_list '())
                (number '())
                )
               ;;  Get the line number from the line before
               (prev_line)
               (setq number (current_line))
               (next_line)
               ;;  The line number is held between parens
               (setq number (after number "("))
               (setq number (before number ")"))
               ;;  Error messages go into a list of the form:
               ;;  ( "#" "message 1" "message 2" .. "message n")
               (setq message_list (list number))
               (do_forever (if (^= (substr (current_line) 2 6) "******") (stop_doing))
                  (setq message_list (cons (substr (current_line) 9) message_list))
                  (next_line)
                  )
               (setq error_list (cons (reverse message_list) error_list))
               )
          )
       (return error_list)
       )

(defun after ((s1 string) (s2 string) &returns string &local (i integer))
       (setq i (index s1 s2))
       (if (= i 0)
           (return "")
        else
           (return (substr s1 (+ i (string_length s2))))
       )
)

(defun before ((s1 string) (s2 string) &returns string &local (i integer))
       (setq i (index s1 s2))
       (if (= i 0)
           (return s1)
        else
           (return (substr s1 1 (- i 1)))
       )
)
