; CXX.EM, EMACS*>EXTENSIONS>SOURCES, EMACS DEVELOPMENT, 08/27/90
; C++ Language-mode macros
; Copyright (C) 1990, Prime Computer, Inc., Natick, MA 01760
;
; Modifications:
;
;   Date    Engineer      Modification
; 08/27/90  S. Horowitz   Added C++ support.
; 01/04/88  Bugos/        In both cxx_add_local_def$ and cxx_add_global_def$,
;           Litterio      replaced "<.type>" (incorrect form) with "<.type.>"
;                         (correct form).
; 03/26/87  Litterio      Removed a (prompt "") used for debugging.
; 02/15/85  Rand          Initial coding.
;

(defcom cxx_on
  (turn_mode_on (find_mode 'cxx) first)
  (buffer_info (user language_name$) "cxx")
  (if (null cxx_loaded$) (init_cxx))
  (info_message "C++ Language Mode ON;  Type ^x? for help."))

(defcom cxx_off
  (turn_mode_off (find_mode 'cxx))
  (buffer_info (user language_name$) '())
  (info_message "C++ Language Mode OFF"))

(defcom init_cxx
   (spd_load_file "emacs*>extensions>spd>cxx")
   (spd_on)
   (if (null cxx_pp$_0) (setq cxx_pp$_0 2)) ; current right margin
   (set_mode_key "cxx" "^j" "cret_indent_relative")
   (set_mode_key "cxx" "^x\" "pp_region")
   (set_mode_key "cxx" "^xl1" "cxx_pp_function$")
   (set_mode_key "cxx" "^xl0" "pp_cursors")
   (set_mode_key "cxx" "^xg" "cxx_add_global_def$")
   (set_mode_key "cxx" "^xc" "cxx_add_local_def$")
   (set_mode_key "cxx" "^x/" "cxx_ret_from_def$")
   (set_mode_key "cxx" "^x?" "cxx_help$")
   (init_cxx_actions)
   (epf_defun cxx "RTCXX" "*" "kk" "")
   (setq cxx_loaded$ true)
)

(defun cxx_pp_function$ ()
    (insert "~n// PP FUNCTION~n")
    (prev_line)
    (save_excursion
        (pp_region))
    (kill_line 2)
    (rubout_char))

(defun cxx_add_global_def$()
    (setq cxx_def_retn_cursor$ (copy_cursor current_cursor))
    (if (reverse_search "// GLOBAL DECLARATIONS")
       (next_line 2)
       (insert "<.type.> <.identifier.>;~n")
       (mark)
       (prev_line)
       (pp_region)
   )
)

(defun cxx_add_local_def$()
    (setq cxx_def_retn_cursor$ (copy_cursor current_cursor))
    (if (reverse_search "// LOCAL DECLARATIONS")
       (next_line 2)
       (insert "<.type.> <.identifier.>;~n")
       (mark)
       (prev_line)
       (pp_region)
   )
)

(defun cxx_ret_from_def$()
    (go_to_cursor cxx_def_retn_cursor$)
)

(defcom make_cxx_prog
  &doc "Insert a program template."
  (with_no_redisplay
    (insert "// GLOBAL DECLARATIONS") (cr)
    (insert "  <.type.> <.identifier.>;") (cr)
    (insert "  ") (cr)
    (insert "<.type.> <.name.> (<.type.> <.arg_identifier.>)") (cr)
    (insert "  {") (cr)
    (insert "  // LOCAL DECLARATIONS") (cr)
    (insert "  ") (cr)
    (insert "   <.type.> <.identifier.>;") (cr)
    (insert "   ") (cr)
    (insert "   <.statement.>") (cr)
    (insert "   }") (cr)
;    (mark)
    (reverse_search "// GLOBAL DECLARATIONS")
;    (pp_region)
  )
;  (exchange_mark)
  (forward_place_holder)
)

(defcom make_class
  &doc "Insert a class template."
  (with_no_redisplay
;    (insert "// CLASS DEFINITION") (cr)
    (insert "class <.identifier.> {") (cr)
;    (insert "// PUBLIC Section") (cr)
    (insert "  public:") (cr)
    (insert "    <.type.> <.identifier.>;") (cr)
    (insert "    <.type.> <.name.> (<.type.> <.arg_identifier.>);") (cr)
    (insert "  ") (cr)
;    (insert "// PRIVATE Section") (cr)
    (insert "  private:") (cr)
    (insert "    <.type.> <.identifier.>;") (cr)
    (insert "    <.type.> <.name.> (<.type.> <.arg_identifier.>);") (cr)
    (insert "};") (cr)
;    (mark)
    (reverse_search "// CLASS DEFINITION")
;    (pp_region)
  )
;  (exchange_mark)
  (kill_line)
  (forward_place_holder)
)


(defcom make_cxx_func
  &doc "Insert a function template."
  (with_no_redisplay
    (insert "// PP FUNCTION") (cr)
    (insert "<.type.> <.name.> (<.type.> <.arg_identifier.>)") (cr)
    (insert "{") (cr)
    (insert "// LOCAL DECLARATIONS") (cr)
    (insert "") (cr)
    (insert "   <.type.> <.identifier.>;") (cr)
    (insert "") (cr)
    (insert "   <.statement.>") (cr)
    (insert "}") (cr)
;    (mark)
    (reverse_search "// PP FUNCTION")
;    (pp_region)
    )
;  (exchange_mark)
  (kill_line)
  (forward_place_holder)
)

(defcom make_memfunc
  &doc "Insert a member function template."
  (with_no_redisplay
    (insert "// PP MEMBER FUNCTION") (cr)
    (insert "<.type.> <.class_name.>::<.function_name.> (<.type.> <.arg_identifier.>)") (cr)
    (insert "{") (cr)
    (insert "// LOCAL DECLARATIONS") (cr)
    (insert "") (cr)
    (insert "   <.type.> <.identifier.>;") (cr)
    (insert "") (cr)
    (insert "   <.statement.>") (cr)
    (insert "}") (cr)
;    (mark)
    (reverse_search "// PP MEMBER FUNCTION")
;    (pp_region)
    )
;  (exchange_mark)
  (kill_line)
  (forward_place_holder)
)


(defcom init_cxx_actions
  (setq cxx$.dt_spec_fun_hd '(0 "N"))
  (setq cxx$.fun_head '(0 "li"))
  (setq cxx$.param_dcl1 '(0 "ls#1"))
  (setq cxx$.param_dcl2 '(0 "ls#"))
  (setq cxx$.fun_bod_b '(0 "li.+#2"))
  (setq cxx$.fun_bod_e '(0 "^li"))
  (setq cxx$.fun_dcl1 '(0 "ls#1"))
  (setq cxx$.fun_dcl2 '(0 "ls#1"))
  (setq cxx$.ext_data_dcl1 '(0 "ls#1"))
  (setq cxx$.ext_data_dcl2 '(0 "ls#1"))
  (setq cxx$.int_data_dcl1 '(0 "ls#1"))
  (setq cxx$.int_data_dcl2 '(0 "ls#1"))
  (setq cxx$.statement '(0 "l"))
  (setq cxx$.comp_stat_dec '(0 "l"))
  (setq cxx$.comp_stat_b '(0 "lb#2i"))
  (setq cxx$.comp_stat_e '(0 "lb#2i"))
  (setq cxx$.case_list_b '(0 "li.+#2.+#2"))
  (setq cxx$.case_list_e '(0 "^^li"))
  (setq cxx$.case_lbl '(0 "n"))
  (setq cxx$.case_hdr '(0 "lb#3"))
  (setq cxx$.case_dflt_lbl '(0 "n"))
  (setq cxx$.case_dflt_hdr '(0 "lb#3"))
  (setq cxx$.if_stat '(0 "l"))
  (setq cxx$.if_end '(0 "^"))
  (setq cxx$.if_else '(0 "lb#3"))
  (setq cxx$.if_else_stat '(0 "l"))
  (setq cxx$.if_hdr '(0 "li.+#2"))
  (setq cxx$.while_hdr '(0 "l.+#2"))
  (setq cxx$.while_stat '(0 "l"))
  (setq cxx$.while_end '(0 "^"))
  (setq cxx$.do_hdr '(0 "li.+#2"))
  (setq cxx$.do_stat '(0 "li"))
  (setq cxx$.do_while '(0 "^l"))
  (setq cxx$.for_hdr '(0 "li.+#2"))
  (setq cxx$.for_stat '(0 "li"))
  (setq cxx$.for_end '(0 "^"))
  (setq cxx$.struct_b '(0 "li"))
  (setq cxx$.union_b '(0 "li"))
  (setq cxx$.enum_list_b '(0 "li.+#2"))
  (setq cxx$.enum_list_e '(0 "^li"))
  (setq cxx$.agg_dcl_b '(0 "li.+#2"))
  (setq cxx$.agg_dcl_e '(0 "^li"))
  (setq cxx$.mem_dcl '(0 "n"))
  (setq cxx_pp$_0 2)
  (setq cxx_pp$_1 4)
  (setq cxx_pp$_2 4)
  (setq cxx_pp$_3 4)
  (setq cxx_pp$_4 4)
  (setq cxx_pp$_5 4)
  (setq cxx_pp$_6 8)
  (setq cxx_pp$_7 4)
  (setq cxx_pp$_8 4)
  (setq cxx_pp$_9 4)
)

(defcom cxx_help$
  (init_local_displays "The C++ Language Mode offers the following features:")
  (local_display_generator " ")
  (local_display_generator "    The COMMANDS:")
;  (local_display_generator
;"            ^x\   pretty print a marked region (only for whole files ")
;  (local_display_generator
;"                  or inside a function - otherwise use ^xl1);")
;  (local_display_generator
;"            ^xl1  pretty print a function and/or definition not part ")
;  (local_display_generator
;"                  of a function body (inside the first brace);")
;  (local_display_generator
;"            ^xl0  pretty print a just inserted ""template region;"""       )
  (local_display_generator
"            ^xg   add a global declaration;")
  (local_display_generator
"            ^xc   add a local (in the current function) declaration;")
  (local_display_generator
"            ^x/   return from an inserted declaration (^xg or ^xc);")
  (local_display_generator
"            ^x?   print this help;")
  (local_display_generator
" ")
  (local_display_generator
"    The Templates: ")
  (local_display_generator
" ")
  (local_display_generator
"       /class  to begin a class     /memfunc  to begin a new member function")
  (local_display_generator
"       /prog  to begin a program    /func  to begin a new function")
  (local_display_generator
"       /block, /body, /{ for { <.statement.> } ")
  (local_display_generator
"       /if        => if <.condition.> <.statement.>" )
  (local_display_generator
"       /ifelse    => if <.condition.> <.statement.> else <.statement.>")
  (local_display_generator
"       /for       => for (<.expr.>;<.expr.>;<.expr.>) <.statement.>")
  (local_display_generator
"       /do        => do <.statement.> while(<.expr.>;")
  (local_display_generator
"       /while     => while (<.expr.>) <.statement.> ")
  (local_display_generator
"       /switch    => switch { case <.expr.>: <.stat.> default : <.stat.>}")
  (local_display_generator
"          /case    => case <.expr.> : <.statement.> ")
  (local_display_generator
"          /default => default : <.statement.> ")
  (local_display_generator
"       /struct    => struct { <.type> <.dentifier.>; } ")
  (local_display_generator
"       /union     => union { <.type> <.dentifier.>; } " )
  (local_display_generator
"       /dcl       => <.type.> <.identifier.>; ")
  (local_display_generator " ")
)
