;  DATE_FORMAT.EM,  EMACSSRC>EMACS*>EXTENSIONS>SOURCES, TOOLS GROUP, 02/03/83
;  Contains library of functions for manipulating date information in EMACS
;  Copyright (c) 1982, Prime Computer, Inc., Natick, MA 01760
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;    This file contains routines that display the date in different        ;;;
;;;    formats                                                               ;;;
;;;                                                                          ;;;
;;;    {esc}x europe_dt           8/7/81                                     ;;;
;;;    {esc}x sort_dt             81/07/14                                   ;;;
;;;    {esc}x trim_date           8 Jul 1981                                 ;;;
;;;    {esc}x trim_dt             7/8/81                                     ;;;
;;;                                                                          ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; 02/03/83 Zane   (if (null loaded$) (load))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; trim_dt                                                                  ;;;
;;;     Command that Removes the time portion of dt.  This is an             ;;;
;;;     extended command                                                     ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom trim_dt
    &doc "Inserts date wihout hours, etc."
    (mark)
    (dt)
    (rubout_word 3)                    ; get rid of time stuff
    (rubout_char)
    (back_word 3)
    (do_n_times 2
        (if_at "0"                     ; get rid of leading zeroes
            (delete_char)
            (forward_char 2)
         else
            (forward_char 3)))
     (forward_word))                   ; restore place

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; trim_date                                                                ;;;
;;;     Command that removes the day of the week, removes a leading          ;;;
;;;     zero on the month, and initial caps the month.  This is              ;;;
;;;     an extended command                                                  ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom trim_date
    &doc "Inserts date without day"
    (mark)
    (date)
    (back_word 3)
    (rubout_word)
    (if_at "0" (delete_char))
    (forward_word)
    (forward_char 2)
    (capinitial)
    (forward_word))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; europe_dt                                                                ;;;
;;;      Command that first invokes trim_dt then inverts the month and the   ;;;
;;;      day. It also removes leading zeroes from month and day.  This       ;;;
;;;      is an extended command.                                             ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom europe_dt
    &doc "Prints date the European way"
    (europe_dt$))
(defun europe_dt$ (&local (month string))
    (trim_dt)
    (back_word 2)
    (with_cursor here
         (back_word)
         (setq month (point_cursor_to_string here))
         (delete_point_cursor here))
    (forward_search "/")
    (insert month)
    (back_word 2)
    (if_at "0" (delete_char))
    (forward_word)
    (forward_char)
    (if_at "0" (delete_char))
    (forward_word 2))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; sort_dt                                                                  ;;;
;;;    Command that moves date information around so it is in sort order.    ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom sort_dt
     &doc "Puts date in sort order"
     (sort_dt$))
(defun sort_dt$ (&local (month integer)
                        (day integer))
     (mark)
     (dt)
     (rubout_word 3)
     (rubout_char)
     (back_word 3)
     (with_cursor here
          (forward_char 2)
          (setq month (point_cursor_to_string here))
          (delete_point_cursor here))
     (delete_char)
     (with_cursor here
          (forward_char 2)
          (setq day (point_cursor_to_string here))
          (delete_point_cursor here))
     (delete_char)
     (forward_char 2)
     (insert (catenate "/" month "/" day)))


; 02/03/83 Zane (setq date_format_loaded$ true)
