; DYNAMIC_ABBREVS.EM, EMACSSRC>EMACS*>EXTENSIONS>SOURCES, EMACS DEVELOPMENT, 10/12/88
; Dynamic abbreviation expansion package
; Copyright (c) 1988 Prime Computer, Inc., Natick, MA 01760
;                     All Rights Reserved
;
;
; Description:
;
; Abnormal conditions:
;
; Implementation:
;
; Modifications:
;   Date    Engineer      Description of modification
; 10/12/88  Bugos         Integration into EMACSSRC.
; 06/21/88  DS            Initial coding.


(defcom init_dyn_abbrev
    &doc "Initialize dynamic abbreviation expansion"
    (setq dyn_abbrev_delimiters " .,:;'()[]<>=+-?*%~"~n")    ; Word delimiters
    (setq da_cur nil)
    (set_permanent_key "^[/" "dyn_abbrev")
)

; Local functions:

; Return true if character to left of point is a word delimiter
(defun da_left_delim ()
    (if (beginning_of_buffer_p)
        (return true)
    )
    (save_excursion
        (back_char)
        (return (^= (search (current_character) dyn_abbrev_delimiters) 0))
    )
)

; Return true if character to right of point is a word delimiter
(defun da_right_delim ()
    (if (end_of_buffer_p)
        (return true)
    )
    (return (^= (search (current_character) dyn_abbrev_delimiters) 0))
)

; Move forward over an n-word completion
(defun da_fwd_n_words ()
    (search_fd dyn_abbrev_delimiters (numeric_argument 1))
)

; Return true if current completion is unique
(defun da_unique ()
    (save_excursion
        ; Locate current n words of completion at search site
        (if (= direction 'fwd)
            (forward_char (string_length da_abbrev))
        )
        (with_cursor start
            (da_fwd_n_words)
            (setq da_str (point_cursor_to_string start))

            ; Is it in the list of unique completions?
            (if (member da_str da_list)
                (return false)
            else
                ; Not found: add to list of unique completions
                (setq da_list (cons da_str da_list))
                (return true)
            )
        )
    )
)

; Search for the abbreviation in the given direction and return true if found
(defun da_search ((direction atom))
    (go_to_cursor da_try)
    (do_forever

        ; Search for the abbreviation
        (if (= direction 'rev)
            (if (not (reverse_search da_abbrev))
                (return false)
            )
        else
            (if (not (forward_search da_abbrev))
                (return false)
            )
        )

        ; Make sure trial abbreviation is left-bounded by a delimiter
        ; and completion is not a delimiter
        (save_excursion
            (if (= direction 'rev)
                (if (da_left_delim)
                    (forward_char (string_length da_abbrev))
                    (if (not (da_right_delim))
                        (if (da_unique)
                            (stop_doing) ; Found
                        )
                    )
                )
            else
                (if (not (da_right_delim))
                    (back_char (string_length da_abbrev))
                    (if (da_left_delim)
                        (if (da_unique)
                            (stop_doing) ; Found
                        )
                    )
                )
            )
        )
    )
    (return true)
)

(defcom dyn_abbrev
    &doc "Dynamically expand an abbreviation"

    ; Is point unchanged from the end of a previous expansion?
    (setq da_unchanged false)
    (if (not (null da_cur))
        (if (= current_cursor da_cur)
            (if (looked_at da_string)
                (setq da_unchanged true)
    )   )   )
    (if da_unchanged

        ; Yes: delete previous completion
        (delete_point_cursor da_orig)
    else

        ; No: initialize
        (setq da_direction 'rev)
        (setq da_list nil)

        ; Locate abbreviation string
        (setq da_orig (copy_cursor current_cursor))
        (if (not (bolp))
            (back_char)
            (search_bk dyn_abbrev_delimiters)
            (if (not (beginning_of_buffer_p))
                (forward_char) ; kludge
            )
        )
        (setq da_abbrev (point_cursor_to_string da_orig))
        (back_char)
        (setq da_try (copy_cursor current_cursor))
    )
    ; Search for next unique completion
    (do_forever
        (if (da_search da_direction)
            (stop_doing) ; Found
        else

            ; Not found: already looking forward?
            (if (= da_direction 'fwd)

                ; Yes: error and quit
                (setq da_cur nil)
                (go_to_cursor da_orig)
                (ring_the_bell)
                (error_message (catenate "No further expansions of ~""
                    da_abbrev "~" found.")
                )
                (throw nil 'done)
            )

            ; Try looking forward
            (setq da_direction 'fwd)
            (go_to_cursor da_orig)
            (forward_char)
            (setq da_try (copy_cursor current_cursor))
        )
    )
    (setq da_try (copy_cursor current_cursor))

    ; Move over abbreviation
    (if (= da_direction 'rev)
        (forward_char (string_length da_abbrev))
    )

    ; Copy n words of completion from search site to abbreviation site
    (setq da_from (copy_cursor current_cursor))
    (da_fwd_n_words)
    (setq da_string (point_cursor_to_string da_from))
    (go_to_cursor da_orig)
    (back_char)
    (setq da_orig (copy_cursor current_cursor))
    (forward_char)
    (insert da_string)
    (setq da_cur (copy_cursor current_cursor))
    (go_to_cursor da_orig)
    (forward_char)
    (setq da_orig (copy_cursor current_cursor))
    (setmark)
    (go_to_cursor da_cur)
)

; End of dynamic abbreviation expansion package

