; EXPLORE.EM, EMACSSRC>EMACS*>EXTENSIONS>SOURCES, ENVIRONMENTS, 10/02/89
; Directory exploration package.                   DMM  06-Jan-84
; Copyright (c) 1985, Prime Computer, Inc., Natick, MA 01760
;                     All Rights Reserved

; Description:
;
; Abnormal conditions:
;
; Implementation:
;
; Modifications:
;   Date   Programmer     Description of modification
; 10/02/89 DMM/Bugos      Added verification of correct initialization of
;                         explore_ns_root_exists$.
; 12/09/88 DMM            Added support for Name Service Root directory.
; 12/09/88 DMM            emacs_broken_list_dir$ now properly true for T1/T2 Emacs.
; 12/09/88 DMM            Corrected LDEV root display to handle Rev 22 STAT DISKS format.
; 12/09/88 DMM            Fixed explore buffer naming to no longer contain passwords.
; 03/25/88 DMM            Fixed insert_dir_info$ to properly display pathologic filename "/*".
; 05/07/87 DMM            Eliminated forward/reverse_search_case$ by using let.
; 02/13/87 DMM            explore_spool now prompts for overriding spool options to confirm.
; 02/13/87 DMM            explore_spool no longer checks files for white_ok$.
; 12/15/86 DMM/BMK        Simplified explore$ and explore_help to be table-driven.
; 12/15/86 DMM/MAM        Explicit error message for segdir diving. SPAR 4000246
; 09/09/86 DMM            Made explore_attach general for non-explore buffer use.
; 05/02/86 DMM            Spool options no longer default to -FORMS WHITE. SPAR 4000666
; 04/11/86 DMM            Explore buffers now named entryname[:x]>, not :explore.x.
; 04/11/86 DMM            Because of new naming, eliminated explore_restore fix of 02/27/86
; 04/11/86 DMM            Because of new naming, explore (and root) buffers now identified using mode membership.
; 04/11/86 DMM            Spool requests must now be confirmed.
; 04/11/86 DMM            insert_disks$ now sets (buffer_info (user explore_sepcur)) elim test in explore_dive.
; 04/11/86 DMM            insert_disks$ now uses search_fd not forward_word so disk names are properly formatted. SPAR 4003731
; 02/27/86 DMM            Fixed explore_restore to handle file pathname change since dive and pop to new directory
; 02/27/86 DMM            A count > 1 to explore_cname now copies rather than moves
; 02/27/86 DMM            explore_cname now complains of a non-CNAME (move/copy) under Primix
; 10/29/85 DMM            Drastic changes for PRIMIX pathname support
; 10/24/85 DMM            Workaround for buggy list_dir on passworded directories
; 10/01/85 DMM            explore_restore positions to file popped from (like explore_pop does for directories)
; 10/01/85 DMM            Corrected explore_dir$ handling of implied MFD's and popping from file
; 09/26/85 DMM            Fixed problems with searching for ~n in 2d-mode buffers
; 09/11/85 DMM            Fixed explore_wild_dir$/explore_dir$ to expand *> pathnames
; 09/11/85 DMM            Fixed explore_wild_dir$ to catch non-existent directories
; 09/10/85 DMM            Fixed explore_attach to correctly attach to an MFD.
; 09/10/85 DMM            Fixed explore_spool$ to work correctly with white_ok$
; 01/06/84 DMM            Initial coding.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Bindings:  explore$                   : set_mode_key (mode "explore","exroot")
;                                       : set_permanent_key (^X-U/u)
;
; Globals:   explore_ready$             ; Package initialized flag
;            curdir$                    ; Pathname of original attach point
;            explore_quit_buf$          ; Buffer to restore upon quit
;            explore_ns_root_exists$    ; Name Service Root exists (Rev 23).
;           +hide_explore_buffers$      ; Have list_buf hide explore buffers
;           +spool_options$             ; Spool options
;           +white_ok$                  ; -FORMS WHITE spooler option okay
;           +verbosity_level$           ; Feedback and message verbosity
;           +emacs_broken_file_system$  ; Workaround broken file-system calls
;           +emacs_broken_list_dir$     ; Workaround broken list_dir call
;            (b-i expdir)               ; Explore parent directory
;            (b-i explore_sepcur)       ; Explore dir/file separator cursor
;            (b-i dmm_alt_bufnum$)      ; Next buffer number for name conflict
;            (b-i dmm_alt_buflst$)      ; Assoc list of alt buffers for name conflict
;            (putprop 'docbinding)      ; Atom property used for keybinding
;
;           + CAN BE EXTERNALLY DEFINED
;
; Commands: -explore                    ; Explore the directory hierarchy
;           -explore_restore            ; Pop from file/dir to explore parent
;           -explore_attach             ; Attach to current explore directory
;            explore_attributes         ; Get attributes on entry(ies)
;            explore_cname              ; Change directory entry name
;            explore_create             ; Create directory entry
;            explore_delete             ; Delete directory entry
;            explore_dive               ; Dive into an entry
;            explore_dive_pwd           ; Dive into a passworded directory
;            explore_help               ; Provide help for explore package
;            explore_pop                ; Pop from directory to explore parent
;            explore_quit               ; Quit from explore package
;            explore_reject             ; Reject certain commands for "root"
;            explore_spool              ; Spool a file
;            explore_update             ; Force update of explore information
;            set_spool                  ; Set/Modify spool options
;
; Functions:-explore$                   ; Initialize package
;            explore_dir$               ; Manage explore hierarchy and buffers
;            explore_disk_search$       ; Locate disk if unspecified in path
;            explore_spool$             ; Spool a file
;            get_explore_path$          ; Return explore pathname at cursor
;            insert_dir_info$           ; Get and format directory information
;            insert_disks$              ; Get and format "root" information
;            wild_explore_dir$          ; Wildcard expander for exploration
;            internpath$                ; Convert pathname to internal form
;            primospath$                ; Convert pathname to Primos form
;
;           - INDICATES EXTERNAL ENTRY POINTS
;
; Externals: basename$                  ; (Function [Optional])
;            explore$cvtpath            ; (Function [Optional])
;            explore$meta_re_fresh      ; (Function [Optional])
;            explore$select_buf         ; (Function [Optional])
;            explore$visit_file         ; (Function [Optional])
;            explore_binding$           ; (Function [Optional])
;            primos_to_unix             ; (Function [Required])  Emacs internal
;            unix_to_primos             ; (Function [Required])  Emacs internal
;            fs$                        ; (Variable [Read:Opt])  Emacs internal
;
; Packaging: Module can stand alone for packaging.
;
; CAVEATS:   It is currently impossible to do a wildcard explore on a top-level
;            UFD when the disk is not specified (i.e. you want a disk-search
;            with wildcarding).
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;====================
; PACKAGE INITIALIZE
;====================

    (defun explore$ (&local (exmode any)
                            (exroot any)
                            (keybind any)
                            (binding any)
                            (binding_char any)
                            (explore_atom any)
                            (exroot_atom any)
                            (command_list any)
                    )
        ;
        ; EXPLORE KEYBINDINGS
        ;
        (setq exmode (find_mode 'explore))
        (setq exroot (find_mode 'exroot))
        ;                    Char Explore Binding   Exroot Binding
        (setq command_list '((\? explore_help       )
                             (\@ explore_attach     explore_reject)
                             (\A explore_attributes )
                             (\C explore_create     explore_reject)
                             (\D explore_dive       )
                             (\G explore_dive       )
                             (\H explore_help       )
                             (\K explore_delete     explore_reject)
                             (\L explore_update     )
                             (\N explore_create     explore_reject)
                             (\O set_spool          )
                             (\P explore_dive_pwd   explore_reject)
                             (\Q explore_quit       )
                             (\R explore_cname      explore_reject)
                             (\S explore_spool      explore_reject)
                             (\U explore_pop        )
                            ))
        (do_forever
            (if (null command_list)  (stop_doing))
            (setq binding (car command_list))
            (setq command_list (cdr command_list))
            (setq binding_char (car binding))
            (setq explore_atom (car (cdr binding)))
            (setq exroot_atom (car (cdr (cdr binding))))
            (if (null (dispatch_info exmode binding_char))
                (dispatch_info exmode binding_char explore_atom)
                (if (^= binding_char (downcase binding_char))
                    (dispatch_info exmode (downcase binding_char) explore_atom)
                )
                (if (^ (null exroot_atom))
                    (dispatch_info exroot binding_char exroot_atom)
                    (if (^= binding_char (downcase binding_char))
                        (dispatch_info exroot (downcase binding_char) exroot_atom)
                    )
                )
                (if (null (setq keybind (get explore_atom 'docbinding)))
                    (putprop explore_atom binding_char 'docbinding)
                 else
                    (putprop explore_atom (catenate keybind "/" binding_char) 'docbinding)
                )
            )
        )
        ; Finish up with multi-character ^X-U binding to explore_restore:
        (if (^ (null (setq exmode (dispatch_info exmode \~cx))))
            (setq exmode (dispatch_info exmode \u))
        )
        (if (null exmode)
            (set_mode_key "explore" "~cxu" "explore_restore")
            (set_mode_key "explore" "~cxU" "explore_restore")
            (if (null (setq keybind (get 'explore_restore 'docbinding)))
                (putprop 'explore_restore "^X-U" 'docbinding)
             else
                (putprop 'explore_restore (catenate keybind "/^X-U") 'docbinding)
            )
        )

        (if (^ (null (fsymeval 'explore_binding$)))
            (explore_binding$)
         else
            (set_permanent_key "~cxu" "explore_restore")
            (set_permanent_key "~cxU" "explore_restore")
        )

    ; DMM 09-Dec-88 Redefine basename$ regardless of whether it's externally
    ;               defined because it's probably out-of-date.
    ;   (if (null (fsymeval 'basename$))
            (defun basename$ ((option integer)
                              (pathseps string)
                              (separators string)
                              (path string)
                              &optional (fs string)
                              &local (entry integer)
                                     (suffix integer)
                                     (indx integer)
                              &returns string
                             )
                (if (null fs)  (setq fs fs$))
                (if (= path "")  (return ""))
                (if (= fs "primos")
                    (setq entry 0)
                    (setq indx (string_length path))
                    (setq suffix (1+ indx))
                    (if (= pathseps ">")  (setq pathseps "><")) ; DMM 09-Dec-88 ROOTs
                    (do_forever
                        (if (<= indx 0)  (stop_doing))
                        (if (> (search separators (substr path indx 1)) 0)
                            (if (= suffix (1+ (string_length path)))
                                (setq suffix indx)
                            )
                         else
                            (if (> (search pathseps (substr path indx 1)) 0)
                                (setq entry indx)
                                (stop_doing)
                            )
                        )
                        (setq indx (1- indx))
                    )
                    (select option
                      1  (return (substr path (1+ entry) (- suffix (1+ entry))))
                      2  (return (substr path (1+ suffix)))
                      3  (return (substr path (1+ entry)))
                      4  (return (substr path 1 (1- suffix)))
                ; DMM 09-Dec-88  Added following if clause to handle ROOTs.
                      5  (if (= entry 1)  (return (substr path 1 1)) ; Separator
                          else (return (substr path 1 (1- entry))))
                    )
                    (return path)
                 else
                    (select option
                      1 3
                         (if (& (= (substr path 1 3) "///")
                                (= (index (substr path 4) "//") 0))
                             (return (substr path 4))
                          else
                             (return (file_info path entry_name))
                         )
                      2  (return "")
                      4  (return path)
                      5  (if (= path "///")  (return path)) ; DMM 09-Dec-88 ROOTs
                         (setq path (file_info path directory_name))
                         (if (= (index path explore$unix_root) 1)
                             (setq path (substr path (1+ (string_length explore$unix_root))))
                             (if (= path "")  (setq path "/"))
                         )
                    )
                    (return path)
                )
            )
    ;   ) ; DMM 09-Dec-88

        (if (null (fsymeval 'explore$cvtpath))
            (defun explore$cvtpath ((path string)
                                    &optional (home string)
                                    &local    (pathdummy string)
                                    &returns string
                                   )
                (setq pathdummy path)            ; Avoid Emacs use-count bug
                (return pathdummy)
            )
        )

        (if (null (fsymeval 'explore$meta_re_fresh))
            (fset 'explore$meta_re_fresh (fsymeval 'refresh))
        )

        (if (null (fsymeval 'explore$select_buf))
            (fset 'explore$select_buf (fsymeval 'select_buf))
        )

        (if (null (fsymeval 'explore$visit_file))
            (fset 'explore$visit_file (fsymeval 'find_file))
        )

        (if (null hide_explore_buffers$)
            (setq hide_explore_buffers$ false)
        )

        (if (null spool_options$)
            (setq spool_options$ "")
        )
        (if (null white_ok$)
            (setq white_ok$ false)
        )
        (if (null verbosity_level$)
            (setq verbosity_level$ 2)
        )
        (if (null emacs_broken_file_system$)
            (setq emacs_broken_file_system$ (& (>= ef_version "19.2C")
                                               (<  ef_version "20.0")))
        )
        (if (null emacs_broken_list_dir$)
            (setq emacs_broken_list_dir$ (>= ef_version "20.0")) ; DMM 09-Dec-88
        )
        (if (null fs$)
            (setq fs$ "primos")
        )
        (if (& (^= fs$ "primos") (null explore$unix_root))
            (setq explore$unix_root (primos_to_unix (unix_to_primos  "/")))
        )
    ; DMM 09-Dec-88  Determine if a name-service root exists.
        (if (null explore_ns_root_exists$)
            (setq explore_ns_root_exists$ false)
        )
        (setq explore_ns_root_exists$ name_service_root_exists$)

        (setq explore_quit_buf$ "")

        (setq explore_ready$ true)
        ; Tested in:  explore
        ;             explore_restore
        ;             explore_attach
    )


;====================
; EXTERNAL ENTRIES
;====================

;;;;;
    ; explore -- Explore a directory hierarchy.
    ;

    (defcom explore
        &doc "EXPLORE: Explore the hierarchy package"
        &na (&pass count &default 1)
        &args ((dir &prompt "Explore Directory"))
        (if (null explore_ready$)  (explore$))
        (setq explore_quit_buf$ (buffer_info name))
        (if (= dir "")
            (setq dir (file_info "" path_name))
         else
            (with_command_abort_handler
                (setq dir (explore$cvtpath dir))
             command_abort_handler
                (error_message "Bad variable/template expansion in pathname")
                (return)
            )
        )
        (wild_explore_dir$ count dir)
    )


;;;;;
    ; explore_restore -- Pop from a file/directory to explore its parent.
    ;

    (defcom explore_restore
        &doc "EXPLORE: Pop from a file/directory"
        &na (&pass count &default 4)
        (if (null explore_ready$)  (explore$))
        (if (member (find_mode "explore") (buffer_info modes)) ; DMM 11-Apr-86
            (explore_pop count)
            (return)
        )
        ; DMM 11-Apr-86  No longer maintain (buffer_info (user expdir)) for
        ;                buffers containing files; new explore buffer naming
        ;                obviates this.
        (let ((dir (buffer_info default_file)))
            (setq explore_quit_buf$ (buffer_info name))
            (if (= dir "") ; Buffer presumed in current dir.
                (setq dir (file_info "" path_name))
             else
                (setq dir (file_info dir directory_name))
            )
            (if (null (setq dir (explore_disk_search$ dir)))
                (return)
            )
            (explore_dir$ count dir (buffer_info default_file) 'file)  ; DMM 01-Oct-85
        )
    )


;====================
; INTERNAL ENTRIES
;====================

;;;;;
    ; explore_update -- Force update on directory explore information.
    ;

    (defcom explore_update
        &doc "EXPLORE: Update information for current directory"
        ; Leave cursor at equivalent place as before update!
        (if (>= verbosity_level$ 1)
            (info_message "Preparing EXPLORE display...")
        )
        (with_no_redisplay
            (let ((curln "")
                  (two-d (buffer_info two_dimensional false)))   ; DMM 26-Sep-85
                (with_cursor here
                    (search_fd_in_line " ")
                    (setq curln (point_cursor_to_string here))
                )
                (insert_dir_info$)
                (if (= curln "")
                    (goto_line 3)
                 else
                    (let ((*ignore_case_in_search false))
                        (if (forward_search (catenate "~n" curln "~n"))
                            (prev_line)
                         else
                            (if (forward_search (catenate curln " "))
                                (begin_line)
                            )
                        )
                    )
                )
                (buffer_info two_dimensional two-d)              ; DMM 26-Sep-85
            )
        )
        (info_message "")
    )


;;;;;
    ; explore_reject -- Explore command rejection for "root" display.
    ;

    (defcom explore_reject
        &doc "EXPLORE: Reject explore commands not valid for disk partitions"
        (error_message "Command not valid on disk partition")
        (ring_the_bell)
    )


;;;;;
    ; explore_dive -- Dive into an entry.  Will prompt for a directory
    ;                 password if count >100; count is also used for buffer
    ;                 window placement per explore$select_buf.
    ;

    (defcom explore_dive
        &doc "EXPLORE: Dive into a file/directory"
        &na (&pass count &default 4)   ; Used for password prompt, plus buffer loc
        (begin_line)
        (if (| (line_is_blank) (looking_at ">>>"))
            (error_message "In static area; point to desired entry")
            (ring_the_bell)
            (return)
        )
        (let ((path (get_explore_path$))
              (query_pwd 0)   ; assume no password required
              (passwd "")
              (dir (buffer_info (user expdir))))
            (if (>= count 100)
                (setq query_pwd 1)
                (setq count (- count 100))
            )
            (if (> current_cursor (buffer_info (user explore_sepcur)))
                ; diving to a file
                (if (>= verbosity_level$ 2)
                    (info_message "Diving into file; please wait...")
                )
                (with_command_abort_handler
                    (explore$visit_file count path)
                    (if (>= verbosity_level$ 2)
                        (let ((keypath (get 'explore_restore 'docbinding)))
                            (if (null keypath)
                                (info_message "")
                             else
                                (info_message "Type " keypath " to return to EXPLORE")
                            )
                        )
                     else
                        (info_message "")
                    )
                 command_abort_handler
                    (explore_dir$ count dir)
                    ; DMM/MAM 12/15/86 added check for segdir.
                    (if (= "segdir" (file_info (get_explore_path$) type))
                        (error_message "Cannot explore a SEGDIR")
                    else
                        (error_message "Non-existent or inaccessible file.")
                    )
                )
             else
                ; diving into a directory
                (if (& (= fs$ "primos") (= query_pwd 1)) ; Add password (or replace existing one)
                    (setq passwd (prompt (catenate "Password for "
                                                   (basename$ 1 ">" " " path))))
                    (explore_dir$ count (catenate (basename$ 4 ">" " " path) " "
                                                      passwd))
                 else
                    (explore_dir$ count path)
                )
            )
        )
    )


;;;;;
    ; explore_dive_pwd -- Dive into a passworded directory.
    ;

    (defcom explore_dive_pwd
        &doc "EXPLORE: Dive into a passworded directory"
        &na (&pass count &default 4)
        (explore_dive (+ count 100))
    )


;;;;;
    ; explore_pop -- Pop to explore directory's parent.
    ;

    (defcom explore_pop
        &doc "EXPLORE: Pop from explore sublevel"
        &na (&pass count &default 4)
        (let ((dir (primospath$ (buffer_info (user expdir)))))
            (if (| (= dir "<")                             ; DMM 09-Dec-88 ROOTs
                   (member (find_mode "exroot") (buffer_info modes))) ; DMM 11-Apr-86
                (error_message "At ROOT.")
                (ring_the_bell)
                (return)
            )
        ; DMM 09-Dec-88  No longer represent <PART as <PART>.
            (explore_dir$ count (internpath$ (basename$ 5 ">" " " dir "primos")) (internpath$ dir))
        )
    )


;;;;;
    ; explore_attributes -- Get attributes on entries in directory.
    ;                       If count = 4, gets attributes on all entries.
    ;

    (defcom explore_attributes
        &doc "EXPLORE: Show attributes (count=4: all files)"
        &na (&pass count)
        (begin_line)
        (if (= count 4)
            (if (>= verbosity_level$ 1)
                (info_message "Getting attributes...")
            )
            (save_position
                (goto_line 3)
                (do_forever
                    (if (| (end_of_buffer_p) (have_input_p))  (stop_doing))
                    (explore_attributes)
                    (if (^ (next_line))  (stop_doing))
                )
            )
            (info_message "")
            (return)
        )
        (if (| (line_is_blank) (looking_at ">>>"))
            (return)
        )
        (let ((path (get_explore_path$)))
           ;(if (> (search (current_line) " ") 0)
           ;    (return)
           ;)
            (buffer_info read_only false)
            (end_line)
            (if (<= (cur_hpos) 35)
                (whitespace_to_hpos 35)
             else
                (with_cursor here
                    (go_to_hpos 35)
                    (delete_point_cursor here)
                )
            )
            (with_command_abort_handler
                (af (catenate "[attrib '" (primospath$ path) "' -type]"))
                (whitespace_to_hpos 44)
                (af (catenate "[attrib '" (primospath$ path) "' -dtm]"))
    ; 19.2C adjust dir for file_info call:  If only one ">" in path with
    ; disk specified, then change it to ">>" for the file_info call.
                (if emacs_broken_file_system$
                    (let ((i (search path ">"))
                          (tpath path))
                        (if (& (= (substr tpath 1 1) "<")
                               (= (search (substr tpath (1+ i)) ">") 0))
                            (setq tpath (catenate (substr tpath 1 i) (substr tpath i)))
                        )
                        (if (file_info tpath dumped)
                            (insert "  (d)")
                        )
                    )
                 else
                    (if (file_info path dumped)
                        (insert "  (d)")
                    )
                )
             command_abort_handler
                (delete_white_left)
                (explore$meta_re_fresh)
                (error_message "Insufficient access to get attributes")
            )
        )
        (begin_line)
        (buffer_info modified false)
        (buffer_info read_only true)
    )


