; EXPLORE2.EM, EMACSSRC>EMACS*>EXTENSIONS>SOURCES, ENVIRONMENTS, 12/09/88
; Second file with Explore commands and support functions
; Copyright (c) 1985, Prime Computer, Inc., Natick, MA 01760
;                     All Rights Reserved

; Description:
;
; Abnormal conditions:
;
; Implementation:
;
; Modifications:
;   Date   Programmer     Description of modification
; 01/06/84 DMM            See EXPLORE.EM for modification history of this file.
; 01/06/84 DMM            Initial coding.

;;;;;
    ; explore_help -- Provide help on explore mode.
    ;

    (defcom explore_help
        &doc "EXPLORE: Help and bindings"
        (init_local_displays "Explore subcommands:")
        (let ((keypath "")
              (command_list '(explore_attach explore_dive explore_dive_pwd
                              explore_pop explore_attributes explore_cname
                              explore_delete explore_create explore_spool
                              set_spool explore_quit explore_update
                              explore_restore explore_help))
             )
             (do_forever
                (if (null command_list)  (stop_doing))
                (if (null (setq keypath (get (car command_list) 'docbinding)))
                    (setq keypath "")
                )
                (local_display_generator (catenate
                    (string_of_length_n keypath 15)
                    (handler_info (fsymeval (car command_list)) explanation)))
                (setq command_list (cdr command_list))
             )
        )
        (if (>= verbosity_level$ 2)
            (local_display_generator "(Type ^G to return to Explore)")
        )
        (local_display_generator "================================================================================")
    )


;;;;;
    ; explore_quit -- Exit from explore, returning to previous buffer.
    ;

    (defcom explore_quit
        &doc "EXPLORE: Quit and return to previous buffer"
        &na (&pass count &default 4)
        (explore$select_buf count explore_quit_buf$)
    )


;;;;;
    ; explore_delete -- Delete a directory's entry.
    ;

    (defcom explore_delete
        &doc "EXPLORE: Delete a file/directory"
        (begin_line)
        (if (| (line_is_blank) (looking_at ">>>"))
            (error_message "In static area; point to desired entry")
            (ring_the_bell)
            (return)
        )
        (let ((path (get_explore_path$))
              (msg  ">> Delete FILE: ")
             )
            (if (< current_cursor (buffer_info (user explore_sepcur)))
                (setq msg ">> Delete DIRECTORY: ")
            )
            (if (yesno (catenate msg path))
                (with_command_abort_handler
                    (save_position
                        (if (^= (file_operation path delete) 0)
                            (primos_internal_quiet (catenate "DELETE '" (primospath$ path)
                                                             "' -NVFY -NQ -FORCE"))
                        )
                    )
                    (buffer_info read_only false)
                    (begin_line)
                    (with_cursor here
                        (if (^ (next_line))
                            (end_line)
                        )
                        (delete_point_cursor here)
                    )
                    (buffer_info modified false)
                    (buffer_info read_only true)
                    (info_message "")
                 command_abort_handler
                    (explore$meta_re_fresh)
                    (error_message "Unable to delete " path)
                )
            )
        )
    )


;;;;;
    ; explore_create -- Create a new entry.
    ;

    (defcom explore_create
        &doc "EXPLORE: Create a new file/directory"
        (let ((directory false)
              (msg "Create File")
              (entryname "")
              (two-d (buffer_info two_dimensional))              ; DMM 26-Sep-85
              (path (buffer_info (user expdir)))
              (ppath (primospath$ (buffer_info (user expdir))))
             )
            (if (< current_cursor (buffer_info (user explore_sepcur)))
                (setq directory true)
                (setq msg "Create Directory")
            )
            (setq entryname (prompt msg))
            (if (= fs$ "primos")  (setq entryname (upcase entryname))) ; For search
            (if (& (^= ppath "<") (^= (nth ppath (string_length ppath)) \>)) ; DMM 09-Dec-88 ROOTs
                (setq ppath (catenate ppath ">"))
            )
            (setq ppath (catenate ppath (primospath$ entryname)))
            (setq path (internpath$ ppath))
    ; 19.2C adjust dir for file_info call:  If only one ">" in path with
    ; disk specified, then change it to ">>" for the file_info call.
            (if emacs_broken_file_system$
                (let ((i (search path ">"))
                      (tpath path))
                    (if (& (= (substr tpath 1 1) "<")
                           (= (search (substr tpath (1+ i)) ">") 0))
                        (setq tpath (catenate (substr tpath 1 i) (substr tpath i)))
                    )
                    (if (file_info tpath exists)
                        (error_message "File already exists.")
                        (ring_the_bell)
                        (return)
                    )
                )
             else
                (if (file_info path exists)
                    (error_message "File already exists.")
                    (ring_the_bell)
                    (return)
                )
            )
            (with_no_redisplay
                (if directory
                    (with_command_abort_handler
                        (primos_internal_quiet (catenate "CREATE '" ppath "'"))
                        (info_message "")
                     command_abort_handler
                        (explore$meta_re_fresh)
                        (error_message (catenate "Illegal name: " path))
                        (return)
                    )
                 else
                    (save_excursion
                        (go_to_cursor (find_buffer ".empty"))
                        (write_file path)
                    )
                )
                (insert_dir_info$)
                (buffer_info two_dimensional false)              ; DMM 26-Sep-85
                (if (forward_search (catenate "~n" entryname "~n"))
                    (prev_line)
                    (buffer_info two_dimensional two-d)          ; DMM 26-Sep-85
                 else
                    (buffer_info two_dimensional two-d)          ; DMM 26-Sep-85
                    (error_message "Cannot locate newly created entry (?)")
                    (ring_the_bell)
                    (return)
                )
                (explore_dive)
            )
        )
    )


;;;;;
    ; explore_cname -- Change entryname or copy/move entry somewhere else.
    ;

    (defcom explore_cname
        &doc "EXPLORE: Rename or relocate a file/directory"
        &na (&pass count &default 1)                             ; DMM 27-Feb-86
        (begin_line)
        (if (| (line_is_blank) (looking_at ">>>"))
            (error_message "In static area; point to desired entry")
            (ring_the_bell)
            (return)
        )
        (let ((new_name (prompt (catenate "Change "
                                          (basename$ 1 ">" " " (get_explore_path$))
                                          " to name")))
              (pnew_name "")
              (two-d (buffer_info two_dimensional))              ; DMM 26-Sep-85
              (delete " -DELETE")                                ; DMM 27-Feb-86
              (old_name (get_explore_path$))                     ; DMM 27-Feb-86
              (next_name ""))
            (if (= new_name "")
                (return)
            )
            (save_position
                (next_line)
                (with_cursor here
                    (next_line)
                    (setq next_name (point_cursor_to_string here))
                )
            )
            ; BUG:  Because of the way unix_to_primos works, we can't support
            ;       a name change to another directory under Primix as we do
            ;       under Primos.
            (setq pnew_name (primospath$ (explore$cvtpath new_name (buffer_info (user expdir)))))
            (setq new_name (internpath$ pnew_name))
            (with_command_abort_handler
                (with_no_redisplay
                    ; DMM 27-Feb-86 Added following if clause
                    (if (& (= (search pnew_name "><") 0) ; DMM 09-Dec-88 ROOTs
                           (> count 1))
                        (setq pnew_name (catenate "*>" pnew_name))
                    )
                    (if (= (search pnew_name "><") 0) ; DMM 09-Dec-88 ROOTs
                        (primos_internal_quiet (catenate "CNAME '"
                                                         (primospath$ old_name) ; DMM 27-Feb-86
                                                         "' " pnew_name))
                     else
                        ; DMM 27-Feb-86 Added following if clause
                        (if (^= fs$ "primos")
                            (error_message "Cannot move/copy while under Primix")
                            (ring_the_bell)
                            (return)
                        )
                        (if (= (substr pnew_name 1 2) "*>")
                            (setq pnew_name (catenate (primospath$ (buffer_info (user expdir)))
                                                      (substr pnew_name 2)))
                            (setq new_name (internpath$ pnew_name))
                        )
                        (if (> count 1)  (setq delete ""))       ; DMM 27-Feb-86
                        (primos_internal_quiet (catenate "COPY '"
                                                         (primospath$ old_name) ; DMM 27-Feb-86
                                                         "' '" pnew_name
                                                         "' -DTM" delete)) ; DMM 27-Feb-86
                    )
                    (info_message "")
                )
             command_abort_handler
                (explore$meta_re_fresh)
                (error_message "Illegal name: " new_name)
                (return)
            )
            (insert_dir_info$)
            (buffer_info two_dimensional false)                  ; DMM 26-Sep-85
            ; DMM 27-Feb-86 Added following if clause to precede others
            (let ((*ignore_case_in_search false))
                (if (forward_search (catenate "~n" (basename$ 3 ">" " " old_name) "~n"))
                    (prev_line)
                 else (if (forward_search (catenate "~n" new_name "~n"))
                    (prev_line)
                 else (if (forward_search (catenate "~n" next_name))
                    (prev_line)
                )))
            )
            (buffer_info two_dimensional two-d)                  ; DMM 26-Sep-85
        )
    )


;;;;;
    ; explore_attach -- Attach to current explore directory, or back home.
    ;                   Count                         Action
    ;                     0  (default) Attach to current explore directory.
    ;                    4-15          Attach back to original attach point.
    ;                    >=16          Display current attach point.
    ;

    (defcom explore_attach
        &doc "EXPLORE: Attach to current explore directory"
        &na (&pass count &default 0)
        (if (null explore_ready$)  (explore$))                   ; DMM 09-Sep-86
        (if (null curdir$)
            (setq curdir$ (file_info "" path_name))
        )
        (if (^= fs$ "primos")
            (if (< count 4)      ; Complain only if we try to leave current dir.
                (error_message "Attach is currently not supported under Primix Emacs.")
                (ring_the_bell)
                (return)
            )
            (setq count 16)                 ; Force display that we went nowhere
        )
        (with_command_abort_handler
            (if (< count 16)
                (with_no_redisplay
                    (let ((dir curdir$)
                          (pdir "")
                         )
                        ; DMM 09-Sep-86 If non-explore, figure out directory
                        (if (< count 4)
                            (if (null (setq dir (buffer_info (user expdir))))
                                (setq dir (buffer_info default_file))
                                (if (= dir "") ; Buffer presumed in current dir.
                                    (setq dir (file_info "" path_name))
                                 else
                                    (setq dir (file_info dir directory_name))
                                )
                            )
                        )
                        (setq pdir (primospath$ dir))
                    ; DMM 09-Dec-88  Now set (user expdir) to "<PART" not "<PART>".
                        (if (& (= (nth pdir 1) "<") (^= pdir "<") (= (search pdir ">") 0))
                            (setq pdir (catenate pdir ">MFD"))
                        )
                        (primos_internal_quiet (catenate "A '" pdir "'"))
                    )
                )
            )
            (if (>= verbosity_level$ 2)
                (info_message "Attached to " (file_info "" path_name))
             else
                (info_message "@ " (internpath$ (catenate (primospath$ (file_info "" path_name)) ">")))
            )
         command_abort_handler
            (explore$meta_re_fresh)
            (error_message "Cannot attach to this directory. @ "
                           (internpath$ (catenate (primospath$ (file_info "" path_name)) ">")))
        )
    )


;;;;;
    ; explore_spool -- Spool a file.
    ;

    (defcom explore_spool
        &doc "EXPLORE: Spool a file"
        (explore_spool$)
    )


;;;;;
    ; set_spool -- Set/modify spool options.
    ;

    (defcom set_spool
        &doc "EXPLORE: Set spool options"
        (info_message "Current spool options: " spool_options$)
        (with_command_abort_handler
            (if (>= verbosity_level$ 3)
                (setq spool_options$ (prompt "New spool options (^G to retain current ones)"))
             else
                (setq spool_options$ (prompt "    New spool options"))
            )
        )
        (info_message "Spool options are now: " spool_options$)
    )


