; EXPLORE3.EM, EMACSSRC>EMACS*>EXTENSIONS>SOURCES, ENVIRONMENTS, 12/09/88
; Third file with Explore commands and support functions
; Copyright (c) 1985, Prime Computer, Inc., Natick, MA 01760
;                     All Rights Reserved

; Description:
;
; Abnormal conditions:
;
; Implementation:
;
; Modifications:
;   Date   Programmer     Description of modification
; 01/06/84 DMM            See EXPLORE.EM for modification history of this file.
; 01/06/84 DMM            Initial coding.

;====================
; SUPPORT FUNCTIONS
;====================

;;;;;
    ; insert_disks$ -- Explore the "root" directory.
    ;

    (defun insert_disks$ (&local (curcur cursor)
                                 (pentry string)
                         )
        (turn_mode_off (find_mode 'exroot))
        (turn_mode_on (find_mode 'exroot) first)
        (insert ">>>-LDEV DISK PARTITIONS:~n")
        (setq curcur (copy_cursor current_cursor))
        (save_position
            (with_command_abort_handler
                (primos_internal_como "STAT DISK")
            )
            (info_message "")
            (go_to_cursor (find_buffer "file_output"))
            (with_cursor here
                (let ((two-d (buffer_info two_dimensional false))) ; DMM 26-Sep-85
                (if (^ (forward_search "DISK   LDEV  PDEV  SYSN")) ; Rev 18
                    (forward_search "Disk   Ldev  Pdev  System")   ; Rev 19
                )
                (buffer_info two_dimensional two-d)              ; DMM 26-Sep-85
                )                                                ; DMM 26-Sep-85
                (end_line) ; DMM 09-Dec-88  Make it work w/ Rev 22 STAT DISK.
                (delete_point_cursor here)
            ; DMM 09-Dec-88  If no NS ROOT, then we're all set with LDEV names
            ;                in first column, LDEV #'s in second.  Otherwise,
            ;                must swap these two cols to ensure dive will
            ;                go through LDEV ROOT, not NS ROOT.
                (if explore_ns_root_exists$
                    (forward_char)            ; cursor `here' still points to ~n
                    (do_forever
                        (if (| (line_is_blank) (end_of_buffer_p))  (stop_doing))
                        (search_fd_in_line " ")
                        (with_cursor there
                            (verify_fd_in_line " ")
                            (setq pentry (point_cursor_to_string there))
                            (delete_point_cursor there)
                            (search_fd_in_line " ")
                            (setq pentry (catenate (point_cursor_to_string there) pentry))
                            (delete_point_cursor there)
                        )
                        (begin_line)
                        (insert pentry)
                        (next_line)
                    )
                 else
                    (move_bottom)
                )
                (insert (point_cursor_to_string here) curcur)
            )
            (buffer_info modified false)
        )
        (insert "~n")  ; Overcome later vagaries with forward_search at eob
        (buffer_info (user explore_sepcur) (copy_cursor current_cursor)) ; DMM 11-Apr-86
        (buffer_info modified false)
        (buffer_info changed_ok true)
        (buffer_info read_only true)
        (move_top)
    )


;;;;;
    ; insert_dir_info$ -- Get and format directory information.
    ;

    (defun insert_dir_info$  (&local (wildspec string)
                                     (dir string)
                                     (pdir string)
                             )
        (setq dir (buffer_info (user expdir)))
        (buffer_info read_only false)
        (delete_buffer)
        (setq pdir (primospath$ dir))
        (if (= pdir ">")                                   ; DMM 09-Dec-88 ROOTs
            (insert_disks$)
            (return))
        (insert (catenate ">>>-DIRECTORIES in " (basename$ 4 ">" " " dir) ":~n~n"))
    ; 19.2C fix dir for list_dir call with added wildspec:  always set
    ; wildspec to >@@, so <disk> ==> <disk>>@ and <disk>name ==> <disk>name>@@
        (if (= fs$ "primos")
            (if emacs_broken_file_system$
                (setq wildspec (catenate dir ">@@"))
             else
                (if (& (^= pdir "<") (^= (nth pdir (string_length pdir)) \>)) ; DMM 09-Dec-88 ROOTs
                    (setq pdir (catenate pdir ">"))
                )
                (if emacs_broken_list_dir$
                    (setq wildspec (internpath$ (catenate "'" pdir "'@@")))
                 else
                    (setq wildspec (internpath$ (catenate pdir "@@")))
                )
            )
         else
            (if (& (^= pdir "<") (^= (nth pdir (string_length pdir)) \>)) ; DMM 09-Dec-88 ROOTs
                (setq pdir (catenate pdir ">"))
            )
            (setq wildspec (internpath$ pdir))
        )
        (list_dir wildspec sorted directories entry_names insert_names)
        (insert (catenate "~n>>>-FILES in " (basename$ 4 ">" " " dir) ":~n~n"))
        (list_dir wildspec sorted files segdirs entry_names insert_names)
        (insert "~n")  ; Overcome later vagaries with forward_search at eob
        ;
        ; 20.0:  FIX list_dir problem in which it appends a single-quote '
        ;        to the end of every entry name when the pathname supplied
        ;        to list_dir is (a) quoted, and (b) contains a password.
        ;
;DMM 25-Mar-88 list_dir still does this for certain filenames (e.g. "/*").
;       (if (& (^ emacs_broken_file_system$)
;                 emacs_broken_list_dir$
;              (> (search wildspec " ") 0))
            (save_excursion
                (do_forever
                    (if (reverse_search "'~n")  (delete_char)
                     else                       (stop_doing)
                    )
                )
            )
;       )
        (reverse_search ">>>-FILES")
        (buffer_info (user explore_sepcur) (copy_cursor current_cursor))
        (buffer_info modified false)
        (buffer_info changed_ok true)
        (buffer_info read_only true)
        (move_top)
    )


;;;;;
    ; explore_disk_search$ -- Take a pathname without a specified disk
    ;                         and generate a full pathname, with disk.
    ;                         Returns full pathname, or null if pathname
    ;                         is illegal (in which case it cleans up
    ;                         screen and puts out an error message).
    ;

    (defun explore_disk_search$ ((dir string)
                                 &local (pwd string)
                                        (pdir string)
                                 &returns any
                                )
        ; if disk unspecified, go get it by disk-search.  NOTE that this
        ; wipes any and all passwords associated with the pathname, so
        ; these must be retained separately (only retains last one!)
        (setq pdir (primospath$ dir))
        (if (^= (substr pdir 1 1) "<")
            (setq pwd (basename$ 2 ">" " " dir))
            (with_command_abort_handler
                (info_message "Searching disks for UFD '" dir "' ...")
                (if (= (nth pdir (string_length pdir)) \>)
                    (setq pdir (evaluate_af (catenate "[pathname '" pdir "@@']")))
                 else
                    (setq pdir (evaluate_af (catenate "[pathname '" pdir ">@@']")))
                )
                (setq pdir (substr pdir 1 (- (string_length pdir) 3)))
                (setq dir (internpath$ pdir))
                (info_message "Found: '" dir "'.")
                (if (> (string_length pwd) 0)       ; Stick password back in.
                    (setq dir (catenate dir " " pwd))
                )
             command_abort_handler
                (explore$meta_re_fresh)
                (error_message "Bad directory pathname.")
                (return ())
            )
        )
        (return dir)
    )


;;;;;
    ; explore_dir$ -- Manage explore hierarchy and set up explore buffer.
    ;

    (defun explore_dir$ ((count integer)
                         (dir string)
                         &optional (prevdir string)
                                   (type atom)
                         &local (new boolean)
                                (pdir string)
                                (buf string)
                                (bufroot string)
                        )
        (if (null prevdir)
            (setq prevdir "")
        )
        (setq pdir (primospath$ dir))
        (do_forever     ; strip off trailing '>'s
            (if (= (nth pdir (string_length pdir)) \>)
                (setq pdir (substr pdir 1 (1- (string_length pdir))))
             else
                (stop_doing)
            )
        )
        ; if relative pathname, complete it.
        (if (= (substr pdir 1 2) "*>")
            (setq pdir (catenate (primospath$ (file_info "" path_name)) (substr pdir 2)))
        )
    ; DMM 09-Dec-88  Put back `>' for LDEV ROOT.
        (if (= pdir "")
            (setq pdir ">")
    ; DMM 09-Dec-88  Now set (user expdir) to "<PART" not "<PART>".
    ;    else
    ;       (if (& (= (nth pdir 1) \<) (^= pdir "<") (= (search pdir ">") 0)) ; DMM 09-Dec-88 ROOTs
    ;           ; for disks (mfds), make sure they end in a >; assume mfds exist
    ;           (setq pdir (catenate pdir ">"))
    ;       )
        )
    ; DMM 09-Dec-88  If NS ROOT, ensure it exists or fall back on LDEV ROOT.
        (if (& (= pdir "<") (^ explore_ns_root_exists$))
            (setq pdir ">")
        )
    ; DMM 09-Dec-88  If parent is ROOT, and prevdir is an LDEV#, use LDEV ROOT.
        (if (& (= pdir "<") (^= prevdir "") (= (verify (basename$ 1 ">" " " prevdir) "0123456789") 0))
            (setq pdir ">")
        )
        (setq dir (internpath$ pdir))
        ; DMM 04/11/86  Explore buffers now named after directory entryname
        ;               (with conflicts handled) rather than prev :explore.#.
        (setq new false)
        (save_position
            (setq buf (basename$ 1 ">" " " dir)) ; DMM 09-Dec-88 No pwd
            (if (= buf "")  (setq buf dir))
        ; DMM 09-Dec-88  dir should already be proper root.
        ;   (if (= buf "")  (setq buf "<"))
            (setq bufroot (substr (primospath$ buf) 1 31))
            (setq buf (internpath$ (catenate bufroot ">")))
            (select_buf buf)
            (if (null (buffer_info (user dmm_alt_bufnum$)))
                (buffer_info (user dmm_alt_bufnum$) "1")
            )
            (if (& (^ (& (empty_buffer_p) (= (buffer_info default_file) "")))
                   (^= dir (buffer_info (user expdir))))
                (setq orig_buf buf)
                (setq buf (car (cdr (assoc dir (buffer_info (user dmm_alt_buflst$))))))
                (if (^ (null buf))
                    (select_buf buf)
                    (if (^= dir (buffer_info (user expdir)))
                        (select_buf orig_buf)
                        (buffer_info (user dmm_alt_buflst$) (remassoc dir (buffer_info (user dmm_alt_buflst$))))
                        (setq buf ())
                    )
                )
                (if (null buf)
                    (setq new true)
                    (setq buf (internpath$ (catenate
                            (substr bufroot 1 (- 30 (string_length (buffer_info (user dmm_alt_bufnum$)))))
                            ":" (buffer_info (user dmm_alt_bufnum$)) ">")))
                    (buffer_info (user dmm_alt_bufnum$)
                            (integer_to_string (1+ (string_to_integer
                                (buffer_info (user dmm_alt_bufnum$))))))
                    (buffer_info (user dmm_alt_buflst$)
                            (cons (list dir buf) (buffer_info (user dmm_alt_buflst$))))
                    (select_buf buf)
                )
            )
            (if (empty_buffer_p)  (setq new true))
        )
        (if (& new (>= verbosity_level$ 1))
            (info_message "Preparing EXPLORE display...")
        )
        (with_no_redisplay
            (explore$select_buf count buf)
            (if new
                (buffer_info (user expdir) dir)
            ; DMM 09-Dec-88  Don't append `>' to roots.
                (if (| (= pdir "<") (= pdir ">"))
                    (buffer_info default_file (internpath$ (primospath$ dir)))
                 else
                    (buffer_info default_file (internpath$ (catenate (primospath$ (basename$ 4 ">" " " dir)) ">")))
                )
                (buffer_info dont_show hide_explore_buffers$)
                (buffer_info changed_ok true)
               ;(buffer_info status_template "** EXPLORE:  %f  [%b] (%p) **")
                (set_mode "explore")
                (insert_dir_info$)
                (if (>= verbosity_level$ 2)
                    (let ((keypath (get 'explore_help 'docbinding)))
                        (if (null keypath)
                            (info_message "")
                         else
                            (info_message "EXPLORE: Type " keypath " for help")
                        )
                    )
                 else
                    (info_message "")
                )
             else
                (info_message "")
            )
            (if (= prevdir "")
                (if (| new (end_of_buffer_p))                    ; DMM 01-Oct-85
                    (goto_line 3)
                )
             else
                (move_top)
                (setq buf (basename$ 1 ">" " " prevdir))
                (if (^= buf "")
                    (setq prevdir buf)
                )
                (let ((two-d (buffer_info two_dimensional false)) ; DMM 26-Sep-85
                      (*ignore_case_in_search false))
                (if (forward_search (catenate "~n" prevdir "~n"))
                    (prev_line)
                 else
                    (if (forward_search (catenate "~n" prevdir " "))
                        (begin_line)
                     else
                        ; DMM 01-Oct-85 Handle restore to current file:
                        (if (= type 'file)
                            (go_to_cursor (buffer_info (user explore_sepcur)))
                            (next_line 2)
                         else
                            (goto_line 3)
                        )
                        (do_forever
                            (if (line_is_blank)  (stop_doing))
                            (if (< prevdir (current_line))  (stop_doing))
                            (if (^ (next_line))  (stop_doing))
                        )
                        (buffer_info read_only false)
                        (insert (catenate prevdir "~n"))
                        (buffer_info modified false)
                        (buffer_info read_only true)
                        (prev_line)
                        (begin_line)
                    )
                )
                (buffer_info two_dimensional two-d)              ; DMM 26-Sep-85
                )                                                ; DMM 26-Sep-85
            )
        )
    )


;;;;;
    ; wild_explore_dir$ -- Wildcard expander for directory exploration.
    ;

    (defun wild_explore_dir$ ((count integer)
                              (dir string)
                              &optional (prevdir string)
                              &local (pwild string)
                                     (pbasedir string)
                                     (pdir string)
                                     (pwd string)
                             )
        (if (null prevdir)
            (setq prevdir "")
        )
        (setq pdir (primospath$ dir))
        (do_forever     ; strip off trailing '>'s
            (if (= (nth pdir (string_length pdir)) \>)
                (setq pdir (substr pdir 1 (1- (string_length pdir))))
             else
                (stop_doing)
            )
        )
        (if (= pdir "")  (setq pdir ">"))                  ; DMM 09-Dec-88 ROOTs
        ; if relative pathname, complete it.
        (if (= (substr pdir 1 2) "*>")
            (setq pdir (catenate (primospath$ (file_info "" path_name)) (substr pdir 2)))
        )
        (setq dir (internpath$ pdir))
        (setq pbasedir (primospath$ (basename$ 5 ">" " " dir)))
        (setq pwd (basename$ 2 ">" " " dir))
        (setq dir (basename$ 4 ">" " " dir))
        (setq pdir (primospath$ dir))
        (if (& (> (search pdir "><") 0) (> (search pdir "@+") 0)) ; DMM 09-Dec-88 ROOTs
            (with_command_abort_handler
                (setq pwild (evaluate_af (catenate "[wild '" pdir "' -dirs]")))
                (if (= pwild "")
                    (error_message "Bad directory pathname.")
                    (ring_the_bell)
                    (return)
                 else
                    (setq pwild (catenate pwild " "))
                )
             command_abort_handler
                (explore$meta_re_fresh)
                (error_message "Bad directory pathname.")
                (return)
            )
         else
            (setq pwild (catenate (primospath$ (basename$ 3 ">" " " dir)) " "))
        )
    ; DMM 09-Dec-88  Directly explore either root here.
        (if (= pwild "")
            (explore_dir$ count dir prevdir)
            (return)
        )
        ; Loop through wild card directory specifications.
        (do_forever
            (if (= pwild "")  (stop_doing))
        ; DMM 09-Dec-88  Handle appending entryname to appropriate root.
        ;                Both NS and LDEV ROOTS share the same syntax, so
        ;                LDEV must be a # if NS exists, otherwise it will
        ;                be interpreted by Primos as NS ROOT-relative.
            (select pbasedir
                ""
                    (setq dir (internpath$ (substr pwild 1 (1- (search pwild " ")))))
                "<" ">"                                      ; NS and LDEV ROOTs
                    (setq dir (internpath$ (catenate "<" (substr pwild 1 (1- (search pwild " "))))))
                otherwise
                    (setq dir (internpath$ (catenate pbasedir ">" (substr pwild 1 (1- (search pwild " "))))))
            )
            (if (> (string_length pwd) 0)
                (setq dir (catenate dir " " pwd))
            )
            (setq pwild (substr pwild (1+ (search pwild " "))))
            (if (null (setq dir (explore_disk_search$ dir)))
                (error_message "Bad directory pathname.")
                (return)
            )
            (setq pdir (primospath$ dir))
    ; DMM REMOVED since file_info fails for non-existent directories as well
    ;             as existing directories under those without list access.
    ;             Better to err on the side of the user, and believe it exists.
    ;       (if (> (search dir ">") 0)
    ;           ; for directories (ufds), make sure the ufd actually exists.
    ;           ; ignore password on resultant ufd in doing this existence check.
    ; 19.2C adjust dir for file_info call:  If only one ">" in path with
    ; disk specified, then change it to ">>" for the file_info call.
    ;           (if emacs_broken_file_system$
    ;               (let ((i (search dir ">"))
    ;                     (tdir dir))
    ;                   (if (& (= (substr tdir 1 1) "<")
    ;                          (= (search (substr tdir (1+ i)) ">") 0))
    ;                       (setq tdir (catenate (substr tdir 1 i) (substr tdir i)))
    ;                   )
    ;                   (if (^ (file_info (basename$ 4 ">" " " tdir) exists))
    ;                       (error_message "Bad directory pathname.")
    ;                       (ring_the_bell)
    ;                       (return)
    ;                   )
    ;               )
    ;            else
    ;               (if (^ (file_info (basename$ 4 ">" " " dir) exists))
    ;                   (error_message "Bad directory pathname.")
    ;                   (ring_the_bell)
    ;                   (return)
    ;               )
    ;           )
    ;       )
    ; DMM ADDED BELOW 11-Sep-85
    ;           This code should fix the above restriction on file_info
    ;           checking into non-existent directories.  We must use the
    ;           Primos function EXISTS because ATTRIB has the same problem
    ;           as Emacs file_info does:  it needs to open the parent
    ;           directory (which we may not have List access to).
            (with_command_abort_handler
    ; DMM CHANGED BELOW 01-Oct-85
    ;           Now use tdir and append >MFD if we're dealing with an MFD
    ;           since EXISTS doesn't like pathnames of the form `<DISK'.
                (let ((tdir pdir))
                    (if (& (= (nth pdir 1) "<") (^= pdir "<") (= (search pdir ">") 0)) ; DMM 09-Dec-88 ROOTs
                        (setq tdir (catenate pdir ">MFD"))
                    )
                    (if (^= (evaluate_af (catenate "[exists '" tdir "' -dir]")) "TRUE")
                        (error_message "Bad directory pathname.")
                        (ring_the_bell)
                        (return)
                    )
                )
             command_abort_handler
                (explore$meta_re_fresh)
                (error_message "Bad directory pathname.")
                (return)
            )
    ; DMM ADDED ABOVE 11-Sep-85
            (explore_dir$ count dir prevdir)
            ; When wildcarding, force all into window of first
            (setq count 16)
        )
    )


;;;;;
    ; get_explore_path$ -- Given a position in the buffer, return the
    ;                      pathname corresponding to this position.
    ;

    (defun get_explore_path$ (&returns string
                              &local (line string)
                                     (inx integer)
                                     (ppath string) ; DMM 09-Dec-88 ROOTs
                             )
        (setq line (current_line))
        ; if spaces in line due to attributes, must get rid of them
        (setq inx (search line " "))
        (if (> inx 0)
            (setq line (substr line 1 (1- inx)))
        )
    ; DMM 09-Dec-88  Generate proper pathname prefix for roots.
        (setq ppath (primospath$ (buffer_info (user expdir))))
        (select ppath
            "<"                                                        ; NS ROOT
                ()
            ">"                                                      ; LDEV ROOT
                (setq ppath "<")
            otherwise
                (setq ppath (catenate ppath ">"))
        )
        (setq line (catenate ppath (primospath$ line)))
    ; DMM 09-Dec-88  No longer represent <PART as <PART>.
    ;   (setq inx (index line ">>"))
    ;   (if (> inx 0)
    ;       (setq line (catenate (substr line 1 (1- inx)) (substr line (1+ inx))))
    ;   )
    ; DMM 09-Dec-88  Don't need trap for old ROOT syntax.
    ;   (if (= (substr line 1 1) ">")
    ;       (setq line (substr line 2))
    ;   )
        (return (internpath$ line))
    )


;;;;;
    ; explore_spool$ -- Do the work of spooling a file.
    ;

    (defun explore_spool$ (&local (command string)
                                  (path string)
                                  (options string)
                          )
        (begin_line)
        (if (| (line_is_blank) (looking_at ">>>"))
            (error_message "In static area; point to desired entry")
            (ring_the_bell)
            (return)
        )
        (if (< current_cursor (buffer_info (user explore_sepcur)))
            (error_message "Not spoolable file.")
            (ring_the_bell)
            (return)
        )
        (setq path (get_explore_path$))
        ; DMM 02/13/87  Prompt for overriding options...also confirms the spool.
        (setq options (prompt_for_string (catenate "Spool options (default=~"" spool_options$ "~")") spool_options$))
        (if (>= verbosity_level$ 1)
            (info_message "Spooling " path " " options)
        )
        (setq command (catenate "SPOOL '" (primospath$ path) "' " options))
        (with_no_redisplay
            (save_position
                ; DMM 02/13/87  REMOVED as unnecessary with option prompt.
                ;(if white_ok$
                ;   (save_excursion
                ;       (select_buf ".spoolfile")
                ;       (buffer_info dont_show true)
                ;       (buffer_info changed_ok true)
                ;       (delete_buffer)
                ;       (with_command_abort_handler
                ;           (read_file path)
                ;           (if (= (high_bit_on (current_line)) "~h81~h81")
                ;               (setq command (catenate command " -FTN -FORM WHITE"))
                ;           )
                ;       )
                ;       (delete_buffer)
                ;       (buffer_info modified false)
                ;   )
                ;)
                (with_command_abort_handler
                    (primos_external command)
                    (go_to_cursor (find_buffer "file_output"))
                    (if (forward_search "ER!")
                        (error_message "Spool failed (see file_output buffer).")
                        (ring_the_bell)
                     else
                        (info_message "Spool successful.")
                    )
                 command_abort_handler
                    (error_message "Spool failed (see file_output buffer).")
                    (explore$meta_re_fresh)
                )
            )
        )
    )

;;;;;
    ; primospath$ -- Convert Primos/Unix path to Primos format.
    ;

    (defun primospath$ ((path string)
                        &returns string
                        &local (temp string)                         ;BUG
                               (cx integer)                          ;BUG
                       )
        (if (= fs$ "primos")
            (return (upcase path))
         else
            ; BUG:  The following hacks and wonderment are due to the
            ;       fact that unix_to_primos is not the inverse of
            ;       primos_to_unix.  This means that the presumption
            ;       (= path (primos_to_unix (unix_to_primos path))) is
            ;       always true is FALSE!  In particular:
            ;           - unix_to_primos will toss any trailing
            ;             '/'s in the pathname without converting
            ;             them to their corresponding '>';
            ;           - unix_to_primos ALWAYS returns a FULL
            ;             pathname, even when passed an entryname
            ;             (it will tack the converted entryname onto
            ;             the current directory).
            ;          -  unix_to_primos insists that ///diskname
            ;             is passed back as <DISKNAME>MFD; we just
            ;             want <DISKNAME
            ;       Why is it that no one ever does things as simple
            ;       as conversion routines right??  Why must there
            ;       always be IMPLICIT ASSUMPTIONS made??
        ; DMM 09-Dec-88 Choose proper ROOT representation
            (if (= path "///")
                (if explore_ns_root_exists$  (return "<")
                 else                        (return ">")
                )
            )
            (setq temp (unix_to_primos path))
            ; Fudge // to a single /.
            (if (> (setq cx (index (substr path 4) "//")) 0)
                (setq path (catenate (substr path 1 (+ 3 cx)) (substr path (+ 5 cx))))
            )
            (if (^= path "/")
                (do_forever
                    (if (= (nth path (string_length path)) \/)
                        (setq temp (catenate temp ">"))
                        (setq path (substr path 1 (1- (string_length path))))
                     else
                        (stop_doing)
                    )
                )
            )
            (if (= (search path \/) 0)     ; Want ENTRYNAME not PATHNAME
                (setq temp (basename$ 3 ">" " " temp "primos"))
             else (if (& (= (substr path 1 3) "///")
                         (= (search (substr path 4) \/) 0)
                         (> (setq cx (index temp ">MFD")) 0))
                (setq temp (catenate (substr temp 1 (1- cx)) (substr temp (+ 4 cx))))
            ))
            (return temp)
        )
    )

;;;;;
    ; internpath$ -- Convert Primos/Primix path to internal format (Primos
    ;                if Emacs invoked under Primos, Primix if under Primix).
    ;

    (defun internpath$ ((path string)
                        &returns string
                        &local (cx integer)                          ;BUG
                               (pathdummy string)
                       )
        (if (= fs$ "primos")
            (return (upcase path))
         else
            (if (= path "<")  (return "///"))   ; DMM 09-Dec-88  Primix NS root
            (if (= path ">")  (return "///"))   ; DMM 09-Dec-88  Primix NS root
            (if (= path "<>") (return "////"))  ; DMM 09-Dec-88  Primix NS root
            (if (= path ">>") (return "////"))  ; DMM 09-Dec-88  Primix NS root
            (setq pathdummy (primos_to_unix path))
            (if (= (index pathdummy explore$unix_root) 1)
                (setq pathdummy (substr pathdummy (1+ (string_length explore$unix_root))))
                 (if (= pathdummy "")  (setq pathdummy "/"))
            )
            (return pathdummy)
        )
    )

