; FILE_HOOKS.EM,  EMACSSRC>EMACS*>EXTENSIONS>SOURCES, EMACS DEVELOPMENT, 08/27/90
; Contains "file hook" functions.
; Copyright (c) 1982, Prime Computer, Inc., Natick, MA 01760
;                     All Rights Reserved
;
;
; Modifications:
;
;   Date    Engineer     Modifications
; 08/27/90  S. Horowitz  Added "cxx" file hook to programmer$.
; 02/28/89  Bugos        Added "cob" file hook to programmer$. (SPAR 4038598)
; 12/22/87  Bugos        Added "cobol85" file hook.
; 11/02/87  Bugos        Removed "cobol" file hook.
; 11/02/87  Bugos        Added "c" and "cc" file hooks to programmer$.
; 11/14/84  MAM          Changed rpg suffix to default to vrpg.
; 02/03/83  Zane         (set_permanent_key "^xb" "mod_select_buf")
; 02/03/83  Zane         (set_permanent_key "^xB" "mod_select_buf")


(defun found_file_hook  ()
     (setq file_hook_type$ (list user_type$))
     (if (null (car file_hook_type$))
         (if (null (cdr file_hook_type$))
             (return)))
     (if (= file_hook_type$ '(no_file_hooks))
         (return))
     (eval file_hook_type$))

(defun no_file_hooks$ () )

(defun clerical$ ()
    (select (suffix$)
      "runi"
          (fill_on)
      otherwise
          (fill_on)))

(defun programmer$ ()
      (select (suffix$)
          "runi"
               (fill_on)          ; fill mode
          "em"
               (lisp_on)          ; lisp mode
          "cbl"
               (cbl_on)           ; cobol mode
          "cob"
               (cobol85_on)       ; cobol mode
          "cobol85"
               (cobol85_on)       ; cobol mode
          "ftn" "f77"
               (fortran_on)       ; fortran mode
          "c" "cc"
               (cc_on)            ; c mode
          "cxx"
               (cxx_on)           ; c++ mode
          "rpg"
               (vrpg_on)          ; vrpg mode
          "vrpg"
               (vrpg_on)          ; vrpg mode
          "pl1"
               (pl1_on)           ; full pl1
          "pl1g"
               (pl1g_on)          ; pl1 subset G
          "como"
               ()
          otherwise
               ()
          ))

;;; The file hook macro does not work with select buffer
;;; The following macro lets it be used


    (defcom mod_select_buf
        &doc "Select buffer"
        &args ((buf_name &prompt "Buffer" &string))
        (select_buf buf_name)
        (if (null (buffer_info modes))
            (found_file_hook)))
