; FORTRAN.EM,  EMACS*>EXTENSIONS>SOURCES, EMACS DEVELOPMENT, 11/30/89
; Contains the functions for FORTRAN mode
; Copyright (c) 1982, Prime Computer, Inc., Natick, MA 01760
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Modifications:
;
;   Date   Engineer     Modification description
; 12/4/90  Colt         Corrected indenting problem caused by the fix for
;                       (SPAR 4044735). Added a second routine to find
;                       previous line before a comment interatively.
;                       (SPAR 4051098)
; 11/30/89 Bugos        Corrected PL recursion error when entering 32 (or more)
;                       consecutive comment lines followed by a non-comment
;                       line beginning with an alphabetic character.
;                       (SPAR 4044735)
; 08/23/89 Bugos        Enabled numeric argument (repeat count) to work for
;                       all alphabetic characters -- lowercase and uppercase.
;                       (SPAR 4043100)
; 07/09/86 Bugos        Corrected fortran_wrap$ to avoid wrapping when source
;                       code line ends in column 72 (SPAR 4003634).
; 05/08/86 MAM          ESC > no longer bound to back_tab (SPAR 4001398).
; 03/26/86 MAM          Made FTN the default for no extension and
;                       gives message correctly (SPAR 3008804).
; 11/21/85 MAM          Fixed Continuation for Comments and Code
;                       (SPAR 3015252).
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; FUNCTIONS:                                                               ;;;
;;;      do$            Indentation for lines beginning with DO              ;;;
;;;      fortran_character_indent$                                           ;;;
;;;                     Check if should indent what is typed at col 1        ;;;
;;;      fortran_comment$                                                    ;;;
;;;                     Checks if comment character is inserted at col 1     ;;;
;;;      fortran_continuation$                                               ;;;
;;;                     Checks if continuation char is inserted at col 1     ;;;
;;;      fortran_do_toggle                                                   ;;;
;;;                     Every time typed, changes state of what occurs when  ;;;
;;;                     line begins with DO                                  ;;;
;;;      fortran_on     Turns on fortran mode                                ;;;
;;;      fortran_off    Turns off fortran mode                               ;;;
;;;      fortran_space$  Checks column before invoking fortran_wrap$         ;;;
;;;      fortran_wrap$   Basically the same as regular wrap function         ;;;
;;;      set_fortran_comment                                                 ;;;
;;;                     Sets up the indentation after a comment              ;;;_
;;;      set_fortran_cont                                                    ;;;
;;;                     Sets the continuation char that will be printed      ;;;
;;;      set_indent$    Figures out what indentation should be               ;;;
;;;      setup_character_indent$                                             ;;;
;;;                     Binds all character insertions to correct function   ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; do$                                                                      ;;;
;;;    If fortran_do$ is true, then if the first non-space characters after  ;;;
;;;    column 6 are DO, then an added level of indentation is added          ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun do$ ()
   (dispatch
      "do " "DO " "Do "
      "do~n" "DO~n" "Do~n"
         (type_tab)
         (setq current_indent$ (cur_hpos))
      otherwise
         (setq current_indent$ (cur_hpos))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; set_indent$                                                              ;;;
;;;    Function that figures out what the current line should be indented to ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun set_indent$ ()
   (save_excursion
     (if (not (prev_line))
         (setq current_indent$ 7)
         (return))

     (if_at "C"
        (span_c$))

     (if (go_to_hpos 7)
         (skip_over_white)
         (if fortran_do$
             (do$)
          else
             (setq current_indent$ (cur_hpos)))
      else
         (setq current_indent$ 7))))

(defun span_c$ ()
  (begin_line)
  (do_forever
    (if (not (prev_line))
        (stop_doing))
    (if_at "C"
        (begin_line)
     else
        (stop_doing))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; set_fortran_comment                                                      ;;;
;;;    Command that lets the user indicate to what space comment text should ;;;
;;;    begin in.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom set_fortran_comment
    &doc "Sets up the indentation after a FORTRAN comment"
    (setq fortran_comment_indent$
          (prompt_for_integer "What is the comment indentation column" 3)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; set_fortran_cont                                                         ;;;
;;;   Lets the user specify what character should be printed in column 6 for ;;;
;;;   continuations                                                          ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom set_fortran_cont
    &doc "Sets the continuation character"
    (setq fortran_continue_char$
         (substr
             (prompt_for_string "What is the continuation character" "C") 1 1)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; fortran_do_toggle                                                        ;;;
;;;    Changes the fortran_do$ boolean from true to false or vice versa.  See;;;
;;;    do$ for what this does.                                               ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom fortran_do_toggle
    &doc "Changes DO indentation"
    (if (= fortran_do$ true)
        (setq fortran_do$ false)
        (info_message "DO does not add indentation")
    else
        (setq fortran_do$ true)
        (info_message "DO adds indentation")))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; fortran_on                                                               ;;;
;;;   Turns on fortran mode                                                  ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom fortran_on
    &doc "Turns on FORTRAN mode"
    (if (null fortran_comment_indent$)
        (setq fortran_comment_indent$ 3))
    (if (null fortran_continue_char$)
        (setq fortran_continue_char$ "C"))
    (if (null fortran_do$)
        (setq fortran_do$ false))
    (setq current_indent$ 7)
    (if (null fortran_keybindings$)
        (fundamental_fortran_keybindings$)
     else
        (if (^= fortran_keybindings$ "loaded")
            (load_fortran_keybindings$)))
    (setq fortran_keybindings$ "loaded")
    (setup_character_indent$)
    (buffer_info fill_column 72)
    (turn_mode_on (find_mode 'fortran) first)
    (if (not (atom my_fortran_tabs$))
        (tablist "7 13 19 25 31 37 43 49 55 61 67 72")
     else
        (tablist my_fortran_tabs$))
;
    (buffer_info (user language_name$) "ftn")    ; Set ftn as the default
    (if (= (suffix$) "ftn")
        (info_message "FORTRAN mode now on, language FTN")
     else
        (if (= (suffix$) "f77")
            (buffer_info (user language_name$) "f77")
            (info_message "FORTRAN mode now on, language F77")
        else
            (ring_the_bell)
            (info_message
            "FORTRAN mode now on. No mode suffix, default language FTN")))
  )

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; fortran_off                                                              ;;;
;;;    Turns off fortran mode                                                ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom fortran_off
    &doc "Turns off FORTRAN mode"
    (turn_mode_off (find_mode 'fortran)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; fortran_comment$                                                         ;;;
;;;   Checks to see if comment invokation character is being typed in col 1. ;;;
;;;   If it is, a C is inserted in column 1 and then an indentation occurs.  ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom fortran_comment$
    &doc "Indents for FORTRAN comment"
    (if (& (line_is_blank) (= (cur_hpos) 1))
           (insert "C")
           (if (null fortran_comment_indent$)
               (setq fortran_comment_indent$ 3))
           (whitespace_to_hpos fortran_comment_indent$)
     else
        (insert (character_argument))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; fortran_continuation$                                                    ;;;
;;;    Checks to if if continuation invokation character is being typed in   ;;;
;;;    column 1.  If it is, the continuation character is typed in col 6.    ;;;
;;;    The line is then indented appropriately.                              ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom fortran_continuation$
    &doc "Indents line for continuation lines"
    (if (& (line_is_blank) (= (cur_hpos) 1))
        (whitespace_to_hpos 6)
        (insert fortran_continue_char$)
        (set_indent$)
        (whitespace_to_hpos current_indent$)
     else
        (insert (character_argument))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; fortran_character_indent$                                                ;;;
;;;    Checks to see if character should be indented if it is typed in col   ;;;
;;;    1.  If so, the line is indented appropriately                         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom fortran_character_indent$
    &doc "Indents lines for character input"
    (if (& (line_is_blank) (= (cur_hpos) 1))
        (set_indent$)
        (whitespace_to_hpos current_indent$))
    (if (null (numeric_argument))
       ;then
            (setq repeat_count 1)
        else
            (setq repeat_count (numeric_argument))
    )
    (do_n_times repeat_count
        (insert (character_argument))
    )
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; setup_character_indent$                                                  ;;;
;;;   Sets up the basic dispatch tables for insertion chararacters that will ;;;
;;;   be checked by fortran_character_indent$.  Note that only alphabetic    ;;;
;;;   characters are setup.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun setup_character_indent$ (&local (charcode integer)
                                       (fortran dispatch))
    (setq fortran (find_mode 'fortran))
    (setq charcodes "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ")
    (do_forever
      (if (= 0 (string_length charcodes)) (stop_doing))
      (dispatch_info fortran (substr charcodes 1 1) 'fortran_character_indent$)
      (setq charcodes (substr charcodes 2))
      )
    )


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; fortran_space$                                                            ;;;
;;;   Normally just inserts a space.  However, if past col 72 does a wrap.   ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom fortran_space$
     (if (> (cur_hpos) 72)
         (fortran_wrap$))
     (self_insert " "))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; fortran_wrap$                                                            ;;;
;;;   Wraps line if text is entered past column 72.  Normally invoked by a   ;;;
;;;   space or a carriage return.                                            ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom fortran_wrap$
    &doc "Fill in FORTRAN mode"
    (if (<= (cur_hpos) 6)
        (setq current_indent$ 7)
        (cr)
        (return))
    (if (<= (cur_hpos) 73)     ; Wrap only if cur_hpos value is 74 or more.
        (cr)
        (return))
    (save_excursion
        (next_line)
        (set_indent$))
    (insert "")
    (go_to_hpos (buffer_info fill_column))
    (if (search_bk_in_line " ")
        (delete_white_sides)
        (cr)
        (prev_line)
        (if_at "C"
            (next_line)
           (insert "C")
           (if (null fortran_comment_indent$)
               (setq fortran_comment_indent$ 3))
           (whitespace_to_hpos fortran_comment_indent$)
         else
            (next_line)
            (whitespace_to_hpos 6)
            (insert fortran_continue_char$)
            (whitespace_to_hpos current_indent$)
            (save_excursion
                (next_line)
                (if (line_is_blank)
                    (if_at " "
                          (kill_line 2)
                     else
                          (delete_char))))))
    (forward_search "")
    (rubout_char 3))

(defun fundamental_fortran_keybindings$ ()
   (set_mode_key "fortran" " " "fortran_space$")
   (set_mode_key "fortran" "^j" "fortran_wrap$")
   (set_mode_key "fortran" "^i" "type_tab")
   (set_mode_key "fortran" "/" "fortran_comment$")
   (set_mode_key "fortran" "*" "fortran_comment$")
   (set_mode_key "fortran" "&" "fortran_continuation$"))
