; GET_SAVE_TAB.EM, EMACS*>EXTENSIONS>SOURCES, ENVIRONMENTS GROUP, 03/26/85
; Gets tabs from files and saves them to files.
; COPYRIGHT (C) 1985, Prime computer, inc., Natick, Ma 01760
;
; Description:
;
; Abnormal conditions:
;
; Implementation:
;
; Modifications:
;   Date   Programmer   Description of modification
; 03/26/85 Sarkisian    Adding handling of buffers in language mode that uses
;                       tabs...must always look for local tab information in
;                       this case.
; 02/21/85 Sarkisian    Initial coding.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                       ;;;
;;; C/F       Name                     Description                        ;;;
;;; ---       ---                      -----------                        ;;;
;;; C         get_tab                  Retrieves tabs previously written  ;;;
;;;                                    to a file.                         ;;;
;;;                                                                       ;;;
;;; C         save_tab                 Writes the tabs currently being    ;;;
;;;                                    used to a file.                    ;;;
;;;                                                                       ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                       ;;;
;;; get_tab        Command that restores tabs that were previously saved  ;;;
;;;                into the tabs that are currently in use, i.e global    ;;;
;;;                or local. Expects to be used interactively with the    ;;;
;;;                user.                                                  ;;;
;;;                                                                       ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defcom get_tab
    &doc "Restores named tabs"
    &args ((place &prompt "Where are the tabs stored" &string))
    (get_tabf place))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                       ;;;
;;; get_tabf       Function that does the work for get_tab.               ;;;
;;;                                                                       ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun get_tabf (       (place string)
                 &local  tab_name
                         dummy_last_tab
                         tab_language_mode_val)
    (save_position
         (if (^ (file_info place exists))   ; file not found...yell at user.
             (ring_the_bell)
             (error_message "File not found.")
             (return))
         (setq tab_language_mode_val (tab_language_mode))
         (find_file place)

         (pl)                ; so that all saved tabs names are known.
         (setq tab_name (intern (prompt "What name are the tabs stored with")))

         (if (null (eval tab_name))         ; bad name supplied...yell at user.
             (ring_the_bell)
             (error_message "Tab name not known.")
             (return)))


         ; everything is alright...restore tabs.
         ;
         (check_tab_vars)         ; make certain tab variables exist.

         (if (& global_tabs_on$ (^ tab_language_mode_val))
             (info_message "Restoring tabs (global)")
             (tablist_to_array$ (eval tab_name) tab_array$ last_tab$)
             (info_message "Tabs restored (global)")
         else
             (info_message "Restoring tabs (local_to_buffer)")

             (tablist_to_array$ (eval tab_name) (buffer_info (user tab_array))
                                                dummy_last_tab)
             (buffer_info (user last_tab) dummy_last_tab)
             (info_message "Tabs restored (local to buffer)")))
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                       ;;;
;;; save_tab       Command that writes the tabs currently in use to a     ;;;
;;;                file. The user is prompted for a filename; if the file ;;;
;;;                doesn't exist, it is created. The user is also asked   ;;;
;;;                to supply a name under which the tabs will be saved.   ;;;
;;;                This allows the user to save many different sets of    ;;;
;;;                tabs in the same file.                                 ;;;
;;;                                                                       ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defcom save_tab
    &doc "Saves tab stops for future use"
    (save_tabf))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                       ;;;
;;; save_tabf      Function that does the work for save_tab.              ;;;
;;;                                                                       ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun save_tabf (&local (place string)
                         (tab_name string)
                         (temp_tab list)
                          tab_array_used
                          last_tab_used)

    (if (& (null global_tabs_on$) (^ (tab_language_mode)))
        (info_message "No tabs are set (global or local).")
        (ring_the_bell)
        (return))
;
;   determine which set of tabs is presently in use. If the tabs have not been
; set, inform the user and exit, else set the dummy variables tab_array_used
; and last_tab_used to the proper values. NOTE: The variable tab_array_used
; POINTS DIRECTLY TO THE ARRAY IT IS SET EQUAL TO. This effect is used to avoid
; problem of switching buffers (to write out presently used tabs) and thereby
; referencing the wrong set of local tabs, i.e. use the local tabs from buffer
; where this routine was called from!

    (if (& global_tabs_on$ (^ (tab_language_mode)))
        (if (null tab_array$)
            (info_message "No tabs are set (global).")
            (ring_the_bell)
            (return)
        else
            (setq tab_array_used tab_array$) ; tab_array_used points to
                                             ; tab_array$!
            (setq last_tab_used last_tab$))
    else
        (if (null (buffer_info (user tab_array)))
            (info_message "No tabs are set (local to buffer).")
            (ring_the_bell)
            (return)
        else
            (setq tab_array_used (buffer_info (user tab_array))) ; both point to
                                                                 ; same address!
            (setq last_tab_used (buffer_info (user last_tab)))))
;
; get the file with the saved tabs in it and go to that buffer. This allows
; us to write to the buffer and save our work when we are done and allows the
; user to see what tabs he/she has already saved.
;
    (save_excursion
         (setq place (prompt "What file do you wish to write to"))
         (if (file_info place exists)
             (find_file place)
         else
             (go_to_cursor (find_buffer place))
             (write_file place))

         (move_bottom)
         (setq tab_name (prompt "What name are you using to save the tabs"))
         (if (null tab_name)
             (info_message "No tab name supplied. Tabs are not saved.")
             (return))

         (insert (catenate "(setq " tab_name " '("))

         (setq present_stop (aref tab_array_used 1))
         (setq position 1)

         (do_forever
              (if (>= position last_tab_used) (stop_doing))
              (insert (integer_to_string present_stop))
              (setq prev_stop present_stop)

              (do_forever
                   (setq position (1+ position))
                   (setq present_stop (aref tab_array_used position))
                   (if (^= present_stop prev_stop) (stop_doing)))

              (insert " "))

         (insert "))")
         (cr)
         (save_file)
         (info_message "Tabs are now saved.")))
