; KILL_RING.EM, EMACSSRC>EMACS*>EXTENSIONS>SOURCES, EMACS DEVELOPMENT, 02/19/88
; Functions for viewing kill ring buffers.
; Copyright (c) 1981, Prime Computer, Inc., Natick, MA 01760
;
;
; Modifications:
;
;   Date    Engineer     Description of modification
; 02/19/88  Bugos        Modified to ensure that the most-recently killed
;                        text is correctly placed on the kill ring.
;                        (SPAR 4025939)
; 02/18/88  Bugos        Rewrote this module. In addition, made the behavior
;                        of yank_kill_text consistent with that of yank_region.
; 06/30/86  MAM          Fixed overflow in view_kill_ring. Check array count.
;                        (SPAR 4003469)
; 02/03/83  Zane         (setq kill_ring_loaded$ true)
; 02/03/83  Zane         (setq save_text$ "")


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                         ;;;
;;;  This file contains: view_kill_ring (^x^zk)                             ;;;
;;;                      yank_kill_text (^x^z^y)                            ;;;
;;;                                                                         ;;;
;;;  When view_kill_ring is invoked, the contents of kill ring buffers      ;;;
;;;  are displayed. As each kill ring buffer is displayed, the following    ;;;
;;;  options are made available:                                            ;;;
;;;                                                                         ;;;
;;;  n, N, <RETURN>:                                                        ;;;
;;;      View the contents of the next kill ring text. Once all kill        ;;;
;;;      ring texts have been viewed, return to the buffer from which       ;;;
;;;      view_kill_ring was invoked.                                        ;;;
;;;  v, V:                                                                  ;;;
;;;      Invoke view_file to view a kill ring text.                         ;;;
;;;  s, S:                                                                  ;;;
;;;      Save the contents of the current kill ring text for later          ;;;
;;;      retrieval, and return to the buffer from which view_kill_ring      ;;;
;;;      was invoked.                                                       ;;;
;;;  q, Q, ^g:                                                              ;;;
;;;      Return immediately to the buffer from which view_kill_ring         ;;;
;;;      was invoked.                                                       ;;;
;;;  h, H,:                                                                 ;;;
;;;      Display the kill ring "help" screen.                               ;;;
;;;                                                                         ;;;
;;;  Global variable(s): save_text$                                         ;;;
;;;                                                                         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(defcom view_kill_ring
    &doc "Views the contents of kill ring buffers"
    &na (&pass count &default 1)
    (view_kill_ringf count)
)


(defun view_kill_ringf (       (count integer)
                        &local (response string)
                               (index_value integer)
                               (number_of_kill_buffers integer)
                               (kill_array array)
                               (buffer_spec string)
                               (here cursor)
                       )
    ; Retain this test for possible future use -- to permit a text kill ring.
    (if (= count 1)
       ;then
            (setq buffer_spec ".kill.")
        else
            (setq buffer_spec ".text.")
    )
    (save_excursion
        ; Create kill_array only large enough to store the maximum of 11
        ; kill ring buffers reported in the ".buffers" buffer.
        (setq kill_array (make_array 'string 11))
        ; Valid index values will range, therefore, from 0 through 10.
        (setq index_value -1)
        (save_excursion
            (select_buf ".buffers")
            (move_top)
            (do_forever
                (if (forward_search buffer_spec)
                   ;then
                        (if (< index_value 10)
                           ;then
                                (setq index_value (1+ index_value))
                            else
                                (stop_doing)
                        )
                        (begin_line)
                        (with_cursor here
                            (forward_search " ")
                            (aset (point_cursor_to_string here) kill_array index_value)
                        )
                    else
                        (stop_doing)
                )
            )
        )
        (if (= index_value -1)
           ;then
                (ring_the_bell)
                (info_message "The kill ring is empty!")
                (sleep_for_n_milliseconds 1000)
                (info_message "")
                (return)
        )
        ; Valid index values begin at, and include, 0.
        (setq number_of_kill_buffers (1+ index_value))
        (setq index_value 0)
        (do_n_times number_of_kill_buffers
            (select_buf (aref kill_array index_value))
            (move_top)
            (do_forever
                (info_message
                "Selections: n (next), s (save), v (view), q (quit), h (help)")
                (setq response (char_to_string (read_character)))
                (select response
                    "n" "N" "~cj"
                        (stop_doing)
                    "v" "V"
                        (view_file)
                    "s" "S"
                        (move_top)
                        (with_cursor here
                            (move_bottom)
                            (setq save_text$ (point_cursor_to_string here))
                        )
                        (info_message
                            "Text has been saved; to retrieve it, type ^x^z^y.")
                        (return)
                    "q" "Q"  "~cg"
                        (info_message "")
                        (return)
                    "h" "H"
                        (save_excursion
                            (select_buf ".help.kill")
                            (buffer_info dont_show true)
                            (if (empty_buffer_p)
                                (insert "~n~n")
                                (insert "            ")
                                (insert "             KILL RING HELP SCREEN~n~n")
                                (insert "            ")
                                (insert "n, N, <RETURN>   View next kill ring text.~n")
                                (insert "            ")
                                (insert "v, V             Invoke view_file to view the text.~n")
                                (insert "            ")
                                (insert "s, S             Save this text for later retrieval.~n")
                                (insert "            ")
                                (insert "q, Q, ^g         Quit.~n")
                                (insert "            ")
                                (insert "h, H             Display this 'help' screen.~n~n")
                                (insert "            ")
                                (insert "Type any character to return: ")
                                (buffer_info changed_ok true)
                            )
                            (read_character)
                        )
                  otherwise
                        (ring_the_bell)
                        (info_message "Invalid selection!")
                        (sleep_for_n_milliseconds 1000)
                )
            )
            (setq index_value (1+ index_value))
        )
    )
    (info_message "")
)


(defcom yank_kill_text
    &doc "Inserts text saved by view_kill_ring"
    (insert save_text$)
)
