; MAINTAIN.EM,  EMACSSRC>EMACS*>EXTENSIONS>SOURCES, EMACS DEVELOPMENT, 01/29/88
; Routines helpful for administering EMACS libraries.
; Copyright (c) 1982, Prime Computer, Inc., Natick, MA 01760
;
;
; Description:
;
; Abnormal conditions:
;
; Implementation:
;
; Modifications:
;   Date    Engineer     Description of modification
; 01/29/88  Bugos        Modified dump_file so that the buffer being dumped
;                        must have a default file name which is not null and
;                        which does not have a .EFASL suffix. (SPAR 4024433)
; 02/03/83  Zane         (setq maintain_loaded$ true)
; ??/??/??  Unknown      Initial coding.


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;  USERS SHOULD NOT BE MODIFYING THIS FILE -- RESULTS COULD BE DANGEROUS!  ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; dump_file             creates a fasdump file                             ;;;
;;; load_compiled         loads a fasdump file                               ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; dump_file                                                                ;;;
;;;     This command converts an ASCII file to a fasdump file.               ;;;
;;;     The name of the default file does not require a .EM suffix.          ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom dump_file
     &doc "Convert to fasdump file"
     (dump_filef))
(defun dump_filef (&local (start integer)
                          (name string)
                          (pos integer))
     (setq start (cpu_time))
     (setq name (buffer_info default_file))
;    (setq pos (last_entryname_suffix name ".EM"))
;    (if (> pos 0) (setq name (substr name 1 (- pos 1)))
;     else
;        (setq pos (index name ".em"))
;        (if (> pos 0) (setq name (substr name 1 (1- pos)))))
;
     (setq name (upcase name))
     ; Append an invalid file name character to be able to test for the
     ; name of the default file.
     (setq name (catenate name "@"))
     (do_forever
         (if (^= name "@")
            ;then
                 (setq pos (index name ".EFASL@"))
                 (if (= pos 0)
                    ;then
                         (stop_doing)
                    else
                         (info_message "The default file name may not have a .EFASL suffix.")
                 )
             else
                 (info_message "There is no default file name for this buffer.")
         )
         (ring_the_bell)
         (setq name (prompt "Please assign a default file name to this buffer"))
         (setq name (upcase name))
         (setq name (catenate name "@"))
     )
     (setq pos (index name "@"))
     (buffer_info default_file (substr name 1 (1- pos)))
     (setq pos (index name ".EM@"))
     (if (= pos 0)
         ;then
             (setq pos (index name "@"))
     )
     (setq name (substr name 1 (1- pos)))
     (info_message (catenate "Starting to dump " name))
     (setq name (remove_charset name "~~"))
     (fasdump name)
     (info_message (catenate "Elapsed time "
                         (integer_to_string (- (cpu_time) start)))))

;
;  This finds the index of a suffix in a pathname but only checks in
;  the entryname.  This fixes dump_file
;

(defun last_entryname_suffix (pathname suffix &local pos total)
       (setq total 0)
       ;; find last entryname
       (do_forever (if (= 0 (setq pos (index pathname ">"))) (stop_doing))
          (setq total (+ total pos))
          (setq pathname (substr pathname (1+ pos))))
       ;; find suffix (if exists)
       (return (+ total (index pathname suffix))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; load_compiled                                                            ;;;
;;;   Extended command that load a fasload file.  It prompts the user        ;;;
;;;   for a file name.                                                       ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom load_compiled
     &doc "Loads a fasdump file"
     (fasload (prompt "Fasdump file name")))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;  Utilities for EMACS Maintainers  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; These functions are intentionally not documented anywhere. While these   ;;;
;;; functions can't get anyone in trouble, they are not for general use      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom dump_package
        &doc "Convert to fasdump file"
        (save_position
             (xdump_package_function "")))   ; use the slower one

(defun top_message ((text string))
       (save_position (window_info top_line_cursor dump_top)
            (info_message text)))

(defun dump_package_function (       (note string)
                              &local (start integer)
                                     (name string)
                                     (pos integer)
                                     (dump_top cursor))
       (setq dump_top (window_info top_line_cursor))
       (setq name (buffer_info default_file))
       (setq start (cpu_time))
       (setq pos (index name ".EM"))
       (if (> pos 0) (setq name (substr name 1 (- pos 1)))
        else
           (setq pos (index name ".em"))
           (if (> pos 0) (setq name (substr name 1 (1- pos)))))
       (if (> pos 0) (setq name (substr name 1 (- pos 1))))
       (top_message (catenate "Starting to dump " name " " note))
       (setq name (remove_charset name "~~"))
       (fasdump name)
       (top_message (catenate "Elapsed time "
                         (integer_to_string (- (cpu_time) start)))))

(defcom xdump_package
        &doc "Convert to fasdump file"
        (xdump_package_function ""))

(defun xdump_package_function ((note string)
                     &local (start integer)
                            (name string)
                            (pos integer)
                            (dump_top cursor))
       (setq dump_top (window_info top_line_cursor))
       (setq start (cpu_time))
       (setq name (buffer_info default_file))
       (save_excursion
            (move_top)
            (if (forward_search "~n(def_auto") ; ) for lisp mode
                (move_top)
                (top_message "expanding")
                (util.dump_with_expansion name)
                (save_excursion
                    (go_to_buffer ".temp")
                    (buffer_info changed_ok true)
                    (dump_package_function
                         (catenate "after "
                              (integer_to_string (- (cpu_time) start)))))
                (return)))
       (setq pos (index name ".EM"))
       (if (> pos 0) (setq name (substr name 1 (- pos 1))))
       (top_message (catenate "Starting to dump " name " " note))
       (fasdump name)
       (top_message (catenate "Elapsed time "
                         (integer_to_string (- (cpu_time) start)))))


(defun util.dump_with_expansion
       ((name string)                  ; default file
        &local (the_list list))

       (save_excursion
            (go_to_buffer ".temp")
            (delete_buffer)
            (buffer_info default_file name))
       (move_top)
       (do_forever
          (setq the_list (read))
          (if (not (null the_list))
              (util.process the_list))
          (if (end_of_buffer_p) (stop_doing)))
       (return))                       ; for now

(defun util.process
       ((the_list list))
       (save_excursion
          (go_to_buffer ".temp")
          (move_bottom)
          (redisplay)
          (if (not (eq (car the_list) 'def_auto))
              (util.insert the_list)
              (return))
                                       ; for now def_auto does print directly
          (apply (fsymeval 'def_auto)
                 (append (cdr the_list)
                         (list (fsymeval 'util.insert))))))

(defun util.insert                     ; insert value in def_auto
       ((value list))
       (save_excursion
          (go_to_buffer ".temp")
          (move_bottom)
          (print value current_cursor)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;; TELL.EM                                                            ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; When this is ready, it will be distributed for general use               ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom tell
      &doc "Tell useful information about an atom"
      (display_atom (fsymeval (intern (prompt "Function")))))

(defun display_atom ((a any))
      (select (typef a)
         2 3 4 5 6 8
              (prin1 (catenate (get_type (typef a)) ":"))
              (print a)
         7    (display_function a)
         11   (display_dispatch a)
         12   (display_handler a)
       otherwise (print (catenate "Type " (get_type (typef a))
                                  " not yet handled"))))

(defun display_function ((f function) &local (i integer))
       (if (function_info f returns_a_value)
            (print (catenate "returns a value of type "
                  (get_type (function_info f return_value)))))
       (prin1  "Required args ")
               (print (function_info f required_arguments))
       (prin1  "Total args ")
               (print(function_info f optional_arguments))
       (prin1 "Special form ")
               (print (function_info f special_form))
       (prin1 "User defined function ")
               (print (function_info f user_defined_function))
       (prin1 "Cleanup_handler: ")
               (print (function_info f cleanup_handler))
       (setq i 1)
       (do_n_times (function_info f optional_arguments)
          (prin1 "Evaluate arg ")
               (prin1 i) (prin1 " ")
               (prin1  (function_info f evaluate_argument i))
               (prin1 " type ")
               (print (get_type (function_info f argument_type i)))
          (setq i (1+ i))))

(defun display_handler ((h any) &local (i integer))
        (prin1 "Name: ")
        (print (handler_info h name))
        (prin1 "Explanation: ")
        (print (handler_info h explanation))
        (prin1 "Handler: ")
        (print (handler_info h handler))
        (prin1 "Data_value: ")
        (print (handler_info h data_value))
        (prin1 "Is_prefix: ")
        (print (handler_info h is_prefix)))

(defcom display_buffer
        &doc "Display information about the current buffer"
        (prin1 "Name: ")
        (print (buffer_info name))
        (prin1 "Default_file: ")
        (print (buffer_info default_file))
        (prin1 "Modified: ")
        (print (buffer_info modified))
        (prin1 "Modes: ")
        (print (buffer_info modes))
        (prin1 "Read_only: ")
        (print (buffer_info read_only))
        (prin1 "Changed_ok: ")
        (print (buffer_info changed_ok))
        (prin1 "Dont_show: ")
        (print (buffer_info dont_show))
        (prin1 "Two_dimensional: ")
        (print (buffer_info two_dimensional))
        (prin1 "Fill_column: ")
        (print (buffer_info fill_column))
        (prin1 "Mark: ")
        (print (buffer_info mark))
        (prin1 "Top_cursor: ")
        (print (buffer_info top_cursor))
        (prin1 "Bottom_cursor: ")
        (print (buffer_info bottom_cursor)))

(defcom display_window
        &doc "Display information about current window"
        (prin1 "Top_line: ")
        (print (window_info top_line))
        (prin1 "Bottom_line: ")
        (print (window_info bottom_line))
        (prin1 "Left_column: ")
        (print (window_info left_column))
        (prin1 "Right_column: ")
        (print (window_info right_column))
        (prin1 "Is_active: ")
        (print (window_info is_active))
        (prin1 "Is_major: ")
        (print (window_info is_major))
        (prin1 "Top_line_cursor: ")
        (print (window_info top_line_cursor))
        (prin1 "Showing_numbers: ")
        (print (window_info showing_numbers))
        (prin1 "Column_offset: ")
        (print (window_info column_offset))
        (prin1 "Last_buffer_cursor: ")
        (print (window_info last_buffer_cursor)))

(defcom display_terminal
        &doc "Tell about the current terminal"
        (prin1 "Type: ")
        (print (terminal_info type))
        (prin1 "Height: ")
        (print (terminal_info height))
        (prin1 "Width: ")
        (print (terminal_info width))
        (prin1 "Speed: ")
        (print (terminal_info speed))
        (prin1 "Crtp: ")
        (print (terminal_info crtp)))

(defun display_dispatch (d &local (c integer) (s string))
       (prin1 "Name: ")
       (print (dispatch_info d 'name))
       (setq c 0)
       (do_n_times 256
           (if (^ (null (dispatch_info d c)))
               (prin1 (catenate (string_of_length_n
                                    (catenate "Char("
                                              (integer_to_string c)
                                              ")")
                                    9)
                                (catenate ": "
                                          (char_to_string (ItoC c))
                                          " ")
                      )
               )
               (print (dispatch_info d c))
           )
           (setq c (1+ c))
       )
)

(defun get_type((i integer) &returns string)
     (select i
          1    (return "any")
          2    (return "boolean")
          3    (return "character")
          4    (return "integer")
          5    (return "string")
          6    (return "atom")
          7    (return "function")
          8    (return "list")
          9    (return "cursor")
          10   (return "buffer")
          11   (return "dispatch_table")
          12   (return "handler")
          14   (return "window")
          15   (return "array")

       otherwise
               (return (catenate (integer_to_string) " unknown"))))
