;  MISC.EM,  EMACSSRC>EMACS*>EXTENSIONS>SOURCES, EMACS DEVELOPMENT, 01/19/87
;  Contains functions used by other functions in EMACS
;  Copyright (c) 1982, Prime Computer, Inc., Natick, MA 01760
;                     All Rights Reserved
;
; Description:
;
; Abnormal conditions:
;
; Implementation:
;
; Modifications:
;   Date   Programmer     Description of modification
; 01/19/87 Bugos          Modified the "p" (print) command of the function
;                         "viewer" to permit users to select their own spool
;                         command-line option(s) instead of automatically
;                         having a file spooled "-at 1" (SPAR 4009692).
; ??/??/82 DNK            Initial coding.
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; all_modes_off    Extended command for turning all modes off              ;;;
;;; describe         Tells information about fundamental and library         ;;;
;;;                  commands and functions.                                 ;;;
;;; lines_in_file    a function that returns how many lines exist            ;;;
;;;                  in a file.                                              ;;;
;;; new_features     Lists enhancements, new commands, etc.                  ;;;
;;; tell_modes       Exended command that shows what modes are in force      ;;;
;;; view_file        a command that lets a user look through a               ;;;
;;;                  a file without using EMACS commands.  This is           ;;;
;;;                  an extended command.                                    ;;;
;;; viewer           the function called by view_file                        ;;;
;;;                                                                          ;;;
;;; Global Variables: search_text$                                           ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; view_file                                                                ;;;
;;;     Command that lets a user look through a file without using           ;;;
;;;     EMACS commands.                                                      ;;;
;;;                                                                          ;;;
;;;        (view_file)                                                       ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom view_file
    &doc "Lets a user look at a file"
    (save_excursion
        (let ((filename (prompt "View file")))
             (if (^= filename "")
                 (find_file filename))
             (do_forever
                 (if (^ (viewer (lines_in_file))) (stop_doing)))))
    (info_message ""))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; viewer                                                                   ;;;
;;;    Function that moves though a file without using EMACS commands.       ;;;
;;;                                                                          ;;;
;;;        (viewer optional-integer optional-string)                         ;;;
;;;                                                                          ;;;
;;;    where integer is optional and indicates the number of lines in        ;;;
;;;    the file and string is an optional text message to be printed.        ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun viewer (&optional (no_of_lines integer)
                         (message string)
               &local    (per_cent integer)
                         (movement string)
               &returns  boolean)
    (if (null message) (setq message "Viewer (type ? for help)"))
    (if (^ (null no_of_lines))
        (setq message (catenate "-- "
        (integer_to_string (/ (* (line_number current_cursor) 100) no_of_lines))
                                " % -- " message)))
    (info_message message)
    (setq movement (char_to_string (read_character)))
    (select movement
         "?"   (view_help$)
               (return true)
          " "  "~cj"
               (next_page)
               (return true)
          "b"
          "B"  (back_page)
               (return true)
          "<"  (move_top)
               (return true)
          ">"  (move_bottom)
               (return true)
          "s" "~cs" "S"
               (with_command_abort_handler
                   (if (^ (forward_search
                       (setq search_text$ (prompt "Forward search"))))
                       (info_message (catenate search_text$ " not found"))
                       (sleep_for_n_milliseconds 1000))
                   (return true)
                command_abort_handler
                   (return true))
          "l"  "~cl"
          "L"  (refresh)
               (return true)
          "r"  "~cr" "R"
               (with_command_abort_handler
                  (if (^ (reverse_search
                             (setq search_text$ (prompt "Reverse search"))))
                      (info_message (catenate search_text$ " not found"))
                      (sleep_for_n_milliseconds 1000))
                   (return true)
                command_abort_handler
                   (return true))
          "p" "P"
               (save_excursion
                 (with_no_redisplay
                   (let ((filename (buffer_info default_file)))
                        (if (= filename "")
                            (setq filename ".viewer.print")
                            (write_file filename)
                         else
                            (if (buffer_info modified)
                                (write_file filename)))
                        (setq spool_options$ (prompt "Select spool command-line options (if any)"))
                        (setq spool_command (catenate "spool " filename " " spool_options$))
                        (primos_command spool_command)
                   )
                 )
               )
               (return true)
          "q" "Q" "~cG"
               (return false)
          otherwise
               (info_message "Unknown response")
               (sleep_for_n_milliseconds 1000)
               (return true)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun view_help$ ()
   (save_excursion
      (select_buf ".view.help")
      (if (empty_buffer_p)
      (buffer_info dont_show true)
      (insert "~n~n")
      (insert "                space, cr  Move forward a screen~n")
      (insert "                b          Move back a screen~n")
      (insert "                l          Refresh~n")
      (insert "                p          Print~n")
      (insert "                q          Quit~n")
      (insert "                r          Reverse search~n")
      (insert "                s          Search for a string~n")
      (insert "                <          Move to the top of buffer~n")
      (insert "                >          Move to the bottom of buffer~n")
      (insert "                ?          Type this text~n~n~n")
      (insert "Type any key to return to viewer")
      (buffer_info changed_ok true))
   (read_character)))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; lines_in_file                                                            ;;;
;;;     Function that returns the number of lines in file.                   ;;;
;;;                                                                          ;;;
;;;             (lines_in_file)                                              ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun lines_in_file (&returns integer)
    (return (line_number (buffer_info bottom_cursor))))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; all_modes_off                                                            ;;;
;;;     Extended commands that turns all modes off.  Note that if the        ;;;
;;;     mode sets up some conditions that are really global in nature        ;;;
;;;     (such as 2don in overlay mode), this command will not shut them      ;;;
;;;     off.                                                                 ;;;
;;;                                                                          ;;;
;;;        (all_modes_off)                                                   ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom all_modes_off
     &doc "Turns off all modes"
     (set_mode "")
     (info_message "Modes are off"))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; tell_modes                                                               ;;;
;;;     Extended command that shows what modes are in force.  This is        ;;;
;;;     needed for those situations in which all modes are not shown in      ;;;
;;;     the mode line.                                                       ;;;
;;;                                                                          ;;;
;;;        (tell_modes)                                                      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom tell_modes
     &doc "Shows what modes are on"
          (print (buffer_info modes)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; describe                                                                 ;;;
;;;     This function is bound to ^_ d or it can be invoked as an extended   ;;;
;;;     command. By typing a function name, EMACS will print all functions   ;;;
;;;     that begin with what you have typed. If you precede the function name;;;
;;;     with an @, EMACS will print all functions that have that string      ;;;
;;;     anywhere in its text. Finally, if you precede the function name with ;;;
;;;     @@, EMACS looks for that string in the text, then prints that macro. ;;;
;;;                                                                          ;;;
;;;     For example, search locates all functions beginning with search.     ;;;
;;;     @search would locate forward_search (and other functions as well).   ;;;
;;;     @@search would locate all places where search was used. This means   ;;;
;;;     you could get extraneous information, but it will be complete.)      ;;;
;;;                                                                          ;;;
;;;     describe contains the following internal functions:                  ;;;
;;;           describe$        the actual function                           ;;;
;;;           describe_search0 does a non-wildcard search                    ;;;
;;;           describe_search1 does a single wildcard search                 ;;;
;;;           describe_search2 does a double wildcard search                 ;;;
;;;           describe_mes$    error message function                        ;;;
;;;           describe_help    contains the help text                        ;;;
;;;                                                                          ;;;
;;;     describe requires that each function be preceded by --*--            ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom describe
    &doc "Displays information about functions and commands"
    (describe$))
(defun describe$ (&local (search_string string)
                         (lines integer)
                         (found string)
                         (here cursor))
 (if  (member (find_mode 'mb_mode) (buffer_info modes))
      (ring_the_bell)
      (info_message "Describe cannot be executed from within the minibuffer")
      (return))

 (save_excursion
    (setq search_string (downcase (prompt
                    "Describe (? for help) (q for exit)")))
    (if (or (= search_string "") (= search_string " ") (= search_string "q"))
        (info_message " Describe exited")
        (return))
    (if (= search_string "?")          ; asking for help
        (describe_help)                ; give it to them
        (describe$)                    ; recursive invocation
        (return))                      ; get out
    (info_message "Please wait ... ")
    (with_no_redisplay                 ; find text but don't show it.
        (select_buf ".describe_emacs")
        (buffer_info dont_show true)
        (if (empty_buffer_p)
            (read_file "emacs*>info>describe_emacs")))
    (move_top)
    (if (= "@@" (substr search_string 1 2))  ; two wild cards
        (setq search_string (substr search_string 3))
        (setq found (describe_search2 search_string))
     else
         (if (= "@" (substr search_string 1 1))   ; one wild card
             (setq search_string (substr search_string 2))
             (setq found (describe_search1 search_string))
         else                                     ; no wildcards
             (setq search_string (catenate "--*-- " search_string))
             (setq found (describe_search0 search_string))))
    (if (= found  "--*--")
        (sleep_for_n_milliseconds 1000)
        (describe$)
        (return))
    (go_to_cursor (find_buffer ".describe"))
    (buffer_info dont_show true)
    (delete_buffer)
    (insert found)
    (move_top)
    (unmodify)
    (do_forever
         (if (^ (viewer (lines_in_file))) (stop_doing)))
    (info_message "")))              ; clear minibuffer message


(defun describe_search0 ((search_string string)
                &local (found string)
                &returns string)
    (setq found "")
    (with_no_redisplay
      (do_forever
         (if (> (string_length found) 20000)
             (describe_mes$ "The text you entered is not unique enough, try again")
             (return "--*--"))
         (if (forward_search search_string)
             (reverse_search " ")
             (forward_char)
             (with_cursor here
                (forward_search "--*--")
                (begin_line)
                (setq found (catenate found (point_cursor_to_string here))))
         else
             (stop_doing))))
    (if (= found "")
        (setq found "--*--")
        (describe_mes$ "No information was found, try again")
        (sleep_for_n_milliseconds 1000))
    (return found))

(defun describe_search1 ((search_string string)
                &local (found string)
                &returns string)
  (setq found "")
  (with_no_redisplay
    (do_forever
       (if (> (string_length found) 20000)
           (info_message "The text you entered is not unique enough, try again")
           (return "--*--"))
       (if (forward_search "--*-- ")
           (if (> (index (current_line) search_string) 0)
               (with_cursor here
                  (forward_search "--*--")
                  (begin_line)
                  (setq found (catenate found (point_cursor_to_string here)))))
       else
          (stop_doing)))
    (if (= found "")
        (setq found "--*--")
        (describe_mes$ "No information was found, try again")
        (sleep_for_n_milliseconds 1000))
    (return found)))

(defun describe_search2 ((search_string string)
                     &local (found string)
                     &returns string)
    (setq found "")
    (with_no_redisplay
      (do_forever
         (if (> (string_length found) 20000)
           (describe_mes$ "The text you entered is not unique enough, try again")
           (return "--*--"))
         (if (forward_search search_string)
             (reverse_search "--*--")
             (forward_char 5)
             (with_cursor here
                (forward_search "--*--")
                (begin_line)
                (setq found (catenate found (point_cursor_to_string here))))
         else
             (if (= found "")
                 (setq found "--*--")
                 (describe_mes$ "No information was found, try again")
                 (sleep_for_n_milliseconds 1000))
             (return found)))))

(defun describe_help ()
   (save_excursion
     (select_buf ".describe.help")
     (if (empty_buffer_p)
         (buffer_info dont_show true)
(insert "By  typing  a function name, EMACS will print all functions that begin~n")
(insert "with what you have typed.  If you precede the function  name  with  an~n")
(insert "@,  EMACS  will  print all functions that have that string anywhere in~n")
(insert "its function name.  Finally,  if you  precede  the  function name with~n")
(insert "@@,  EMACS looks for that string in the text and function names.~n~n")
(insert "For example, search  locates  all  functions  beginning  with  search.~n")
(insert "@search  would  locate  forward_search  (and other functions as well).~n")
(insert "@@search would locate all places where search was  used.   This  means~n")
(insert "you could get extraneous information, but it will be complete.~n~n")
(insert "After the describe information is presented, EMACS  uses  a  different~n")
(insert "command  set to help you get through the  text.   To  see  what  these~n")
(insert "commands are type ? after the text has been displayed:~n~n~n")
(insert "Type any character to return to viewer")
         (buffer_info changed_ok true))
      (read_character)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; new_features                                                             ;;;
;;;    extended command that allows previewing of undocumented features.     ;;;
;;;    It assumes that information is written to a file called               ;;;
;;;    EMACS*>INFO>NEW_FEATURES_INFO                                         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom new_features
    &doc "Lists new features, commands, etc"
    (save_excursion
       (select_buf ".new_features")
       (move_top)
       (if (empty_buffer_p)
           (read_file "EMACS*>INFO>NEW_FEATURES_INFO")
           (buffer_info changed_ok true)
           (buffer_info read_only true)
           (buffer_info dont_show true))
       (do_forever
           (if (^ (viewer (lines_in_file)))
               (stop_doing))))
               (info_message "")
               )

(defun describe_mes$  ((text string))
    (go_to_buffer ".describe")
    (delete_buffer)
    (buffer_info changed_ok true)
    (buffer_info dont_show true)
    (redisplay)
    (info_message "")
    (insert "~n~n~n~n~n                   ")
    (insert text)
    (insert "~n~n~n~n~n~n~n                   ")
    (insert "Type any character to resume")
    (read_character))
