; PRETTY_PRINTER.EM, EMACSSRC>EMACS*>EXTENSIONS>SOURCES, EMACS GROUP, 05/12/86
; Pretty printer and related routines for language modes
; Copyright (c) 1984, Prime Computer, Inc., Natick, MA 01760
;                     All Rights Reserved

; Modifications:
;   Date   Programmer     Description of modification
; 05/12/86 Rand           Changed to use internal pp.
; 07/31/84 Rand           Initial coding.

(defcom mark_spd_region
   (setq cur_list$ (spd_curs))
   (setq cur_0$ (car cur_list$))(setq cur_1$ (car (cdr cur_list$)))
   (go_to_cursor (make_cursor (buffer_info name) (car cur_0$) (cdr cur_0$)))
   (forward_char)
   (mark)
   (go_to_cursor (make_cursor (buffer_info name) (car cur_1$) (cdr cur_1$)))
   (forward_char)
)

(defcom pp_cursors
   (mark_spd_region)
   (exchange_mark)
   (pp_region)
)

(defcom pp_region
(if (= right_margin$ '()) (setq right_margin$ 79))
(save_position
  (begin_line) (skip_over_white)
  (setq left_margin$ (list (cur_hpos)))
)
(process_actions (setq parse_list (parse_region)))
)

(defun parse_region (&local
                     (start_cur cursor)
                     (temp_cur cursor)
                     (end_cur cursor)
                     (p_list list)
                     &returns list)
   (setq start_cur (copy_cursor current_cursor))
   (exchange_mark)
   (setq end_cur (copy_cursor current_cursor))
   (if (> start_cur end_cur)
      (setq temp_cur start_cur)
      (setq start_cur end_cur)
      (setq end_cur temp_cur))
   (setq p_list
     ((fsymeval (intern (buffer_info (user language_name$))))
      start_cur end_cur))
   (return (sort_list p_list))
)

(defun process_actions ((alist list)
                        &local (action any)
                        (optional_action list)
                        )
(setq optional_action '())
(do_forever
   (if (null alist) (stop_doing))
   (setq action (car alist))
   (setq alist (cdr alist))
   (pp (car action) (nthcar action 3))
   (if (^ (null (sublist action 4)))
      (setq optional_action (cons
        (list (car action) (nthcar action 2) (nthcar action 4))
        optional_action
        )
      )
   )
)
(do_optional_actions (reverse optional_action))
)

(defun do_optional_actions ((alist list)
                        &local (action any)
                        (optional_action list)
                        )
(if (null alist) (return))
(do_forever
   (if (null alist) (stop_doing))
   (setq action (car alist))
   (setq alist (cdr alist))
   (using_cursor (car action)
   (if (= (nthcar action 2) 1)
     (if (> (string_length (current_line)) right_margin$)
       (pp (car action) (nthcar action 3)))
    else
      (setq optional_action (cons
        (list (car action) (1- (nthcar action 2)) (nthcar action 3))
        optional_action
        )
      )
   ))
)
(do_optional_actions (reverse optional_action))
)

(defcom undent
&doc "undents by the amount in pp$_0"
   (do_n_times
      (eval (intern (catenate (buffer_info (user language_name$)) "_pp$_0")))
   (back_char))
)
(defcom indent
&doc "indents by the amount in pp$_0"
   (do_n_times
      (eval (intern (catenate (buffer_info (user language_name$)) "_pp$_0")))
   (self_insert \ ))
)
