; RPG2.EM, EMACSSRC>EMACS*>EXTENSIONS>SOURCES, EMACS TEAM-DNK, 12/03/85
; Second portion of RPG mode macros
; Copyright (c) 1984, Prime Computer, Inc., Natick, MA 01760

; Description:
;
; Abnormal conditions:
;
; Implementation:
;
; Modifications:
;   Date   Programmer   Description of modification
; 12/03/85 MAM          Made template buffers .?... not ?...(SPAR 3016022)
; 05/06/85 cdm          Fundamental_rpg_keybindings$ is moved here from rpg.em.
;                       Fixed lm_next(prev)_error -> lm_next(prev)_error$.
; 12/26/84 cdm          Changes in help info and tabbing for F-spec for
;                       secondary keys, for rev 20.0.
; 06/10/84 DNK          Added PT200 support; moved rpg_unplate_key$ from eaux$
;                       to page$ key on PT45, because of addition of scrolling.
;                       Improved the handling of lm_forward_error_key$ and
;                       lm_prev_error_key$ assignments.
; 04/10/84 cdm          Added new features for rev 19.4.
;                       Program identification with new help info and tabs in
;                       header spec.  Also DEL in col 16-18 of output spec.
;                       Also other odd help information changes.
; 11/29/83 MAM          Changed help key to call rpg_full_help$
; 11/21/83 cdm          Modifications for rev 19.3.
;                       Added new help info for addrout files, data structures
;                       and command key indicators, and changed info for new
;                       use of FORMS.  Also corrections for consistency in
;                       grammer, spelling, capitilization, spacing, etc.
; 10/05/83 MAM          More fixes in rpg_only_once$
; 09/21/83 MAM          Fixes modifications for REV19.3 RPG

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; make_rpg_tabs$                                                           ;;;
;;;   sets up all tab stops for each template type                           ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

   (defun make_rpg_tabs$ ()
     (setq rpg_tabs$ (make_array 'boolean 564))
     (fill_array rpg_tabs$ false)
                                       ; rpg line card 1-80
     (aset true rpg_tabs$ 1  )                               ; 1
     (aset true rpg_tabs$ 6  )                               ; 6
     (aset true rpg_tabs$ 15 )                               ; 15
     (aset true rpg_tabs$ 18 )                               ; 18
     (aset true rpg_tabs$ 20 )                               ; 20
     (aset true rpg_tabs$ 23 )                               ; 23
     (aset true rpg_tabs$ 25 )                               ; 25
     (aset true rpg_tabs$ 80 )                               ; 80
                                       ; rpg input card   81-160
     (aset true rpg_tabs$ 81 )                               ; 1
     (aset true rpg_tabs$ 86 )                               ; 6
     (aset true rpg_tabs$ 95 )                               ; 15
     (aset true rpg_tabs$ 99 )                               ; 19
     (aset true rpg_tabs$ 101)                               ; 21
     (aset true rpg_tabs$ 105)                               ; 25
     (aset true rpg_tabs$ 108)                               ; 28
     (aset true rpg_tabs$ 112)                               ; 32
     (aset true rpg_tabs$ 115)                               ; 35
     (aset true rpg_tabs$ 119)                               ; 39
     (aset true rpg_tabs$ 124)                               ; 44
     (aset true rpg_tabs$ 128)                               ; 48
     (aset true rpg_tabs$ 132)                               ; 52
     (aset true rpg_tabs$ 139)                               ; 59
     (aset true rpg_tabs$ 141)                               ; 61
     (aset true rpg_tabs$ 143)                               ; 63
     (aset true rpg_tabs$ 145)                               ; 65
     (aset true rpg_tabs$ 147)                               ; 67
     (aset true rpg_tabs$ 149)                               ; 69
     (aset true rpg_tabs$ 151)                               ; 71
     (aset true rpg_tabs$ 160)                               ; 80
                                       ; rpg calc card   161-240
     (aset true rpg_tabs$ 161)                               ; 1
     (aset true rpg_tabs$ 166)                               ; 6
     (aset true rpg_tabs$ 169)                               ; 9
     (aset true rpg_tabs$ 178)                               ; 18
     (aset true rpg_tabs$ 188)                               ; 28
     (aset true rpg_tabs$ 193)                               ; 33
     (aset true rpg_tabs$ 203)                               ; 43
     (aset true rpg_tabs$ 209)                               ; 49
     (aset true rpg_tabs$ 212)                               ; 52
     (aset true rpg_tabs$ 214)                               ; 54
     (aset true rpg_tabs$ 216)                               ; 56
     (aset true rpg_tabs$ 218)                               ; 58
     (aset true rpg_tabs$ 220)                               ; 60
     (aset true rpg_tabs$ 240)                               ; 80
                                       ; rpg output card 241-320
     (aset true rpg_tabs$ 241)                               ; 1
     (aset true rpg_tabs$ 246)                               ; 6
     (aset true rpg_tabs$ 254)                               ; 14
     (aset true rpg_tabs$ 257)                               ; 17
     (aset true rpg_tabs$ 259)                               ; 19
     (aset true rpg_tabs$ 261)                               ; 21
     (aset true rpg_tabs$ 263)                               ; 23
     (aset true rpg_tabs$ 266)                               ; 26
     (aset true rpg_tabs$ 269)                               ; 29
     (aset true rpg_tabs$ 272)                               ; 32
     (aset true rpg_tabs$ 278)                               ; 38
     (aset true rpg_tabs$ 280)                               ; 40
     (aset true rpg_tabs$ 284)                               ; 44
     (aset true rpg_tabs$ 285)                               ; 45
     (aset true rpg_tabs$ 311)                               ; 71
     (aset true rpg_tabs$ 320)                               ; 80
                                       ; rpg ext card 321-400
     (aset true rpg_tabs$ 321)                               ; 1
     (aset true rpg_tabs$ 326)                               ; 6
     (aset true rpg_tabs$ 329)                               ; 9
     (aset true rpg_tabs$ 331)                               ; 11
     (aset true rpg_tabs$ 339)                               ; 19
     (aset true rpg_tabs$ 347)                               ; 27
     (aset true rpg_tabs$ 353)                               ; 33
     (aset true rpg_tabs$ 356)                               ; 36
     (aset true rpg_tabs$ 360)                               ; 40
     (aset true rpg_tabs$ 363)                               ; 43
     (aset true rpg_tabs$ 366)                               ; 46
     (aset true rpg_tabs$ 372)                               ; 52
     (aset true rpg_tabs$ 375)                               ; 55
     (aset true rpg_tabs$ 378)                               ; 58
     (aset true rpg_tabs$ 400)                               ; 80
                                       ; rpg header card 401-480
     (aset true rpg_tabs$ 401)                               ; 1
     (aset true rpg_tabs$ 406)                               ; 6
     (aset true rpg_tabs$ 421)                               ; 21
     (aset true rpg_tabs$ 452)                               ; 52
     (aset true rpg_tabs$ 475)                               ; 75
     (aset true rpg_tabs$ 480)                               ; 80
                                       ; rpg file card 481-560
     (aset true rpg_tabs$ 481)                               ; 1
     (aset true rpg_tabs$ 486)                               ; 6
     (aset true rpg_tabs$ 495)                               ; 15
     (aset true rpg_tabs$ 498)                               ; 18
     (aset true rpg_tabs$ 500)                               ; 20
     (aset true rpg_tabs$ 504)                               ; 24
     (aset true rpg_tabs$ 506)                               ; 26
     (aset true rpg_tabs$ 508)                               ; 28
     (aset true rpg_tabs$ 509)                               ; 29
     (aset true rpg_tabs$ 513)                               ; 33
     (aset true rpg_tabs$ 515)                               ; 35
     (aset true rpg_tabs$ 519)                               ; 39
     (aset true rpg_tabs$ 520)                               ; 40
     (aset true rpg_tabs$ 534)                               ; 54
     (aset true rpg_tabs$ 546)                               ; 66
     (aset true rpg_tabs$ 551)                               ; 71
     (aset true rpg_tabs$ 553)                               ; 73
     (aset true rpg_tabs$ 555)                               ; 75
     (aset true rpg_tabs$ 560)                               ; 80
     )

(defun rpg_help_header$ ( (column_number integer) &returns string )
  (if (< column_number 6) (return
" col 1-5 Numeric line sequence"))
  (if (< column_number 7) (return
" col 6 Card type - must be H for Header Spec"))
  (if (< column_number 21) (return
" col 7-20 Unimplemented on PR1ME"))
  (if (< column_number 22) (return
" col 21 Inverted Print - Date notation - Blank I J or D"))
  (if (< column_number 52) (return
" col 22-51 Unimplemented on PR1ME"))
  (if (< column_number 53) (return
" col 52 File assignment request - Blank or T (request files)"))
  (if (< column_number 75) (return
" col 53-74 Unimplemented on PR1ME"))
  (if (< column_number 81)
    (if (= (buffer_info (user language_name$)) "vrpg")
      (return " col 75-80 Program identification")
    else
      (return " col 75-80 Unimplemented on PR1ME")))
  (return
" Unimplemented on PR1ME"))

(defun rpg_help_file$ ( (column_number integer) &returns string )
  (if (< column_number 6) (return
" col 1-5 Numeric line sequence"))
  (if (< column_number 7) (return
" col 6 Card type - must be F for File Spec"))
  (if (< column_number 15) (return
" col 7-14 File Name"))
  (if (< column_number 16)
      (if (= (buffer_info (user language_name$)) "vrpg")
          (return " col 15 File Type entries - I O U C D ")
       else
          (return " col 15 File Type entries - I O U D ")))
  (if (< column_number 17) (return
" col 16 File Designation entries - P S C R T D or blank"))
  (if (< column_number 18) (return
" col 17 End of File entry - E or blank"))
  (if (< column_number 19) (return
" col 18 File Sequence - A D or blank"))
  (if (< column_number 20) (return
" col 19 File Format entries - F U or blank"))
  (if (< column_number 24) (return
" col 20-23 Block Length - numeric right just 0001-9999 - not implemented"))
  (if (< column_number 26) (return
" col 24-27 Record Length - numeric right just 0001-9999"))
  (if (< column_number 28)
      (if (= (buffer_info (user language_name$)) "vrpg")
          (return
" col 26-27 Key Number - numeric right just 00-17; 24-27 also Record Length")
       else
          (return
" col 24-27 Record Length - numeric right just 0001-9999")))
  (if (< column_number 29) (return
" col 28 Processing Mode entries - L R or blank"))
  (if (< column_number 31)
        (if (= (buffer_info (user language_name$)) "vrpg")
            (return
" col 29-30 Length of Key Field or Addrout File Record - num 01-32 right just")
         else
            (return " col 29-30 Length of Key Field - num 01-32 right just")))
  (if (< column_number 32)
        (if (= (buffer_info (user language_name$)) "vrpg")
            (return " col 31 Record Address Type - I A or blank")
         else
            (return " col 31 Record Address Type - not implemented")))
  (if (< column_number 33)
        (if (= (buffer_info (user language_name$)) "vrpg")
              (return " col 32 File Organization - I D T or blank")
          else
              (return " col 32 File Organization - I D or blank")))
  (if (< column_number 35) (return
" col 33-34 Overflow Indicator for Printer file - OA-OG OV or blank"))
  (if (< column_number 39) (return
" col 35-38 Key Start Field Indexed files - numeric 0001-9999 right just"))
  (if (< column_number 40) (return
" col 39 Extension - E, Line Counter - L, Multiple Keys - M, Duplicates - D"))
  (if (< column_number 47)
        (if (= (buffer_info (user language_name$)) "vrpg")
              (return
" col 40-46 Device entries Blank or DISK, PRINTER, CONSOLE, SPECIAL, FORMS")
          else
              (return
" col 40-46 Device entries Blank or DISK, PRINTER, CONSOLE, SPECIAL")))
  (if (< column_number 53) (return
" col 47-52 Unimplemented on PR1ME"))
  (if (< column_number 53) (return
" col 52 Continuation Character - K"))
  (if (< column_number 54) (return
" col 53 Continuation Line option - K or blank"))
  (if (< column_number 60)
        (if (= (buffer_info (user language_name$)) "vrpg")
            (return
" col 54-59 Name of Label Exit - subr-name (SPECIAL) or form-name (FORMS)")
         else
            (return " col 54-59 Name of Label Exit - subr-name (SPECIAL)")))
  (if (< column_number 66) (return
" col 60-65 Unimplemented on PR1ME"))
  (if (< column_number 67)
        (if (= (buffer_info (user language_name$)) "vrpg")
            (return " col 66 File Addition - U A or blank")
         else
            (return " col 66 File Addition - A or blank")))
  (if (< column_number 68) (return
" col 67 Key Definition Line option - K or blank"))
  (if (< column_number 71) (return
" col 68-70 Unimplemented on PR1ME"))
  (if (< column_number 73) (return
" col 71-72 File Condition - U1-U9 or blank"))
  (if (< column_number 75) (return
" col 73-74 Key of Reference - numeric right just 00-17"))
  (return
" col 75-80 Comments"))

(defun rpg_help_ext$ ( (column_number integer) &returns string )
  (if (< column_number 6) (return
" col 1-5 Numeric line sequence"))
  (if (< column_number 7) (return
" col 6 Card type - must be E for Extension Spec"))
  (if (< column_number 11) (return
" col 7-10 Undefined at PR1ME"))
  (if (< column_number 19) (return
" col 11-18 From Filename on file spec "))
  (if (< column_number 27) (return
" col 19-26 To Filename - Blank, or Input, Update or Output file"))
  (if (< column_number 33) (return
" col 27-32 Table or Array Name used in program"))
  (if (< column_number 36) (return
" col 33-35 Number Entries/Record - numeric < or = entries/table right just"))
  (if (< column_number 40) (return
" col 36-39 Number Entries/Table or Array - numeric right just"))
  (if (< column_number 43) (return
" col 40-42 Length of Entry - num right just, alpha 512 max, num 15 max"))
  (if (< column_number 44) (return
" col 43 Field Format - P B or blank"))
  (if (< column_number 45) (return
" col 44 Decimal Positions - 0-9 or blank"))
  (if (< column_number 46) (return
" col 45 Sequence entries - A D or blank"))
  (if (< column_number 52) (return
" col 46-51 Alternate Table or Array name"))
  (if (< column_number 55) (return
" col 52-54 Length of Entry in alternate table or array"))
  (if (< column_number 56) (return
" col 55 Field Format alternate table or array - P B or blank"))
  (if (< column_number 57) (return
" col 56 Decimal Position for alternate - 0-9 or blank"))
  (if (< column_number 58) (return
" col 57 Sequence of alternate - A D or blank"))
  (return
" col 58-80 Comments"))

(defun rpg_help_line$ ( (column_number integer) &returns string )
  (if (< column_number 6) (return
" col 1-5 Numeric line sequence"))
  (if (< column_number 7) (return
" col 6 Card type - must be L for Line Counter"))
  (if (< column_number 15) (return
" col 7-14 Line Counter Printer File Name"))
  (if (< column_number 18) (return
" col 15-17 Form Length if FL in 18-19 - num 1-112"))
  (if (< column_number 20) (return
" col 18-19 Form Length - FL indicates preceding entry is form length"))
  (if (< column_number 23) (return
" col 20-22 Line Number of the Overflow Line if OL in 23-24 - num 1-112"))
  (if (< column_number 25) (return
" col 23-24 Overflow Line - OL indicates preceding entry is overflow line"))
  (return
" col 25-80 Comments"))

(defun rpg_help_input$ ( (column_number integer) &returns string )
  (if (< column_number 6) (return
" col 1-5 Numeric line sequence"))
  (if (< column_number 7) (return
" col 6 Card type - must be I for Input Spec"))
  (if (< column_number 13)
      (if (= (buffer_info (user language_name$)) "vrpg")
          (return " col 7-14 Input spec File Name; col 7-12 Data Structure Name")
       else
          (return " col 7-14 Input spec File Name")))
  (if (< column_number 15) (return
  " col 7-14 Input spec File Name"))
  (if (< column_number 17) (return
" col 15-16 Sequence Checking - 2 digit num, or alpha (no sequence check)"))
  (if (< column_number 18) (return
" col 17 Number - used with sequence checking - 1 N or blank"))
  (if (< column_number 19)
      (if (= (buffer_info  (user language_name$)) "vrpg")
          (return
" col 18 Option (record type seq check) - blank or O; Local Data Area - U")
        else
        (return  " col 18 Option (record type sequence check) - blank or O ")))
  (if (< column_number 21)
      (if (= (buffer_info  (user language_name$)) "vrpg")
          (return
" col 19-20 Record Indicators - 01-99, L1-L9, LR, H1-H9, or '**'; or DS")
       else
   (return " col 19-20 Record Indicators - 01-99, L1-L9, LR, H1-H9, or '**'")))
  (if (< column_number 25) (return
" col 21-24 Record Identifying Position - numeric right just"))
  (if (< column_number 26) (return
" col 25 Record Identifying Character negate - N not char"))
  (if (< column_number 27) (return
" col 26 Record Identifying Type - C (char), Z (zone), D (decimal)"))
  (if (< column_number 28) (return
" col 27 Record Identifying Character"))
  (if (< column_number 32) (return
" col 28-31 Record Identifying Position - numeric right just"))
  (if (< column_number 33) (return
" col 32 Record Identifying Character negate - N not char"))
  (if (< column_number 34) (return
" col 33 Record Identifying Type - C (char), Z (zone), D (decimal)"))
  (if (< column_number 35) (return
" col 34 Record Identifying Character"))
  (if (< column_number 39) (return
" col 35-38 Record Identifying Position - numeric right just"))
  (if (< column_number 40) (return
" col 39 Record Identifying Character negate - N not char"))
  (if (< column_number 41) (return
" col 40 Record Identifying Type - C (char), Z (zone), D (decimal)"))
  (if (< column_number 42) (return
" col 41 Record Identifying Character"))
  (if (< column_number 43) (return
" col 42 Stacker Select - unimplemented on PR1ME"))
  (if (< column_number 44) (return
" col 43 Field Format - Blank (ascii), P (packed), B (binary)"))
  (if (< column_number 48) (return
" col 44-47 Field Location From - 0001-9999 numeric right just"))
  (if (< column_number 52) (return
" col 48-51 Field Location To - 0001-9999 numeric right just"))
  (if (< column_number 53) (return
" col 52 Decimal Position - Blank (alphanumeric) or 0-9 (numeric) right just"))
  (if (< column_number 59)
      (if (= (buffer_info  (user language_name$)) "vrpg")
          (return
" col 53-58 Field Name - Input record field; PAGE, PAGE1-PAGE7; DS subfield")
       else
(return " col 53-58 Field Name - Input record field; PAGE, PAGE1, PAGE2")))
  (if (< column_number 61) (return
" col 59-60 Control Level - Blank (no control) or L1-L9"))
  (if (< column_number 63) (return
" col 61-62 Matching fields - Blank (no matching) or M1-M9"))
  (if (< column_number 65) (return
" col 63-64 Field Record Relation - 01-99, L1-L9, MR, U1-U9, H1-H9"))
  (if (< column_number 67) (return
" col 65-66 Field Indicator - Blank (no test), 01-99, H1-H9 for > 0 (+)"))
  (if (< column_number 69) (return
" col 67-68 Field Indicator - Blank (no test), 01-99, H1-H9 for < 0 (-)"))
  (if (< column_number 71) (return
" col 69-70 Field Indicator - Blank (no test), 01-99, H1-H9 for 0 or BLANK"))
  (return
" col 71-80 Undefined at PR1ME"))

(defun rpg_help_output$ ( (column_number integer) &returns string )
  (if (< column_number 6) (return
" col 1-5 Numeric line sequence"))
  (if (< column_number 7) (return
" col 6 Card type - must be O for Output Spec"))
  (if (< column_number 14) (return
" col 7-14 File Name"))
  (if (< column_number 15) (return
" col 14-15 AND/OR conditions for indicators; 14 also part of filename"))
  (if (< column_number 16) (return
" col 15 Type - H D T E; 14-15 also AND/OR conditions for indicators"))
  (if (< column_number 17)
      (if (= (buffer_info  (user language_name$)) "vrpg")
          (return
" col 16 - F (fetch overflow); col 16-18 - ADD (add rec), DEL (delete rec)")
       else
          (return
" col 16 - F (fetch overflow), col 16-18 - ADD (add record)")))
  (if (< column_number 18) (return
" col 17 Space Before - # of lines numeric 0-3 or blank"))
  (if (< column_number 19) (return
" col 18 Space After - # of lines numeric 0-3 or blank"))
  (if (< column_number 21) (return
" col 19-20 Skip Before - skip # of lines 01-99, A0-A9, B0-B2"))
  (if (< column_number 23) (return
" col 21-22 Skip After - skip # lines 01-99, A0-A9, B0-B2"))
  (if (< column_number 24) (return
" col 23 Not indicator - negates indicator in col 24-25"))
  (if (< column_number 26) (return
" col 24-25 Indicator - any valid indicator - conditions output"))
  (if (< column_number 27) (return
" col 26 Not indicator - negates indicator in col 27-28"))
  (if (< column_number 29) (return
" col 27-28 Indicator - any valid indicator - conditions output"))
  (if (< column_number 30) (return
" col 29 Not indicator - negates indicator in col 30-31"))
  (if (< column_number 32) (return
" col 30-31 Indicator - any valid indicator - conditions output"))
  (if (< column_number 38) (return
" col 32-37 Field Name - previously defined name or special word (PAGE etc)"))
  (if (< column_number 39) (return
" col 38 Edit Code - 1 2 3 4 A B C D J K L M X Y Z"))
  (if (< column_number 40) (return
" col 39 Blank After - B or blank "))
  (if (< column_number 44) (return
" col 40-43 End Position - numeric right just"))
  (if (< column_number 45) (return
" col 44 Field Format - P (packed decimal), B (binary) or blank"))
  (if (< column_number 71) (return
" col 45-70 Constant or Edit Word - Literal or edit field entry"))
  (return
" col 71-80 Comments"))

(defun rpg_help_calc$ ( (column_number integer) &returns string )
  (if (< column_number 6) (return
" col 1-5 Numeric line sequence"))
  (if (< column_number 7) (return
" col 6 Card type - must be C for Calc Spec"))
  (if (< column_number 9) (return
" col 7-8 Control Level entries - L0, L1-L9, LR, SR, AN, OR"))
  (if (< column_number 10) (return
" col 9 Indicator Specifier - N for not Indicator"))
  (if (< column_number 12) (return
" col 10-11 Conditioning Indicator - any valid indicator except 1P or L0"))
  (if (< column_number 13) (return
" col 12 Indicator Specifier - N for not Indicator"))
  (if (< column_number 15) (return
" col 13-14 Conditioning Indicator - any valid indicator except 1P or L0"))
  (if (< column_number 16) (return
" col 15 Indicator Specifier - N for not Indicator"))
  (if (< column_number 18) (return
" col 16-17 Conditioning Indicator - any valid indicator except 1P or L0"))
  (if (< column_number 28) (return
" col 18-27 Factor1 - field on which operation is performed"))
  (if (< column_number 33) (return
" col 28-32 Operation Code - left justified"))
  (if (< column_number 43) (return
" col 33-42 Factor2 - field on which operation is performed"))
  (if (< column_number 49) (return
" col 43-48 Result Field - result of operation"))
  (if (< column_number 52) (return
" col 49-51 Field Entry - length: 1-15 (num) or 1-256 (alpha) right just"))
  (if (< column_number 53) (return
" col 52 Decimal Position - numeric 0-9 or blank"))
  (if (< column_number 54) (return
" col 53 Half Adjust - H (rounds result factor) or blank "))
  (if (< column_number 56) (return
" col 54-55 Result Indicator - tests HI, >, + and sets on indicator"))
  (if (< column_number 58) (return
" col 56-57 Result Indicator - tests LO, <, - and sets on indicator"))
  (if (< column_number 60) (return
" col 58-59 Result Indicator - tests EQ or ZERO and sets on indicator"))
  (return
" col 60-80 Comments"))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; rpg_only_once$                                                           ;;;
;;;   Set up keybindings for SUI users                                       ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun rpg_only_once$ ()
     (if (^ (null rpg_only_once$))(return))
     (fset 'pre_rpg_redisplay_hook$ (fsymeval 'redisplay_hook$))
     (fset 'pre_rpg_one_window$ (fsymeval 'one_window))
     (fset 'pre_rpg_split_window$ (fsymeval 'split_window))
     (fset 'pre_rpg_split_window_stay$ (fsymeval 'split_window_stay))
     (setq rpg_only_once$ 1)
     (change_select_buf$)
     (fset 'select_buf (fsymeval 'rpg_select_buf))
     (change_go_to_buffer$)
     (fset 'go_to_buffer (fsymeval 'rpg_go_to_buffer))
;     (change_mod_select_buf$)
;     (fset 'mod_select_buf (fsymeval 'rpg_mod_select_buf))
     (change_find_file$)
     (fset 'find_file (fsymeval 'rpg_find_file))
; setup initial switches if not set in user's ulib
     (if (null rpg_split_window$) (setq rpg_split_window$ true))
     (if (null rpg_full_template$) (setq rpg_full_template$ true))
     (if (null rpg_show_shadow$) (setq rpg_show_shadow$ true))
     (if (null rpg_help_sw$) (setq rpg_help_sw$ true))
     (if (null rpg_full_help_sw$) (setq rpg_full_help_sw$ true))
     (if (null rpg_force_old$) (setq rpg_force_old$ false))
     (make_rpg_tabs$)
; make some rpg tables and buffers
     (rpg_make_templates$)
     (make_rpg_plates$)
; setup key bindings
     (if (|
           (= keybinding$ "pt45")
           (= keybinding$ "pst100")
           (= keybinding$ "pt200")
         )
       (setq rpg_keybindings$ true))
     (if (null rpg_keybindings$)
         (fundamental_rpg_keybindings$); defined below.
     else
         (load_rpg_keybindings$))      ; defined below.
                                       ; and now continue, having done one of
                                       ; the above macros
     (set_mode_key "rpg" "^j" "rpg_cr$")
     (set_mode_key "rpg" rpg_tab_key$ "rpg_tab$")
     (select keybinding$
          "pt45"   (set_mode_key "rpg" btab$           "rpg_back_tab$")
          "pst100" (set_mode_key "rpg" backtab_pst100$ "rpg_back_tab$")
          "pt200"  (set_mode_key "rpg" back_tab_pt200$ "rpg_back_tab$"))
     (set_mode_key "rpg" rpg_help_key$ "rpg_full_help$")
     (if (= rpg_help_key$ "^[H")
       (set_mode_key "rpg" "^[h" "rpg_full_help$"))
     (set_mode_key "rpg" rpg_plate_key$ "rpg_template$")
     (set_mode_key "rpg" rpg_unplate_key$ "rpg_kill_template$"))

; load keybindings for fundamental mode user
(defun fundamental_rpg_keybindings$ ()
  (set_mode_key "rpg" "^j" "rpg_cr$")
  (if (null rpg_tab_key$) (setq rpg_tab_key$ "^i"))
  (if (null rpg_help_key$) (setq rpg_help_key$ "^[H"))  ; also ^[h
  (if (null rpg_plate_key$) (setq rpg_plate_key$ "^[^c"))
  (if (null rpg_unplate_key$) (setq rpg_unplate_key$ "^[^k"))
  (set_mode_key "rpg" rpg_tab_key$ "rpg_tab$")
  (set_mode_key "rpg" rpg_help_key$ "rpg_full_help$")
  (set_mode_key "rpg" rpg_plate_key$ "rpg_template$")
  (set_mode_key "rpg" rpg_unplate_key$ "rpg_kill_template$"))

; load keybindings for sui/suix mode user
(defun load_rpg_keybindings$ ()
    (setq rpg_tab_key$ "^I")
    (select keybinding$
         "pt45"
            (setq rpg_plate_key$ f4$)
            (setq rpg_unplate_key$ page$)
                                       ; THIS IS A CHANGE AT REV 20.
                                       ; The rpg_unplate_key$ used to be
                                       ; eaux$ BUT IT WAS DISPLACED BY
                                       ; THE SCROLL LEFT (horiz_right)
                                       ; FUNCTION FOR THIS TERMINAL!!
            (setq rpg_help_key$ f12$)
         "pst100"
            (setq rpg_plate_key$ pf08_pst100$)
            (setq rpg_unplate_key$ pf09_pst100$)
            (setq rpg_help_key$ help_pst100$)
         "pt200"
            (setq rpg_plate_key$ pf09_pt200$)
            (setq rpg_unplate_key$ spf09_pt200$)
            (setq rpg_help_key$ help_pt200$)
         )
                                       ; and now, time to handle the
                                       ; lm_forward_error_key$ and
                                       ; lm_prev_error_key$ assignments.
      (if (null lm_initialized$) (lm_init))
                                       ; Check existence of global var.
                                       ; lm_initialized.  If it doesn't exist
                                       ; we have to run it to get proper
                                       ; definition of lm_forward_error_key$
                                       ; and lm_prev_error_key$ strings.
                                       ; User can define them privately or
                                       ; if not, accept assignment to "^xn"
                                       ; and "^xp" respectively.
                                       ; lm_init is defined in COMPILE.EM
                                       ; Now with the key string definitions
                                       ; possibly default-accepted, it's
                                       ; OK to bind them to the proper
                                       ; functions for moving to errors
                                       ; in COBOL mode:
    (set_mode_key "rpg" lm_forward_error_key$ "lm_next_error$")
    (set_mode_key "rpg" lm_prev_error_key$ "lm_prev_error$")
                                       ; above 2 functions are also defined in
                                       ; COMPILE.EM
         )                             ; end of load_rpg_keybindings$ defun

(defun make_rpg_plates$ ()
  (setq blank_line "
                                                                                 ")
(save_position (with_no_redisplay
  (rpg_make_plate$ "input")
  (rpg_make_plate$ "output")
  (rpg_make_plate$ "ext")
  (rpg_make_plate$ "header")
  (rpg_make_plate$ "line")
  (rpg_make_plate$ "calc")
  (rpg_make_plate$ "file")
  (rpg_make_plate$ "ruler"))))

(defun rpg_make_plate$ ( (name string) )
  (select_buf (catenate ".?rpg_plate" (substr name 1 1)))
  (delete_buffer)
  (insert (eval (intern (catenate "rpg_" name "_plate$"))))
  (insert blank_line)
  (buffer_info changed_ok true)
  (buffer_info dont_show true)
  (buffer_info read_only true)   ; MAM 11/28/83
)

;<FOXTST>DNK>KEYMACS>SOURCES>RPG2.EM  Ed: DNK Sun 10 Jun 1984 12:47:29
; Last modified -- SUN, 10 JUN 1984 12:47:29
;END
