; TEXT.EM, EMACS*>EXTENSIONS>SOURCES, EMACS DEVELOPMENT, 04/04/89
; Miscellaneous text manipulation functions.
; Copyright (c) 1984, Prime Computer, Inc., Natick, MA 01760
;
;
; Description:
;
; Abnormal conditions:
;
; Implementation:
;
; Modifications:
;   Date   Engineer     Description of modification
; 04/04/89 Bugos        Modified center_line to avoid modification of the
;                       kill ring. (SPAR 4039587)
; 01/26/88 Bugos        Modified to make behavior of capinitial consistent with
;                       that of lowercase_word and uppercase_word for a numeric
;                       argument (repeat count) of 0. (SPAR 4024751)
; 03/19/85 Rand         Fixed capinitialf.
; 06/18/84 DNK          Renamed old defun lowercasef to be partial_lowercasef
;                       and renamed old defun uppercasef to be
;                       partial_uppercasef. Made the uppercase_word defcom
;                       move to the START of words before acting; same for the
;                       lowercase_word defcom. The old defuns are still around
;                       and still shared, but are NOT called anymore by their
;                       respective shared defcoms. The capinitial defcom was
;                       already "word-boundary-sensitive."
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; backward_clause        goes backward a clause at a time        ^x^z^a    ;;;
;;; backward_kill_clause   kills backward a clause                 ^x^z^h    ;;;
;;; backward_kill_line     kills from point to the beginning of    ^x^k      ;;;
;;; backward_kill_sentence kills a sentence backward               ^x^h      ;;;
;;; backward_para          goes backward a paragraph               ^x[       ;;;
;;; backward_sentence      goes back a sentence at a time          {esc}a    ;;;
;;; capinitial             changes a word to initial caps          {esc}c    ;;;
;;; center_line            centers a line within margins           ^x^zs     ;;;
;;; forward_clause         goes forward a clause at a time         ^x^z^e    ;;;
;;; forward_kill_clause    kills forward a clause                  ^x^z^k    ;;;
;;; forward_kill_sentence  kills a sentence forward                {esc}k    ;;;
;;;                        the line                                          ;;;
;;; forward_para           goes forward a paragraph                ^x]       ;;;
;;; forward_sentence       goes forward a sentence at a time       {esc}e    ;;;
;;; lowercase_region       changes a region to lowercase           ^x^l      ;;;
;;; lowercase_word         changes a word to lowercase             {esc}l    ;;;
;;; mark_end_of_word       puts a mark at end of word              {esc}@    ;;;
;;; mark_para              puts mark at the end of a paragraph     {esc}h    ;;;
;;;                        and  point at the begining                        ;;;
;;; transpose words        interchanges the positions of two words {esc}t    ;;;
;;; uppercase_region       changes a region to uppercase           ^x^u      ;;;
;;; uppercase_word         changes a word to uppercase             {esc}u    ;;;
;;;                                                                          ;;;

;;; Global Variables removed: clause_scan_table$, sentence_scan_table$               ;;;

; 02/03/83 Zane              (setq clause_scan_table$ ",.;:?!(){}[]")
; 02/03/83 Zane              (setq sentence_scan_table$  ".?!")

; [these are initialized elsewhere]

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; backward_para                                                            ;;;
;;;     This command places point at the beginning of the current paragraph. ;;;
;;;     Paragraphs are defined as lines beginning with a period, a blank line;;;
;;;     or lines beginning with a space.  If there is no paragraph break,    ;;;
;;;     point is placed at the beginning of the buffer.  Bound as {esc}[.    ;;;
;;;                                                                          ;;;
;;;         (backward_para arg)                                              ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom backward_para
     &doc "Move backward a paragraph"
     &na (&pass count &default 1)
     (if (> count 0)
          (backward_paraf count)
      else
          (forward_paraf (- count))))

(defun backward_paraf (&optional (count integer))
     (if (null count) (setq count 1))
     (do_n_times count
          (prev_line)
          (do_forever
               (if_at "." (stop_doing))
               (if_at " " (prev_line) (stop_doing))
               (if (line_is_blank) (stop_doing))
               (if (beginning_of_buffer_p) (stop_doing))
               (prev_line) ) ) )




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; forward_para                                                             ;;;
;;;     This command places point at the end of the current paragraph.       ;;;
;;;     Paragraphs are defined as lines beginning with a period, a blank line;;;
;;;     or lines beginning with a space.  If there is no paragraph break,    ;;;
;;;     point is placed at the end of the buffer.  It is bound as {esc}].    ;;;
;;;                                                                          ;;;
;;;         (forward_para arg)                                               ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom forward_para
     &doc "Move forward a paragraph"
     &na (&pass count &default 1)
     (if (> count 0)
          (forward_paraf count)
      else
          (backward_paraf (- count))))

(defun forward_paraf (&optional (count integer))
     (if (null count) (setq count 1))
     (do_n_times count
          (next_line)
          (do_forever
               (if_at "." (stop_doing))
               (if_at " " (stop_doing))
               (if (line_is_blank) (stop_doing))
               (if (lastlinep)
                   (move_bottom)
                   (end_line)
                   (cr)
                   (stop_doing))
               (next_line))))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; mark_para                                                                ;;;
;;;     This command puts a mark at the end of a paragraph and               ;;;
;;;     point at the beginning.  It is bound as {esc}h.                      ;;;
;;;                                                                          ;;;
;;;         (mark_para optional-integer)                                     ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom mark_para
     &doc "Marks a paragraph"
     &na (&pass count &default 1)
     (if (> count 0)
         (backward_paraf)
      else
         (forward_paraf))
     (mark)
     (forward_para count))




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; backward_sentence                                                        ;;;
;;;    This command places point before the beginning of the current sentence;;;
;;;    It is bound as {esc}a.                                                ;;;
;;;                                                                          ;;;
;;;         (backward_sentence arg)                                          ;;;
;;;                                                                          ;;;
;;;         (if (backward_sentencef arg) ... )                               ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom backward_sentence
     &doc "Goes back a sentence at a time"
     &na (&pass count &default 1)
     (if (> count 0)
          (do_n_times count (backward_sentencef))
      else
          (do_n_times (- count) (forward_sentencef))))

(defun backward_sentencef (&returns boolean)
     (back_char 2)
     (if (search_charset_backward sentence_scan_table$)
         (if (not (beginning_of_buffer_p))
             (forward_char))
         (return true)
      else
          (move_top)
          (return false)))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; forward_sentence                                                         ;;;
;;;    This command places point at the end of the current sentence.         ;;;
;;;    It is bound as {esc}e.                                                ;;;
;;;                                                                          ;;;
;;;         (forward_sentence arg)                                           ;;;
;;;                                                                          ;;;
;;;         (if (forward_sentencef arg) ... )                                ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom forward_sentence
     &doc "Goes forward a sentence at a time"
     &na (&pass count &default 1)
     (if (> count 0)
          (do_n_times count (forward_sentencef))
      else
          (do_n_times (- count) (backward_sentencef))))

(defun forward_sentencef (&returns boolean)
     (if (search_charset_forward sentence_scan_table$)
         (forward_char)
         (return true)
      else
          (move_bottom)
          (return false)))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; backward_kill_sentence                                                   ;;;
;;;     This command kills from point back to the begining of a sentence.    ;;;
;;;     It is bound as ^x^h.                                                 ;;;
;;;                                                                          ;;;
;;;         (backward_kill_sentence arg)                                     ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom backward_kill_sentence
     &doc "Kills a sentence backwards"
     &na (&pass count &default 1)
     (mark)
     (backward_sentence count)
     (kill_region))




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; forward_kill_sentence                                                    ;;;
;;;     This command kills from point to the end of a sentence.              ;;;
;;;     It is bound as {esc}k.                                               ;;;
;;;                                                                          ;;;
;;;         (forward_kill_sentence arg)                                      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom forward_kill_sentence
     &doc "Kills a sentence forwards"
     &na (&pass count &default 1)
     (mark)
     (forward_sentence count)
     (kill_region))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; backward_kill_line                                                       ;;;
;;;     This command kills from point back to the beginning of the line.     ;;;
;;;     It is bound as ^x^k.                                                 ;;;
;;;                                                                          ;;;
;;;         (backward_kill_line)                                             ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom backward_kill_line
    &doc "Kills to the beginning of line"
    (kill_line 0) )



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; backward_clause                                                          ;;;
;;;    Command that places point before the beginning of the current clause. ;;;
;;;    This is normally bound as ^x^z^a.                                     ;;;
;;;                                                                          ;;;
;;;         (backward_clause optional-arg)                                   ;;;
;;;                                                                          ;;;
;;;         (if (backward_clausef optional-arg) ... )                        ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom backward_clause
     &doc "Goes backward a clause at a time"
     &na (&pass count &default 1)
     (if (> count 0)
          (backward_clausef count)
      else
          (forward_clausef (- count))))

(defun backward_clausef (&optional (count integer)
                         &local    (start cursor)
                         &returns boolean)
     (if (null count) (setq count 1))
     (do_n_times count
         (back_char)
         (setq start (copy_cursor current_cursor))
         (if (search_charset_backward clause_scan_table$)
             (if (= current_cursor start)
                 (if (beginning_of_buffer_p) (return false))
                 (backward_clausef)
              else
                 (back_char))
          else
             (move_top)
             (return false)))
      (return true))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; forward_clause                                                           ;;;
;;;    Command that places point at the end of the current clause.           ;;;
;;;    This is normally bound as ^x^z^e.                                     ;;;
;;;                                                                          ;;;
;;;         (forward_clause optional-arg)                                    ;;;
;;;                                                                          ;;;
;;;         (if (forward_clausef optional-arg) ... )                         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom forward_clause
     &doc "Goes forward a clause at a time"
     &na (&pass count &default 1)
     (if (> count 0)
          (forward_clausef count)
      else
          (backward_clausef (- count))))

(defun forward_clausef (&optional (count integer)
                        &local    (start cursor)
                        &returns boolean)
     (if (null count) (setq count 1))
     (do_n_times count
         (forward_char)
         (setq start (copy_cursor current_cursor))
         (if (search_charset_forward clause_scan_table$)
             (if (= current_cursor start)
                 (if (end_of_buffer_p) (return false))
                 (forward_clausef)
              else
                 (forward_char))
          else
             (move_bottom)
             (return false)))
      (return true))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; backward_kill_clause                                                     ;;;
;;;    Command that kills from point to the beginning of the current clause. ;;;
;;;    This is normally bound as ^x^z^h.  (^h is backspace.)                 ;;;
;;;                                                                          ;;;
;;;         (backward_kill_clause arg)                                       ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom backward_kill_clause
     &doc "Kills backward a clause at a time"
     &na (&pass count &default 1)
     (if (> count 0)
          (backward_kill_clausef count)
      else
          (forward_kill_clausef (- count))))

(defun backward_kill_clausef (&optional (count integer))
     (mark)
     (if (null count) (setq count 1))
     (backward_clausef count)
     (forward_char 2)
     (kill_region))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; forward_kill_clause                                                      ;;;
;;;    Command that kills from point to the end of the current clause.       ;;;
;;;    This command is normally bound as ^x^z^k.                             ;;;
;;;                                                                          ;;;
;;;         (forward_kill_clause arg)                                        ;;;
;;;                                                                          ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom forward_kill_clause
     &doc "Kills forward a clause at a time"
     &na (&pass count &default 1)
     (if (> count 0)
          (forward_kill_clausef count)
      else
          (backward_kill_clausef (- count))))

(defun forward_kill_clausef (&optional (count integer))
     (mark)
     (if (null count) (setq count 1))
     (forward_clausef count)
     (kill_region))




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; center_line                                                              ;;;
;;;     This command centers a line of text.  It doesn't matter where        ;;;
;;;     you are when you do this.  This is bound as {esc}s.                  ;;;
;;;                                                                          ;;;
;;;         (center_line arg)                                                ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom center_line
    &doc "Center the current line"
    &na (&pass count &default 1)
    (center_linef count))

(defun center_linef (&optional (count integer)
                     &local (text string)
                            (wrap_column integer)
                            (direction integer))
     (if (null count) (setq count 1))
     (if (< count 0)
         (setq direction -1)
         (setq count (- count))
      else
         (setq direction 1))
     (if (| (null (buffer_info fill_column)) (= (buffer_info fill_column) 0))
         (buffer_info fill_column 70)
         (info_message "Filling was not on, column has been set to 70"))
     (do_n_times count
          (setq text (trim (current_line)))
          (begin_line)
          (mark)
          (end_line)
          (delete_region)
          (whitespace_to_hpos (/ (- (buffer_info fill_column) (string_length text)) 2))
          (insert text)
          (if (< direction 0)
              (prev_line)
           else
              (next_line))))




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; transpose_word                                                           ;;;
;;;    This command inverts the word after point with the word before        ;;;
;;;    point.  It is bound as {esc}t                                         ;;;
;;;                                                                          ;;;
;;;         (transpose_word)                                                 ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom transpose_word
     &doc "Interchanges the position of two words"
     (transpose_wordf))

(defun transpose_wordf (&local (word1 string)
                               (sep string)
                               (word2 string))
    (if (| (beginning_of_buffer_p) (end_of_buffer_p)) (return))
    (forward_word)
    (back_word)
    (do_forever
          (back_char)
          (if_at " " (forward_char) (stop_doing))
          (if_at "~n" (forward_char) (stop_doing))
          (if (beginning_of_buffer_p) (stop_doing)))
    (with_cursor here
         (forward_word)
         (do_forever
               (if_at " " (stop_doing))
               (if_at "~n" (stop_doing))
               (if_at "." (stop_doing))
               (if_at "," (stop_doing))
               (if_at "?" (stop_doing))
               (if (end_of_buffer_p) (stop_doing))
               (forward_char))
         (setq word1 (point_cursor_to_string here))
         (delete_point_cursor here))
    (with_cursor here
         (back_word)
         (forward_word)
         (do_forever
               (if_at " " (stop_doing))
               (if_at "~n" (stop_doing))
               (if (end_of_buffer_p) (stop_doing))
               (forward_char))
         (setq sep (point_cursor_to_string here))
         (delete_point_cursor here))
     (with_cursor here
         (back_word)
         (do_forever
              (back_char)
              (if_at " " (forward_char) (stop_doing))
              (if_at "~n" (forward_char) (stop_doing))
              (if (beginning_of_buffer_p) (stop_doing)))
         (setq word2 (trim (point_cursor_to_string here)))
         (delete_point_cursor here))
     (insert (catenate word1 sep word2))
     (back_word))








;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; mark_end_of_word                                                         ;;;
;;;     This command places a mark at the end of the curent word and leaves p;;;oint
;;;     alone.  Bound as {esc}@.                                             ;;;
;;;                                                                          ;;;
;;;         (mark_end_of_word)                                               ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom mark_end_of_word
    &doc "Places a mark at the end of the current word"
    (mark)
    (forward_word)
    (exchange_mark))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; lowercase_word                                                           ;;;
;;;     This command changes the text from the beginning of the current word ;;;
;;;     into lower case.  It also returns the altered text. It is            ;;;
;;;     bound as {esc}u.                                                     ;;;
;;;                                                                          ;;;
;;;         (lowercase_word optional-arg)                                    ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom lowercase_word
     &doc "Changes a full word into lowercase"
     &na (&pass count &default 1)
     (let ((start (copy_cursor current_cursor))
           (word ""))
          (if (< count 1)
              (back_word (setq count (- count)))
           else
              (forward_word) (back_word))
          (with_cursor here
              (forward_word count)
              (setq word (downcase (point_cursor_to_string here)))
              (delete_point_cursor here))
         (insert word)
         (if (< current_cursor start)
              (go_to_cursor start))))

(defun partial_lowercasef (&optional (count integer)
                                       ; This is the ORIGINAL defun, now
                                       ; unused, but shared and available
                   &local    (word string)
                   &returns  string)
     (if (null count) (setq count 1))
     (with_cursor here
          (forward_word count)
          (setq word (downcase (point_cursor_to_string here)))
          (delete_point_cursor here))
     (insert word)
     (return word))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; lowercase_region                                                         ;;;
;;;     This command changes a region into lowercase.  It is bound as ^x^l.  ;;;
;;;                                                                          ;;;
;;;         (lowercase_region)                                               ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom lowercase_region
     &doc "Convert region to lower case"
     (let ((text (point_cursor_to_string (buffer_info mark))))
          (delete_point_cursor (buffer_info mark))
          (create_text_save_buffer$ text)
          (back_char (string_length (insert (downcase text)))))
     (exchange_mark))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; uppercase_word                                                           ;;;
;;;     This command changes the text from the beginning of the current word ;;;
;;;     into upper case.  It also returns the altered text. It is            ;;;
;;;     bound as {esc}u.                                                     ;;;
;;;                                                                          ;;;
;;;         (uppercase_word optional-arg)                                    ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom uppercase_word
     &doc "Changes a full word into uppercase"
     &na (&pass count &default 1)
     (let ((start (copy_cursor current_cursor))
           (word ""))
          (if (< count 1)
              (back_word (setq count (- count)))
           else
              (forward_word) (back_word))
          (with_cursor here
              (forward_word count)
              (setq word (upcase (point_cursor_to_string here)))
              (delete_point_cursor here))
         (insert word)
         (if (< current_cursor start)
              (go_to_cursor start))))

(defun partial_uppercasef (&optional (count integer)
                                       ; This is the ORIGINAL defun, now
                                       ; unused, but shared and available
                   &local    (word string)
                   &returns  string)
     (if (null count) (setq count 1))
     (with_cursor here
          (forward_word count)
          (setq word (upcase (point_cursor_to_string here)))
          (delete_point_cursor here))
      (insert word)
      (return word))




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; uppercase_region                                                         ;;;
;;;    This command converts a region to uppercase.  It is bound as ^x^u.    ;;;
;;;                                                                          ;;;
;;;         (uppercase_region)                                               ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom uppercase_region
     &doc "Convert region to upper case"
     (let ((text (point_cursor_to_string (buffer_info mark))))
          (delete_point_cursor (buffer_info mark))
          (create_text_save_buffer$ text)
          (back_char (string_length (insert (upcase text)))))
     (exchange_mark))




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; capinitial                                                               ;;;
;;;    This command initial caps a word.  It is bound as {esc}c.             ;;;
;;;                                                                          ;;;
;;;         (capinitial optional-integer)                                    ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defcom capinitial
     &doc "Capitalizes the initial letter of a word"
     &na (&pass count &default 1)
     (capinitialf count))

(defun capinitialf ((count integer) &local (word string))
       (if (= count 0) (return))
       (if (< count 1)
           (back_word (setq count (- count))))
       (do_n_times count
                   (forward_word) (back_word)
                   (self_insert (upcase (current_character)))
                   (delete_char)
                   (if (= (index (catenate clause_scan_table$
                                           sentence_scan_table$
                                           " ~n")
                                 (current_character))
                           0)
                       (mark)
                       (forward_word)
                       (lowercase_region))
                   )
       (back_word)
       (forward_word)
       )

