;  SUI_HELP.EM,  EMACS*>EXTENSIONS>SUI>SOURCES, EMACS TEAM-DNK, 06/20/84
;  Standard User Interface for PT45, PST100, and PT200 terminals: HELP system.
;  Copyright (c) 1984, Prime Computer, Inc., Natick, MA 01760

;  NOTE THE pathname$ VARIABLE SETTING ADDED TO (defcom help) --
;  IT'S AN IMPORTANT GLOBAL VARIABLE.

(defun set_windows$ ()
    (setq now_in_sui_help$ true)       ; global variable that is TRUE as
                                       ; long as user has any HELP on screen.
                                       ; It may be FALSE or undefined elsewhere.
    (setq was_two_windows$  false)     ; set some other globals
    (setq switched_windows$ false)
    (setq bottom_window_column_offset$ 1)
    (setq top_window_column_offset$ 1)
                                       ; now see if they can stay that way.
                                       ; At this point we don't yet know whether
                                       ; we are on the top or bottom of screen.
    (if (= (major_window_count) 2)
        (setq was_two_windows$ true)   ; remember that there were
                                       ; two windows on the screen when the
                                       ; user called for HELP
        (if (^= (window_info top_line) 1)
                                       ; in this case, use has called HELP
                                       ; from the BOTTOM window
            (setq switched_windows$ true)
                                       ; remember that fact
            (mod_other_window)         ; Now go to what we now know
                                       ; is the top window.
                                       ; This will be the one used for HELP.
            )                          ; end of the IF concerning
                                       ; window_info top_line.
                                       ; If execution resumes here:
                                       ; No, the user didn't call from bottom.
        (mod_other_window)             ; go to the bottom
        (setq bottom_window_column_offset$ (window_info column_offset))
        (mod_other_window)             ; go back to the top window
        (one_file_mode)                ; And now wipe out other window!
    )                                  ; end of IF concerning major_window_count
                                       ; Whew, that's a relief.  User only
                                       ; had 1 window onscreen when s/he called.
                                       ; At any rate remember TOP offset:
        (setq top_window_column_offset$ (window_info column_offset))
        (window_info column_offset 1)
                                       ; now fix this TOP window's offset as 1,
                                       ; so that the HELP material can be seen.
        )                              ; end of defun set_windows$

(defun restore_windows$ ()
    (setq now_in_sui_help$ false)      ; reset the global variable used by
                                       ; sui_help_key_mb_response$ macro
    (if (not was_two_windows$)         ; if this was the SINGLE starting window:
    (with_no_redisplay
    (window_info column_offset top_window_column_offset$)
                                       ; Restore the original offset.
    )                                  ; OK to think about showing things
    (sui_refresh)                      ; And now force the new picture out!
    (return)                           ; Now get out; we're done.
    )                                  ; end of the if that did the
                                       ; checking on was_two_windows$.
                                       ; If we continue, there WERE two windows.
  (with_no_redisplay                   ; wait till the screen settles...
    (two_file_mode)                    ; If there WERE 2 windows at calling
                                       ; time, put back, and GO TO,
                                       ; the OTHER window. (The "go to" is
                                       ; provided by the two_file_mode macro).
    (window_info column_offset bottom_window_column_offset$)
                                       ; Then restore ITS original offset.
    (mod_other_window)                 ; Now go to what we now know must be
                                       ; the top window
    (window_info column_offset top_window_column_offset$)
                                       ; and fix ITS offset.
    (if switched_windows$              ; Decide whether to stay there.
        (mod_other_window)             ; return to the BOTTOM window
        )                              ; IF we started from there.
  )                                    ; end of with_no_redisplay
(sui_refresh)                          ; Now FORCE adjusted picture out!
)                                      ; end of defun restore_windows$

(defcom sui_help_key_mb_response$      ; for use when user presses HELP
                                       ; while already in the MiniBuffer
    &doc "HELP keybinding when user is in the MiniBuffer"

  (if now_in_sui_help$                 ; check the global variable
                                       ; do the following if TRUE
    (info_message
    "You are already in the SUI HELP function.  (You can exit with CONTROL-G)")
    (sleep_for_n_milliseconds sui_info_message_time$)
    (info_message "")                  ; clear it out to avoid confusing
                                       ; the user...
  else                                 ; but if global variable is FALSE
                                       ; (or undefined, as yet)
    (unused_mb_key_feedback$)          ; do the general feedback.
    )                                  ; end of check on the global variable
)                                      ; end of sui_help_key_mb_response$

(defcom help
   &doc "SUI: Help command"
   (restrict_to_sui$)
   (info_message "HELP is on the way...")

   (setq pathname$ "EMACS*>INFO>")     ; This USED to be done in SUI_INIT.EM,
                                       ; but now must be set here!!

   (setq used_graphics_this_time$ false)
                                       ; if we have reached this level
                                       ; of the menuing,
                                       ; the command_abort_handler on defcom
                                       ; help need not repaint the screen.

   (setq minimum_speed_for_graphics$ 1201)

(if (and
         (or
           (= keybinding$ "pst100")
           (= keybinding$ "pt200")
           )
         (> (terminal_info speed) minimum_speed_for_graphics$)
         )
    (setq do_graphics$ true)
    else
    (setq do_graphics$ false)
    )                                  ; now do_graphics is a boolean
                                       ; that gates whether we bother the
                                       ; user with PST100/PT200 graphics stuff

   (with_command_abort_handler
      (set_windows$)
      (save_position
          (with_no_redisplay
              (go_to_buffer ".help_top_menu")
                                       ; use . to obey convention that
                                       ; buffernames starting with . are
                                       ; internal
              (buffer_info dont_show true)
                                       ; conceal this buffer in ^X^B listings
              (delete_buffer)
              )                        ; end of with_no_redisplay
                   (menu_top$)         ; put up top-level menu
              (move_top)
              (unmodify)
              (info_message "")
                                       ; clear the minibuffer area

          (do_forever
              (minibuffer_print "RETURN = exit this level")
              (setq choice$ (vivid_prompt))
              (minibuffer_print "")
              (select choice$
                      "1"     (key_map)
                      "2"     (help_explain)
                      "3"     (unused_key_feedback$)
                      "4"     (unused_key_feedback$)
                      "5"     (unused_key_feedback$)
                      "6"     (unused_key_feedback$)
                      "7"     (unused_key_feedback$)
                      "8"     (unused_key_feedback$)
                      "9"     (unused_key_feedback$)
                      "0"     (unused_key_feedback$)
                      otherwise
                              (stop_doing))

        )
                                       ; end of do_forever
       (info_message "HELP finishing...")
                                       ; add some message to keep
                                       ; from trashing the first line of the
                                       ; display.
        )                              ; end of save_position; return now.

        (restore_windows$)             ; and that's all for a normal exit.

    command_abort_handler              ; But if user ABORTS out:

       (info_message "HELP being terminated...")
                                       ; add something to keep
                                       ; from trashing the first line of the
                                       ; display

       (restore_windows$)
       )                               ; end of with_command_abort_handler

       (info_message "HELP done.")     ; clear out all the garbage messages
       (sleep_for_n_milliseconds 1000)
       (info_message "")               ; but don't leave them around
       )                               ; end of defcom help

(defun key_map ()
      (setq used_graphics_this_time$ false)
                                       ; if we have reached this level
                                       ; of the menuing,
                                       ; the command_abort_handler on defcom
                                       ; help need not repaint the screen.
      (save_position
          (with_no_redisplay
              (go_to_buffer ".key_maps")
              (buffer_info dont_show true)
                                       ; conceal this buffer in ^X^B listings
              (delete_buffer)
              (select keybinding$      ; put up the two different map menus
                   "pt45"
                        (pt45_menu1$)
                   "pst100"
                        (pst100_menu1$)
                   "pt200"
                        (pt200_menu1$)
                   )
              (move_top)
              (unmodify)
              (info_message "")
                                       ; clear the minibuffer area
              )                        ; end of with_no_redisplay

          (do_forever
              (minibuffer_print "RETURN = exit this level")
              (setq choice$ (vivid_prompt))
              (minibuffer_print "")
              (select keybinding$
                   "pt45"
                        (select choice$
                             "1"     (help_template "1")
                             "2"     (help_template "2")
                             "3"     (unused_key_feedback$)
                             "4"     (unused_key_feedback$)
                             "5"     (unused_key_feedback$)
                             "6"     (unused_key_feedback$)
                             "7"     (unused_key_feedback$)
                             "8"     (unused_key_feedback$)
                             "9"     (unused_key_feedback$)
                             "0"     (unused_key_feedback$)
                              otherwise
                                     (stop_doing))
                   "pst100"
                        (select choice$
                             "1"     (help_template "1")
                             "2"     (help_template "2")
                             "3"     (help_template "3")
                             "4"     (help_template "4")
                             "5"     (unused_key_feedback$)
                             "6"     (unused_key_feedback$)
                             "7"     (unused_key_feedback$)
                             "8"     (unused_key_feedback$)
                             "9"     (unused_key_feedback$)
                             "0"     (unused_key_feedback$)
                              otherwise
                                     (stop_doing))
                   "pt200"
                        (select choice$
                             "1"     (help_template "1")
                             "2"     (help_template "2")
                             "3"     (help_template "3")
                             "4"     (help_template "4")
                             "5"     (unused_key_feedback$)
                             "6"     (unused_key_feedback$)
                             "7"     (unused_key_feedback$)
                             "8"     (unused_key_feedback$)
                             "9"     (unused_key_feedback$)
                             "0"     (unused_key_feedback$)
                              otherwise
                                     (stop_doing))
                   )                   ; end of keybinding$ select
        (if do_graphics$ (sui_refresh))
                                       ; restore PST100/PT200 screen video

              )                        ; end of do_forever

       )                               ; end of save_position

       )                               ; end of key_map defun

(defun header_cut$ ()                  ; purpose: erase the PRIMOS standard
                                       ; headers that have to be atop the
                                       ; info files used in the HELP system
 (with_no_redisplay                    ; attempt to stop cutting from being
                                       ; visible
    (mark)                             ; since cursor is left at the start of
                                       ; the inserted file, remember the place
    (do_n_times 3 (next_line_command)) ; puts us at start of the fourth line
                                       ; now can delete the 3-line header
    (delete_region)                    ; don't want it popping back from YANK
    (unmodify)                         ; ignore any changes to this buffer
    )                                  ; end of with_no_redisplay
    )                                  ; end of defun header_cut$

(defun help_explain ()
   (setq used_graphics_this_time$ false)
                                       ; if we have reached this level
                                       ; of the menuing,
                                       ; the command_abort_handler on defcom
                                       ; help need not repaint the screen.
   (save_position
         (with_no_redisplay
               (go_to_buffer ".key_functions")
               (buffer_info dont_show true)
               (delete_buffer)
               (menu2$)          ; add the appropriate function here
               (unmodify)
               (move_top)
               (info_message "")
                                       ; clear the minibuffer area
               (redisplay))
         (do_forever
             (minibuffer_print "RETURN = exit this level")
             (setq choice$ (vivid_prompt))
             (select choice$
                     "1"     (explain_it (catenate
                              keybinding$ "_cursor_positioning"))
                     "2"     (explain_it "word_char")
                     "3"     (explain_it "delete_line")
                     "4"     (explain_it "searching")
                     "5"     (explain_it "searching_and_replacing")
                     "6"     (explain_it "mark_cut_paste")
                     "7"     (explain_it "tab")
                     "8"     (explain_it "find_file")
                     "9"     (explain_it "insert_file")
                     "10"    (explain_it "two_file_mode")
                     "11"    (explain_it "write_file")
                     "12"    (explain_it "save_file")
                     "13"    (explain_it (catenate
                              keybinding$ "_horiz_scrolling"))
                     "14"    (explain_it (catenate
                              keybinding$ "_help"))
                     "15"    (explain_it "extend_command")
                     "16"    (explain_it (catenate
                             keybinding$ "_control_escape_cmds"))
                     "17"    (explain_it "sui_vs_suix")
                     "18"    (explain_it "sui_as_wp")
                   otherwise
                             (return))))
)                                      ; end of defun help_explain

(defun explain_it ((fname string))     ; THIS MACRO USES THE FILES
                                       ; STORED IN THE pathname$ DIRECTORY
    (save_position
        (with_no_redisplay
             (go_to_buffer (catenate "." fname "_info"))
                                       ; add . to make this an internal buffer
             (buffer_info dont_show true)
                                       ; conceal this buffer in ^X^B listings
             (delete_buffer)
             (insert_file (catenate pathname$  fname "_info"))
             (header_cut$)
             (info_message "")
                                       ; clear the minibuffer area of the "file
                                       ; read" message
             (redisplay))
        (prompt "RETURN = exit this level"))
)                                      ; end of defun explain_it

(defun help_template ((function_display string))
    (save_position
      (with_no_redisplay
        (go_to_buffer ".specific_key_maps")
        (buffer_info dont_show true)
                                       ; conceal this buffer in ^X^B listings
        (delete_buffer)                ; delete any previous contents,
        )                              ; and turn redisplay back on

        (select keybinding$
              "pt45"
              (select function_display
                   "1"
                   (pt45_a1$)
                   "2"
                   (pt45_a2$)
                   )
              (unmodify)               ; ignore any changes here

              "pst100"
              (setq used_graphics_this_time$ true)
                                       ; remember that we're messing up
                                       ; the screen in case user aborts
                                       ; from here.  See abort_handler on
                                       ; defcom help.
              (select function_display
                   "1"
                   (pst100_a1$)
                   (move_top)          ; make sure entire buffer is visible
                   "2"
                   (pst100_a2$)
                   (move_top)
                   "3"
                   (pst100_a3$)
                   (move_top)
                   "4"
                   (pst100_a4$)
                   (move_top))
              (unmodify)               ; ignore any changes here

              "pt200"
              (setq used_graphics_this_time$ true)
                                       ; remember that we're messing up
                                       ; the screen in case user aborts
                                       ; from here.  See abort_handler on
                                       ; defcom help.
              (select function_display
                   "1"
                   (pt200_a1$)
                   (move_top)          ; make sure entire buffer is visible
                   "2"
                   (pt200_a2$)
                   (move_top)
                   "3"
                   (pt200_a3$)
                   (move_top)
                   "4"
                   (pt200_a4$)
                   (move_top))
              (unmodify)               ; ignore any changes here
                                       ; End of stuff needed for PT200
        )                              ; End of keybinding$ specific select                                         ;
        (redisplay)                    ; force screen to be shown now

        (select keybinding$            ; now continue...

              "pt45"                   ; do the rest of the macro ONLY when
                                       ; driving a pt45

        (move_bottom)                  ; so we can continue adding stuff to
                                       ; the screen from where we left off
        (redisplay)
        (pt45_grph_on)                 ; now go into PT45's graphics mode
        (select function_display
              "1"
                   (pt45_b1$)
              "2"
                   (pt45_b2$)
              )
        (move_bottom)
        (redisplay)                    ; force current image out now
        (pt45_grph_off)
         (select function_display
              "1"
                   (pt45_c1$)
              "2"
                   (pt45_c2$)
              )

        (info_message "")
                                       ; clear the minibuffer area
        (move_top)
        (redisplay)                    ; force it out now
        (unmodify)                     ; ignore any changes here
        )                              ; END OF PT45-specific select

        (setq choice$ (prompt "RETURN = exit this level"))

        (delete_buffer)                ; now empty the buffer
        (unmodify)                     ; ignore any changes here
        )                              ; end of save_position
        (setq used_graphics_this_time$ false)
                                       ; if we have reached this level
                                       ; of the menuing,
                                       ; the command_abort_handler on defcom
                                       ; help need not repaint the screen.
)                                      ; end of defun help_template

(defun vivid_prompt (&local   (response string)
                        &returns string)
        (do_forever
            (select keybinding$
              "pt45"
                   (send_raw_string "~c[F6 ~c[dP~c[F6<~c[dQ")
             "pst100"
                   (send_raw_string "~c[[23;0H")
                                       ; position cursor at line 23 col 0
                   (send_raw_string "~c[[7m")
                                       ; Select Graphic Rendition:
                                       ; select reversed 7
                   (send_raw_string "~c[[26q")
                                       ; assert those visual attributes for
                                       ; 26 characters forward...
                   (send_raw_string "~c[[23;28H")
                                       ; position cursor at line 23 col 28
                   (send_raw_string "~c[[0m")
                                       ; reassert the default graphics
             "pt200"

  (if (> (terminal_info height) 24)    ; if SUI is running on PT200 set in
                                       ; 132x27 mode, height is returned as 27.
                                       ; SUI can run EITHER in 80x24 OR 132x27,
                                       ; & in NO OTHER screen orientations.
      (send_raw_string "~c[[26;0H")    ; position cursor at line 26 col 0
    else                               ; "normal" display below:
      (send_raw_string "~c[[23;0H"))   ; position cursor at line 23 col 0

                   (send_raw_string "~c[[7m")
                                       ; Select Graphic Rendition:
                                       ; select reversed 7
                   (send_raw_string "~c[[26q")
                                       ; assert those visual attributes for
                                       ; 26 characters forward...
  (if (> (terminal_info height) 24)
      (send_raw_string "~c[[26;28H")   ; position cursor at line 26 col 28
    else                               ; "normal" display below:
      (send_raw_string "~c[[23;28H"))  ; position cursor at line 23 col 28

                   (send_raw_string "~c[[0m")
                                       ; reassert the default graphics
              )                        ; end of keybinding$ specific select
            (setq response (prompt "Please make your selection "))
            (if (not (< response " "))
                (return response)))
)                                      ; end of defun vivid_prompt

(defun pt45_grph_on ()
    (select keybinding$
         "pt45"
              (send_raw_string "~c[R")
         )
)

(defun pt45_grph_off ()
    (select keybinding$
         "pt45"
              (send_raw_string "~c[S")
         )
)

;<FOXTST>DNK>KEYMACS>SOURCES>SUI_HELP.EM  Ed: DNK Tue 5 Jun 1984 13:54:50
; In development -- TUE, 05 JUN 1984 13:54:50
;END
