; SUI_MACROS.EM,  EMACSSRC>EMACS*>EXTENSIONS>SUI>SOURCES, EMACS DEVELOPMENT, 02/17/88
; Standard User Interface for PT45, PST100, and PT200: macro definitions.
; Copyright (c) 1984, Prime Computer, Inc., Natick, MA 01760
;
; Modifications:
;   Date    Engineer     Description of modification
; 02/17/88  Bugos        Modified to permit "mod_other_window" to work correctly
;                        when more than two windows are on the screen.
;                        (SPAR 4025928)
; 12/02/86  BMK          Commented out defcom for mod_write_file.
; 06/03/85  DNK          Added bindings to pf12_pt200$ to sui_toggle_word and
;                        sui_toggle_cobol_word$ to track change in PT200 ucode.
;                        is a similar fix to 5/22 MAM one needed for cobol_word?
; 05/22/85  MAM          fixed test for word_used_once$
; 10/05/84  DNK          renamed mod_copy_region, mod_exchange_mark to avoid
;                        pt45a conflict.
; 09/28/84  DNK          removed restrict_to_sui$ from repaint func.;
;                        PT45A uses it too..


(defun sui_quit ()
    (select keybinding$
     "pst100" (host_off$)              ; host_off$ is defined below
     )
    (quit))

(defun host_off$ ()                    ; FOR USE BY PST100s ONLY
                                       ; Hack to get around a peculiarity
    (send_raw_string "~c[[>16l"))      ; of primos_internal_screen:  it responds
                                       ; improperly when handed a host notifi-
                                       ; cation string ESC ] 2 ESC \ even though
                                       ; that string was bound to do_nothing$.
                                       ; Therefore we need to make the terminal
                                       ; not respond AT ALL to clear-screen
                                       ; sequences.  This mode is reset to the
                                       ; normal host notify ON via the
                                       ; sui_refresh at the end of the calling
                                       ; macros.

                                       ; NOW STARTS A SECTION OF EXTENSIVELY
                                       ; RENAMED FUNCTIONS FOR "TURNING OFF"
                                       ; KEYS -- PARTIALLY OR COMPLETELY
                                       ; THIS WILL HAVE TO BE CAREFULLY
                                       ; CHECKED AT THE SPL LEVEL

(defun eat_keystroke_no_feedback$ ()   ; for keybindings that simply
                                       ; eat a keystroke with no user feedback
   () )                                ; !!WHATEVER!!

(defcom unused_key_feedback$
  &doc "SUI:  This key is not used"
   (info_message "This key is not used")
   (sleep_for_n_milliseconds 1000)
   (info_message "")
   (flush_typeahead)                   ; to avoid excessive enforced "time-out"
                                       ; from multiple invocations while the
                                       ; first info_message is on the screen
   )

(defcom unused_mb_key_feedback$
  &doc "SUI:  This key is not used in the MiniBuffer"
   (info_message
"This key is not used in the MiniBuffer.  (You can exit with CONTROL-G)")
   (sleep_for_n_milliseconds sui_info_message_time$)
   (info_message "")
   (flush_typeahead)                   ; to avoid excessive enforced "time-out"
                                       ; from multiple invocations while the
                                       ; first info_message is on the screen
   )

(defcom restrict_to_sui$
  &doc "Included in all commands used ONLY in SUI/SUIX"
  (select keybinding$
     "pt45" "pst100" "pt200" (return)
                                       ; it's OK here; get out.
     otherwise
        (ring_the_bell)
        (info_message "That command is not used in this interface")
        (sleep_for_n_milliseconds 1000)
        (info_message "")
        (flush_typeahead)              ; to avoid excessive enforced "time-out"
                                       ; from multiple invocations while the
                                       ; first info_message is on the screen
        (abort_command)                ; halt any command calling this one
     )
)
                                       ;  END OF QUESTIONABLE TURN-OFF SECTION
(defcom repaint
     &doc "SUI: Moves cursor to first or ARGth line of screen"
     &na (&pass count &default 1)
                                       ;  (restrict_to_sui$)
                                       ; no -- let this be generally used,
                                       ; e.g., PT45A interface needs it...
     (goto_line (line_number (window_info top_line_cursor))) ; go to top line
     (let ((window_length (1+ (- (window_info bottom_line)   ; compute length
                                 (window_info top_line)))))  ; of window
          (if (> count window_length)                        ; make sure arg is
              (setq count window_length)                     ; in range
              (ring_the_bell)
              (info_message
"That argument is too large, it has been set to window_length")))
     (begin_line)
     (if (> count 1)                  ; process argument
         (next_line (1- count))
      else
         (if (< count 1)
             (info_message
"Negative arguments are not accepted in this function")
             (ring_the_bell))))

(defcom one_file_mode
    &doc "SUI:  Creates a single window"
    (restrict_to_sui$)
    (other_window)                     ; Go briefly to the other window so that
                                       ; we can remember what its name is
    (setq other_cursor$ (copy_cursor current_cursor))
    (setq other_buffer_name$ (buffer_info name))
    (other_window)                     ; return to the window that the user
                                       ; wishes to see exclusively on the screen
                                       ; NOTE that we use the other_window
                                       ; rather than the mod_other_window
                                       ; macro!
    (one_window))                      ; Now wipe away the "other" one.

(defcom two_file_mode
    &doc "SUI:  Split windows"
    &na (&pass count &default -99999)
    (restrict_to_sui$)
    (if (= count -99999)
        (setq count (/ (1+ (- (window_info bottom_line)
                              (window_info top_line)))
                       2)))
    (split_window count)               ; same as split_window
    (if (not (null other_cursor$))     ; go to where we were previously
        (go_to_cursor other_cursor$)))

(defcom toggle_two_file_mode
     &doc "SUI:  Split/unsplit window"
     (restrict_to_sui$)
     (if (& (= (window_info top_line)     1)
            (or (& (= (terminal_info width) 80)
                   (= (window_info bottom_line) 21)
                   )
                (& (= (terminal_info width) 132)
                   (= (window_info bottom_line) 24)
                   )
            )
         )
         (two_file_mode)               ; go into TWO FILE mode IFF the current
                                       ; state of things is: 1. That the current
                                       ; window's top line is #1 on the tube,
                                       ; AND 2. That its bottom line is #21 (if
                                       ; terminal is in 24x80 display mode),
                                       ; OR that its bottom line is #24 (if
                                       ; terminal is in 27x132 display mode,
                                       ; thus being a PT200 in wide mode).
     else
         (one_file_mode))              ; but if that isn't true, user must
                                       ; already be in two file mode; return.
)                                      ; end toggle_two_file_mode

(defcom mod_other_window
    &doc "SUI:  modified other_window command"
    (restrict_to_sui$)
    (if (< (major_window_count) 2)
                                       ; here, user has mistakenly pressed
                                       ; the OTHER WINDOW key; only 1 on screen
         (ring_the_bell)
         (info_message
         "Sorry, can not go to OTHER WINDOW; there is only one on the Screen.")
         (sleep_for_n_milliseconds sui_info_message_time$)
         (info_message "")
         (flush_typeahead)             ; to avoid excessive enforced "time-out"
                                       ; from multiple invocations while the
                                       ; first info_message is on the screen
         (return)
    else                               ; here, it's OK to switch.
                                       ; Now, we won't mistakenly set the
                                       ; following 2 variables.
    (setq other_cursor$ (copy_cursor current_cursor))
                                       ; remember where we are now
    (setq other_buffer_name$ (buffer_info name))
    (other_window)                     ; so we can return if need be
    ))

(defcom query_replace_forward
     &doc "SUI:  Query Replace from point to end of buffer"
     (restrict_to_sui$)
     (with_no_redisplay
     (save_position
          (move_bottom)
          (mark)))
          (query_replace)
          (popmark))                   ; erase the last-entered mark

(defcom replace_forward
     &doc "SUI:  Global Replace from point to end of buffer"
     (restrict_to_sui$)
     (with_no_redisplay
     (save_position
          (move_bottom)
          (mark)))
          (replace)
          (popmark))                   ; erase the last-entered mark

(defcom mod_setmark
    &doc "SUI:  Normal setmark function with added feedback"
    (restrict_to_sui$)
    (setmark)
    (info_message "MARK reset to current cursor position")
    )

(defcom unload
    &doc "SUI:  Unloads region to specified file"
    &args ((trnam &prompt "UNLOAD to Pathname"))
    (restrict_to_sui$)
    (setq unload_starting_cursor$ (copy_cursor current_cursor))
                                       ; remember where we are when we begin
     (save_position
         (with_no_redisplay
             (copy_region)
             (go_to_buffer ".temp")
             (delete_buffer)
             (yank_region)
             (buffer_info default_file trnam)
             (mod_write_file trnam)    ; use mod_write_file to safeguard
                                       ; against user inadvertently naming
                                       ; a file that already exists.  If s/he
                                       ; aborts out at this point, no harm done.
             (delete_buffer)
             (go_to_cursor unload_starting_cursor$)
                                       ; return to beginning point
             )))

(defcom dunload
   &doc "SUI:  Deletes and unloads region to file"
   &args ((trnam &prompt "DUNLOAD to Pathname"))
   (restrict_to_sui$)
   (setq dunload_starting_cursor$ (copy_cursor current_cursor))
                                       ; remember where we are when we begin
   (save_position
       (with_no_redisplay
          (copy_region)                ; don't remove it from starting buffer
                                       ; (at least not yet).  We don't want to
                                       ; damage the starting buffer in case the
                                       ; user aborts out at mod_write_file.
          (go_to_buffer ".temp")
          (delete_buffer)
          (yank_region)
          (buffer_info default_file trnam)
          (mod_write_file trnam)       ; safeguard any existing files
          (delete_buffer)
          (go_to_cursor dunload_starting_cursor$)
                                       ; return to beginning point
          (delete_region)              ; NOW it's OK to remove the DUNLOADed
                                       ; region.  But don't duplicate it;
                                       ; it's already on the kill ring.
          )))

(defcom sui_copy_region
    &doc "SUI:  copy_region command, with user feedback"
    (copy_region)
    (info_message "COPYing region into KILL (Paste) BUFFER"))

(defcom sui_exchange_mark
    &doc "SUI:  exchange_mark command, with user feedback"
    (info_message "Exchanging positions of cursor and last MARK")
    (exchange_mark))

(defcom sui_toggle_overlay
    &doc "SUI:  Alternates between overlay mode on/off"
    (if (member (find_mode 'overlay) (buffer_info modes))
                                       ; when in here,overlay mode
                                       ; is ON already
         (overlay_off)
    else
         (overlay_on)
    ))

(defcom sui_toggle_word
    &doc "SUI:  Alternates between character and word mode"
    (restrict_to_sui$)
    (if (member (find_mode 'word) (buffer_info modes))
                                       ; when in here, WORD mode is ON already
         (turn_mode_off (find_mode 'word))
                                       ; and that's it; return from here
    else
         (turn_mode_on (find_mode 'word) first)
                                       ; and now check: do we need to set up
                                       ; special keybindings for WORD mode?
         (if word_used_once$
              (return)
         else
              (select keybinding$
                   "pt45"
                        (set_mode_key "word" left$ "back_word")
                        (set_mode_key "word" right$ "forward_word")
                        (set_mode_key "word" del$ "delete_word")
                        (set_mode_key "word" "^h" "rubout_word")
                        (set_mode_key "word" dchar$ "delete_word")
                   "pst100"
                        (set_mode_key "word" left_pst100$ "back_word")
                        (set_mode_key "word" right_pst100$ "forward_word")
                        (set_mode_key "word" del_pst100$ "delete_word")
                        (set_mode_key "word" backspace_pst100$ "rubout_word")
                        (set_mode_key "word" delete_pst100$ "delete_word")

                   "pt200"
                        (set_mode_key "word" left_pt200$ "back_word")
                        (set_mode_key "word" right_pt200$ "forward_word")
                        (set_mode_key "word" num_lock_pt200$ "delete_word")
                        (set_mode_key "word" pf12_pt200$ "delete_word")
                        (set_mode_key "word" backspace_pt200$ "rubout_word")
                        (set_mode_key "word" sbackspace_pt200$ "rubout_word")
                        (set_mode_key "word" cbackspace_pt200$ "rubout_word")
                        (set_mode_key "word" scbackspace_pt200$ "rubout_word")

              )                        ; end keybinding$-specific select
              (setq word_used_once$ true)
                                       ; trapdoor variable; will stop the
                                       ; above IF from being executed >once.
         )                             ; end of above check on word_used_once$
      )                                ; end of check on whether word mode is
                                       ; on or off
    )                                  ; end of defcom

(defcom sui_toggle_cobol_word
    &doc "SUI:  COBOL: alternates between char and word mode"
    (restrict_to_sui$)
    (if (member (find_mode 'cobol_word) (buffer_info modes))
                                       ; when in here, cobol_word mode
                                       ; is ON already
         (turn_mode_off (find_mode 'cobol_word))
                                       ; and that's it; return from here
    else
         (turn_mode_on (find_mode 'cobol_word) first)
                                       ; and now check: do we need to set up
                                       ; special keybindings for
                                       ; cobol_word mode?
         (if (^ (null cobol_word_used_once$))
              (return)
         else
              (select keybinding$
                   "pt45"
                        (set_mode_key "cobol_word" left$ "cobol_back_word")
                        (set_mode_key "cobol_word" right$ "cobol_forward_word")
                        (set_mode_key "cobol_word" del$ "cobol_delete_word")
                        (set_mode_key "cobol_word" "^h" "cobol_rubout_word")
                        (set_mode_key "cobol_word" dchar$ "cobol_delete_word")
                   "pst100"
                        (set_mode_key "cobol_word" left_pst100$
                                                   "cobol_back_word")
                        (set_mode_key "cobol_word" right_pst100$
                                                   "cobol_forward_word")
                        (set_mode_key "cobol_word" del_pst100$
                                                   "cobol_delete_word")
                        (set_mode_key "cobol_word" backspace_pst100$
                                                   "cobol_rubout_word")
                        (set_mode_key "cobol_word" delete_pst100$
                                                   "cobol_delete_word")

                   "pt200"
                        (set_mode_key "cobol_word" left_pt200$
                                                   "cobol_back_word")
                        (set_mode_key "cobol_word" right_pt200$
                                                   "cobol_forward_word")
                        (set_mode_key "cobol_word" num_lock_pt200$
                                                   "cobol_delete_word")
                        (set_mode_key "cobol_word" pf12_pt200$
                                                   "cobol_delete_word")
                        (set_mode_key "cobol_word" backspace_pt200$
                                                   "cobol_rubout_word")
                        (set_mode_key "cobol_word" sbackspace_pt200$
                                                   "cobol_rubout_word")
                        (set_mode_key "cobol_word" cbackspace_pt200$
                                                   "cobol_rubout_word")
                        (set_mode_key "cobol_word" scbackspace_pt200$
                                                   "cobol_rubout_word")

              )                        ; end keybinding$-specific select
              (setq cobol_word_used_once$ true)
                                       ; trapdoor variable; will stop the
                                       ; above IF from being executed >once.
         )                             ; end of above check on
                                       ; cobol_word_used_once$
      )                                ; end of check on whether
                                       ; cobol_word mode is
                                       ; on or off
    )                                  ; end of defcom

; (defcom mod_write_file
;     &doc "SUI:  Write specified file"
;     &args ((place &prompt "Write file" &string))
;     (if (= place "")
;         (setq place (file_name current_cursor)))
;     (if (file_info place exists)  ;check if file exists
;         (if (^ (yesno "This file already exists. Do you want to overwrite it"))
;             (mod_write_file)           ; Ask again if user doesn't want to
;                                        ; overwrite.
;             (return)))                 ; Now unwind if multiple invocations...
;     (write_file place))                ; or just write it if place doesn't exist
;                                        ; or if user says Yes, overwrite.

(defcom remove_invalid_cmd$
     &doc "SUI:  removes INVALID CMD from PST100/PT200 status line"

                                       ; This will be bound to PST100 RESET
                                       ; and PT200 CLEAR key.
                                       ; Therefore it should do both a screen
                                       ; repaint and send the ESC sequence
                                       ; that removes INVALID CMD from status
                                       ; line...
     (select keybinding$
        "pst100" "pt200"               ; both terminals want the same thing
           (send_raw_string "~c[$G")
           (sui_refresh)
           (return)
       otherwise
        (ring_the_bell)
        (info_message "That command is not used in this interface")
        (sleep_for_n_milliseconds 1000)
        (info_message "")
        )
     )

(defcom fix_wrong_num_lock$
     &doc "SUI:  restores Cursor-Function/Number pad to Cursor-Function mode"
     (select keybinding$
        "pt200" (send_raw_string "~c[[>10h")
       otherwise
        (ring_the_bell)
        (info_message "That command is not used in this interface")
        (sleep_for_n_milliseconds 1000)
        (info_message "")
        )
     )

(defcom fix_wrong_insert$              ; works for PST100 but there's not a
                                       ; function key that should get this
                                       ; bound to it.  There IS one on the 200.
     &doc "SUI:  restores PST100/PT200 in INSERT to proper OVERLAY mode"
     (select keybinding$
        "pst100" "pt200" (send_raw_string "~c[[4h")
                                       ; and now, because the screen might
                                       ; well be garbled:
        (sui_refresh)
        (return)
       otherwise
        (ring_the_bell)
        (info_message "That command is not used in this interface")
        (sleep_for_n_milliseconds 1000)
        (info_message "")
        )
     )

(defcom sui_horiz_left                 ; BOUND TO SCROLL RIGHT (!) KEY!!
    &doc "SUI:  BUFFER.EM's horiz_left command, with more feedback"
                                       ; buffer.em's horiz_right is
                                       ; bound to SCROLL LEFT key
                                       ; (functions' NAMES mean "move the
                                       ; WINDOW" as distinguished from
                                       ; "move the TEXT")
    &na (&pass count &default 40)
    (restrict_to_sui$)
    (if (| (= count 0)(= count 1))
         (hcol 1)                      ; fast way to say "all the way back":
                                       ; hit ESC 0 or ESC 1 before the
                                       ; SCROLL RIGHT key.
                                       ; and that's all you have to do...
                                       ; but you can't say ESC 0 on a
                                       ; PT45 terminal, hence we allow
                                       ; esc 1 to have a special meaning.
    else

    (horiz_left count)
    (if (> (window_info column_offset) 122)
                                       ; help the user out if s/he's off
                                       ; in the hinterlands...
(select keybinding$
     "pt45"
    (info_message
"To scroll ALL THE WAY right, precede SCROLL RIGHT with the ESC 1 keys")
                                       ; because ESC 0 is
                                       ; what the A-SEND key sends out.
                                       ; We have to "keep that quiet" for
                                       ; PT45 users...
     otherwise
    (info_message
"To scroll ALL THE WAY right, precede SCROLL RIGHT with the ESC 0 or ESC 1 keys")
                                       ; but you CAN use ESC 0 for others.
     )

    (sleep_for_n_milliseconds sui_info_message_time$)
                                       ; hold the above for a while, then
    (hcol)                             ; reinstate the present hcol feedback
    )                                  ; end the if where a hint is given

    )                                  ; end the if contingent on ESC 0 or
                                       ; ESC 1 numeric prefices
)                                      ; end of defcom sui_horiz_left

                                       ; the horiz_right in BUFFER.EM will
                                       ; serve the SUI user OK, I guess...

(defcom get_file                       ; OBSOLETE CODE!!
                                       ; this function is NOT bound to a key
                                       ; at this rev of the SUI

    &doc "SUI:  Loads a new file <<UNSUPPORTED CMD - use find_file>>"
    (restrict_to_sui$)
    (setq get_file_starting_buffer_name$ (buffer_info name))
                                       ; remember where we are when we start
    (if (buffer_info modified)
         (if (yesno "Save this file?")
              (mod_write_file)
              )
         )
    (setq new_filename$ (prompt "Get File"))

         (if (| (= new_filename$ " ")
                (= 0 (string_length new_filename$))
             )
                                       ; if user doesn't give a filename,
         (go_to_buffer "scratch")      ; create a scratch workspace
                                       ; and exit.  Note no use of . in
                                       ; buffername; want it visible.
       else                            ; POTENTIAL PROBLEM:
                                       ; what if user does this more than once?
                                       ; won't that create conflicts?

         (find_file new_filename$)     ; now I should be in a new buffer
         )                             ; if the file didn't exist before

                                       ; Note no use of
                                       ; with_command_abort_handler
                                       ; in this area.

    (if                                ; do the following if
         (|                            ; EITHER of the following conditions
                                       ; is met:
              (= get_file_starting_buffer_name$ (buffer_info name))
                                       ; the command was given from the same
                                       ; buffer where the find_file
                                       ; just placed us --
                                       ; OR:

              (and                     ; BOTH
                   (= (major_window_count) 2)
                                       ; there are currently two windows
                                       ; and
                   (= get_file_starting_buffer_name$ other_buffer_name$)
                                       ; the get_file command was given from
                                       ; the other window on screen at the time
              ))                       ; then DO the stuff till the ELSE.
                                       ; above condition returns TRUE if BOTH
                                       ; windows of display had the SAME buffer
                                       ; in them; in that case we don't want to
                                       ; erase the other buffer!!
                                       ; also we don't want to erase the "other"
                                       ; buffer if it's where we started;
         (return)                      ; we will just get out and be done.

    else                               ; but if they are different, OK to clear.

         (select_buf get_file_starting_buffer_name$)
                                       ; go back to where you came from
         (delete_buffer)               ; get rid of it
         (select_buf "")               ; return to new buffer just found

    )                                  ; end of the check on different buffers

)                                      ; end of !!OBSOLETE!! defcom get_file

(defcom set_get_file
     &doc "SUI:  Restores obsolete GET FILE function to FIND FILE key"
     (restrict_to_sui$)
     (select keybinding$
       "pt45"   (set_permanent_key f3$         "get_file")
       "pst100" (set_permanent_key f02_pst100$ "get_file")
       "pt200"  (set_permanent_key pf02_pt200$ "get_file")
      )
     (info_message
"Obsolete GET FILE substituted for FIND FILE.  Restore with set_find_file cmd.")
     )

(defcom set_find_file
     &doc "SUI:  Restores FIND FILE over obsolete GET FILE function"
     (restrict_to_sui$)
     (select keybinding$
       "pt45"   (set_permanent_key f3$         "find_file")
       "pst100" (set_permanent_key f02_pst100$ "find_file")
       "pt200"  (set_permanent_key pf02_pt200$ "find_file")
      )
     (info_message
"FIND FILE substituted for obsolete GET FILE.  Reverse with set_get_file cmd.")
     )
