;  SUI_TABS.EM,  EMACSSRC>EMACS*>EXTENSIONS>SUI>SOURCES,03/13/85;                                          ENVIRONMENTS GROUP, 10/09/84
;  Standard User Interface for PT45, PST100, PT200 terminals: TAB macros
;  Copyright (c) 1984, Prime Computer, Inc., Natick, MA 01760
;
; Description:
;
; Abnormal conditions:
;
; Implementation:
;
; Modifications:
;   Date   Programmer   Description of modification
; 03/13/85 Sarkisian    All these "special" tab commands for SUI(X) are
;                       unneeded. All of the commands and functions herein call
;                       the basic tab routines found in the directory
;                       EMACS*>EXTENSIONS>SOURCES under
;                        TAB.EM and TAB1.EM.
; 10/09/84 DNK          Initial coding.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                       ;;;
;;; SUI "Dummy" Command/Function          Actual Source Command/Function  ;;;
;;; ============================          ==============================  ;;;
;;; reset_tabs                            default_tabs                    ;;;
;;; sui_tab                               type_tab                        ;;;
;;; sui_tabf                              type_tabf                       ;;;
;;; sui_back_tab                          back_tab                        ;;;
;;; sui_back_tabf                         back_tabf                       ;;;
;;; sui_set_tabs                          set_tab, settabs, etc.          ;;;
;;; set_tabsf                             settabf                         ;;;
;;; sui_insert_tab                        insert_tab                      ;;;
;;; sui_initialize_tabs$                  check_set_tab_vars              ;;;
;;; cobol_sui_back_tab                    cobol_back_tab                  ;;;
;;; init_tab                              RESIDES HERE; NO EQUIVALENT     ;;;
;;;                                       IN OTHER TAB ROUTINES.          ;;;
;;; get_input                             OBSOLETE.                       ;;;
;;; parse_line                            OBSOLUTE.                       ;;;
;;;                                                                       ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;
(defcom reset_tabs
     &doc "SUI:  Sets up default tabs every five spaces"
     (default_tabs))

(defcom sui_tab
    &doc "SUI:  Tab function"
    &na (&pass count &default 1)
    (type_tab count))

(defun sui_tabf ()
    (type_tabf))

(defcom sui_back_tab
    &doc "SUI:  Moves cursor to previous tab stop"
    &na (&pass count &default 1)
    (back_tab count))

(defun sui_back_tabf ()
    (back_tabf))

(defcom sui_set_tabs
    &doc "SUI:  Sets tabs to what you want"
    (set_tabs))

(defun set_tabsf ()
    (settabf))

(defcom sui_insert_tab
   &doc "SUI:  Inserts spaces to next tab stop"
   &na (&pass count &default 1)
   (insert_tab count))

(defcom init_tab
   &doc "SUI:  Initial setting of tab key"
   &na (&pass count &default 1)
   (set_permanent_key "^i" "sui_tab")
   (info_message
   "To set your own tabs, press COMMAND MODE key and type: sui_set_tabs")
   (sui_initialize_tabs$)
   (sui_tab count))

(defcom cobol_sui_back_tab
    &doc "COBOL: Back tab for SUI"
    &na (&pass count &default 1)
    (cobol_back_tab count))

(defun sui_initialize_tabs$ ()
    (check_set_tab_vars))

;CHANGELOG:  DNK, TUE, 09 OCT 1984, removed tablist_to_array because it
;            duplicates functionality found in EXTENSIONS>SOURCES>TAB.EM
;            Also renamed set_tabs defcom to be sui_set_tabs to relieve
;            conflict with another defcom in TAB1.EM.  Changed init_tab here
;            to tell users to type sui_set_tabs to get this function.

;<FOXTST>DNK>KEYMACS>SOURCES>SUI_TABS.EM  Ed: DNK Tue 9 Oct 1984 17:00:51
; in process of revision -- TUE, 09 OCT 1984 17:00:52

;END
