//---------------------------------------------------------------------------
#include <vcl.h>
#include <string>
#include <vector>
#pragma hdrstop

USERES("inspect.res");
USEFORM("ushell.cpp", Form1);
USEUNIT("uinspect.cpp");
USEFORM("uabout.cpp", AboutBox);
USEUNIT("Types.cpp");
USEFORM("umodifsh.cpp", ModifyBox);
//---------------------------------------------------------------------------
using namespace std;

void interpretArguments(vector<string> &arg, char *cmd);

vector<string> args;

//---------------------------------------------------------------------------
WINAPI WinMain(HINSTANCE, HINSTANCE, LPSTR cmdln, int)
{
        try
        {
                 interpretArguments(args, cmdln);

                 Application->Initialize();
                 Application->Title = "Inspector";
                 Application->CreateForm(__classid(TForm1), &Form1);
                 Application->CreateForm(__classid(TAboutBox), &AboutBox);
                 Application->CreateForm(__classid(TModifyBox), &ModifyBox);
                 Application->Run();
        }
        catch (Exception &exception)
        {
                 Application->ShowException(&exception);
        }
        return 0;
}
//---------------------------------------------------------------------------
//----------------------------------------------------------interpretArguments()

static
void skipspaces(char **w)
{
        while((**w == ' '
            || **w == '\t'
            || **w == '\n')
           && **w != 0)
                ++(*w);
}

void interpretArguments(vector<string> &args, char *cmd)
{
        char *w = cmd, *p;
        char buffer[1024];
        char final_char;

        while(*w)
        {
                // skip spaces -if any, which would be strange at the beginning-
                skipspaces(&cmd);
                p = buffer;

                // is there a doble quote ?
                if (*w=='\"')
                        final_char = '\"';
                else
                        final_char = ' ';

                do {
                        *(p++) = *(w++);
                } while(*w != final_char
                     && *w != 0);

                if (final_char=='\"')
                        *(p++) = '\"';

                *p = 0;

                if (*w)
                        ++w;
                        
                args.push_back(buffer);
        }
}


