/* JOIN.H : This module integrates the editor with the compiler.
	    We have the function prototypes for the top-level
    editor and compiler functions.
*/




/*------------ Join provides: ---------*/
void JoinInit(void);
void JoinClose(void);
void JoinCompileAndRun(str source, error_type err);
void JoinEditSource(str name);
void JoinReturnToTopLevel(void);


/*---------- Someone provides: -----------*/
void SaveCode(void);
void RestoreCode(void);
void UpdateSavedCode(void);


/*---------- The compiler provides: ----------*/
extern bool PredefinitionPhase;
	/* This is for suppressing the storing of the source-code for predefined things. */

void* UserCompileString(str source);


/*----------- The editor provides: ----------*/

void OutputLine(str buf);
	/* Output this line to the screen. */

void ClearOutputLines(void);
	/* Clear all <<< output lines near the current location. */

bool EditorInclude(str filename);
	/* Insert the contents of this file into the editor. */

void EditorAddSource(str source);
	/* Insert this str at the current location. */

int EditorWidth(void);
	/* How many characters can we fit on one line? */

void EditorReprint(void);
	/* Flush the display so all changes are visible. */

str EditorGets(char dest[], int sizeofdest);
	/* Input a str from the keyboard. */

int EditorGetch(void);
	/* Input a single keystroke from the keyboard. */

void EditorClearLog(void);
	/* Clear the whole editor. */

str SubEdit(void);
	/* Re-enter the editor to get a single str.  Return NULL if they   */
	/* leave the window without entering a compileable str. The caller */
	/* must free the returned str. */

