#include <memory.h>
#include <stdio.h>
#include "barbados.h"
#include "memory.h"
#include "array.h"
#include "compiler.h"
#include "name.h"



interface struct Resolved_node ResolveInfo;
interface char ResolveErrormsg[512];


interface Namedobj ** qcopyobjlist(Namedobj ** list)
/* Copy a dynamic array of namedobjs into the compiler heap. 	*/
/* Do this because we want the compiler memory allocation	*/
/* to apply to this set.  However, note it means you can't	*/
/* add to or delete from or free this dynamic array. 		*/
/* It frees the list you pass it. */
{	Namedobj** newlist;
	int size;

	if (list == NULL)
            return NULL;
        size = Array_Size(list) * sizeof(Namedobj*) + 4;
        newlist = (Namedobj**)memcpy(qmalloc(size), (str)list-4, size);
        newlist = (Namedobj**)((str)newlist + 4);
        Array_Free(list);
        return newlist;
}


static bool InsideNamespace(Classdef* classdef)
{
	if (context_fn) {
            if (context_fn->owner == classdef)
            	return yes;
        }
        if (context_class) {
            if (context_class == classdef)
            	return yes;
        }
        return no;
}


static Namedobj* ResolveMemberRecurse(Classdef* classdef, str name,
		visibility_enum visibility,
                Namedobj* &obj2, int &offset)
/* Resolve 'name' to a member of 'classdef' or a base class of classdef.*/
/* 'visibility'=='public' if we are only allowed public objects,	*/
/* otherwise we can see all objects. 'context_fn' (if non-NULL) defines	*/
/* the function we're defining.  If it's in a class's Friends list or	*/
/* its class owner is in a class's Friends list, then this is another	*/
/* way we get permission to see private objects of the given classdef.  */
/* If only one base class matches, return the matching object formally	*/
/* and obj2=NULL. If two or more classes match, return one class's     	*/
/* first object formally and the other one via 'obj2'. 			*/
{	Namedobj *obj, *base, *obj3;

	/* Never return a constructor: */
        if (classdef->typedef_obj and   // Only null if partially parsed classes
                streq(name, classdef->typedef_obj->name)) {
            obj2 = NULL;
            return NULL;
        }

        /* Friends: */
        if (visibility == public_visibility) {
	    if (context_fn and (Array_HasP(classdef->Friends, context_fn) or
            	Array_HasP(classdef->Friends, context_fn->owner))
                or InsideNamespace(classdef))
            	visibility = private_visibility;
        }

	/* Is there a direct member? */
	for (obj=classdef->member; obj; obj=obj->next) {
            if (streq(obj->name, name) and obj->visibility >= visibility)
            	return obj;
        }

        /* Look for 'name' inside base classes: */
        obj2 = NULL;
        obj3 = NULL;
	for (base=classdef->member; base; base=base->next) {
            if (base->storage != inherit_storage)
            	continue;
            if (base->visibility != public_visibility and
            		visibility == public_visibility)
            	continue;
            offset += ((FieldNamedobj*)base)->offset;
            obj = ResolveMemberRecurse(TypeToClassdef(base->type), name,
                        visibility == debug_visibility ? debug_visibility :
                        base->visibility < visibility ?
                        	base->visibility : visibility,
            		obj2, offset);
            if (obj and obj2)
            	return obj;
            if (obj and obj3) {
            	obj2 = obj3;
                return obj;
            }
            if (obj)
            	obj3 = obj, ResolveInfo.offset = offset;
            offset -= ((FieldNamedobj*)base)->offset;
        }
        return obj3;
}


interface Namedobj* ResolveMember(Classdef* classdef, str name,
		visibility_enum visibility)
/* Look for 'name' inside classdef or any base class thereof.	*/
/* Return the first applicable member.				*/
/* Constructors are never returned. */
{	Namedobj *obj2, *obj;
        int offset = 0;

	obj2 = NULL;
        ResolveInfo.offset = 0;
        ResolveInfo.list = NULL;
	obj = ResolveMemberRecurse(classdef, name, visibility,
        		obj2, offset);
        if (obj2) {
            Classdef *base1, *base2;
            base2 = (Classdef*)obj->owner;
            base1 = (Classdef*)obj2->owner;
	    sprintf(ResolveErrormsg, "%s.%s is ambiguous: do you mean %s::%s "
            	"or %s::%s?",
                classdef->typedef_obj->name, name,
                base1->typedef_obj->name, name,
                base2->typedef_obj->name, name);
        }
        else if (obj == NULL)
            return ResolveInfo.obj = NULL;
        else {
            *ResolveErrormsg = '\0';
            for (obj2=obj->next; obj2; obj2=obj2->next) {
		if (strieq(obj2->name, name))
                    Array_Add(ResolveInfo.list, obj2);
            }
            if (ResolveInfo.list) {
            	Array_Add(ResolveInfo.list, obj);
                ResolveInfo.list = qcopyobjlist(ResolveInfo.list);
            }
        }
        return ResolveInfo.obj = obj;
}


interface Namedobj* ResolveGlobal(str name)
/* Like above but only considers global scope. Used for the 	*/
/* ::X syntax. */
{	Namedobj* obj, **list;

	*ResolveErrormsg = '\0';
        ResolveInfo.offset = 0;
        ResolveInfo.list = NULL;
        list = NULL;

	/* Level 3.1: Look for it in the current directory or */
	/* immediate children of the current subdirectory: */
        list = NULL;
        if (curdir) {
            list = curdir->SetSearchMeAndChildren(name, list);
            if (list and list[0]->type and *list[0]->type != tp_function) {
            	obj = list[0];
                Array_Free(list);
                return ResolveInfo.obj = obj;
            }
        }

	/* Level 3.2: Look for it in the Common directory or */
	/* immediate children of the Common directory: */
	if (common_dir and common_dir != curdir) {
	    list = common_dir->SetSearchMeAndChildren(name, list);
            if (list and list[0]->type and *list[0]->type != tp_function) {
            	obj = list[0];
                Array_Free(list);
                return ResolveInfo.obj = obj;
            }
        }

	/* Step 3.3: Is it in Stdlib? */
	if (stdlib_dir != curdir) {
	    list = stdlib_dir->SetSearchMeAndChildren(name, list);
            if (list and list[0]->type and *list[0]->type != tp_function) {
            	obj = list[0];
                Array_Free(list);
                return ResolveInfo.obj = obj;
            }
        }

        /* Copy the list to ResolveInfo: */
        if (Array_Size(list) == 0)
            return ResolveInfo.obj = NULL;
        if (Array_Size(list) == 1) {
            obj = list[0];
            Array_Free(list);
            return ResolveInfo.obj = obj;
        }
        ResolveInfo.list = qcopyobjlist(list);
	return ResolveInfo.obj = ResolveInfo.list[0];
}


interface Namedobj* Resolve(str name)
/* Look up 'name'. Resolve it to a set of applicable Namedobj's	*/
/* according to the C++ rules.					*/
/* There are 3 levels of name resolution: 			*/
/*								*/
/* 1. Local variables						*/
/* 2. 'this' members						*/
/* 3. Global members						*/
/* 								*/
/* We search the levels in this order. If we find a matching 	*/
/* object or ambiguity in any level, we return immediately.	*/
/* But within a level, it must be unambiguous.  For level 1,    */
/* this doesn't apply. For level 2, this means 2 or more base   */
/* classes having an object of that name.  For level 3, this	*/
/* means 2 or more subdirectories having this object. 		*/
/*								*/
/* If 'classdef' is defined, we assume we're inside a member	*/
/* function of 'classdef', i.e. access private objects etc.	*/
{	Namedobj* obj, *list;

	*ResolveErrormsg = '\0';
        ResolveInfo.offset = 0;
        ResolveInfo.list = NULL;
        list = NULL;

	/* Level 1: Look for it in the current scope */
        obj = NameLocalResolve(name);
        if (obj)
            return ResolveInfo.obj = obj;

        /* Level 2: Look for it in classdef: */
        if (declarator_class) {
            obj = ResolveMember(declarator_class, name,
            		InsideNamespace(declarator_class) ?
                        	private_visibility : public_visibility);
            if (*ResolveErrormsg)
            	return ResolveInfo.obj = NULL;
            if (obj)
            	return ResolveInfo.obj = obj;
        }

	/* Level 3: Look for objects in the relevant directories. */
        return ResolveGlobal(name);
}


interface Namedobj* ResolveTok(Classdef* classdef)
/* As above, but an optimised version based on 'tok'. */
{	Namedobj* obj, *list;

	*ResolveErrormsg = '\0';
        ResolveInfo.offset = 0;
        ResolveInfo.list = 0;
        assert(tok.en == identifier);
        list = NULL;

	/* Level 1: Look for it in the current scope */
        if (tok.local_obj)
            return ResolveInfo.obj = tok.local_obj;

        /* Level 2: Look for it in classdef: */
        if (classdef) {
            obj = ResolveMember(classdef, tok.buf,
            		InsideNamespace(classdef) ?
                        	private_visibility : public_visibility);
            if (*ResolveErrormsg)
            	return ResolveInfo.obj = NULL;
            if (obj)
            	return ResolveInfo.obj = obj;
        }

	/* Level 3: Look for it in the relevant directories. */
        return ResolveGlobal(tok.buf);
}


Namedobj* Directory::SearchMeAndChildren(str name, char errormsg[])
/* Search for 'name' in 'this' or immediate subdirectories of 'dir'. */
{	Namedobj* obj, *obj2;
	uint h;

        *errormsg = '\0';

	/* Firstly look for it in dir: */
	obj = Find(name);
	if (obj)
	    return obj;

	/* Otherwise look for it in children of dir: */
	for (each_dir_obj(this)) {
	    Directory* subdir;
	    if (obj->storage != static_storage)
		continue;
	    else if (TypeEqual(obj->type, direc_typstr))
		subdir = (Directory*)objLocation;
	    else if (TypeEqual(obj->type, dirref_typstr))
		subdir = *(Directory**)objLocation;
	    else if (TypeEqual(obj->type, container_typstr)) {
		Conim *conim = FindConim(*(container_id*)objLocation);
		if (conim == NULL)
		    continue;	    /* This fn expects other fn's to have */
		    /* ensured that children LGO's are mapped in. */
		subdir = conim->directory();
	    }
	    else continue;
	    obj2 = subdir->Find(name);
	    if (obj2)
		return obj2;
	}

	return NULL;
}


Namedobj** Directory::SetSearchMeAndChildren(str name, Namedobj* *A)
/* Search for 'name' in 'this' or immediate subdirectories of 'dir'.	*/
/* If we find a match in 'this', then return the set of all matching	*/
/* objects. Otherwise, search all child directories and return the set	*/
/* of all matching objects in them.					*/
/*	It's used for resolving identifiers we find in source code.	*/
{	Namedobj* obj;
	uint h;

	/* Firstly look for it in dir: */
	A = SetFind(name, A);
	if (A)
	    return A;

	/* Otherwise look for it in children of dir: */
	for (each_dir_obj(this)) {
	    Directory* subdir;
	    if (obj->storage != static_storage)
		continue;
	    else if (TypeEqual(obj->type, direc_typstr))
		subdir = (Directory*)objLocation;
	    else if (TypeEqual(obj->type, dirref_typstr))
		subdir = *(Directory**)objLocation;
	    else if (TypeEqual(obj->type, container_typstr)) {
		Conim *conim = FindConim(*(container_id*)objLocation);
		if (conim == NULL)
		    continue;	    /* This fn expects other fn's to have */
		    /* ensured that children LGO's are mapped in. */
		subdir = conim->directory();
	    }
	    else continue;
	    A = subdir->SetFind(name, A);
	}

	return A;
}


interface bool IsPublicBaseClass(Classdef* base, Classdef* derived)
/* Is 'base' a public or protected base class of 'derived'? */
{	Namedobj *obj;

	assert(base->ValidClassdef() and derived->ValidClassdef());
        if (base == derived)
            return yes;
        for (obj=derived->member; obj; obj=obj->next) {
            if (obj->storage == inherit_storage and obj->visibility
            		!= private_visibility) {
            	if (IsPublicBaseClass(base, TypeToClassdef(obj->type)))
                    return yes;
            }
        }
        return no;
}





/*----------------------------------------------*/

class C {
	int g;
public:
	C(int h) { g = h; }
};


class D {
public:
	C c1,c2;
};

int foo(bool b)
{
	return 1;
}

int foo(void *v)
{
	return 3;
}


/* const types:   they're allowed to have their address taken.
They're just not allowed to be assigned to. */
