//#define BREAKPOINT_BY_INT3
//#define DECREMENT_IP_INT3
// My Win2000 laptop needs this, my WinNT v4 desktop doesn't.
// But Jose's Win2000 desktop doesn't need it!!  What is the
// difference??


#include <windows.h>
#include <signal.h>
#include <stdio.h>
#include <string.h>
#include <memory.h>
#include "barbados.h"
#include "exception.h"
#include "source.h"
#include "array.h"
#include "debug.h"



typedef uchar* ins_type;

typedef struct bpcode_node {
	/* A machine-code level breakpoint for a single instruction. */
	ins_type location;
#ifdef BREAKPOINT_BY_INT3
        uchar under_INT3;
#else
	uchar under_INT3[5];
#endif
	Namedobj* obj;
	DebugInfo* dinfo;
	struct bpcode_node *next;
	struct bpcode_node *next_for_src;
} *bpcode_type;


typedef struct bpsrc_node {
	/* A source-level breakpoint for a line of source text. */
	int LineNo;
	Namedobj* obj;
	bpcode_type bpcode;
	struct bpsrc_node *next;
} *bpsrc_type;


static bpsrc_type BpsrcList;
static bpcode_type BpcodeList;
static CONTEXT RegIm;

interface CONTEXT* RegisterImage;
interface FrameNode Frame;      /* A description of one level of the call stack. */
interface char exception_message[16384];

void TfcMessage(str title, char icon, str fmt, ...);


/*---------*/

static void BpcDisable(bpcode_type bpc)
/* Temporarily disable this breakpoint. */
{
	__try {
#ifdef BREAKPOINT_BY_INT3
            *bpc->location = bpc->under_INT3;
#else
	    memcpy(bpc->location, bpc->under_INT3, 5);
#endif
	}
	__except(yes) {
	}
}


#ifdef BREAKPOINT_BY_INT3

interface void Handler(int A[])
{
	RegisterImage = &RegIm;
	RegIm.Eip = (A[2] -= 5);        // Return to site of the "Call Handler"
	// instruction, it will have been replaced by the proper instruction.
	RegIm.Ebp = A[1];
	RegIm.Esp = (int)(A + 3);
	RegIm.Eax = A[-2];
	RegIm.Ecx = A[-4];
	RegIm.Edx = A[-5];
	RegIm.Ebx = A[-6];
	RegIm.Esi = A[-9];
	RegIm.Edi = A[-10];
	Frame.ins = (ins_type)RegIm.Eip;
	Frame.BP = (void**)RegIm.Ebp;

	bpcode_type bpc;
	for (bpc=BpcodeList; bpc; bpc=bpc->next) {
	    if (bpc->location == Frame.ins)
		goto FOUND;
	}
	assert(false);
	/* We can't find the breakpoint!! */
	return;

	FOUND:
	if (bpc->obj == NULL)
	    bpc->obj = InsToObj(Frame.ins);
	if (bpc->dinfo == NULL and bpc->obj)
	    bpc->dinfo = bpc->obj->make ? bpc->obj->make->source.dinfo : NULL;
	Debugger(bpc->obj, bpc->dinfo, DebugInsToLineNo(bpc->dinfo, Frame.ins),
			&Frame);
}


#else


static void Handler()
{
        static int* Stack;

    __asm {
        NOP
        PUSHFD
        PUSHAD
        MOV [Stack],ESP
    }

	RegisterImage = &RegIm;
	RegIm.Ebp = Stack[2];
	RegIm.Esp = (int)(Stack + 10);
	RegIm.Eax = Stack[7];
	RegIm.Ecx = Stack[6];
	RegIm.Edx = Stack[5];
	RegIm.Ebx = Stack[4];
	RegIm.Esi = Stack[1];
	RegIm.Edi = Stack[0];
	Frame.ins = (ins_type)(Stack[9] -= 5);
        RegIm.Eip = (int)Frame.ins;
	Frame.BP = (void**)RegIm.Ebp;

	static bpcode_type bpc;
	for (bpc=BpcodeList; bpc; bpc=bpc->next) {
	    if (bpc->location == Frame.ins)
		goto FOUND;
	}
	assert(false);
	/* We can't find the breakpoint!! */
	return;

	FOUND:
	if (bpc->obj == NULL)
	    bpc->obj = InsToObj(Frame.ins);
	if (bpc->dinfo == NULL and bpc->obj)
	    bpc->dinfo = bpc->obj->make ? bpc->obj->make->source.dinfo : NULL;
	Debugger(bpc->obj, bpc->dinfo, DebugInsToLineNo(bpc->dinfo, Frame.ins),
			&Frame);

    __asm {
        POPAD
        POPFD
        RET
    }
}


static ins_type RealFunctionStart(void *_fn)
{       ins_type fn=(ins_type)_fn;

        if (*fn == 0xe8)
            fn = *(ins_type*)(fn+1);
        else if (*fn == 0xe9)
            fn += 5 + *(int*)(fn+1);
        while (*fn != 0x90)
            fn++;
        return ++fn;
}

#endif




static void BpcEnable(bpcode_type bpc)
/* Re-enable this breakpoint. */
{	ins_type location=bpc->location;

	__try {
#ifdef BREAKPOINT_BY_INT3
	*location = 0xcc;
#else
	*location++ = 0xe8;
	*(int*)location = RealFunctionStart(Handler) - (location + 4);
#endif
	}
	__except(yes) {
	}
}


static bpcode_type InsertBpc(ins_type location, Namedobj* obj, DebugInfo* dinfo)
/* Create a single machine-code level breakpoint at this instruction. */
{	bpcode_type bpc;

	/* Is there already one there? */
	for (bpc=BpcodeList; bpc; bpc=bpc->next) {
	    if (bpc->location == location)
		return NULL;	/* There's already one at this location. */
	}

	/* Create a new one. */
	bpc = new bpcode_node;
	bpc->location = location;
	bpc->obj = obj;
	bpc->dinfo = dinfo;
#ifdef BREAKPOINT_BY_INT3
	bpc->under_INT3 = *location;
#else
	memcpy(bpc->under_INT3, location, 5);
#endif
	BpcEnable(bpc);
	bpc->next = BpcodeList;
	BpcodeList = bpc;
	return bpc;
}


static bool DeleteBpc(bpcode_type bpc)
/* Delete this bpc. */
{	bpcode_type *bpcp;

	/* First undo it in the code: */
	BpcDisable(bpc);

	/* Now delete it from the linked list: */
	for (bpcp=&BpcodeList; *bpcp; bpcp=&(*bpcp)->next) {
	    if (*bpcp == bpc)
		goto FOUND;
	}
	return no;	/* Not found! */
	FOUND:
	*bpcp = (*bpcp)->next;
	return yes;
}


interface bool FindCodeBreakpoint(ins_type ins)
/* Is there a breakpoint at this machine-code location? */
{	bpcode_type bpc;

	for (bpc=BpcodeList; bpc; bpc=bpc->next)
	    if (bpc->location == ins)
		return yes;
	return no;
}


interface bool DebugDeleteCodeBreakpoint(ins_type ins)
/* Delete this bpc, specified by instruction location. */
{   	bpcode_type bpc, *bpcp;

	for (bpcp=&BpcodeList; (bpc=*bpcp) != NULL; bpcp=&bpc->next) {
	    if (bpc->location == ins) {
		BpcDisable(bpc);
		*bpcp = bpc->next;
		delete bpc;
		return yes;
	    }
	}
	return no;
}


interface bool DebugInsertCodeBreakpoint(ins_type ins, Namedobj* obj, DebugInfo* dinfo)
/* Delete this bpc, specified by instruction location. */
{
	return InsertBpc(ins, obj, dinfo) != NULL;
}


interface bool DebugInsertBreakpoint(Namedobj* obj, int LineNo, DebugInfo* dinfo)
/* Create a breakpoint at this location. Supply the debug-info if you have it. */
/* If LineNo == 0, then pick the beginning of the fn. */
/* If it fails then it returns the reason in b_errno. */
{	DebugInfo::linemap_node *linemap;
	bpcode_type old_bpcode;
	bpsrc_type bp;
	int i;

	/* Check for a breakpoint already at this location: */
	for (bp=BpsrcList; bp; bp=bp->next) {
	    if (bp->obj == obj and bp->LineNo == LineNo)
		return yes;	    /* Already there. */
	}

	/* Get the debug object for this obj: */
	if (dinfo == NULL) {
	    dinfo = obj->make ? obj->make->source.dinfo : NULL;
	    if (dinfo == NULL) {
		b_errno = E_NO_DEBUG_OBJ;
		return no;		/* couldn't find the debuginfo object. */
	    }
	}

	/* Create a fresh object: */
	bp = new bpsrc_node;
	bp->LineNo = LineNo;
	bp->obj = obj;
	bp->bpcode = NULL;

	/* Find the code location(s). */
	if (LineNo == 0) {
	    LineNo = bp->LineNo = dinfo->linemap[0].LineNo;
            for (bpsrc_type bp=BpsrcList; bp; bp=bp->next) {       // Check for a breakpoint
                // already existing on this new line.
                if (bp->obj == obj and bp->LineNo == LineNo)
                    return yes;	    /* Already there. */
            }
        }

        /* Insert the breakpoint: */
	for (i=0; (linemap=&dinfo->linemap[i])->LineNo >= 0; i++) {
	    if (linemap->LineNo == LineNo) {
		old_bpcode = bp->bpcode;
		bp->bpcode = InsertBpc(linemap->Code, obj, dinfo);
		if (bp->bpcode)
		    bp->bpcode->next_for_src = old_bpcode;
		/* else it means there was already one there. */
	    }
	}
	if (bp->bpcode == NULL) {
	    b_errno = E_BREAKPOINT_NO_CODE;
	    delete bp;
	    return no;	    /* There's no code on this line. */
	}

	/* Install it in the list: */
	bp->next = BpsrcList;
	BpsrcList = bp;
	return yes;
}


interface bool DebugDeleteBreakpoint(Namedobj* obj, int LineNo)
/* Delete the breakpoint at this location. */
{	bpcode_type bpc, bpc_next;
	bpsrc_type bp, *bpp;

	/* Find it: */
	for (bpp=&BpsrcList; (bp=*bpp) != NULL; bpp=&bp->next)
	    if (bp->bpcode->obj == obj and bp->LineNo == LineNo)
		goto FOUND;
	TfcMessage("debug", 'x', "Breakpoint %s:%d not found", obj->name, LineNo);
	return no;	/* Not found. */
	FOUND:

	/* Delete the bpc's first: */
	for (bpc=bp->bpcode; bpc; bpc=bpc_next) {
	    bpc_next = bpc->next_for_src;
	    DeleteBpc(bpc);
	}

	/* Delete this bp: */
	*bpp = bp->next;
	delete bp;
	return yes;
}


interface bool FindBreakpoint(Namedobj* obj, int LineNo)
/* Is there a breakpoint at this source-code location? */
{	bpsrc_type bp;

	for (bp=BpsrcList; bp; bp=bp->next)
	    if (bp->LineNo == LineNo and bp->obj == obj)
		return yes;
	return no;
}


interface str DebugDisassemble(char buf[], ins_type ins)
/* Do a disassembly of this instruction, keeping in mind that we might need */
/* to uncover some breakpoints to get it. */
{	bpcode_type bpc;

	for (bpc=BpcodeList; bpc; bpc=bpc->next) {
	    if (bpc->location + 4/* length of bp*/ >= ins and bpc->location <= ins + 7 /* the longest instr */) {
		BpcDisable(bpc);
		Disassemble(buf, ins);
		BpcEnable(bpc);
		return buf;
	    }
	}
	return Disassemble(buf, ins);
}


static unsigned int RegisterLookup(int reg)
{
	switch (reg) {
	    case 0: return RegisterImage->Eax;
	    case 1: return RegisterImage->Ecx;
	    case 2: return RegisterImage->Edx;
	    case 3: return RegisterImage->Ebx;
	    case 4: return RegisterImage->Esp;
	    case 5: return RegisterImage->Ebp;
	    case 6: return RegisterImage->Esi;
	    case 7: return RegisterImage->Edi;
	    default:	assert(false);
		    return 0;
	};
}


static void* CurrentInstructionMem(disassembledins_type I)
/* Interpret a disassembledins_node struct according to the RegisterImage */
/* to get what memory location is being accessed by the current instruction. */
{	uchar* mem;

	if (not I->modregrm_present)
	    return NULL;
	mem = (uchar*)I->disp;
	if (I->sib_present)
	    mem += RegisterLookup(I->rm) + I->scaler*RegisterLookup(I->index);
        else if (I->rm != -1)
	    mem += RegisterLookup(I->rm);
	return mem;
}


interface ins_type* DebugDisassembleToStruct(ins_type ins, disassembledins_type I)
/* Do a disassembly of this instruction, keeping in mind that we might need */
/* to uncover some breakpoints to get it. */
{	bpcode_type bpc;

	for (bpc=BpcodeList; bpc; bpc=bpc->next) {
	    if (bpc->location + 4/* length of bp*/ >= ins and bpc->location <= ins + 7 /* the longest instr */) {
		BpcDisable(bpc);
		DisassembleToStruct(ins, I);
		BpcEnable(bpc);
		goto MEM;
	    }
	}
	DisassembleToStruct(ins, I);
	MEM:
	if (I->modregrm_present)
	    return (ins_type*)CurrentInstructionMem(I);
	else return NULL;
}


interface ins_type DebugNextInstruction(ins_type ins)
/* Uncover breakpoints as necessary and disassemble this instruction. */
{	bpcode_type bpc;

	for (bpc=BpcodeList; bpc; bpc=bpc->next) {
	    if (bpc->location + 4/* length of bp*/ >= ins and bpc->location <= ins + 7 /* the longest instr */) {
		BpcDisable(bpc);
		ins = NextInstruction(ins);
		BpcEnable(bpc);
		return ins;
	    }
	}
	return NextInstruction(ins);
}


interface void DebugBodyDeleted(Namedobj* obj)
/* Keeping breakpoints in sync with changing functions: */
/* remove all the machine-code-level breakpoints. */
{	bpcode_type bpc, bpc_next;
	bpsrc_type bp;

	for (bp=BpsrcList; bp; bp=bp->next) {
	    if (bp->obj == obj) {
		for (bpc=bp->bpcode; bpc; bpc=bpc_next) {
		    bpc_next = bpc->next_for_src;
		    DeleteBpc(bpc);
		}
		bp->bpcode = NULL;
	    }
	}
	DebugGuiDeleteObj(obj);	    // Uninstalls the source-code
}


interface void DebugBodyRecompiled(Namedobj* obj)
/* Keeping breakpoints in sync with changing functions: */
/* re-instate all the 'lost' breakpoints of this object.*/
{	DebugInfo::linemap_node *linemap;
	bpcode_type old_bpcode;
	DebugInfo* dinfo;
	bpsrc_type bp;
	int i;

	DebugBodyDeleted(obj);	    // In case it hasn't already been done.
	DebugGuiDeleteObj(obj);	    // Uninstalls the source-code

	/* Get the debug object for this obj: */
        if (obj->make == NULL or (dinfo=obj->make->source.dinfo) == NULL)
            return;

	/* Look for any breakpoints that need re-instating: */
	for (bp=BpsrcList; bp; bp=bp->next) {
	    if (bp->obj == obj) {

		/* Find the code location(s). */
		for (i=0; (linemap=&dinfo->linemap[i])->LineNo >= 0; i++) {
		    if (linemap->LineNo == bp->LineNo) {
			old_bpcode = bp->bpcode;
			bp->bpcode = InsertBpc(linemap->Code, obj, dinfo);
			if (bp->bpcode)
			    bp->bpcode->next_for_src = old_bpcode;
			/* else it means there was already one there. */
		    }
		}
	    }
	}
}


interface void DebugDeleteObj(Namedobj* obj)
/* Keeping breakpoints in sync with changing functions: */
/* delete all the breakpoints this object had. */
{	bpcode_type bpc, bpc_next;
	bpsrc_type bp, *bpp;

	for (bpp=&BpsrcList; (bp=*bpp) != NULL; ) {
	    if (bp->obj == obj) {
		/* Delete the bpc's: */
		for (bpc=bp->bpcode; bpc; bpc=bpc_next) {
		    bpc_next = bpc->next_for_src;
		    DeleteBpc(bpc);
		}

		/* Delete this bp: */
		*bpp = bp->next;
		delete bp;
	    }
	    else bpp = &bp->next;
	}
	DebugGuiDeleteObj(obj);
}


interface void DebugCloseContainer(class Conim *conim)
/* Delete all breakpoints for objects in this Conim. */
{	bpcode_type bpc, bpc_next;
	bpsrc_type bp, *bpp;

	for (bpp=&BpsrcList; (bp=*bpp) != NULL; ) {
	    if (Ptr_to_conim(bp->obj) == conim) {

		/* Delete the bpc's: */
		for (bpc=bp->bpcode; bpc; bpc=bpc_next) {
		    bpc_next = bpc->next_for_src;
		    DeleteBpc(bpc);
		}

		/* Delete this bp: */
		DebugGuiDeleteObj(bp->obj);
		*bpp = bp->next;
		free(anon_heap, bp);
	    }
	    else bpp = &bp->next;
	}
}







/*-------------- Finding followers & return points and so on: -----------------*/

static ins_type *SameLine;
static foundins_fn processor;

static void Consider(ins_type ins)
/* This instruction is reachable.  Process it if it's on a different line. */
{
	/* Are we avoiding this one (probably on the same line)? */
	if (Array_HasP(SameLine, ins))
	    return;
	processor(ins);
}


interface void DebugFindFollowers(ins_type *_SameLine, foundins_fn _processor)
/* Find all instructions of different lines reachable directly from '_SameLine'. */
{	ins_type ins;
	int i;

	SameLine = _SameLine;
	processor = _processor;
	for (each_aeli(ins, _SameLine)) {
	    if (*ins == 0xeb) {
		Consider(ins + 2 + (char)ins[1]);
	    }
	    else if (*ins == 0xe9) {
		Consider(ins + 5 + *(int*)(ins+1));
	    }
	    else if ((*ins & 0xf0) == 0x70) {
		Consider(ins + 2 + (char)ins[1]);
		Consider(ins + 2);
	    }
	    else if (*ins == 0x0f and (ins[1] & 0xf0) == 0x80) {
		Consider(ins + 6 + *(int*)(ins+2));
		Consider(ins + 6);
	    }
	    else if (*ins == 0xc3) {
                /* The RET statement will be covered by the DebugFindParent() fn. */
            }
	    else {
                ins = NextInstruction(ins);
                if (i+1 < Array_Size(SameLine) and ins == SameLine[i+1])
                    continue;   // An optimisation.
                Consider(ins);
            }
	}
}


static void ProcessCallTarget(ins_type ins, foundins_fn processor)
/* 'ins' is the target of a call. Process its following instruction */
/* if it's an ENTER instruction, otherwise it itself.  This is      */
/* because we never like users to break before the ENTER instrction,*/
/* this stuffs up all the Watch points etc. */
{
        if (*ins == 0xc8)
            processor(ins+4);
        else processor(ins);
}


interface void DebugFindCalls(ins_type *_SameLine, foundins_fn processor)
/* Find all CALL destinations called from _SameLine. */
{	struct disassembledins_node I;
	ins_type ins, *insp;
	int i;

	for (each_aeli(ins, _SameLine)) {
	    if (*ins == 0xe8)
		ProcessCallTarget(ins + 5 + *(int*)(ins+1), processor);
	    else if (*ins == 0xff and (ins[1] & 0x38) == 0x10) {
		if (ins == (ins_type)RegisterImage->Eip) {
		    insp = DebugDisassembleToStruct(ins, &I);
		    if (insp)
			ProcessCallTarget(*insp, processor);
		}
		else ProcessCallTarget(ins, processor);
	    }
	}
}


interface void DebugFindParent(FrameNode *Frame, foundins_fn processor)
/* Find the instruction that will be executed straight after we return. */
{	ins_type ins;

        try {
            ins = ((ins_type*)Frame->BP)[1];
            processor(ins);
        }
        catch (...) {
            TfcMessage("DebugFindParent", '!',
                "Frame = 0x%p.  Can't insert breakpoint at 0x%p", Frame->BP, ins);
        }
}


interface FrameNode DebugFrameToParent(const FrameNode &Frame)
/* Return the frame corresponding to this frame's caller */
{       FrameNode Parent;

        Parent.ins = (ins_type)((int*)Frame.BP)[1];
        Parent.BP = (void**)(*(void**)Frame.BP);
        return Parent;
}




/*-------------- The direct interface: -----------------*/

interface int DebugInsToLineNo(DebugInfo* dinfo, ins_type ins)
/* Map an instruction to a line-number. */
{	DebugInfo::linemap_node *linemap;
	int i;

	/* Find the line number: */
	if (dinfo == NULL)
	    return -1;
	for (i=1; (linemap=&dinfo->linemap[i]) < (void*)dinfo->localvarmap; i++) {
	    if (linemap->Code > ins)
		return dinfo->linemap[i-1].LineNo;
	}
	return -1;
}




/*---------------- Exception Handlers: --------------*/

/*

typedef struct _CONTEXT {
    DWORD ContextFlags;


    // This section is specified/returned if CONTEXT_DEBUG_REGISTERS is
    // set in ContextFlags.  Note that CONTEXT_DEBUG_REGISTERS is NOT
    // included in CONTEXT_FULL.
    DWORD   Dr0;
    DWORD   Dr1;
    DWORD   Dr2;
    DWORD   Dr3;
    DWORD   Dr6;
    DWORD   Dr7;


    // This section is specified/returned if the
    // ContextFlags word contians the flag CONTEXT_FLOATING_POINT.
    FLOATING_SAVE_AREA FloatSave;


    // This section is specified/returned if the
    // ContextFlags word contians the flag CONTEXT_SEGMENTS.
    DWORD   SegGs;
    DWORD   SegFs;
    DWORD   SegEs;
    DWORD   SegDs;


    // This section is specified/returned if the
    // ContextFlags word contians the flag CONTEXT_INTEGER.
    DWORD   Edi;
    DWORD   Esi;
    DWORD   Ebx;
    DWORD   Edx;
    DWORD   Ecx;
    DWORD   Eax;


    // This section is specified/returned if the
    // ContextFlags word contians the flag CONTEXT_CONTROL.
    DWORD   Ebp;
    DWORD   Eip;
    DWORD   SegCs;              // MUST BE SANITIZED
    DWORD   EFlags;             // MUST BE SANITIZED
    DWORD   Esp;
    DWORD   SegSs;


    // This section is specified/returned if the ContextFlags word
    // contains the flag CONTEXT_EXTENDED_REGISTERS.
    // The format and contexts are processor specific
    BYTE    ExtendedRegisters[MAXIMUM_SUPPORTED_EXTENSION];

} CONTEXT;
*/


#define EXCEPTION_ASSERT_FAIL   0xba2bad05

interface void L_assert(bool assertion)
/* This would normally go in 'runlib.cpp' except that it interacts */
/* heavily with the debugger. */
{
        if (not assertion)
            RaiseException(EXCEPTION_ASSERT_FAIL, 0, 0, NULL);
}



interface int DebugException(EXCEPTION_POINTERS *dbg)
/* Must return:
	-1 to continue at the point of the exception
	1 to exit the user code and go back to the Barbados prompt
	0 if the exception is not handled (pass it to the Borland
		exception handler)
*/
{	static bool AlreadyDebugging;
	DebugInfo* dinfo;
	bool Continuable=no;
	Namedobj *obj;

	switch (dbg->ExceptionRecord->ExceptionCode) {
	    case EXCEPTION_ACCESS_VIOLATION:
		/* ExceptionInformation[0] is 0 if it was an attempt
		to read which caused the exception; next position is the address
		in virtual memory which was the target of the operation. */
		sprintf(exception_message,
			"Access violation at address %p when accessing %p. Tried to %s",
                        dbg->ExceptionRecord->ExceptionAddress,
                        dbg->ExceptionRecord->ExceptionInformation[2],
                        (dbg->ExceptionRecord->ExceptionInformation[0]==0) ?
                            "read inaccessible data. " :
			    "write an inaccessible address. ");
		break;

	    case EXCEPTION_BREAKPOINT:
		sprintf(exception_message,
			"Breakpoint hit.");
		Continuable = yes;
		break;

	    case EXCEPTION_INT_DIVIDE_BY_ZERO:
		sprintf(exception_message,
			"Divide by zero (integer)");
		break;

	    case EXCEPTION_FLT_DIVIDE_BY_ZERO:
		sprintf(exception_message,
			"Divide by zero (floating point)");
		break;

	    case EXCEPTION_STACK_OVERFLOW:
		sprintf(exception_message,
			"Stack overflow (unbounded recursion?)");
		break;

	    case EXCEPTION_FLT_STACK_CHECK:
		sprintf(exception_message,
			"Floating-point unit register overflow");
		break;

            case CONTROL_C_EXIT:
                return 0;
		/*sprintf(exception_message,
			"Run-time error: %s", Error.message);
                break;*/

            case EXCEPTION_ASSERT_FAIL:
		sprintf(exception_message, "Assert failed");
                Continuable = yes;
                break;

	    default:
		TfcMessage("debug", 'x', "Unhandled exception:  0x%x",
			dbg->ExceptionRecord->ExceptionCode);
		return 0;       // Not handled.
	}

	/* Are we re-entering the debugger? */
	if (AlreadyDebugging) {
	    TfcMessage("Bug in debugger", '!', "%s", exception_message);
	    return 0;
	}
	AlreadyDebugging = yes;

	/* Find the frame that we're in, by unwinding out of a stack */
	/* of library calls if necessary: */
	Frame.ins = (uchar*)dbg->ContextRecord->Eip;
	Frame.BP = (void**)dbg->ContextRecord->Ebp;
#ifdef DECREMENT_IP_INT3
        // Some combinations of compiler and Win OS version require this
        // decrementing (decrement IP to return to the start of the instruction
        // that the INT3 was covering).
	if (dbg->ExceptionRecord->ExceptionCode == EXCEPTION_BREAKPOINT) {
            //Frame.ins--;                // This is what the debugger sees
            //dbg->ContextRecord->Eip--;  // This is what we'll return to
	    // My Win95 computer needs this, but not my WinNT computer.
        }
#endif
	try {
            dinfo = NULL;
            for ( ; ; Frame = DebugFrameToParent(Frame)) {
                obj = InsToObj(Frame.ins);
                if (obj == NULL)
                    continue;
                if (strieq(obj->name, "Barbados>"))
                    break;
                if (obj->make == NULL or (dinfo=obj->make->source.dinfo) == NULL)
                    continue;
                else break;
                /* runlib.cpp library functions such as operator<< will  */
                /* have an 'obj' but no 'dinfo'.  Borland libc functions */
                /* will have neither 'obj' nor 'dinfo'. */
            }
	}
	catch (...) {
	    obj = NULL;
	    Frame.ins = (uchar*)dbg->ContextRecord->Eip;
	    Frame.BP = (void**)dbg->ContextRecord->Ebp;
	    TfcMessage("Debugger", '!', "The instruction-pointer is: %p, "
		"but I can't find any Barbados function in the stack frame."
		"\n\n%s",
		Frame.ins, exception_message);
	    return 0;
	}
	RegisterImage = &RegIm;
        RegIm = *dbg->ContextRecord;
	RegIm.Eip = (int)Frame.ins;
	RegIm.Ebp = (int)Frame.BP;


	/* Enter the debugger: */
	Debugger(obj, dinfo, DebugInsToLineNo(dinfo, Frame.ins), &Frame);

	/* Return: */
	AlreadyDebugging = no;
	return Continuable ? -1 : 1;
}


interface void DebugInit(void)
{
}



