/*** NAME.H : Named object creation, deletion; scope; directories ***/



extern Directory* curdir;
extern class Conim* curconim;		// = Ptr_to_heap(curdir)
extern int InsideCompiler;		// Are we in compile-time or run-time?
extern bool MakeCanBeClosed;		// Do we update make now or later?
extern Directory* stdlib_dir;	// The directory of standard objects
extern Directory* common_dir;	// Common objects




/*----- Initialising -----*/
void NameInit();





/*----- Inserting & deleting named objects -----*/

Namedobj* NameDeclare(Directory* direc, str name, Type type, storage_enum storage,
	    int flags);
	/* Created a named-object. Can be for a directory, for a class	*/
	/* definition or for local variables, or even for macros and	*/
	/* goto labels. */
#define NAME_OVERLOAD		0x1
#define NAME_CREATEMAKE		0x2
	/* OVERLOAD:  if you declare a new function in the same directory as */
	/* an old one, and it has a different footprint, does it overwrite   */
	/* the old one or is it an overloaded version of it? */
	/* CREATEMAKE:	do we create a make node? */


bool NameDelete(Directory* direc, Namedobj* obj);
	/* Delete this object from its directory. */
	/* Can fail, e.g. a non-empty directory.  */

typedef Namedobj* scopemarker_type;

scopemarker_type NameMarkScope();
	/* Get a pointer which marks the current position on the stack of */
	/* local variables. */

void NamePopScope(scopemarker_type scope);
	/* Delete all local variables back to the specified position */
	/* on the stack of local variables. */

Namedobj* NameGrabList(scopemarker_type scope);
	/* Take all objects declared since 'scope' and return it as */
	/* a linked list. This action also removes them from 'scope'. */


/* For directory objects:   Use NameDeclare() and NameDelete(). */
/* For local objects:	    Use NameMarkScope(); NameDeclare(); NamePopScope(); */
/* For class definitions:   Use NameMarkScope; NameDeclare() and NameGrabList(). */
/* For enums:		    Use NameMarkScope; NameDeclare(). */

Namedobj* NameLocalResolve(str name);
	/* Resolve this name to a single object in the local-variable scope. */

Namedobj* NamePathToObj(str path);
	/* Convert this path to a (namedobj,directory).	*/
	/* This algorithm should be equivalent to the	*/
	/* compiler's path-name resolution algorithm,	*/
	/* meaning we understand '..' and absolute vs	*/
	/* relative path-names and so on. We use this	*/
	/* function for run-time use.  NB:- this func	*/
	/* deals with 'unames', ie. Unique Names,	*/
	/* meaning that overloaded functions are	*/
	/* distinguished with a ' symbol and version	*/
	/* number. */






/*------------- Misc Name functions: ------------*/

bool NameIsOriginalClass(Namedobj* obj);
/* Is this obj the original class/struct typedef for some structure? */

bool NameIsOriginalEnum(Namedobj* obj);
/* Is this obj the original enum typedef for some structure? */

str NameUnameFromObj(Namedobj* obj, char dest[]);
/* Map this object to a 'uname'. */

bool NameDeleteClass(Namedobj* typedef_obj);
/* Delete this object, including the structure definition */
/* and member functions. */

bool NameDirectoryDelete(Directory* direc, Namedobj* obj);
/* Remove this object from this directory.  */
/* Requires that (a) we have this directory */
/* in write mode, and (b) it's not in the   */
/* current name-space. */

bool NameBodyDefined(Namedobj* obj);
/* Has the body of this function or class definition been defined? */
/* Used to interface MAKE with the compiler. */

str NameObjectUnique(Namedobj* obj);
/* Returns a str identifier that makes overloaded functions unique again. */

void NameOwner(Namedobj* obj, Directory* *dirp, Classdef* *classdefp);
/* Find the owner of this object.  It will be either a dir or a classdef. */
/* Set the relevant one and set the other to NULL. */

FunctionNamedobj* FindMemberFn(Classdef* classdef, str name, Type footprint);
/* Look for a function matching this (name,type) description in */
/* a base class of the given type. */

void CurdirInterfaceChange(bool just_address);
/* Indicate that something in the curdir has changed interface. */

Classdef* NameClassdefFromObject(Namedobj* obj);
/* Return the class of an object, if this object is the class definition */

void DestroyObj(Namedobj* obj);
/* We are about to overwrite or free this variable.  Do anything */
/* we need to do to destroy the value. */



/*--------------- Directory Functions --------------*/

void CurdirInit(void);
void CurdirClose(void);

void Chdir(Directory* new_dir);
bool ChdirContainer(container_id cid);
void DirectoryPrint(Directory* direc);
void DirectoryPrintC(container_id cid);

