/*** NAMEDECL.H :  Interfaces NAME.CPP with COMPDECL.CPP. ***/

typedef enum { not_inside, in_class, in_struct, in_union } InsideAggregateEnum;

extern int auto_offset, max_auto_offset;// For storage of auto variables
extern int member_offset;               // For storage of struct members
extern int member_bit_offset;           // For storage of bit-fields
extern int enum_value;                  // The current value for an enum-const decl.
extern storage_enum storage, default_storage;
extern visibility_enum visibility;
extern bool Overloaded;		        // Is the thing being declared overloaded?
extern int BitField;		        // The width of the current object in bits
extern InsideAggregateEnum InsideAggregate;
extern int parameter_location;
extern Classdef* declarator_class;
extern bool InsideEnum;
extern bool PredefinitionPhase;         // We're defining system entities.

int AllocateLocalStatic(uint size, Type type);
Namedobj* FindTypedefObj(Type type);
Namedobj* NamePartialMembers();
        // Returns a pointer to the linked list of partially parsed members
        // of a class/struct/union.

Namedobj* CreateAutoObj(str name, Type type, storage_enum storage, int offset);
        // An alternative to 'CreateObj()'.  Creates the object in the
        // compiler heap.  Such objects should never be delete'd, they
        // are implicitly freed when the whole compiler heap is freed.

LocalStaticNamedobj* CreateLocalStaticObj(str name, Type type);
        // Like above, but for local_static's.

