#include "barbados.h"



extern bool SwizzleWritePhase(PtrProcessor_fn fn);
	/* Are we in the 'swizzle pointers of GC'd LGO Image' phase? */

extern bool SwizzleLoadPhase(PtrProcessor_fn fn);
	/* Are we in the 'add delta to pointers of LGO image' phase? */

extern str BaseToImage(void* v);

extern PtrProcessor_fn PtrProcessor;



void CallPtrFinder(void *ptrfinder, void *address, PtrProcessor_fn fn)
{
        if (ptrfinder == 0)
            return;
        PtrProcessor = fn;
__asm   {
        MOV EDI,fn
        MOV EAX,address
        CALL ptrfinder
        }
}


interface Type FindPtrsInTypstr(Type type)
{	PtrProcessor_fn fn;
        int i;

	do {
	    switch (*type++) {
		case tp_reference:
		case tp_volatile:
		case tp_dynarray:
		case tp_pointer:
		case tp_const:	    continue;
		case tp_array:      type += sizeof(int);
				    continue;
	        case tp_ptrmemberfn:
		case tp_function:   for (i=(unsigned char)*type++ & 127; i; i--)
					type = FindPtrsInTypstr(type);
				    assert(*type == tp_terminated);
				    type = FindPtrsInTypstr(++type);
				    return type;
		case tp_enumerated: fn((void**)type);
				    return type + 4;
		case tp_class:	    fn((void**)type);
				    return type + 4;
		default:            return type;
	    }
	} forever;
}


interface void* FindPtrsInNamedobj(namedobj_type obj)
{
	/* With this function and its brothers, we must find all    */
	/* pointers in this _tile_.  That means that any sub-object */
	/* that it points to within the tile must have its pointers */
	/* found.  For static_storage named objects, this means	    */
	/* the value embedded in it. */

	if (SwizzleWritePhase(fn)) {
	    /* Process values first, then type info. */

	    /* The location ptr and the embedded value: */
	    if (obj->storage == straight_fn or obj->storage == member_fn or
		obj->storage == local_static or obj->storage == macro_storage)
		fn((void**)&obj->u.location);
	    else if (obj->storage == static_storage) {
		/* Static storage objects are the tricky ones, because  */
		/* we need to find all ptrs in a tile yet in order to   */
		/* do so requires following an unswizzled ptr. */
		fn((void**)&obj->u.location);
		if (*obj->type == tp_class) {
		    Classdef* classdef=*(Classdef**)(obj->type+1);
		    if (classdef->VirtualFns)
			fn((void**)(BaseToImage((char*)obj->u.location - 4)));
			/* Swizzle the virtual-function pointer. */
		}
		FindPtrs(BaseToImage(obj->u.location), obj->type, fn);
	    }

	    /* Process type info. */
	    FindPtrsInTypstr(obj->type, fn);

	    obj->make = NULL;
	}
	else {

	    /* Process type info first, then values. */
	    FindPtrsInTypstr(obj->type, fn);

	    /* The location ptr and the embedded value: */
	    if (obj->storage == straight_fn or obj->storage == member_fn or
		obj->storage == local_static or obj->storage == macro_storage)
		fn((void**)&obj->u.location);
	    else if (obj->storage == static_storage) {
		/* Static storage objects are the tricky ones, because  */
		/* we need to find all ptrs in a tile yet in order to   */
		/* do so requires following an unswizzled ptr. */
		fn((void**)&obj->u.location);
		if (*obj->type == tp_class) {
		    Classdef* classdef=*(Classdef**)(obj->type+1);
		    if (classdef->VirtualFns)
			fn((void**)((char*)obj->u.location - 4));
			/* Swizzle the virtual-function pointer. */
		}
		FindPtrs(obj->u.location, obj->type, fn);
	    }
	}

	/* Other pointers: */
	fn((void**)&obj->name);
	fn((void**)&obj->next);
	fn((void**)&obj->owner);
}


interface void** FindPtrsInClassdef(Classdef* classdef)
{	namedobj_type obj;
	void **vf;
	int i;

	/* Maybe we've already processes this one! */
	if (SwizzleLoadPhase(fn) and ClassdefIsCorrectlyBased(classdef))
	    return;

	/* With this function and its brothers, we must find all    */
	/* pointers in this _tile_.  That means that any sub-object */
	/* that it points to within the tile must have its pointers */
	/* found.  For static_storage namedobj's, this means the    */
	/* value embedded in it. */

	/* Important pointers: */
	fn((void**)&classdef->member);	// This _doesn't_ recurse because the
			// members are all in the same tile as the classdef.
	fn((void**)&classdef->typedef_obj);
	fn((void**)&classdef->myself);
	/* Don't do this:  fn((void**)&classdef->VirtualFns);  because VirtualFns is now an integer. */

	/* Virtual function pointers: */
	for (each_oeli(vf, (void**)(classdef+1)))	// The format of the virtualfn table
	    fn(vf);					// matches the format of a dynamic array.

	/* The members: */
	if (SwizzleWritePhase(fn)) {
	    for (obj=(namedobj_type)BaseToImage(classdef->member); obj;
			obj=(namedobj_type)BaseToImage(obj->next)) {
		FindPtrsInNamedobj(obj, fn);
	    }
	}
	else {
	    for (obj=classdef->member; obj; obj=obj->next) {
		FindPtrsInNamedobj(obj, fn);
	    }
	}
}


interface void** FindPtrsInBitmap(void *p)
/* There are no real pointers here, just some Win32 handles.	*/
/* Since we have no hope of finding the same Win32 objects	*/
/* around when we reload, we simply zero out any such handles	*/
/* when writing out a container, and the applications must	*/
/* create them anew.  In future, we might try to extract the	*/
/* data out of Windows (it might mean getting it out of video-	*/
/* card memory!) and make it persistent. */
{	struct copyofbitmap_node {	// We copy it to avoid a dependency of types.cpp on bitmap.cpp.
	    int cx, cy;
	    void* mDC;
	    void* Bmp;
	} *bm=(struct copyofbitmap_node*)p;

	if (SwizzleWritePhase(fn)) {
	    bm->mDC = NULL;
	    bm->Bmp = NULL;
	}
}


interface void FindPtrs(void* p, Type type)
/* This function finds all pointers in this object, and passes	*/
/* them through 'fn'.  It does not recurse into other memory	*/
/* blocks (unless 'fn' recurses into other memory blocks).	*/
/* 'fn' is recursive in the case of the garbage collection	*/
/* phase, but otherwise not. */
{	Classdef* classdef;
	int i, dimension, size;

	if (type == NULL or p == NULL)
	    return;
	switch (*type++) {
	    case tp_pointer:
            case tp_ptrmemberfn:
            case tp_reference:
		    fn((void**)p);
		    break;

	    case tp_array:
		    GetDimension(dimension, type);
		    if (not TypeIncludesPointers(type))
			break;
		    size = TypeSize(type);
		    for (i=0; i < dimension; i++) {
			FindPtrs(p, type, fn);
			(char*&)p += size;
		    }
		    break;

	    case tp_function:
		    FindPtrsInFuncblock((funcblock_type)p, fn);
		    break;

	    case tp_class:
		    GetPtr(classdef, type);
		    FindPtrs(p, classdef, fn);
		    break;

	    default:// It must be a single datum.
		    break;
	}
}



 