

typedef struct type_expansion {
	int primary;
	Type remainder;
	int n;
	Type params;
	Namedobj* obj, *typedef_obj;
} *type_expansion_type;




/*---------- Initialisation: -----------*/

void StdlibInit(void);




/*------------ Displaying types & values: ------------*/

void OutputValueRaw(Ostream* out, void* value, Type type);	// Don't use any user fn's.
void OutputValueUser(Ostream* out, void* value, Type type);	// Use user fn's if available.
void OutputType(Ostream* out, Type s);
void OutputClassdef(Ostream* out, Classdef* classdef);
void OutputAny(Ostream* out, void *value);
str ValueToString(char buf[], int maxsize, void* value, Type type, bool user_fns);
str ObjDeclarationString(Namedobj* obj, char dest[], int sizeofdest);



/*-----------------*/
void* Fprt(Type type);
void CheckErrno(container_id cid);


str my_gets(char dest[]);

bool CheckTypes(Type A, Type B);

Namedobj* NamePathToObj(str s);
bool CanUseObj(Namedobj* obj);
Namedobj* DirCreateObj(Directory* direc, str name, Type type);
Any DirFindObj(Directory* direc, str uname);
void DirDeleteObj(Directory* direc, str name);
void CopyObj(str s, str d);
void MoveObj(str s, str d);
int TypeExpand(Type type, struct type_expansion *tyex);
Type TypeNextParam(Type type);
Type AnyType(Any A);
Any* AnyArrayLookup(Any A, int i);
int AnyArrayLength(Any A);
Any* AnyFieldLookup(Any A, Namedobj* this_obj);
Any* AnyFieldLookupS(Any A, str s);
Any* AnyDereference(Any A);
int* AnyFunctionCall(int **SPptr, Any *Fn, Any *Params);
Namedobj* NamedObjNext(Namedobj* obj);
str NamedObjName(Namedobj* obj);
Any* NamedObjAny(Namedobj* obj);
Namedobj* NamedObjDependency(Namedobj* obj, int n);
Namedobj* NamedObjFromString(Directory* direc, str s);
Ostream* NamedObjPrint(Ostream* cout, Namedobj* obj);
Namedobj* DirectoryFirst(Directory* direc);
void FixChildContainers(void);



int DebuggerEnter(int LineNo, int *_PC, bool StopHere);
void DebuggerExit(void);



/*----- Memory access checking -----*/
#define AccessCheck     _AccessCheck    
extern bool MemoryCheck, AccessCheck;

void AccessAddInterval(void* m, uint len);
void AccessDeleteInterval(void* m, uint len);
bool AccessCheckAccess(void* m);
bool AccessCheckRange(void* m, uint len);
void AccessAddStack(int *start, uint len, int **ptr);



/*----- Misc: -----*/

void GrepO(str s);
void GrepS(str s);
void GrepD(Namedobj* obj);
