#ifndef MEMORY_H
#include "memory.h"
#endif


/* Storing Source: */
void SourceClearStashed(void);
void SourceStash(Namedobj* obj, Classdef* owner);
void SourceStoreStashed(void);      // Takes source from 'CurrentSource'.
void SourceStashRename(Namedobj* oldobj, Namedobj* newobj);


/* Retrieving source-code: */
str SourceFromObject(Namedobj* obj);
str SourceHeader(Namedobj* obj);
Directory* SourceDirectory(Directory* direc, bool create);


/* Container Makes: */
void SourceLinkSource(Conim *conim, bool CreateIfNeeded);
bool SourceNeedsLinkSource();


/* User functions: */
bool Source_src_del(str name);
bool Source_src_mv(str name, Directory* direc);


/* Misc: */
Directory* ObjectToDirectory(Namedobj* obj);
	/* Find the directory that this object belongs in. */
