#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "editor.h"
#include "resource.h"



class FooEditor : public EditorWin {
public:
	void New();
	void Open();
	void Save();
	void SaveAs();
	void Exit();
	void About();

	FooEditor(str caption, int width, int height);
	Line* NewLine();
	int DefineState(Line *ln);
	bool Keystroke(int key);
	void ApplyFormatting(char formatch);
	void WindowClose() { Exit(); }

	static char* unnamed;
};



interface int FooEditor::DefineState(Line *prev)
/* Define this line's state by processing the previous line. */
{
	return HelpDefineState(prev);
}


Line* FooEditor::NewLine()
{
	return new Line;
}


FooEditor::FooEditor(str caption, int width, int height)
    : EditorWin(caption, width, height)
{
	Background = DARK(BLUE);

	#define Sub	TfcSubMenu
	#define It	TfcMenuItem
	SetMenu(
	    Sub("&File",
		It("&New", (SwVoidVoid_fn)&FooEditor::New),
		It("&Open", (SwVoidVoid_fn)&FooEditor::Open),
		It("&Save", (SwVoidVoid_fn)&FooEditor::Save),
		It("Save &As", (SwVoidVoid_fn)&FooEditor::SaveAs),
		It("&Print", (SwVoidVoid_fn)&FooEditor::Print),
		TfcSeparator(),
		It("E&xit", (SwVoidVoid_fn)&FooEditor::Exit),
		NULL),

	    Sub("&Edit",
		It("Undo\tALT-BACKSPACE", (SwVoidVoid_fn)&EditorWin::UndoOp),
		It("Redo\tctrl-R", (SwVoidVoid_fn)&EditorWin::RedoOp),
		TfcSeparator(),
		It("Cut\tSHIFT_DEL", (SwVoidVoid_fn)&EditorWin::Cut),
		It("&Copy\tSHIFT-INS", (SwVoidVoid_fn)&EditorWin::CopyAndClear),
		It("&Paste", (SwVoidVoid_fn)&EditorWin::Paste),
		TfcSeparator(),
		It("&Find", (SwVoidVoid_fn)&EditorWin::GuiFind),
		It("&Replace", (SwVoidVoid_fn)&EditorWin::GuiReplace),
		NULL),

	    Sub("&Help",
		It("&About FooEditor", (SwVoidVoid_fn)&FooEditor::About),
		NULL),

	    NULL
	);
	#undef Sub
	#undef It


	/*** The dialog bar: ***/
	control bar_c;
	bar_c = IconButton(IDI_NEW, (SwVoidVoid_fn)&FooEditor::New) | 
	    IconButton(IDI_OPEN, (SwVoidVoid_fn)&FooEditor::Open) |
	    IconButton(IDI_SAVE, (SwVoidVoid_fn)&FooEditor::Save) |
	    IconButton(IDI_PRINT, (SwVoidVoid_fn)&EditorWin::Print) |
	    IconButton(IDI_CUT, (SwVoidVoid_fn)&EditorWin::Cut) |
	    IconButton(IDI_COPY, (SwVoidVoid_fn)&EditorWin::Copy) |
	    IconButton(IDI_PASTE, (SwVoidVoid_fn)&EditorWin::Paste);
        SetRebar(bar_c, nullcontrol);
}


void FooEditor::ApplyFormatting(char formatch)
{	Line *oldie;
	str s,buf;

	if (Marker1.ln) {
	    /*** We have selected text - apply formatting to it. ***/
	    StartTransaction();
	    InsertChar(Marker1, formatch);
	    InsertChar(Marker2, formatch);
	    FinishTransaction();
	}
	else {
	    /*** No text selected - just insert us into a double-format-char. ***/
	    oldie = c.ln;
	    buf = (str)malloc(strlen(oldie->buf) + 3);
	    memcpy(buf, oldie->buf, c.n);
	    buf[c.n] = formatch;
	    buf[c.n+1] = formatch;
	    strcpy(buf + c.n + 2, oldie->buf + c.n);

	    /* Optimise out old formatting doubles: */
	    for (s=buf; *s; s++) {
		if (s-buf == c.n)
		    continue;
		if (*s > 0 and *s < ' ' and s[1] > 0 and s[1] == *s) {
		    strcpy(s, s+2);
		    s--;
		}
	    }
	    *s = '\0';

	    /* Put in this line: */
	    ReplaceLine(oldie, buf, c);
	    free(buf);
	    c.n++;
	}
	c.ln->SetCursor(c.n);
}


bool FooEditor::Keystroke(int key)
{
	switch (key) {
	    case RIGHT:
		while (c.n < strlen(c.ln->buf) and 
			    c.ln->buf[c.n] > 0 and c.ln->buf[c.n] < ' ')
		    MoveRight();
		return EditorWin::Keystroke(key);

	    case LEFT:
		while (c.n > 0 and c.ln->buf[c.n] > 0 and c.ln->buf[c.n] < ' ')
		    MoveLeft();
		return EditorWin::Keystroke(key);

	    case CTRL('B'):
		ApplyFormatting(1);
		break;

	    case CTRL_I:
		ApplyFormatting(2);
		break;

	    case CTRL('L'):
		ApplyFormatting(3);
		break;

	    case F1:
		ViewHelp("\2Help\2:\nYou see many lines here.\nAre they all bad?\n");
		break;

	    default:
		return EditorWin::Keystroke(key);
	}
	c.ln->SetCursor(c.n);
	return yes;
}


char* FooEditor::unnamed = "unnamed.cpp";


void FooEditor::New()
{
	if (NeedsSave) {
	    response = TfcChoose("New", "&Save\0&Discard\0Cancel\0", 
			"Do you want to save: %s ?", filename);
	    if (response == 0 or response == 3)
		return;
	    if (response == 1)
		Save();
	}
	remove(unnamed);
	LoadFile(unnamed);
	SetTitle(unnamed);
}


void FooEditor::Open()
{	char* _filename;
	char buf[1024];
	int response;

	/* Choose the filename. */
	buf[0] = '\0';
	_filename = TfcSelectFilename(no, buf, sizeof(buf),
		"C and C++ files\0*cpp; *.c; *.h\0C++ source files\0*.cpp\0"
		"C source files\0*.c\0Header files\0*.h\0All files\0*.*\0", "cpp");
	if (_filename == NULL)
	    return;

	/* What about the existing file? */
	if (NeedsSave) {
	    response = TfcChoose("Open", "&Save\0&Don't save\0Cancel\0", 
			"Do you want to save:\n\t%s\n", filename);
	    if (response == 0 or response == 3)
		return;
	    if (response == 1)
		SaveFile();
	}

	/* Ok - load it! */
	LoadFile(_filename);
	SetTitle(_filename);
}


void FooEditor::Save()
{
	if (strcmp(filename, unnamed) == 0)
	    SaveAs();
	else {
	    SaveFile();
	    TfcMessage("Save", 'i', "File saved.");
	}
}


void FooEditor::SaveAs()
{	char* _filename;
	char buf[1024];

	buf[0] = '\0';
	_filename = TfcSelectFilename(yes, buf, sizeof(buf),
		"C++ files\0*.cpp\0C files\0*.c\0Header files\0*.h\0\0", "cpp");
	if (_filename == NULL)
	    return;
	strcpy(filename, _filename);
	SaveFile();
	SetTitle(filename);
	TfcMessage("Save", 'i', "File saved as: %s", filename);
}


void FooEditor::Exit()
{	int response;

	if (NeedsSave) {
	    response = TfcChoose("Exit", "~&Save\0Just e&xit\0Cancel\0", 
			"Do you want to save: %s ?", filename);
	    if (response == 0 or response == 3)
		return;
	    if (response == 1)
		Save();
	}
	exit(0);
}


void FooEditor::About(void)
{	control c;

	c = (StaticText("FooEditor v1.0") | StaticBitmap(IDB_BITMAP1, 32, 32))
		-
	    StaticText("Written by Tim Cooper.")
		-
	    StaticText("A neat little Help editor.")
		-
	    OkButton();
	DoDialog("About FooEditor", c);
}



int Test()
{
	FooEditor He("Help editor", 500, 300);
	He.LoadFile("barbados.bar");
	He.Edit();
	return 0;
}
