#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include "barbados.h"
#include "textwin.h"




interface str ExpandTabs(str s, char dest[], int TabSize)
/* Expand 'src' (up to the next newline or nullchar) */
/* into 'dest' with tabs expanded. */
{	str d;

	if (TabSize == 0)
	    TabSize = 4;
	d = dest;
	while (*s and *s != '\n') {
	    if (*s == '\t') {
		do {
		    *d++ = ' ';
		} until ((d - dest) % TabSize == 0);
		s++;
	    }
	    else *d++ = *s++;
	}
	*d = '\0';
	return dest;
}


TextWin::TextWin(int width, int height, str caption, 
	    int fontheight, bool fixedwidth, str typeface)
	: EditorWin(caption, width*8, height*(fontheight?fontheight:13), BLACK, YELLOW)
{
        FixedWidth = fixedwidth;
        this->fontheight = fontheight;
	font = TfcFindFont(fontheight, no, no, fixedwidth, typeface);
}


void TextWin::Printf(str format, ...)
{	char buf[1024], tbuf[1024];
	unsigned int width, height;
	va_list argptr;
	Line *row;

	/* Construct the string: */
	va_start(argptr, format);
	vsprintf(buf, format, argptr);

	/* Create the row: */
	row = NewLine(buf);
	TextDimensions(ExpandTabs(buf, tbuf, 4), -1, font, &width, &height);
	row->width = width;
	row->height = height;
	assert(focus == NULL or focus->next == NULL);
	focus = Insert(focus, row);
	assert(focus->next == NULL);
	c.ln = (Line*)focus;
}


void TextWin::Refresh(void)
/* Update the display of this window. */
{
	if (focus == NULL)
	    Printf("");
        Show();
}


TextWin::~TextWin()
{
}

