#include <stdio.h>
#include <memory.h>
#include "barbados.h"
#include "textwin.h"



#define MAX_LINES   100

static TextWin *TraceWindow;
static int Width;	    // The width of the trace window, in characters.
static str Buf[MAX_LINES];
static int Buf_idx;
static char buf[200], *bp;
static FILE *stdbug;



static void AddL(str s)
/* Add this line to the line buffer. */
{
	if (Buf_idx >= MAX_LINES) {
	    free(anon_heap, Buf[0]);
	    memcpy(Buf, Buf + 1, --Buf_idx * sizeof(str));
	}
	Buf[Buf_idx++] = strdup(anon_heap, s);
}


static void AddS(str s)
/* Add this str to the current buffer. */
{
	if (bp == NULL)
	    bp = buf;
	while (*s) {
	    if (*s == '\n') {
		*bp = '\0';
		AddL(buf);
		bp = buf;
	    }
	    else *bp++ = *s;
	    if (bp - buf >= Width) {
		*bp = '\0';
		AddL(buf);
		bp = buf;
	    }
	    s++;
	}
	TraceWindow->Refresh();
}


static void Refocus(void)
{
	if (TraceWindow == NULL) {
	    Width = 60;
	    TraceWindow = new TextWin(Width, 60, "TRACE", 13, yes, NULL);
	}
}


interface void Trace(str format, ...)
{       char buf[200];

	vsprintf(buf, format, (char*)(&format + 1));
	if (debugging & 8) {
	    AddS(buf);
	}
	if (debugging & 16) {
	    if (stdbug)
		fputs(buf, stdbug);
	}
}


interface void TraceMode(bool to_file)
/* Open or close 'stdbug' for trace output. */
{
	if (to_file) {
	    if (stdbug == NULL)
		stdbug = fopen("trace.txt", "wt");
	}
	else {
	    if (stdbug) {
		fclose(stdbug);
		stdbug = NULL;
	    }
	}
}
