/*** TYPESTOR.H: General things needed in order to use the ***/
/***             environment, to do with types, identifiers **/
/***             etc.                                      ***/

extern uchar /* Type's: */ 
		any_typstr[], ostream_typstr[], namedobj_typstr[],
		direc_typstr[], container_typstr[], dirref_typstr[],
		bool_typstr[], ptrclassdef_typstr[], bitmap_typstr[],
		voidvoidptr_typstr[], voidptr_typstr[], string_typstr[],
		uint_typstr[], int_typstr[], typetype_typstr[],
		voidvoidfn_typstr[], containerheader_typstr[],
                file_typstr[], *classdef_typstr;
extern Classdef *AnyStruct, *OstreamStruct, *DirecStruct, *TypeStruct,
		*ClassdefStruct, *NamedObjStruct, *BitmapStruct,
                *ContainerHeaderStruct;
extern int enum_value;
extern Namedobj* debug_obj;


#define GetDimension(dim,type)  dim = *(*(int**)&type)++
#define PutDimension(dim,type)  *(*(int**)&type)++ = dim
#define GetPtr(ptr,type)        ptr = *(*(Classdef ***)&type)++
#define GetPtrE(ptr,type)       ptr = *(*(Namedobj***)&type)++
#define PutPtr(ptr,type)        *(*(void***)&type)++ = ptr

#define AssgPtr(l,r)            memcpy(l, r, sizeof(str))
#define CompPtr(l,r)            memcmp(l, r, sizeof(str))
#define DynVector(dyn)          (*(void**)dyn)
#define DynLength(dyn)          (*(int*)((void**)dyn + 1))



size_t TypeSize(Type type);
size_t TypeSizeWord(Type type);
int LengthOfTypeString(Type type);
Type EndOfTypeString(Type r);
Type TypeAppend(Type d, Type suffix);
bool TypeEqual(Type a, Type b);
bool TypesNearlyEqual_i(Type *ap, Type *bp);
bool TypesNearlyEqual(Type a, Type b);
tp_enum TpToSigned(tp_enum tp);
void TypeCopy(Type dest, Type src);
bool EqualFootprint(Type func, Type footprint);
bool TypeValidated(Type type);
bool TypeIsBigStruct(Type type);		// a tp_class which is > 4 bytes
int TpSize(tp_enum tp);				// classes return '9999'.
bool TpIsIntegral(tp_enum tp);
bool TpIsUnsigned(tp_enum tp);
char TpGroup(tp_enum tp);
/* What kind of tp is this?  'i'=integral, 'f'=fpu, '\0'=other. */
/* Enums are counted as '\0'. */

Classdef * TypeToClassdef(Type type);
Type TypeFunctionReturnType(Type type);
int TypeFunctionArity(Type type);
int EncodeBitField(int offset, int bit_offset, int bit_width);
void DecodeBitField(int x, int *offsetp, int *bit_offsetp, int *bit_widthp);
void OutputType(Ostream* out, Type type);
str StorageToString(storage_enum storage);
str TypeToString(Type type, char dest[], int sizeofdest);
void InitProvisionalTypstrs();
bool IsCharArray(Namedobj* obj);
bool IsDirectory(Namedobj* obj, bool include_dirref, bool include_containers);
bool IsConstructor(Namedobj *obj);
bool IsDestructor(Namedobj *obj);
bool TypeHasConstructor(Type type);
bool TypeHasDestructor(Type type);
FunctionNamedobj* ClassDefaultConstructor(Classdef *classdef, Namedobj **any_constructor);
bool BisBaseOfD(Classdef *bclass, Classdef *dclass, int *offset);
        /* Returns true if the 1st parameter is equal to or a base class  */
        /* of the second parameter.  Return also via '*offset' the offset */
        /* of the base class (quite often zero). */


uint SizeofObj(str name, Type type, storage_enum storage);
	/* What size would we need for this named object? */


#define each_member(classdef)   Namedobj* obj=classdef->member; obj; obj=obj->next
#define objLocation          (((StaticNamedobj*)obj)->location)




/*--------------- Finding pointers: ---------------*/

void CallPtrFinder(PtrFinder_fn ptrfinder, void *address, PtrProcessor_fn fn);
void FindPtrs(void* p, Type typestr);
Type FindPtrsInTypstr(Type typestr);

void* WriteSwizzledToCorrect(void* ptr, PtrProcessor_fn fn);
	/* I don't think I need this one. */

uint MsizeSwizzled(void* ptr);
	/* What is the size of this block? ptr has already passed through 'fn'. */

void FindPtrsInFuncblock(funcblock_type funcblock, PtrProcessor_fn fn);
	/* This is actually implemented inside COMPCODE.CPP which is the */
	/* only module that understands Pentium machine-code. */

void ProcessRelativePtr(int* ptr, PtrProcessor_fn fn);
	/* Process this pointer-relpointer with function 'fn'. */




#define WordAlign(w)    (w = ((w-1) | 3) + 1)
#define WordAlignPtr(w) (w = (str)((((int)w-1) | 3) + 1))


#ifdef __BCPLUSPLUS__
#else

#pragma warning ( disable : 4028 )
#pragma warning ( disable : 4018 )

#define strnicmp	_strnicmp
#define itoa		_itoa
#define stricmp		_stricmp
#endif

